/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.extension.definition;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.osgi.util.NLS;
import org.teiid.core.designer.HashCodeUtil;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.extension.ExtensionConstants;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.extension.Messages;
import org.teiid.designer.extension.definition.ModelExtensionAssistant;
import org.teiid.designer.extension.definition.ModelExtensionDefinitionHeader;
import org.teiid.designer.extension.properties.ModelExtensionPropertyDefinition;
import org.teiid.designer.extension.properties.NamespaceProvider;

public class ModelExtensionDefinition
implements NamespaceProvider,
PropertyChangeListener {
    private final ModelExtensionAssistant assistant;
    private boolean builtIn;
    private boolean imported;
    private final CopyOnWriteArrayList<PropertyChangeListener> listeners;
    private final Map<String, Collection<ModelExtensionPropertyDefinition>> properties;
    private final ModelExtensionDefinitionHeader header;

    public ModelExtensionDefinition(ModelExtensionAssistant assistant) {
        CoreArgCheck.isNotNull((Object)assistant, (String)"assistant is null");
        this.assistant = assistant;
        this.properties = new HashMap<String, Collection<ModelExtensionPropertyDefinition>>();
        this.listeners = new CopyOnWriteArrayList();
        this.header = new ModelExtensionDefinitionHeader();
        this.header.addListener(this);
    }

    public ModelExtensionDefinition(ModelExtensionAssistant assistant, String namespacePrefix, String namespaceUri, String metamodelUri, String description, String version) {
        this(assistant);
        int versionNumber = 1;
        if (!CoreStringUtil.isEmpty((String)version)) {
            try {
                versionNumber = Integer.parseInt(version);
                this.header.setVersion(versionNumber);
            }
            catch (Exception exception) {
                ExtensionConstants.UTIL.log((Object)NLS.bind((String)Messages.invalidDefinitionFileNewVersion, (Object)namespacePrefix, (Object)version));
            }
        }
        this.header.setNamespacePrefix(namespacePrefix);
        this.header.setNamespaceUri(namespaceUri);
        this.header.setMetamodelUri(metamodelUri);
        this.header.setDescription(description);
    }

    public boolean addListener(PropertyChangeListener listener) {
        CoreArgCheck.isNotNull((Object)listener, (String)"listener is null");
        boolean added = this.listeners.addIfAbsent(listener);
        if (added) {
            added = this.header.addListener(listener);
        }
        return added;
    }

    public boolean addMetaclass(String metaclassName) {
        CoreArgCheck.isNotEmpty((String)metaclassName, (String)"metaclassName is empty");
        if (this.properties.containsKey(metaclassName)) {
            return false;
        }
        this.properties.put(metaclassName, new ArrayList());
        this.notifyChangeListeners(PropertyName.METACLASS, null, metaclassName);
        return true;
    }

    public boolean addModelType(String modelType) {
        return this.getHeader().addModelType(modelType);
    }

    public boolean addPropertyDefinition(String metaclassName, ModelExtensionPropertyDefinition propDefn) {
        CoreArgCheck.isNotNull((Object)propDefn, (String)"propDefn is null");
        Collection<ModelExtensionPropertyDefinition> props = this.internalGetProperties(metaclassName);
        if (props == null) {
            if (this.addMetaclass(metaclassName)) {
                props = this.internalGetProperties(metaclassName);
            } else {
                return false;
            }
        }
        if (props.contains(propDefn)) {
            return false;
        }
        props.add(propDefn);
        this.notifyChangeListeners(PropertyName.PROPERTY_DEFINITION, null, propDefn);
        return true;
    }

    private boolean addPropertyDefinitions(String metaclassName, Collection<ModelExtensionPropertyDefinition> propDefns) {
        CoreArgCheck.isNotNull(propDefns, (String)"propDefns is null");
        boolean added = false;
        for (ModelExtensionPropertyDefinition propDefn : propDefns) {
            if (!this.addPropertyDefinition(metaclassName, propDefn)) continue;
            added = true;
        }
        return added;
    }

    public boolean extendsMetaclass(String metaclassName) {
        CoreArgCheck.isNotEmpty((String)metaclassName, (String)"metaclassName is null");
        return this.properties.containsKey(metaclassName);
    }

    public boolean extendsMetamodelUri(String metamodelUri) {
        CoreArgCheck.isNotEmpty((String)metamodelUri, (String)"metamodelUri is null");
        return this.getMetamodelUri().equals(metamodelUri);
    }

    public String getDescription() {
        return this.header.getDescription();
    }

    public String[] getExtendedMetaclasses() {
        return this.properties.keySet().toArray(new String[this.properties.size()]);
    }

    public String getMetamodelUri() {
        return this.header.getMetamodelUri();
    }

    public ModelExtensionAssistant getModelExtensionAssistant() {
        return this.assistant;
    }

    @Override
    public String getNamespacePrefix() {
        return this.header.getNamespacePrefix();
    }

    @Override
    public String getNamespaceUri() {
        return this.header.getNamespaceUri();
    }

    public ModelExtensionDefinitionHeader getHeader() {
        return this.header;
    }

    public ModelExtensionPropertyDefinition getPropertyDefinition(String metaclassName, String propId) {
        CoreArgCheck.isNotEmpty((String)metaclassName, (String)"metaclassName is empty");
        CoreArgCheck.isNotEmpty((String)propId, (String)"propId is empty");
        if (!ModelExtensionPropertyDefinition.Utils.isExtensionPropertyId(propId, this)) {
            return null;
        }
        Collection<ModelExtensionPropertyDefinition> props = this.internalGetProperties(metaclassName);
        if (props == null) {
            return null;
        }
        for (ModelExtensionPropertyDefinition propDefn : props) {
            if (!propId.equals(propDefn.getId())) continue;
            return propDefn;
        }
        return null;
    }

    public Map<String, Collection<ModelExtensionPropertyDefinition>> getPropertyDefinitions() {
        HashMap<String, Collection<ModelExtensionPropertyDefinition>> properties = new HashMap<String, Collection<ModelExtensionPropertyDefinition>>();
        for (Map.Entry<String, Collection<ModelExtensionPropertyDefinition>> entry : this.properties.entrySet()) {
            ArrayList<ModelExtensionPropertyDefinition> propDefns = new ArrayList<ModelExtensionPropertyDefinition>();
            propDefns.addAll(entry.getValue());
            String metaclassName = entry.getKey();
            properties.put(metaclassName, propDefns);
        }
        return properties;
    }

    public Collection<ModelExtensionPropertyDefinition> getPropertyDefinitions(String metaclassName) {
        CoreArgCheck.isNotEmpty((String)metaclassName, (String)"metaclassName is null");
        Collection<ModelExtensionPropertyDefinition> props = this.internalGetProperties(metaclassName);
        if (props == null) {
            return Collections.emptyList();
        }
        return props;
    }

    public Set<String> getSupportedModelTypes() {
        return this.getHeader().getSupportedModelTypes();
    }

    public int getVersion() {
        return this.header.getVersion();
    }

    private Collection<ModelExtensionPropertyDefinition> internalGetProperties(String metaclassName) {
        CoreArgCheck.isNotEmpty((String)metaclassName, (String)"metaclassName is null");
        return this.properties.get(metaclassName);
    }

    public boolean isBuiltIn() {
        return this.builtIn;
    }

    public void markAsBuiltIn() {
        this.builtIn = true;
    }

    public boolean isImported() {
        return this.imported;
    }

    public void markAsImported() {
        this.imported = true;
    }

    private void notifyChangeListeners(PropertyName property, Object oldValue, Object newValue) {
        PropertyChangeEvent event = new PropertyChangeEvent(this, property.toString(), oldValue, newValue);
        Object[] objectArray = this.listeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            try {
                ((PropertyChangeListener)listener).propertyChange(event);
            }
            catch (Exception e) {
                ExtensionPlugin.Util.log((Throwable)e);
                this.listeners.remove(listener);
            }
            ++n2;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String[] metaclasses;
        if (PropertyName.METAMODEL_URI.toString().equals(e.getPropertyName()) && (metaclasses = this.getExtendedMetaclasses()).length != 0) {
            this.properties.clear();
            this.notifyChangeListeners(PropertyName.METACLASS, metaclasses, null);
        }
    }

    public boolean removeListener(PropertyChangeListener listener) {
        CoreArgCheck.isNotNull((Object)listener, (String)"listener is null");
        boolean removed = this.listeners.remove(listener);
        if (removed) {
            removed = this.header.removeListener(listener);
        }
        return removed;
    }

    public boolean removeModelType(String modelType) {
        return this.getHeader().removeModelType(modelType);
    }

    public boolean removePropertyDefinition(String metaclassName, ModelExtensionPropertyDefinition propDefn) {
        CoreArgCheck.isNotEmpty((String)metaclassName, (String)"metaclassName is empty");
        CoreArgCheck.isNotNull((Object)propDefn, (String)"propDefn is null");
        Collection<ModelExtensionPropertyDefinition> propDefns = this.getPropertyDefinitions(metaclassName);
        boolean removed = propDefns.remove(propDefn);
        if (removed) {
            this.notifyChangeListeners(PropertyName.PROPERTY_DEFINITION, propDefn, null);
        }
        return removed;
    }

    public Collection<ModelExtensionPropertyDefinition> removeMetaclass(String metaclassName) {
        CoreArgCheck.isNotEmpty((String)metaclassName, (String)"metaclassName is empty");
        if (this.properties.containsKey(metaclassName)) {
            Collection<ModelExtensionPropertyDefinition> propDefns = this.properties.remove(metaclassName);
            this.notifyChangeListeners(PropertyName.METACLASS, metaclassName, null);
            return propDefns;
        }
        return null;
    }

    public void setDescription(String newDescription) {
        this.header.setDescription(newDescription);
    }

    public void setMetamodelUri(String newMetamodelUri) {
        this.header.setMetamodelUri(newMetamodelUri);
    }

    public void setNamespacePrefix(String newNamespacePrefix) {
        this.header.setNamespacePrefix(newNamespacePrefix);
    }

    public void setNamespaceUri(String newNamespaceUri) {
        this.header.setNamespaceUri(newNamespaceUri);
    }

    public void setVersion(int newVersion) {
        this.header.setVersion(newVersion);
    }

    public void updateMetaclass(String originalMetaclass, String newMetaclass) {
        CoreStringUtil.isEmpty((String)originalMetaclass);
        CoreStringUtil.isEmpty((String)newMetaclass);
        Collection<ModelExtensionPropertyDefinition> propDefns = this.removeMetaclass(originalMetaclass);
        if (propDefns == null || propDefns.isEmpty()) {
            this.addMetaclass(newMetaclass);
        } else {
            this.addPropertyDefinitions(newMetaclass, propDefns);
        }
    }

    public final boolean equals(Object object) {
        String[] otherMetaclassNames;
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ModelExtensionDefinition other = (ModelExtensionDefinition)object;
        if (!this.getHeader().equals(other.getHeader())) {
            return false;
        }
        String[] extendedMetaclassNames = this.getExtendedMetaclasses();
        if (extendedMetaclassNames.length != (otherMetaclassNames = other.getExtendedMetaclasses()).length) {
            return false;
        }
        if (extendedMetaclassNames.length == 0 && otherMetaclassNames.length == 0) {
            return true;
        }
        boolean areEqual = true;
        int i = 0;
        while (i < extendedMetaclassNames.length) {
            HashSet<ModelExtensionPropertyDefinition> metaClassPropertyDefns = new HashSet<ModelExtensionPropertyDefinition>(this.getPropertyDefinitions(extendedMetaclassNames[i]));
            HashSet<ModelExtensionPropertyDefinition> otherMetaClassPropertyDefns = new HashSet<ModelExtensionPropertyDefinition>(other.getPropertyDefinitions(extendedMetaclassNames[i]));
            if (metaClassPropertyDefns.size() != otherMetaClassPropertyDefns.size() || !metaClassPropertyDefns.isEmpty() && !metaClassPropertyDefns.containsAll(otherMetaClassPropertyDefns)) {
                areEqual = false;
                break;
            }
            ++i;
        }
        return areEqual;
    }

    public int hashCode() {
        int result = HashCodeUtil.hashCode((int)0, (boolean)this.builtIn);
        result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{this.getHeader()});
        String[] extendedMetaclassNames = this.getExtendedMetaclasses();
        int i = 0;
        while (i < extendedMetaclassNames.length) {
            Collection<ModelExtensionPropertyDefinition> metaclassPropertyDefns = this.getPropertyDefinitions(extendedMetaclassNames[i]);
            for (ModelExtensionPropertyDefinition propDefn : metaclassPropertyDefns) {
                result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{propDefn});
            }
            ++i;
        }
        return result;
    }

    public boolean supportsModelType(String modelType) {
        return this.getHeader().supportsModelType(modelType);
    }

    public String toString() {
        return this.getHeader().toString();
    }

    public static enum PropertyName {
        PROPERTY_DEFINITION,
        DESCRIPTION,
        METAMODEL_URI,
        METACLASS,
        MODEL_TYPES,
        NAMESPACE_PREFIX,
        NAMESPACE_URI,
        VERSION;

    }
}

