/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.pf.notation;

import java.beans.PropertyChangeEvent;
import java.util.List;
import org.jbpm.gd.common.editor.CreationFactory;
import org.jbpm.gd.common.notation.Edge;
import org.jbpm.gd.common.notation.Node;
import org.jbpm.gd.pf.model.NodeElement;
import org.jbpm.gd.pf.model.PageFlowDefinition;
import org.jbpm.gd.pf.model.Transition;

public class PageFlowNode
extends Node {
    public void propertyChange(PropertyChangeEvent evt) {
        String eventName = evt.getPropertyName();
        if (eventName.equals("name")) {
            this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            List edges = this.getArrivingEdges();
            int i = 0;
            while (i < edges.size()) {
                Edge edge = (Edge)edges.get(i);
                edge.getSemanticElement().removePropertyChangeListener(edge);
                ((Transition)edge.getSemanticElement()).setTo((String)evt.getNewValue());
                edge.getSemanticElement().addPropertyChangeListener(edge);
                ++i;
            }
        } else if (eventName.equals("transitionAdd")) {
            Transition transition = (Transition)evt.getNewValue();
            Edge edge = (Edge)this.getRegisteredNotationElementFor(transition);
            if (edge == null) {
                CreationFactory factory = new CreationFactory(transition, this.getFactory());
                edge = (Edge)factory.getNewObject();
            }
            this.addLeavingEdge(edge);
            transition.addPropertyChangeListener(edge);
            Node targetNode = this.getDestinationNode(transition.getTo());
            if (targetNode != null) {
                targetNode.addArrivingEdge(edge);
            }
        } else if (eventName.equals("transitionRemove")) {
            Transition transition = (Transition)evt.getOldValue();
            Edge edge = (Edge)this.getRegisteredNotationElementFor(transition);
            if (edge != null) {
                Node targetNode = edge.getTarget();
                if (targetNode != null) {
                    transition.removePropertyChangeListener(edge);
                    targetNode.removeArrivingEdge(edge);
                }
                this.removeLeavingEdge(edge);
            }
        } else {
            super.propertyChange(evt);
        }
    }

    private Node getDestinationNode(String to) {
        NodeElement nodeElement = ((PageFlowDefinition)this.getContainer().getSemanticElement()).getNodeElementByName(to);
        return (Node)this.getRegisteredNotationElementFor(nodeElement);
    }
}

