/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.wizard;

import java.io.File;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jbpm.gd.jpdl.wizard.NewProcessProjectDetailsWizardPage;

public class ConfigureRuntimePage
extends WizardPage {
    private static final String ENTER_NAME_MSG = "Choose a name for the jBPM 3 Runtime, e.g. 'jBPM jPDL 3.2.2'";
    private static final String ENTER_LOCATION_MSG = "Enter or search a location for the jBPM 3 Runtime";
    private static final String CONTINUE_MSG = "Press next to continue the project creation";
    private static final String UNEXISTING_LOCATION_MSG = "This location does not exist";
    private static final String INVALID_LOCATION_MSG = "This location does not contain a valid jBPM 3 runtime, please retry";
    Text nameText;
    Text locationText;

    public ConfigureRuntimePage() {
        super("Configure JBoss jBPM Runtime");
        this.setTitle("Configure JBoss jBPM Runtime");
        this.setMessage(ENTER_NAME_MSG);
    }

    public void createControl(Composite parent) {
        Composite composite = this.createClientArea(parent);
        this.createLocateJbpmRuntimeGroup(composite);
        this.createSpace(composite);
        this.setControl((Control)composite);
    }

    private void update() {
        this.updateMessage();
        this.updatePages();
    }

    private void updatePages() {
        this.setPageComplete(!this.isNameEmpty() && !this.isLocationEmpty());
        if (!this.isNameEmpty()) {
            NewProcessProjectDetailsWizardPage page = (NewProcessProjectDetailsWizardPage)this.getNextPage();
            page.combo.removeAll();
            page.combo.add(this.nameText.getText());
            page.combo.select(0);
        }
    }

    private void createSpace(Composite composite) {
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(1808));
    }

    private void createLocateJbpmRuntimeGroup(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText("Locate a JBoss jBPM Runtime");
        group.setLayout((Layout)new GridLayout(3, false));
        GridData gridData = new GridData(768);
        gridData.verticalIndent = 5;
        group.setLayoutData((Object)gridData);
        this.createJbpmRuntimeNameField((Composite)group);
        this.createJbpmRuntimeLocationField((Composite)group);
    }

    private void createJbpmRuntimeNameField(Composite composite) {
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText("Name :");
        this.nameText = new Text(composite, 2048);
        this.nameText.setLayoutData((Object)new GridData(768));
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConfigureRuntimePage.this.update();
            }
        });
        new Label(composite, 0);
    }

    private void createJbpmRuntimeLocationField(Composite composite) {
        Label locationLabel = new Label(composite, 0);
        locationLabel.setText("Location :");
        this.locationText = new Text(composite, 2048);
        this.locationText.setLayoutData((Object)new GridData(768));
        this.locationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConfigureRuntimePage.this.update();
            }
        });
        Button locationButton = new Button(composite, 8);
        locationButton.setText("Browse...");
        locationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigureRuntimePage.this.searchLocation();
            }
        });
    }

    private void searchLocation() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 4096);
        String result = dialog.open();
        if (result != null) {
            this.locationText.setText(result);
        }
    }

    private Composite createClientArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        return composite;
    }

    private void updateMessage() {
        this.setErrorMessage(null);
        if (this.isNameEmpty() && this.isLocationEmpty()) {
            this.setMessage(ENTER_NAME_MSG);
        } else if (this.isLocationEmpty()) {
            this.setMessage(ENTER_LOCATION_MSG);
        } else if (!this.isLocationExisting()) {
            this.setErrorMessage(UNEXISTING_LOCATION_MSG);
        } else if (!this.isValidJbpm3Installation()) {
            this.setErrorMessage(INVALID_LOCATION_MSG);
        } else if (this.isNameEmpty()) {
            this.setMessage(ENTER_NAME_MSG);
        } else {
            this.setMessage(CONTINUE_MSG);
        }
    }

    private boolean isNameEmpty() {
        String text = this.nameText.getText();
        return text == null || "".equals(text);
    }

    private boolean isLocationEmpty() {
        String text = this.locationText.getText();
        return text == null || "".equals(text);
    }

    private boolean isLocationExisting() {
        return new Path(this.locationText.getText()).toFile().exists();
    }

    private boolean isValidJbpm3Installation() {
        return this.getJbpmVersionInfoFile().exists();
    }

    private File getJbpmVersionInfoFile() {
        return new Path(this.locationText.getText()).append("/src/resources/gpd/version.info.xml").toFile();
    }
}

