/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.util;

import java.util.HashSet;
import java.util.Set;
import org.jbpm.gd.jpdl.model.Action;
import org.jbpm.gd.jpdl.model.ActionElement;
import org.jbpm.gd.jpdl.model.CreateTimer;
import org.jbpm.gd.jpdl.model.Delegation;
import org.jbpm.gd.jpdl.model.Event;
import org.jbpm.gd.jpdl.model.ExceptionHandler;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.ProcessDefinition;
import org.jbpm.gd.jpdl.model.StartState;
import org.jbpm.gd.jpdl.model.SuperState;
import org.jbpm.gd.jpdl.model.Swimlane;
import org.jbpm.gd.jpdl.model.Task;
import org.jbpm.gd.jpdl.model.Timer;
import org.jbpm.gd.jpdl.model.TimerContainer;

public class JavaClassNameCollector {
    public static Set getJavaClassNames(ProcessDefinition processDefinition) {
        HashSet result = new HashSet();
        JavaClassNameCollector.addJavaClassNames(result, processDefinition.getActionElements());
        JavaClassNameCollector.addJavaClassNames(result, processDefinition.getEvents());
        JavaClassNameCollector.addJavaClassNames(result, processDefinition.getExceptionHandlers());
        JavaClassNameCollector.addJavaClassNames(result, processDefinition.getNodeElements());
        JavaClassNameCollector.addJavaClassNames(result, processDefinition.getStartState());
        JavaClassNameCollector.addJavaClassNames(result, processDefinition.getSwimlanes());
        JavaClassNameCollector.addJavaClassNames(result, processDefinition.getTasks());
        return result;
    }

    private static void addJavaClassNames(Set result, ActionElement[] actionElements) {
        int i = 0;
        while (i < actionElements.length) {
            Action action;
            if (actionElements[i] instanceof Action && (action = (Action)actionElements[i]).getClassName() != null) {
                result.add(action.getClassName());
            }
            if (actionElements[i] instanceof CreateTimer && (action = ((CreateTimer)actionElements[i]).getAction()) != null && action.getClassName() != null) {
                result.add(action.getClassName());
            }
            ++i;
        }
    }

    private static void addJavaClassNames(Set result, Event[] events) {
        int i = 0;
        while (i < events.length) {
            JavaClassNameCollector.addJavaClassNames(result, events[i].getActionElements());
            ++i;
        }
    }

    private static void addJavaClassNames(Set result, ExceptionHandler[] exceptionHandlers) {
        int i = 0;
        while (i < exceptionHandlers.length) {
            JavaClassNameCollector.addJavaClassNames(result, exceptionHandlers[i].getActionElements());
            ++i;
        }
    }

    private static void addJavaClassNames(Set result, NodeElement[] nodeElements) {
        int i = 0;
        while (i < nodeElements.length) {
            JavaClassNameCollector.addJavaClassNames(result, nodeElements[i].getEvents());
            JavaClassNameCollector.addJavaClassNames(result, nodeElements[i].getExceptionHandlers());
            JavaClassNameCollector.addJavaClassNames(result, nodeElements[i].getTransitions());
            if (nodeElements[i] instanceof TimerContainer) {
                JavaClassNameCollector.addJavaClassNames(result, ((TimerContainer)((Object)nodeElements[i])).getTimers());
            }
            if (nodeElements[i] instanceof SuperState) {
                SuperState superState = (SuperState)nodeElements[i];
                JavaClassNameCollector.addJavaClassNames(result, superState.getNodeElements());
            }
            ++i;
        }
    }

    private static void addJavaClassNames(Set result, StartState startState) {
        if (startState == null) {
            return;
        }
        JavaClassNameCollector.addJavaClassNames(result, startState.getEvents());
        JavaClassNameCollector.addJavaClassNames(result, startState.getExceptionHandlers());
        JavaClassNameCollector.addJavaClassNames(result, startState.getTransitions());
    }

    private static void addJavaClassNames(Set result, Swimlane[] swimlanes) {
        int i = 0;
        while (i < swimlanes.length) {
            JavaClassNameCollector.addJavaClassName(result, swimlanes[i].getAssignment());
            ++i;
        }
    }

    private static void addJavaClassNames(Set result, Task[] tasks) {
        int i = 0;
        while (i < tasks.length) {
            JavaClassNameCollector.addJavaClassName(result, tasks[i].getAssignment());
            JavaClassNameCollector.addJavaClassNames(result, tasks[i].getEvents());
            JavaClassNameCollector.addJavaClassNames(result, tasks[i].getTimers());
            JavaClassNameCollector.addJavaClassName(result, tasks[i].getController());
            ++i;
        }
    }

    private static void addJavaClassNames(Set result, Timer[] timers) {
        int i = 0;
        while (i < timers.length) {
            Action action;
            if (timers[i].getAction() != null && (action = timers[i].getAction()).getClassName() != null) {
                result.add(action.getClassName());
            }
            ++i;
        }
    }

    private static void addJavaClassName(Set result, Delegation delegation) {
        if (delegation != null && delegation.getClassName() != null) {
            result.add(delegation.getClassName());
        }
    }
}

