/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.properties;

import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jbpm.gd.common.properties.NamedElementConfigurationComposite;
import org.jbpm.gd.jpdl.model.Script;
import org.jbpm.gd.jpdl.properties.ScriptAdvancedConfigurationComposite;
import org.jbpm.gd.jpdl.properties.ScriptDetailsConfigurationComposite;

public class ScriptConfigurationComposite {
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private Composite parent;
    private Script script;
    private CTabFolder scriptTabFolder;
    private NamedElementConfigurationComposite namedElementConfigurationComposite;
    private ScriptDetailsConfigurationComposite scriptDetailsConfigurationComposite;
    private ScriptAdvancedConfigurationComposite scriptAdvancedConfigurationComposite;

    public static ScriptConfigurationComposite create(TabbedPropertySheetWidgetFactory widgetFactory, Composite parent) {
        ScriptConfigurationComposite result = new ScriptConfigurationComposite();
        result.widgetFactory = widgetFactory;
        result.parent = parent;
        result.create();
        return result;
    }

    public void setScript(Script script) {
        if (this.script == script) {
            return;
        }
        this.unhookListeners();
        this.clearControls();
        this.script = script;
        if (script != null) {
            this.updateControls();
            this.hookListeners();
        }
    }

    public Script getScript() {
        return this.script;
    }

    private void hookListeners() {
    }

    private void unhookListeners() {
    }

    private void clearControls() {
        this.namedElementConfigurationComposite.setNamedElement(null);
        this.scriptDetailsConfigurationComposite.setScript(null);
        this.scriptAdvancedConfigurationComposite.setScript(null);
    }

    private void updateControls() {
        this.namedElementConfigurationComposite.setNamedElement(this.script);
        this.scriptDetailsConfigurationComposite.setScript(this.script);
        this.scriptAdvancedConfigurationComposite.setScript(this.script);
    }

    private void create() {
        this.scriptTabFolder = this.widgetFactory.createTabFolder(this.parent, 2176);
        this.scriptTabFolder.setLayoutData((Object)this.createScriptTabFolderLayoutData());
        this.createGeneralTabItem();
        this.createDetailsTabItem();
        this.createAdvancedTabItem();
        this.scriptTabFolder.setSelection(0);
    }

    private void createGeneralTabItem() {
        CTabItem generalTabItem = this.widgetFactory.createTabItem(this.scriptTabFolder, 0);
        generalTabItem.setText("General");
        Composite generalTabControl = this.widgetFactory.createFlatFormComposite((Composite)this.scriptTabFolder);
        this.namedElementConfigurationComposite = NamedElementConfigurationComposite.create(this.widgetFactory, generalTabControl);
        generalTabItem.setControl((Control)generalTabControl);
    }

    private void createDetailsTabItem() {
        CTabItem detailsTabItem = this.widgetFactory.createTabItem(this.scriptTabFolder, 0);
        detailsTabItem.setText("Details");
        Composite detailsTabControl = this.widgetFactory.createFlatFormComposite((Composite)this.scriptTabFolder);
        this.scriptDetailsConfigurationComposite = ScriptDetailsConfigurationComposite.create(this.widgetFactory, detailsTabControl);
        detailsTabItem.setControl((Control)detailsTabControl);
    }

    private void createAdvancedTabItem() {
        CTabItem advancedTabItem = this.widgetFactory.createTabItem(this.scriptTabFolder, 0);
        advancedTabItem.setText("Advanced");
        Composite advancedTabControl = this.widgetFactory.createFlatFormComposite((Composite)this.scriptTabFolder);
        this.scriptAdvancedConfigurationComposite = ScriptAdvancedConfigurationComposite.create(this.widgetFactory, advancedTabControl);
        advancedTabItem.setControl((Control)advancedTabControl);
    }

    private FormData createScriptTabFolderLayoutData() {
        FormData result = new FormData();
        result.left = new FormAttachment(0, 0);
        result.right = new FormAttachment(100, 0);
        result.top = new FormAttachment(0, 0);
        result.bottom = new FormAttachment(100, 0);
        return result;
    }
}

