/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.properties;

import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jbpm.gd.jpdl.model.MailNode;
import org.jbpm.gd.jpdl.model.Subject;

public class MailNodeConfigurationComposite
implements SelectionListener,
FocusListener {
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private Composite parent;
    private Label templateLabel;
    private Text templateText;
    private Button toButton;
    private Text toText;
    private Button actorsButton;
    private Text actorsText;
    private Label subjectLabel;
    private Text subjectText;
    private Label bodyLabel;
    private Text bodyText;
    private MailNode mailNode;

    public static MailNodeConfigurationComposite create(TabbedPropertySheetWidgetFactory widgetFactory, Composite parent) {
        MailNodeConfigurationComposite result = new MailNodeConfigurationComposite();
        result.widgetFactory = widgetFactory;
        result.parent = parent;
        result.create();
        return result;
    }

    private MailNodeConfigurationComposite() {
    }

    public void setMailNode(MailNode mailNode) {
        if (this.mailNode == mailNode) {
            return;
        }
        this.unhookListeners();
        this.mailNode = mailNode;
        if (mailNode == null) {
            this.clearControls();
        } else {
            this.updateControls();
            this.hookListeners();
        }
    }

    private void hookListeners() {
        this.templateText.addSelectionListener((SelectionListener)this);
        this.templateText.addFocusListener((FocusListener)this);
        this.toButton.addSelectionListener((SelectionListener)this);
        this.toText.addSelectionListener((SelectionListener)this);
        this.toText.addFocusListener((FocusListener)this);
        this.actorsButton.addSelectionListener((SelectionListener)this);
        this.actorsText.addSelectionListener((SelectionListener)this);
        this.actorsText.addFocusListener((FocusListener)this);
        this.subjectText.addSelectionListener((SelectionListener)this);
        this.subjectText.addFocusListener((FocusListener)this);
        this.bodyText.addSelectionListener((SelectionListener)this);
        this.bodyText.addFocusListener((FocusListener)this);
    }

    private void unhookListeners() {
        this.templateText.removeSelectionListener((SelectionListener)this);
        this.templateText.removeFocusListener((FocusListener)this);
        this.toButton.removeSelectionListener((SelectionListener)this);
        this.toText.removeSelectionListener((SelectionListener)this);
        this.toText.removeFocusListener((FocusListener)this);
        this.actorsButton.removeSelectionListener((SelectionListener)this);
        this.actorsText.removeSelectionListener((SelectionListener)this);
        this.actorsText.removeFocusListener((FocusListener)this);
        this.subjectText.removeSelectionListener((SelectionListener)this);
        this.subjectText.removeFocusListener((FocusListener)this);
        this.bodyText.removeSelectionListener((SelectionListener)this);
        this.bodyText.removeFocusListener((FocusListener)this);
    }

    private void clearControls() {
        this.templateText.setText("");
        this.toButton.setSelection(true);
        this.toText.setText("");
        this.toText.setEnabled(true);
        this.actorsButton.setSelection(false);
        this.actorsText.setText("");
        this.actorsText.setEnabled(false);
        this.subjectText.setText("");
        this.bodyText.setText("");
    }

    private void updateControls() {
        this.templateText.setText(this.mailNode.getTemplate() == null ? "" : this.mailNode.getTemplate());
        if (this.mailNode.getActors() != null) {
            this.toButton.setSelection(false);
            this.actorsButton.setSelection(true);
            this.toText.setText("");
            this.toText.setEnabled(false);
            this.actorsText.setText(this.mailNode.getActors());
            this.actorsText.setEnabled(true);
        } else {
            this.toButton.setSelection(true);
            this.actorsButton.setSelection(false);
            this.actorsText.setText("");
            this.actorsText.setEnabled(false);
            this.toText.setText(this.mailNode.getTo() == null ? "" : this.mailNode.getTo());
            this.toText.setEnabled(true);
        }
        this.subjectText.setText(this.getSubjectText());
        this.bodyText.setText(this.getBodyText());
    }

    private String getSubjectText() {
        String result = "";
        Subject subject = this.mailNode.getSubject();
        if (subject != null) {
            result = subject.getSubject() == null ? "" : subject.getSubject();
        }
        return result;
    }

    private String getBodyText() {
        String result = "";
        if (this.mailNode.getText() != null) {
            result = this.mailNode.getText().getText() == null ? "" : this.mailNode.getText().getText();
        }
        return result;
    }

    private void create() {
        this.templateLabel = this.widgetFactory.createLabel(this.parent, "Template");
        this.templateText = this.widgetFactory.createText(this.parent, "");
        this.toButton = this.widgetFactory.createButton(this.parent, "To", 16);
        this.toButton.setSelection(true);
        this.toText = this.widgetFactory.createText(this.parent, "");
        this.actorsButton = this.widgetFactory.createButton(this.parent, "Actors", 16);
        this.actorsText = this.widgetFactory.createText(this.parent, "");
        this.actorsText.setEnabled(false);
        this.subjectLabel = this.widgetFactory.createLabel(this.parent, "Subject");
        this.subjectText = this.widgetFactory.createText(this.parent, "");
        this.bodyLabel = this.widgetFactory.createLabel(this.parent, "Body");
        this.bodyText = this.widgetFactory.createText(this.parent, "", 514);
        this.templateLabel.setLayoutData((Object)this.createTemplateLabelLayoutData());
        this.templateText.setLayoutData((Object)this.createTemplateTextLayoutData());
        this.toButton.setLayoutData((Object)this.createToButtonLayoutData());
        this.toText.setLayoutData((Object)this.createToTextLayoutData());
        this.actorsButton.setLayoutData((Object)this.createActorsButtonLayoutData());
        this.actorsText.setLayoutData((Object)this.createActorsTextLayoutData());
        this.subjectLabel.setLayoutData((Object)this.createSubjectLabelLayoutData());
        this.subjectText.setLayoutData((Object)this.createSubjectTextLayoutData());
        this.bodyLabel.setLayoutData((Object)this.createBodyLabelLayoutData());
        this.bodyText.setLayoutData((Object)this.createBodyTextLayoutData());
    }

    private FormData createToButtonLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.templateText, 0);
        return data;
    }

    private FormData createToTextLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment((Control)this.templateText, 0);
        data.left.alignment = 16384;
        data.top = new FormAttachment((Control)this.templateText, 0);
        data.right = new FormAttachment(50, 0);
        return data;
    }

    private FormData createActorsButtonLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment((Control)this.toText, 0);
        data.top = new FormAttachment((Control)this.templateText, 0);
        return data;
    }

    private FormData createActorsTextLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment((Control)this.actorsButton, 0);
        data.top = new FormAttachment((Control)this.templateText, 0);
        data.right = new FormAttachment(100, 0);
        return data;
    }

    private FormData createSubjectLabelLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.toText, 0);
        return data;
    }

    private FormData createSubjectTextLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment((Control)this.templateText, 0);
        data.left.alignment = 16384;
        data.top = new FormAttachment((Control)this.toText, 0);
        data.right = new FormAttachment(100, 0);
        return data;
    }

    private FormData createBodyLabelLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.subjectText, 0);
        return data;
    }

    private FormData createBodyTextLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment((Control)this.templateText, 0);
        data.left.alignment = 16384;
        data.top = new FormAttachment((Control)this.subjectText, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        data.height = 100;
        return data;
    }

    private FormData createTemplateTextLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment((Control)this.templateLabel, 0);
        data.top = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        return data;
    }

    private FormData createTemplateLabelLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 0);
        return data;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        if (e.widget == this.templateText) {
            this.mailNode.setTemplate(this.getTemplateText());
        } else if (e.widget == this.toText) {
            this.mailNode.setTo(this.toText.getText());
        } else if (e.widget == this.actorsText) {
            this.mailNode.setActors(this.actorsText.getText());
        } else if (e.widget == this.subjectText) {
            this.handleSubjectTextChange();
        } else if (e.widget == this.bodyText) {
            this.handleBodyTextChange();
        }
    }

    private void handleSubjectTextChange() {
        Subject subject = this.mailNode.getSubject();
        if (subject == null) {
            subject = (Subject)this.mailNode.getFactory().createById("org.jbpm.gd.jpdl.subject");
            this.mailNode.setSubject(subject);
        }
        subject.setSubject(this.subjectText.getText());
    }

    private void handleBodyTextChange() {
        org.jbpm.gd.jpdl.model.Text text = this.mailNode.getText();
        if (text == null) {
            text = (org.jbpm.gd.jpdl.model.Text)this.mailNode.getFactory().createById("org.jbpm.gd.jpdl.text");
            this.mailNode.setText(text);
        }
        text.setText(this.bodyText.getText());
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.toButton) {
            this.handleToButtonSelection();
        }
    }

    private void handleToButtonSelection() {
        if (this.toButton.getSelection()) {
            this.mailNode.setTo(this.toText.getText());
            this.mailNode.setActors(null);
            this.actorsText.setEnabled(false);
            this.toText.setEnabled(true);
        } else {
            this.mailNode.setActors(this.actorsText.getText());
            this.mailNode.setTo(null);
            this.toText.setEnabled(false);
            this.actorsText.setEnabled(true);
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (e.widget == this.templateText) {
            this.mailNode.setTemplate(this.getTemplateText());
        } else if (e.widget == this.toText) {
            this.mailNode.setTo(this.toText.getText());
        } else if (e.widget == this.actorsText) {
            this.mailNode.setActors(this.actorsText.getText());
        } else if (e.widget == this.subjectText) {
            this.handleSubjectTextChange();
        } else if (e.widget == this.bodyText) {
            this.handleBodyTextChange();
        }
    }

    private String getTemplateText() {
        return "".equals(this.templateText.getText()) ? null : this.templateText.getText();
    }
}

