/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.properties;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jboss.tools.jbpm.util.AutoResizeTableLayout;
import org.jbpm.gd.common.model.GenericElement;
import org.jbpm.gd.jpdl.Logger;
import org.jbpm.gd.jpdl.dialog.ChooseDelegationClassDialog;
import org.jbpm.gd.jpdl.model.Delegation;
import org.jbpm.gd.jpdl.util.ProjectFinder;

public class DelegationConfigurationComposite
implements KeyListener,
SelectionListener,
FocusListener {
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private Composite parent;
    private ChooseDelegationClassDialog chooseDelegationClassDialog;
    private Delegation delegation;
    private Label nameLabel;
    private Text nameText;
    private Button searchButton;
    private Label configTypeLabel;
    private CCombo configTypeCombo;
    private HashMap configAreaPages = new HashMap();
    private LabelComposite messageLabel;
    private TextComposite constructorTextComposite;
    private TextComposite compatibilityTextComposite;
    private TableComposite fieldTableComposite;
    private TableComposite beanTableComposite;

    public static DelegationConfigurationComposite create(TabbedPropertySheetWidgetFactory widgetFactory, Composite parent, ChooseDelegationClassDialog dialog) {
        DelegationConfigurationComposite result = new DelegationConfigurationComposite();
        result.chooseDelegationClassDialog = dialog;
        result.widgetFactory = widgetFactory;
        result.parent = parent;
        result.create();
        return result;
    }

    private DelegationConfigurationComposite() {
    }

    public void setDelegation(Delegation delegation) {
        if (this.delegation == delegation) {
            return;
        }
        this.unhookListeners();
        this.delegation = delegation;
        this.clearControls();
        if (delegation != null) {
            this.updateControls();
            this.hookListeners();
        }
    }

    private void hookListeners() {
        this.nameText.addKeyListener((KeyListener)this);
        this.searchButton.addSelectionListener((SelectionListener)this);
        this.configTypeCombo.addSelectionListener((SelectionListener)this);
        this.constructorTextComposite.text.addFocusListener((FocusListener)this);
        this.compatibilityTextComposite.text.addFocusListener((FocusListener)this);
    }

    private void unhookListeners() {
        this.nameText.removeKeyListener((KeyListener)this);
        this.searchButton.removeSelectionListener((SelectionListener)this);
        this.configTypeCombo.removeSelectionListener((SelectionListener)this);
        this.constructorTextComposite.text.removeFocusListener((FocusListener)this);
        this.compatibilityTextComposite.text.removeFocusListener((FocusListener)this);
    }

    private void clearControls() {
        this.nameText.setText("");
        this.configTypeCombo.setText("Field");
        this.showPage("Message");
        this.messageLabel.setText("");
        this.fieldTableComposite.table.removeAll();
        this.beanTableComposite.table.removeAll();
        this.constructorTextComposite.text.setText("");
        this.compatibilityTextComposite.text.setText("");
    }

    private void showPage(String key) {
        for (String candidate : this.configAreaPages.keySet()) {
            ((DelegationConfigurationWidget)this.configAreaPages.get(candidate)).setVisible(candidate.equals(key));
        }
    }

    private void updateControls() {
        this.nameText.setText(this.getDelegationClassName());
        this.configTypeCombo.setText(this.fromConfigType(this.getDelegationConfigType()));
        this.updatePageBook();
    }

    private void updatePageBook() {
        IType type = this.getClassFor(this.nameText.getText());
        this.updateFieldTableComposite(type);
        this.updateBeanTableComposite(type);
        this.updateConstructorTextComposite();
        this.updateCompatibilityTextComposite();
        this.updateVisiblePage(type != null);
    }

    private void updateFieldTableComposite(IType type) {
        if (type == null) {
            return;
        }
        List list = this.getFields(type);
        int i = 0;
        while (i < list.size()) {
            TableItem item = new TableItem(this.fieldTableComposite.table, 0);
            item.setText(0, (String)list.get(i));
            ++i;
        }
        if ("field".equals(this.getDelegationConfigType())) {
            this.updateTableItems(this.fieldTableComposite.table.getItems());
        }
    }

    private void updateTableItems(TableItem[] items) {
        GenericElement[] elements = this.delegation.getGenericElements();
        int i = 0;
        while (i < elements.length) {
            int j = 0;
            while (j < items.length) {
                String value;
                String name = elements[i].getName() == null ? "" : elements[i].getName();
                String string = value = elements[i].getValue() == null ? "" : elements[i].getValue();
                if (name.equals(items[j].getText(0))) {
                    items[j].setChecked(true);
                    items[j].setText(1, value);
                    items[j].setData((Object)elements[i]);
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    private void updateBeanTableComposite(IType type) {
        if (type == null) {
            return;
        }
        List list = this.getSetters(type);
        int i = 0;
        while (i < list.size()) {
            TableItem item = new TableItem(this.beanTableComposite.table, 0);
            item.setText(0, (String)list.get(i));
            ++i;
        }
        if ("bean".equals(this.getDelegationConfigType())) {
            this.updateTableItems(this.beanTableComposite.table.getItems());
        }
    }

    private void updateConstructorTextComposite() {
        boolean valid = "constructor".equals(this.getDelegationConfigType());
        this.constructorTextComposite.text.setText(valid ? this.getDelegationConfigString() : "");
    }

    private void updateCompatibilityTextComposite() {
        boolean valid = "configuration-property".equals(this.getDelegationConfigType());
        this.constructorTextComposite.text.setText(valid ? this.getDelegationConfigString() : "");
    }

    private void updateVisiblePage(boolean validClass) {
        if (!validClass) {
            this.showInvalidTypeMessage();
        } else {
            this.handleValidType();
        }
    }

    private String getDelegationConfigType() {
        return this.delegation.getConfigType() == null ? "field" : this.delegation.getConfigType();
    }

    private String getDelegationClassName() {
        return this.delegation.getClassName() == null ? "" : this.delegation.getClassName();
    }

    private String getDelegationConfigString() {
        return this.delegation.getConfigInfo() == null ? "" : this.delegation.getConfigInfo();
    }

    private void create() {
        this.nameLabel = this.widgetFactory.createLabel(this.parent, "Class Name");
        this.nameText = this.widgetFactory.createText(this.parent, "");
        this.searchButton = this.widgetFactory.createButton(this.parent, "Search...", 8);
        this.configTypeLabel = this.widgetFactory.createLabel(this.parent, "Config Type");
        this.configTypeCombo = this.widgetFactory.createCCombo(this.parent);
        this.configTypeCombo.setItems(this.getConfigurationTypes());
        this.configTypeCombo.setEditable(false);
        this.createPages(this.parent);
        this.nameLabel.setLayoutData((Object)this.createNameLabelLayoutData());
        this.nameText.setLayoutData((Object)this.createNameTextLayoutData());
        this.searchButton.setLayoutData((Object)this.createSearchButtonLayoutData());
        this.configTypeLabel.setLayoutData((Object)this.createConfigTypeLabelLayoutData());
        this.configTypeCombo.setLayoutData((Object)this.createConfigTypeComboLayoutData());
    }

    private void createPages(Composite composite) {
        this.messageLabel = new LabelComposite();
        this.messageLabel.create(composite);
        this.configAreaPages.put("Message", this.messageLabel);
        this.fieldTableComposite = new TableComposite();
        this.fieldTableComposite.create(composite);
        this.configAreaPages.put("Field", this.fieldTableComposite);
        this.beanTableComposite = new TableComposite();
        this.beanTableComposite.create(composite);
        this.configAreaPages.put("Bean", this.beanTableComposite);
        this.constructorTextComposite = new TextComposite();
        this.constructorTextComposite.create(composite);
        this.configAreaPages.put("Constructor", this.constructorTextComposite);
        this.compatibilityTextComposite = new TextComposite();
        this.compatibilityTextComposite.create(composite);
        this.configAreaPages.put("Compatibility", this.compatibilityTextComposite);
    }

    private String[] getConfigurationTypes() {
        return new String[]{"Field", "Bean", "Constructor", "Compatibility"};
    }

    private FormData createNameLabelLayoutData() {
        FormData result = new FormData();
        result.left = new FormAttachment(0, 0);
        result.top = new FormAttachment(0, 2);
        return result;
    }

    private FormData createNameTextLayoutData() {
        FormData result = new FormData();
        result.left = new FormAttachment((Control)this.nameLabel, 0);
        result.right = new FormAttachment((Control)this.searchButton, 0);
        result.top = new FormAttachment(0, 0);
        return result;
    }

    private FormData createSearchButtonLayoutData() {
        FormData result = new FormData();
        result.right = new FormAttachment((Control)this.configTypeLabel, 0);
        result.top = new FormAttachment(0, -3);
        return result;
    }

    private FormData createConfigTypeLabelLayoutData() {
        FormData result = new FormData();
        result.right = new FormAttachment((Control)this.configTypeCombo, 0);
        result.top = new FormAttachment(0, 2);
        return result;
    }

    private FormData createConfigTypeComboLayoutData() {
        FormData result = new FormData();
        result.right = new FormAttachment(100, 0);
        result.top = new FormAttachment(0, -2);
        return result;
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.widget == this.nameText) {
            this.handleNameTextChange();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void handleNameTextChange() {
        String newName = this.nameText.getText();
        if (newName.equals(this.delegation.getClassName())) {
            return;
        }
        this.delegation.setClassName(newName);
        if (this.delegation.getConfigInfo() != null) {
            this.delegation.setConfigInfo(null);
        }
        GenericElement[] genericElements = this.delegation.getGenericElements();
        this.fieldTableComposite.table.removeAll();
        this.beanTableComposite.table.removeAll();
        int i = 0;
        while (i < genericElements.length) {
            this.delegation.removeGenericElement(genericElements[i]);
            ++i;
        }
        this.updatePageBook();
    }

    private void handleValidType() {
        String configType = this.delegation.getConfigType();
        if ("field".equals(configType)) {
            this.handleFieldConfigType();
        } else if ("bean".equals(configType)) {
            this.handleBeanConfigType();
        } else if ("constructor".equals(configType)) {
            this.handleConstructorConfigType();
        } else if ("configuration-property".equals(configType)) {
            this.handleCompatibilityConfigType();
        }
    }

    private void handleFieldConfigType() {
        if (this.fieldTableComposite.table.getItemCount() == 0) {
            this.messageLabel.setText("The class does not have any fields");
            this.showPage("Message");
        } else {
            this.showPage("Field");
            this.restoreConfigElements(this.fieldTableComposite.table.getItems());
        }
    }

    private void restoreConfigElements(TableItem[] items) {
        if (this.delegation.getGenericElements().length == 0) {
            int i = 0;
            while (i < items.length) {
                if (items[i].getChecked()) {
                    this.addGenericElement(items[i]);
                }
                ++i;
            }
        }
    }

    private List getFields(IType type) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            List types = this.getTypes(type);
            int i = 0;
            while (i < types.size()) {
                IType subType = (IType)types.get(i);
                IField[] fields = subType.getFields();
                int j = 0;
                while (j < fields.length) {
                    String fieldName;
                    if (!Flags.isStatic((int)fields[j].getFlags()) && !result.contains(fieldName = fields[j].getElementName())) {
                        result.add(fieldName);
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            Logger.logError("Error while getting the fields for type " + type + ".", e);
        }
        return result;
    }

    private IType getSupertype(IType targetType) throws JavaModelException {
        String qualifiedName;
        if (targetType == null) {
            return null;
        }
        String name = targetType.getSuperclassName();
        if (name == null) {
            return null;
        }
        IType result = this.getClassFor(name);
        if (result != null) {
            return result;
        }
        ICompilationUnit compilationUnit = targetType.getCompilationUnit();
        if (compilationUnit == null) {
            return null;
        }
        IPackageDeclaration[] packageDeclarations = compilationUnit.getPackageDeclarations();
        if (packageDeclarations != null && packageDeclarations.length > 0 && (result = this.getClassFor(qualifiedName = String.valueOf(packageDeclarations[0].getElementName()) + "." + name)) != null) {
            return result;
        }
        IImportDeclaration[] importDeclarations = compilationUnit.getImports();
        if (importDeclarations == null) {
            return null;
        }
        int i = 0;
        while (i < importDeclarations.length) {
            String qualifiedName2;
            String declaration = importDeclarations[i].getElementName();
            if (declaration.endsWith(name) ? (result = this.getClassFor(declaration)) != null : declaration.endsWith(".*") && (result = this.getClassFor(qualifiedName2 = String.valueOf(declaration.substring(0, declaration.length() - 1)) + name)) != null) {
                return result;
            }
            ++i;
        }
        return null;
    }

    private List getTypes(IType targetType) {
        ArrayList<IType> types = new ArrayList<IType>();
        IType type = targetType;
        while (type != null && !"java.lang.Object".equals(type.getFullyQualifiedName())) {
            try {
                types.add(type);
                type = this.getSupertype(type);
            }
            catch (JavaModelException e) {
                Logger.logError("Error while looking up the supertypes of " + targetType.getFullyQualifiedName() + ".", e);
            }
        }
        return types;
    }

    private void handleBeanConfigType() {
        if (this.beanTableComposite.table.getItemCount() == 0) {
            this.messageLabel.setText("The class does not have any setters");
            this.showPage("Message");
        } else {
            this.showPage("Bean");
            this.restoreConfigElements(this.beanTableComposite.table.getItems());
        }
    }

    private List getSetters(IType type) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            List types = this.getTypes(type);
            int i = 0;
            while (i < types.size()) {
                IType subType = (IType)types.get(i);
                IMethod[] methods = subType.getMethods();
                int j = 0;
                while (j < methods.length) {
                    if (methods[j].getElementName().startsWith("set")) {
                        StringBuffer buff = new StringBuffer(methods[j].getElementName().substring(3));
                        buff.setCharAt(0, Character.toLowerCase(buff.charAt(0)));
                        String methodName = buff.toString();
                        if (!result.contains(methodName)) {
                            result.add(methodName);
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            Logger.logError("Error while getting the setters for type " + type + ".", e);
        }
        return result;
    }

    private void handleConstructorConfigType() {
        this.showPage("Constructor");
        if (this.delegation.getConfigInfo() == null) {
            this.delegation.setConfigInfo(this.constructorTextComposite.text.getText());
        } else {
            this.constructorTextComposite.text.setText(this.delegation.getConfigInfo());
        }
    }

    private void handleCompatibilityConfigType() {
        this.showPage("Compatibility");
        if (this.delegation.getConfigInfo() == null) {
            this.delegation.setConfigInfo(this.compatibilityTextComposite.text.getText());
        } else {
            this.compatibilityTextComposite.text.setText(this.delegation.getConfigInfo());
        }
    }

    private void showInvalidTypeMessage() {
        this.messageLabel.setText("The class does not exist on the project classpath.");
        this.showPage("Message");
    }

    private IType getClassFor(String className) {
        if (className == null) {
            return null;
        }
        try {
            return ProjectFinder.getCurrentProject().findType(className);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void addGenericElement(TableItem item) {
        String name = item.getText(0) == null ? "" : item.getText(0);
        String value = item.getText(1) == null ? "" : item.getText(1);
        GenericElement genericElement = (GenericElement)this.delegation.getFactory().createById("org.jbpm.gd.jpdl.genericElement");
        genericElement.setName(name);
        genericElement.setValue(value);
        this.delegation.addGenericElement(genericElement);
        item.setData((Object)genericElement);
    }

    private void removeGenericElement(TableItem item) {
        GenericElement genericElement = (GenericElement)item.getData();
        if (genericElement != null) {
            this.delegation.removeGenericElement(genericElement);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.searchButton) {
            this.handleSearchButtonSelected();
        } else if (e.widget == this.configTypeCombo) {
            this.handleConfigTypeComboChanged();
        }
    }

    private void handleConfigTypeComboChanged() {
        String newConfigType = this.toConfigType(this.configTypeCombo.getText());
        if (this.delegation.getConfigType().equals(newConfigType)) {
            return;
        }
        this.delegation.setConfigInfo(null);
        GenericElement[] genericElements = this.delegation.getGenericElements();
        int i = 0;
        while (i < genericElements.length) {
            this.delegation.removeGenericElement(genericElements[i]);
            ++i;
        }
        this.delegation.setConfigType(newConfigType);
        this.updateVisiblePage(this.getClassFor(this.nameText.getText()) != null);
    }

    private void handleSearchButtonSelected() {
        String chosenClass = this.chooseDelegationClassDialog.openDialog();
        if (chosenClass != null) {
            this.nameText.setText(chosenClass);
            this.handleNameTextChange();
        }
    }

    private String toConfigType(String configType) {
        if ("Field".equals(configType)) {
            return "field";
        }
        if ("Bean".equals(configType)) {
            return "bean";
        }
        if ("Constructor".equals(configType)) {
            return "constructor";
        }
        if ("Compatibility".equals(configType)) {
            return "configuration-property";
        }
        return null;
    }

    private String fromConfigType(String configType) {
        if ("field".equals(configType)) {
            return "Field";
        }
        if ("bean".equals(configType)) {
            return "Bean";
        }
        if ("constructor".equals(configType)) {
            return "Constructor";
        }
        if ("configuration-property".equals(configType)) {
            return "Compatibility";
        }
        return null;
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (e.widget == this.constructorTextComposite.text) {
            this.delegation.setConfigInfo(this.constructorTextComposite.text.getText());
        } else if (e.widget == this.compatibilityTextComposite.text) {
            this.delegation.setConfigInfo(this.compatibilityTextComposite.text.getText());
        }
    }

    public Delegation getDelegation() {
        return this.delegation;
    }

    private static interface DelegationConfigurationWidget {
        public void setVisible(boolean var1);
    }

    private class LabelComposite
    implements DelegationConfigurationWidget {
        private Label label;

        private LabelComposite() {
        }

        private void create(Composite parent) {
            this.label = DelegationConfigurationComposite.this.widgetFactory.createLabel(parent, "");
            this.label.setLayoutData((Object)this.createLabelLayoutData());
        }

        private void setText(String message) {
            this.label.setText(message);
        }

        public void setVisible(boolean visible) {
            this.label.setVisible(visible);
        }

        private FormData createLabelLayoutData() {
            FormData result = new FormData();
            result.left = new FormAttachment(0, 0);
            result.right = new FormAttachment(100, 0);
            result.top = new FormAttachment((Control)DelegationConfigurationComposite.this.configTypeCombo, 2);
            return result;
        }
    }

    private class TableComposite
    implements FocusListener,
    MouseListener,
    SelectionListener,
    DelegationConfigurationWidget {
        private Label label;
        private Table table;
        private TableEditor valueEditor;
        private Text valueText;

        private TableComposite() {
        }

        private void create(Composite parent) {
            this.label = DelegationConfigurationComposite.this.widgetFactory.createLabel(parent, "Config Info");
            this.table = DelegationConfigurationComposite.this.widgetFactory.createTable(parent, 66080);
            this.label.setLayoutData((Object)this.createLabelLayoutData());
            this.table.setLayoutData((Object)this.createTableLayoutData());
            this.table.setHeaderVisible(true);
            this.table.setLinesVisible(true);
            this.table.addSelectionListener((SelectionListener)this);
            this.table.addMouseListener((MouseListener)this);
            AutoResizeTableLayout handlerConfigBeanTableLayout = new AutoResizeTableLayout(this.table);
            handlerConfigBeanTableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(40));
            handlerConfigBeanTableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(60));
            this.table.setLayout((Layout)handlerConfigBeanTableLayout);
            TableColumn handlerConfigBeanTableNameColumn = new TableColumn(this.table, 0);
            handlerConfigBeanTableNameColumn.setText("Name");
            TableColumn handlerConfigBeanTableValueColumn = new TableColumn(this.table, 0);
            handlerConfigBeanTableValueColumn.setText("Value");
            this.createEditor();
        }

        private FormData createLabelLayoutData() {
            FormData result = new FormData();
            result.left = new FormAttachment(0, 0);
            result.top = new FormAttachment((Control)DelegationConfigurationComposite.this.configTypeCombo, 2);
            return result;
        }

        private FormData createTableLayoutData() {
            FormData result = new FormData();
            result.top = new FormAttachment((Control)DelegationConfigurationComposite.this.configTypeCombo, 0);
            result.left = new FormAttachment((Control)DelegationConfigurationComposite.this.nameText, 0);
            result.left.alignment = 16384;
            result.right = new FormAttachment(100, 0);
            result.bottom = new FormAttachment(100, 0);
            return result;
        }

        private void createEditor() {
            this.valueEditor = new TableEditor(this.table);
            this.valueText = new Text((Composite)this.table, 0);
            this.valueText.setVisible(false);
            this.valueText.setText("");
            this.valueEditor.minimumWidth = this.valueText.getSize().x;
            this.valueEditor.horizontalAlignment = 16384;
            this.valueEditor.grabHorizontal = true;
        }

        private void doEdit() {
            if (this.valueText.isVisible()) {
                this.endEdit();
            }
            if (this.table.getSelectionIndex() == -1) {
                return;
            }
            TableItem selection = this.table.getItem(this.table.getSelectionIndex());
            String value = selection.getText(1);
            this.valueText.setText(value == null ? "" : value);
            this.valueEditor.setEditor((Control)this.valueText, selection, 1);
            this.valueText.setVisible(true);
            this.valueText.selectAll();
            this.valueText.setFocus();
            this.valueText.addFocusListener((FocusListener)this);
        }

        private void endEdit() {
            this.valueText.setVisible(false);
            this.valueText.setText("");
            this.valueText.removeFocusListener((FocusListener)this);
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
            int column = this.getSelectedColumn(e.x, e.y);
            if (column == -1) {
                return;
            }
            if (column == 1) {
                this.doEdit();
            }
        }

        private int getSelectedColumn(int x, int y) {
            int columnToEdit = -1;
            int columns = this.table.getColumnCount();
            TableItem tableItem = this.getSelectedTableItem();
            if (tableItem == null) {
                return -1;
            }
            int i = 0;
            while (i < columns) {
                Rectangle bounds = tableItem.getBounds(i);
                if (bounds.contains(x, y)) {
                    columnToEdit = i;
                    break;
                }
                ++i;
            }
            return columnToEdit;
        }

        private TableItem getSelectedTableItem() {
            TableItem[] selection = this.table.getSelection();
            if (selection.length > 0) {
                return selection[0];
            }
            return null;
        }

        public void mouseUp(MouseEvent e) {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        private void applyValue() {
            TableItem item = this.getSelectedTableItem();
            if (item == null) {
                return;
            }
            item.setText(1, this.valueText.getText());
            GenericElement element = (GenericElement)item.getData();
            if (element == null) {
                return;
            }
            element.setValue(this.valueText.getText());
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == this.table && e.detail == 32 && e.item instanceof TableItem) {
                this.handleTableItemCheck((TableItem)e.item);
            }
        }

        private void handleTableItemCheck(TableItem item) {
            if (item.getChecked()) {
                DelegationConfigurationComposite.this.addGenericElement(item);
            } else {
                DelegationConfigurationComposite.this.removeGenericElement(item);
            }
            this.table.setSelection(item);
        }

        public void setVisible(boolean visible) {
            this.label.setVisible(visible);
            this.table.setVisible(visible);
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            if (e.widget == this.valueText) {
                this.applyValue();
                this.endEdit();
            }
        }
    }

    private class TextComposite
    implements DelegationConfigurationWidget {
        private Label label;
        private Text text;

        private TextComposite() {
        }

        private void create(Composite parent) {
            this.label = DelegationConfigurationComposite.this.widgetFactory.createLabel(parent, "Config Info");
            this.text = DelegationConfigurationComposite.this.widgetFactory.createText(parent, "", 514);
            this.label.setLayoutData((Object)this.createLabelLayoutData());
            this.text.setLayoutData((Object)this.createTextLayoutData());
        }

        private FormData createLabelLayoutData() {
            FormData result = new FormData();
            result.left = new FormAttachment(0, 0);
            result.top = new FormAttachment((Control)DelegationConfigurationComposite.this.configTypeCombo, 2);
            return result;
        }

        private FormData createTextLayoutData() {
            FormData result = new FormData();
            result.top = new FormAttachment((Control)DelegationConfigurationComposite.this.configTypeCombo, 0);
            result.left = new FormAttachment((Control)DelegationConfigurationComposite.this.nameText, 0);
            result.left.alignment = 16384;
            result.right = new FormAttachment(100, 0);
            result.bottom = new FormAttachment(100, 0);
            return result;
        }

        public void setVisible(boolean visible) {
            this.label.setVisible(visible);
            this.text.setVisible(visible);
        }
    }
}

