/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.properties;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jbpm.gd.jpdl.dialog.ChooseDelegationClassDialog;
import org.jbpm.gd.jpdl.model.Controller;
import org.jbpm.gd.jpdl.model.Task;
import org.jbpm.gd.jpdl.properties.DelegationConfigurationComposite;
import org.jbpm.gd.jpdl.properties.VariableContainerConfigurationComposite;

public class ControllerConfigurationComposite
implements SelectionListener,
FocusListener {
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private Composite parent;
    private Task task;
    private CCombo controllerTypeCombo;
    private HashMap pagesMap = new HashMap();
    private DelegationConfigurationComposite delegationConfigurationComposite;
    private VariableContainerConfigurationComposite variableContainerConfigurationComposite;

    public static ControllerConfigurationComposite create(TabbedPropertySheetWidgetFactory widgetFactory, Composite parent) {
        ControllerConfigurationComposite result = new ControllerConfigurationComposite();
        result.widgetFactory = widgetFactory;
        result.parent = parent;
        result.create();
        return result;
    }

    private ControllerConfigurationComposite() {
    }

    public void setTask(Task task) {
        if (this.task == task) {
            return;
        }
        this.unhookListeners();
        this.task = task;
        this.clearControls();
        if (task != null) {
            this.updateControls();
            this.hookListeners();
        }
    }

    private void hookListeners() {
        this.controllerTypeCombo.setEnabled(true);
        this.controllerTypeCombo.addSelectionListener((SelectionListener)this);
    }

    private void unhookListeners() {
        this.controllerTypeCombo.setEnabled(false);
        this.controllerTypeCombo.removeSelectionListener((SelectionListener)this);
    }

    private void clearControls() {
        this.controllerTypeCombo.setText("");
        Iterator iter = this.pagesMap.keySet().iterator();
        while (iter.hasNext()) {
            ((Composite)this.pagesMap.get(iter.next())).setVisible(false);
        }
        this.variableContainerConfigurationComposite.setVariableContainer(null);
        this.delegationConfigurationComposite.setDelegation(null);
    }

    private void updateControls() {
        Controller controller = this.task.getController();
        if (controller != null) {
            String className = controller.getClassName();
            if (className == null) {
                this.controllerTypeCombo.setText("Default");
                this.variableContainerConfigurationComposite.setVariableContainer(controller);
            } else {
                this.controllerTypeCombo.setText("Custom");
                this.delegationConfigurationComposite.setDelegation(controller);
            }
        } else {
            this.controllerTypeCombo.setText("<Choose>");
        }
        for (String str : this.pagesMap.keySet()) {
            ((Composite)this.pagesMap.get(str)).setVisible(str.equals(this.controllerTypeCombo.getText()));
        }
    }

    private void create() {
        this.controllerTypeCombo = this.widgetFactory.createCCombo(this.parent);
        this.controllerTypeCombo.setItems(new String[]{"<Choose>", "Default", "Custom"});
        this.controllerTypeCombo.setLayoutData((Object)this.createControllerTypeComboLayoutData());
        this.createDefaultPage();
        this.createCustomPage();
    }

    private void createDefaultPage() {
        Composite defaultPage = this.widgetFactory.createFlatFormComposite(this.parent);
        this.pagesMap.put("Default", defaultPage);
        defaultPage.setLayoutData((Object)this.createGroupLayoutData());
        this.variableContainerConfigurationComposite = VariableContainerConfigurationComposite.create((FormToolkit)this.widgetFactory, defaultPage);
    }

    private void createCustomPage() {
        Composite customPage = this.widgetFactory.createFlatFormComposite(this.parent);
        this.pagesMap.put("Custom", customPage);
        customPage.setLayoutData((Object)this.createGroupLayoutData());
        this.delegationConfigurationComposite = DelegationConfigurationComposite.create(this.widgetFactory, customPage, this.createChooseControllerClassDialog());
    }

    private ChooseDelegationClassDialog createChooseControllerClassDialog() {
        return new ChooseDelegationClassDialog(this.parent.getShell(), "org.jbpm.taskmgmt.def.TaskControllerHandler", "Choose Controller Handler", "Choose a task controller handler from the list");
    }

    private FormData createGroupLayoutData() {
        FormData result = new FormData();
        result.top = new FormAttachment(0, 0);
        result.left = new FormAttachment((Control)this.controllerTypeCombo, 0);
        result.right = new FormAttachment(100, 0);
        result.bottom = new FormAttachment(100, 0);
        return result;
    }

    private FormData createControllerTypeComboLayoutData() {
        FormData result = new FormData();
        result.left = new FormAttachment(0, 0);
        result.top = new FormAttachment(0, 0);
        return result;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.controllerTypeCombo) {
            this.handleControllerTypeComboSelected();
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
    }

    private void handleControllerTypeComboSelected() {
        Controller controller;
        String type = this.controllerTypeCombo.getText();
        if ("".equals(type)) {
            this.task.setController(null);
        } else if ("Default".equals(type)) {
            controller = (Controller)this.variableContainerConfigurationComposite.getVariableContainer();
            if (controller == null) {
                controller = this.createController();
                this.variableContainerConfigurationComposite.setVariableContainer(controller);
            }
            this.task.setController(controller);
        } else if ("Custom".equals(type)) {
            controller = (Controller)this.delegationConfigurationComposite.getDelegation();
            if (controller == null) {
                controller = this.createController();
                controller.setClassName("");
                this.delegationConfigurationComposite.setDelegation(controller);
            }
            this.task.setController(controller);
        }
        for (String str : this.pagesMap.keySet()) {
            ((Composite)this.pagesMap.get(str)).setVisible(type.equals(str));
        }
    }

    private Controller createController() {
        return (Controller)this.task.getFactory().createById("org.jbpm.gd.jpdl.controller");
    }
}

