/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.gd.jpdl.model.Controller;
import org.jbpm.gd.jpdl.model.DescribableElement;
import org.jbpm.gd.jpdl.model.Description;
import org.jbpm.gd.jpdl.model.Event;
import org.jbpm.gd.jpdl.model.EventContainer;
import org.jbpm.gd.jpdl.model.Reminder;
import org.jbpm.gd.jpdl.model.Swimlane;
import org.jbpm.gd.jpdl.model.Timer;
import org.jbpm.gd.jpdl.model.TimerContainer;

public class Task
extends Swimlane
implements EventContainer,
TimerContainer,
DescribableElement {
    private Controller controller;
    private Reminder reminder;
    private List events = new ArrayList();
    private List timers = new ArrayList();
    private String blocking = "false";
    private String signalling = "true";
    private String notify = "false";
    private Description description;
    private String dueDate;
    private String swimlane;
    private String priority = "normal";
    private HashMap customProperties = new HashMap();

    public void setProperty(String name, String newValue) {
        String oldValue = (String)this.customProperties.get(name);
        this.customProperties.put(name, newValue);
        this.firePropertyChange("custom", new String[]{name, oldValue}, new String[]{name, newValue});
    }

    public String getProperty(String name) {
        return (String)this.customProperties.get(name);
    }

    public Map getProperties() {
        return new HashMap(this.customProperties);
    }

    public void setReminder(Reminder newReminder) {
        Reminder oldReminder = this.reminder;
        this.reminder = newReminder;
        this.firePropertyChange("reminder", oldReminder, newReminder);
    }

    public Reminder getReminder() {
        return this.reminder;
    }

    public void setController(Controller newController) {
        Controller oldController = this.controller;
        this.controller = newController;
        this.firePropertyChange("controller", oldController, newController);
    }

    public Controller getController() {
        return this.controller;
    }

    public void addEvent(Event event) {
        this.events.add(event);
        this.firePropertyChange("eventAdd", null, event);
    }

    public void removeEvent(Event event) {
        this.events.remove(event);
        this.firePropertyChange("eventRemove", event, null);
    }

    public Event[] getEvents() {
        return this.events.toArray(new Event[this.events.size()]);
    }

    public void addTimer(Timer timer) {
        this.timers.add(timer);
        this.firePropertyChange("timerAdd", null, timer);
    }

    public void removeTimer(Timer timer) {
        this.timers.remove(timer);
        this.firePropertyChange("timerRemove", timer, null);
    }

    public Timer[] getTimers() {
        return this.timers.toArray(new Timer[this.timers.size()]);
    }

    public void setBlocking(String newBlocking) {
        String oldBlocking = this.blocking;
        this.blocking = newBlocking;
        this.firePropertyChange("blocking", oldBlocking, newBlocking);
    }

    public String getBlocking() {
        return this.blocking;
    }

    public void setSignalling(String newSignalling) {
        String oldSignalling = this.signalling;
        this.signalling = newSignalling;
        this.firePropertyChange("signalling", oldSignalling, newSignalling);
    }

    public String getSignalling() {
        return this.signalling;
    }

    public void setNotify(String newNotify) {
        String oldNotify = this.notify;
        this.notify = newNotify;
        this.firePropertyChange("notify", oldNotify, newNotify);
    }

    public String getNotify() {
        return this.notify;
    }

    public void setDescription(Description newDescription) {
        Description oldDescription = this.description;
        this.description = newDescription;
        this.firePropertyChange("description", oldDescription, newDescription);
    }

    public Description getDescription() {
        return this.description;
    }

    public void setDueDate(String newDueDate) {
        String oldDueDate = this.dueDate;
        this.dueDate = newDueDate;
        this.firePropertyChange("duedate", oldDueDate, newDueDate);
    }

    public String getDueDate() {
        return this.dueDate;
    }

    public void setSwimlane(String newSwimlane) {
        String oldSwimlane = this.swimlane;
        this.swimlane = newSwimlane;
        this.firePropertyChange("swimlane", oldSwimlane, newSwimlane);
    }

    public String getSwimlane() {
        return this.swimlane;
    }

    public void setPriority(String newPriority) {
        String oldPriority = this.priority;
        this.priority = newPriority;
        this.firePropertyChange("priority", oldPriority, newPriority);
    }

    public String getPriority() {
        return this.priority;
    }

    public boolean isNameMandatory() {
        return false;
    }
}

