/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.common.properties;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jbpm.gd.common.model.NamedElement;

public class NamedElementConfigurationComposite
implements FocusListener,
PropertyChangeListener {
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private Composite parent;
    private Label nameLabel;
    private Text nameText;
    private NamedElement namedElement;

    public static NamedElementConfigurationComposite create(TabbedPropertySheetWidgetFactory widgetFactory, Composite parent) {
        NamedElementConfigurationComposite result = new NamedElementConfigurationComposite();
        result.widgetFactory = widgetFactory;
        result.parent = parent;
        result.create();
        return result;
    }

    private NamedElementConfigurationComposite() {
    }

    public void setNamedElement(NamedElement namedElement) {
        if (this.namedElement == namedElement) {
            return;
        }
        this.unhookListeners();
        this.clearControls();
        this.namedElement = namedElement;
        this.updateControls();
        this.hookListeners();
    }

    private void hookListeners() {
        this.nameText.addFocusListener((FocusListener)this);
        if (this.namedElement != null) {
            this.namedElement.addPropertyChangeListener(this);
        }
    }

    private void unhookListeners() {
        this.nameText.removeFocusListener((FocusListener)this);
        if (this.namedElement != null) {
            this.namedElement.removePropertyChangeListener(this);
        }
    }

    private void clearControls() {
        if (!this.nameText.isDisposed()) {
            this.nameText.setText("");
        }
    }

    private void updateControls() {
        if (this.namedElement != null && !this.nameText.isDisposed()) {
            String name = this.namedElement.getName();
            this.nameText.setText(name == null ? "" : name);
        }
    }

    private void create() {
        this.nameLabel = this.widgetFactory.createLabel(this.parent, "Name");
        this.nameText = this.widgetFactory.createText(this.parent, "");
        this.nameLabel.setLayoutData((Object)this.createNameLabelLayoutData());
        this.nameText.setLayoutData((Object)this.createNameTextLayoutData());
    }

    private FormData createNameTextLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.top = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        return data;
    }

    private FormData createNameLabelLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 2);
        return data;
    }

    private String getNameText() {
        String text = this.nameText.getText().trim();
        if ("".equals(text) && !this.namedElement.isNameMandatory()) {
            text = null;
        }
        return text;
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (e.widget == this.nameText) {
            this.namedElement.setName(this.getNameText());
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("name".equals(evt.getPropertyName()) && !this.nameText.isDisposed()) {
            this.nameText.setText(evt.getNewValue() != null ? (String)evt.getNewValue() : "");
        }
    }
}

