/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.jcr.attributes;

import org.jboss.tools.modeshape.jcr.QualifiedName;
import org.jboss.tools.modeshape.jcr.Utils;
import org.jboss.tools.modeshape.jcr.attributes.AttributeState;
import org.jboss.tools.modeshape.jcr.cnd.CndElement;

public class PrimaryItem
extends AttributeState {
    public static final String[] NOTATION = new String[]{"primaryitem", "!", "!"};
    private final QualifiedName primaryItem = new QualifiedName();

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        PrimaryItem that = (PrimaryItem)obj;
        return super.equals(obj) && this.getPrimaryItem().equals(that.getPrimaryItem());
    }

    @Override
    public AttributeState.Value get() {
        AttributeState.Value state = super.get();
        if (state == AttributeState.Value.VARIANT) {
            return AttributeState.Value.VARIANT;
        }
        if (Utils.isEmpty(this.primaryItem.get())) {
            return AttributeState.Value.IS_NOT;
        }
        return AttributeState.Value.IS;
    }

    @Override
    protected String getCompactCndNotation() {
        return NOTATION[2];
    }

    @Override
    protected String getCompressedCndNotation() {
        return NOTATION[1];
    }

    @Override
    protected String getLongCndNotation() {
        return NOTATION[0];
    }

    public QualifiedName getPrimaryItem() {
        return this.primaryItem;
    }

    @Override
    public int hashCode() {
        return Utils.hashCode(super.hashCode(), this.primaryItem);
    }

    @Override
    public boolean set(AttributeState.Value newState) {
        return newState == AttributeState.Value.VARIANT && super.set(AttributeState.Value.VARIANT);
    }

    public boolean setPrimaryItem(String newPrimaryItem) {
        if (this.primaryItem.set(newPrimaryItem)) {
            if (Utils.isEmpty(this.primaryItem.get()) && !this.isVariant()) {
                super.set(AttributeState.Value.IS_NOT);
            } else {
                super.set(AttributeState.Value.IS);
            }
            return true;
        }
        return false;
    }

    @Override
    public String toCndNotation(CndElement.NotationType notationType) {
        String notation = super.toCndNotation(notationType);
        if (!this.isVariant() && this.is()) {
            notation = String.valueOf(notation) + ' ' + this.primaryItem.toCndNotation(notationType);
        }
        return notation;
    }

    @Override
    protected String toVariantCndNotation(String cndNotation) {
        return String.valueOf(cndNotation) + ' ' + '?';
    }
}

