/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.jcr;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.jboss.tools.modeshape.jcr.Activator;
import org.jboss.tools.modeshape.jcr.JcrModelObject;
import org.jboss.tools.modeshape.jcr.LocalName;
import org.jboss.tools.modeshape.jcr.Utils;
import org.jboss.tools.modeshape.jcr.cnd.CndElement;
import org.jboss.tools.modeshape.jcr.cnd.CommentedCndElement;

public class NamespaceMapping
implements CommentedCndElement,
Comparable<NamespaceMapping>,
JcrModelObject {
    public static final String NOTATION_DELIMITER = "=";
    public static final String NOTATION_PREFIX = "<";
    public static final String NOTATION_SUFFIX = ">";
    private String comment;
    private final CopyOnWriteArrayList<PropertyChangeListener> listeners = new CopyOnWriteArrayList();
    private final LocalName prefix = new LocalName();
    private final LocalName uri = new LocalName();

    public static NamespaceMapping copy(NamespaceMapping namespaceMappingToCopy) {
        NamespaceMapping copy = new NamespaceMapping(namespaceMappingToCopy.getPrefix(), namespaceMappingToCopy.getUri());
        copy.comment = namespaceMappingToCopy.comment;
        return copy;
    }

    public NamespaceMapping() {
    }

    public NamespaceMapping(String initialPrefix, String initialUri) {
        this();
        this.prefix.set(initialPrefix);
        this.uri.set(initialUri);
    }

    public boolean addListener(PropertyChangeListener newListener) {
        Utils.verifyIsNotNull(newListener, "newListener");
        return this.listeners.addIfAbsent(newListener);
    }

    @Override
    public int compareTo(NamespaceMapping that) {
        String thisPrefix = this.getPrefix();
        String thatPrefix = that.getPrefix();
        if (Utils.isEmpty(thisPrefix)) {
            if (Utils.isEmpty(thatPrefix)) {
                return 0;
            }
            return 1;
        }
        if (thatPrefix == null) {
            return 1;
        }
        return thisPrefix.compareTo(thatPrefix);
    }

    public boolean equals(Object obj) {
        if (obj != null && this.getClass().equals(obj.getClass())) {
            NamespaceMapping that = (NamespaceMapping)obj;
            if (this.prefix.equals(that.prefix) && this.uri.equals(that.uri)) {
                return Utils.equals(this.comment, that.comment);
            }
        }
        return false;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    public String getPrefix() {
        return this.prefix.get();
    }

    public String getUri() {
        return this.uri.get();
    }

    public int hashCode() {
        return Utils.hashCode(this.prefix, this.uri, this.comment);
    }

    private void notifyChangeListeners(PropertyName property, Object oldValue, Object newValue) {
        assert (property != null) : "property is null";
        PropertyChangeEvent event = new PropertyChangeEvent(this, property.toString(), oldValue, newValue);
        Object[] objectArray = this.listeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            try {
                ((PropertyChangeListener)listener).propertyChange(event);
            }
            catch (Exception e) {
                if (Platform.isRunning()) {
                    Activator.get().getLog().log((IStatus)new Status(4, Activator.PLUGIN_ID, null, (Throwable)e));
                } else {
                    System.err.print(e.getMessage());
                }
                this.listeners.remove(listener);
            }
            ++n2;
        }
    }

    public boolean removeListener(PropertyChangeListener listener) {
        Utils.verifyIsNotNull(listener, "listener");
        return this.listeners.remove(listener);
    }

    @Override
    public boolean setComment(String newComment) {
        boolean changed;
        if (!Utils.isEmpty(newComment)) {
            newComment = newComment.trim();
        }
        String oldValue = this.comment;
        boolean bl = changed = !Utils.equivalent(this.comment, newComment);
        if (changed) {
            this.comment = newComment;
            this.notifyChangeListeners(PropertyName.COMMENT, oldValue, newComment);
        }
        return changed;
    }

    public boolean setPrefix(String newPrefix) {
        String oldValue = this.prefix.get();
        boolean changed = this.prefix.set(newPrefix);
        if (changed) {
            this.notifyChangeListeners(PropertyName.PREFIX, oldValue, newPrefix);
        }
        return changed;
    }

    public boolean setUri(String newUri) {
        String oldValue = this.uri.get();
        boolean changed = this.uri.set(newUri);
        if (changed) {
            this.notifyChangeListeners(PropertyName.URI, oldValue, newUri);
        }
        return changed;
    }

    @Override
    public String toCndNotation(CndElement.NotationType notationType) {
        StringBuilder builder = new StringBuilder();
        if (!Utils.isEmpty(this.comment)) {
            String commentNotation = "";
            if (CndElement.NotationType.LONG == notationType) {
                commentNotation = String.valueOf(commentNotation) + '\n';
            }
            commentNotation = String.valueOf(commentNotation) + CommentedCndElement.Helper.addCommentCharacters(this.comment);
            builder.append(commentNotation);
        }
        builder.append(NOTATION_PREFIX);
        builder.append(this.prefix.toCndNotation(notationType));
        if (CndElement.NotationType.LONG == notationType) {
            builder.append(" ");
        }
        builder.append(NOTATION_DELIMITER);
        if (CndElement.NotationType.LONG == notationType) {
            builder.append(" ");
        }
        builder.append("'");
        builder.append(this.uri.get());
        builder.append("'");
        builder.append(NOTATION_SUFFIX);
        return builder.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.prefix);
        builder.append(NOTATION_DELIMITER);
        builder.append(this.uri);
        return builder.toString();
    }

    public static enum PropertyName {
        COMMENT,
        PREFIX,
        URI;


        public String toString() {
            return String.valueOf(((Object)((Object)this)).getClass().getName()) + '.' + super.toString();
        }
    }
}

