/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.vdb;

import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.teiid.core.designer.event.IChangeListener;
import org.teiid.core.designer.event.IChangeNotifier;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.runtime.ui.vdb.VdbConstants;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.viewsupport.ClosedProjectFilter;
import org.teiid.designer.ui.common.viewsupport.StatusInfo;
import org.teiid.designer.ui.common.widget.Label;
import org.teiid.designer.ui.explorer.ModelExplorerContentProvider;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;
import org.teiid.designer.ui.viewsupport.DesignerPropertiesUtil;
import org.teiid.designer.ui.viewsupport.ModelWorkspaceDialog;

public class ExecuteVdbDialog
extends TitleAreaDialog
implements DqpUiConstants,
VdbConstants,
IChangeListener {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(ExecuteVdbDialog.class);
    private IFile selectedVdb;
    private ILabelProvider labelProvider = new ModelExplorerLabelProvider();
    private Button browseButton;
    private Text selectedVdbText;
    Properties designerProperties;

    public ExecuteVdbDialog(Shell parentShell, Properties properties) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.designerProperties = properties;
    }

    public boolean close() {
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
        }
        return super.close();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(UTIL.getString(String.valueOf(PREFIX) + "title", new Object[0]));
    }

    protected Control createButtonBar(Composite parent) {
        Control buttonBar = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return buttonBar;
    }

    protected Control createDialogArea(Composite parent) {
        Composite pnlOuter = (Composite)super.createDialogArea(parent);
        Composite panel = new Composite(pnlOuter, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        panel.setLayout((Layout)gridLayout);
        panel.setLayoutData((Object)new GridData(1808));
        this.setTitle(UTIL.getString(String.valueOf(PREFIX) + "subTitle", new Object[0]));
        this.setMessage(UTIL.getString(String.valueOf(PREFIX) + "initialMessage", new Object[0]));
        Label label = WidgetFactory.createLabel((Composite)panel, (String)UTIL.getString(String.valueOf(PREFIX) + "vdb", new Object[0]));
        label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.selectedVdbText = WidgetFactory.createTextField((Composite)panel, (int)768);
        this.selectedVdbText.setEditable(false);
        this.browseButton = WidgetFactory.createButton((Composite)panel, (String)"...");
        this.browseButton.setToolTipText(UTIL.getString(String.valueOf(PREFIX) + "button.browseType.tip", new Object[0]));
        this.browseButton.setEnabled(true);
        this.browseButton.setLayoutData((Object)new GridData(0x1000000, 0, false, false));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                ExecuteVdbDialog.this.handleBrowseWorkspaceForVdbPressed();
            }
        });
        return panel;
    }

    public IFile getSelectedVdb() {
        return this.selectedVdb;
    }

    public void stateChanged(IChangeNotifier theSource) {
        this.updateState();
    }

    private void updateState() {
        IStatus status = Status.OK_STATUS;
        if (status.getSeverity() == 4) {
            this.getButton(0).setEnabled(false);
            this.setErrorMessage(status.getMessage());
        } else {
            this.getButton(0).setEnabled(true);
            this.setErrorMessage(null);
            this.setMessage(UTIL.getString(String.valueOf(PREFIX) + "okMsg", new Object[0]));
        }
    }

    private void handleBrowseWorkspaceForVdbPressed() {
        ModelWorkspaceDialog vdbDialog = this.createVdbSelector();
        vdbDialog.addFilter((ViewerFilter)new ClosedProjectFilter());
        vdbDialog.open();
        if (vdbDialog.getReturnCode() == 0) {
            Object[] selections = vdbDialog.getResult();
            this.selectedVdb = (IFile)selections[0];
            this.selectedVdbText.setText(this.selectedVdb.getName());
            this.updateState();
        }
    }

    private ModelWorkspaceDialog createVdbSelector() {
        ModelWorkspaceDialog result = new ModelWorkspaceDialog(this.getShell(), null, (ILabelProvider)new ModelExplorerLabelProvider(), (ITreeContentProvider)new ModelExplorerContentProvider());
        String title = UTIL.getString(String.valueOf(PREFIX) + "selectionDialog.title", new Object[0]);
        String message = UTIL.getString(String.valueOf(PREFIX) + "selectionDialog.message", new Object[0]);
        result.setTitle(title);
        result.setMessage(message);
        result.setAllowMultiple(false);
        result.setInput((Object)ModelerCore.getWorkspace().getRoot());
        result.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                String extension;
                if (selection != null && selection.length == 1 && selection[0] instanceof IFile && (extension = ((IFile)selection[0]).getFileExtension()) != null && extension.equals("vdb")) {
                    return new StatusInfo("org.teiid.designer.dqp.ui");
                }
                if (selection == null || selection.length == 0) {
                    return new StatusInfo("org.teiid.designer.dqp.ui", 4, UTIL.getString(String.valueOf(PREFIX) + "selectionDialog.emptySelection", new Object[0]));
                }
                String msg = UTIL.getString(String.valueOf(PREFIX) + "selectionDialog.invalidSelection", new Object[0]);
                return new StatusInfo("org.teiid.designer.dqp.ui", 4, msg);
            }
        });
        return result;
    }

    protected Control createContents(Composite parent) {
        IResource vdbResource;
        Control control = super.createContents(parent);
        if (this.designerProperties != null && (vdbResource = DesignerPropertiesUtil.getVDB((Properties)this.designerProperties)) != null) {
            this.selectedVdb = (IFile)vdbResource;
            this.selectedVdbText.setText(this.selectedVdb.getName());
            this.updateState();
        }
        return control;
    }
}

