/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.server;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.teiid.core.designer.util.StringConstants;
import org.teiid.designer.runtime.spi.ExecutionConfigurationEvent;
import org.teiid.designer.runtime.spi.IExecutionConfigurationListener;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.runtime.ui.DqpUiPlugin;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;

public class ServerVersionGuard
implements IExecutionConfigurationListener,
StringConstants {
    private static IExecutionConfigurationListener instance;

    public static IExecutionConfigurationListener getInstance() {
        if (instance == null) {
            instance = new ServerVersionGuard();
        }
        return instance;
    }

    public void configurationChanged(ExecutionConfigurationEvent event) {
        if (ExecutionConfigurationEvent.EventType.DEFAULT != event.getEventType()) {
            return;
        }
        if (ExecutionConfigurationEvent.TargetType.SERVER != event.getTargetType()) {
            return;
        }
        ITeiidServer instance = event.getUpdatedServer();
        ITeiidServerVersion version = instance.getServerVersion();
        if (!version.isGreaterThan(TeiidServerVersion.Version.TEIID_DEFAULT.get())) {
            return;
        }
        IWorkbench workbench = DqpUiPlugin.getDefault().getWorkbench();
        if (workbench == null) {
            return;
        }
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        MessageDialog.openWarning((Shell)window.getShell(), (String)DqpUiConstants.UTIL.getString(String.valueOf(this.getClass().getSimpleName()) + "." + "notifyUnsupportedMsgTitle", new Object[0]), (String)DqpUiConstants.UTIL.getString(String.valueOf(this.getClass().getSimpleName()) + "." + "notifyUnsupportedMsg", new Object[0]));
    }
}

