/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.preview;

import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.teiid.core.designer.event.IChangeListener;
import org.teiid.core.designer.event.IChangeNotifier;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.relational.Table;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.viewsupport.ClosedProjectFilter;
import org.teiid.designer.ui.common.viewsupport.StatusInfo;
import org.teiid.designer.ui.common.widget.Label;
import org.teiid.designer.ui.explorer.ModelExplorerContentProvider;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;
import org.teiid.designer.ui.viewsupport.DesignerPropertiesUtil;
import org.teiid.designer.ui.viewsupport.ModelWorkspaceDialog;
import org.teiid.designer.ui.viewsupport.SingleProjectFilter;

public class PreviewDataDialog
extends TitleAreaDialog
implements DqpUiConstants,
IChangeListener {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(PreviewDataDialog.class);
    private EObject previewableEObject;
    private ILabelProvider labelProvider = new ModelExplorerLabelProvider();
    private Button browseButton;
    private Text selectedEobjectText;
    Properties designerProperties;

    public PreviewDataDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public PreviewDataDialog(Shell parentShell, Properties properties) {
        this(parentShell);
        this.designerProperties = properties;
    }

    public boolean close() {
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
        }
        return super.close();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(UTIL.getString(String.valueOf(PREFIX) + "title", new Object[0]));
    }

    protected Control createButtonBar(Composite parent) {
        Control buttonBar = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return buttonBar;
    }

    protected Control createDialogArea(Composite parent) {
        Composite pnlOuter = (Composite)super.createDialogArea(parent);
        Composite panel = new Composite(pnlOuter, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        panel.setLayout((Layout)gridLayout);
        panel.setLayoutData((Object)new GridData(1808));
        this.setTitle(UTIL.getString(String.valueOf(PREFIX) + "subTitle", new Object[0]));
        this.setMessage(UTIL.getString(String.valueOf(PREFIX) + "initialMessage", new Object[0]));
        Label label = WidgetFactory.createLabel((Composite)panel, (String)UTIL.getString(String.valueOf(PREFIX) + "tableOrProcedure", new Object[0]));
        label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.selectedEobjectText = WidgetFactory.createTextField((Composite)panel, (int)768);
        this.selectedEobjectText.setToolTipText(UTIL.getString(String.valueOf(PREFIX) + "text.typeName.tip", new Object[0]));
        this.selectedEobjectText.setEditable(false);
        this.browseButton = WidgetFactory.createButton((Composite)panel, (String)"...");
        this.browseButton.setToolTipText(UTIL.getString(String.valueOf(PREFIX) + "button.browseType.tip", new Object[0]));
        this.browseButton.setEnabled(true);
        this.browseButton.setLayoutData((Object)new GridData(0x1000000, 0, false, false));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                PreviewDataDialog.this.handleBrowseWorkspaceForObjectPressed();
            }
        });
        return panel;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        if (this.designerProperties != null) {
            EObject targetPreviewEObj = DesignerPropertiesUtil.getPreviewTargetObject((Properties)this.designerProperties);
            if (targetPreviewEObj != null) {
                this.previewableEObject = targetPreviewEObj;
                this.selectedEobjectText.setText(ModelerCore.getModelEditor().getName(this.previewableEObject));
            }
            this.updateState();
        }
        return control;
    }

    public EObject getPreviewableEObject() {
        return this.previewableEObject;
    }

    public void stateChanged(IChangeNotifier theSource) {
        this.updateState();
    }

    private void updateState() {
        IStatus status = Status.OK_STATUS;
        if (status.getSeverity() == 4) {
            this.getButton(0).setEnabled(false);
            this.setErrorMessage(status.getMessage());
        } else {
            this.getButton(0).setEnabled(true);
            this.setErrorMessage(null);
            this.setMessage(UTIL.getString(String.valueOf(PREFIX) + "okMsg", new Object[0]));
        }
    }

    private void handleBrowseWorkspaceForObjectPressed() {
        ModelWorkspaceDialog sdDialog = this.createTableOrProcedureSelector();
        sdDialog.addFilter((ViewerFilter)new ClosedProjectFilter());
        sdDialog.addFilter((ViewerFilter)new SingleProjectFilter(this.designerProperties));
        sdDialog.open();
        if (sdDialog.getReturnCode() == 0) {
            Object[] selections = sdDialog.getResult();
            this.previewableEObject = (EObject)selections[0];
            this.selectedEobjectText.setText(ModelerCore.getModelEditor().getName(this.previewableEObject));
            this.updateState();
        }
    }

    public ModelWorkspaceDialog createTableOrProcedureSelector() {
        ModelWorkspaceDialog result = new ModelWorkspaceDialog(this.getShell(), null, (ILabelProvider)new ModelExplorerLabelProvider(), (ITreeContentProvider)new ModelExplorerContentProvider());
        String title = UTIL.getString(String.valueOf(PREFIX) + "selectionDialog.title", new Object[0]);
        String message = UTIL.getString(String.valueOf(PREFIX) + "selectionDialog.message", new Object[0]);
        result.setTitle(title);
        result.setMessage(message);
        result.setAllowMultiple(false);
        result.setInput((Object)ModelerCore.getWorkspace().getRoot());
        result.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection == null || selection.length == 0 || selection[0] == null || !(selection[0] instanceof Table) && !(selection[0] instanceof Procedure)) {
                    String msg = UTIL.getString(String.valueOf(PREFIX) + "selectionDialog.invalidSelection", new Object[0]);
                    return new StatusInfo("org.teiid.designer.dqp.ui", 4, msg);
                }
                return new StatusInfo("org.teiid.designer.dqp.ui");
            }
        });
        return result;
    }
}

