/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.preferences;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.osgi.service.prefs.BackingStoreException;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.runtime.DqpPlugin;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.preferences.IGeneralPreferencePageContributor;

public class EnableTeiidPreviewCleanupPreferenceContributor
implements IGeneralPreferencePageContributor,
DqpUiConstants {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(EnableTeiidPreviewCleanupPreferenceContributor.class);
    private Button chkEnabled;

    public void createPreferenceEditor(Composite theParent) {
        Composite pnl = new Composite(theParent, 0);
        pnl.setLayout((Layout)new GridLayout());
        pnl.setLayoutData((Object)new GridData());
        this.chkEnabled = WidgetFactory.createCheckBox((Composite)pnl, (String)this.getName());
        this.chkEnabled.setLayoutData((Object)new GridData());
        this.chkEnabled.setToolTipText(this.getToolTip());
        this.refresh();
    }

    public String getName() {
        return UTIL.getStringOrKey(String.valueOf(PREFIX) + "name");
    }

    private IEclipsePreferences getPreferences() {
        return DqpPlugin.getInstance().getPreferences();
    }

    public String getToolTip() {
        return UTIL.getStringOrKey(String.valueOf(PREFIX) + "toolTip");
    }

    public boolean performCancel() {
        return true;
    }

    public boolean performDefaults() {
        this.chkEnabled.setSelection(true);
        try {
            this.getPreferences().flush();
            return true;
        }
        catch (BackingStoreException backingStoreException) {
            return false;
        }
    }

    public boolean performOk() {
        IEclipsePreferences prefs = this.getPreferences();
        prefs.putBoolean("org.teiid.designer.dqp.preferences.PreviewTeiidCleanupEnabled", this.chkEnabled.getSelection());
        try {
            prefs.flush();
            return true;
        }
        catch (BackingStoreException backingStoreException) {
            return false;
        }
    }

    public void refresh() {
        IEclipsePreferences prefs = this.getPreferences();
        boolean enable = prefs.getBoolean("org.teiid.designer.dqp.preferences.PreviewTeiidCleanupEnabled", true);
        this.chkEnabled.setSelection(enable);
    }

    public void setPreferencePage(PreferencePage preferencePage) {
    }

    public void setWorkbench(IWorkbench theWorkbench) {
    }
}

