/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.dialogs;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.validation.rules.StringNameValidator;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.runtime.ui.connection.VdbDataSourceInfo;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.widget.Label;

public class CreateVdbDataSourceDialog
extends TitleAreaDialog {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(CreateVdbDataSourceDialog.class);
    private StringNameValidator nameValidator;
    private VdbDataSourceInfo vdbDataSourceInfo;
    private String vdbName;
    private Text vdbNameText;
    private Text dataSourceNameText;
    private Button passThroughButton;
    private ITeiidServer server;
    private boolean withDeployment = false;

    private static String getString(String id) {
        return DqpUiConstants.UTIL.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    private static String getString(String id, String param) {
        return DqpUiConstants.UTIL.getString(String.valueOf(I18N_PREFIX) + id, (Object)param);
    }

    public CreateVdbDataSourceDialog(Shell shell, VdbDataSourceInfo vdbDataSourceInfo, ITeiidServer server, boolean withDeployment) {
        super(shell);
        this.vdbName = vdbDataSourceInfo.getVdbName();
        this.vdbDataSourceInfo = vdbDataSourceInfo;
        this.nameValidator = new StringNameValidator(new char[]{'_', '-'});
        this.server = server;
        this.withDeployment = withDeployment;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(CreateVdbDataSourceDialog.getString("title"));
    }

    protected Control createButtonBar(Composite parent) {
        Control buttonBar = super.createButtonBar(parent);
        this.getButton(0).setEnabled(true);
        if (this.withDeployment) {
            this.getButton(0).setText(CreateVdbDataSourceDialog.getString("createSourceButtonText"));
            this.getButton(1).setText(CreateVdbDataSourceDialog.getString("skipButtonText"));
        }
        this.validate();
        return buttonBar;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(CreateVdbDataSourceDialog.getString("subTitle"));
        this.setMessage(CreateVdbDataSourceDialog.getString("initialMessage"));
        Composite pnl = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(10, 10).equalWidth(false).applyTo(pnl);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)pnl);
        WidgetFactory.createLabel((Composite)pnl, (String)CreateVdbDataSourceDialog.getString("vdbNameLabel"));
        this.vdbNameText = new Text(pnl, 0);
        this.vdbNameText.setText(this.vdbName);
        this.vdbNameText.setEditable(false);
        this.vdbNameText.setBackground(Display.getCurrent().getSystemColor(19));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.vdbNameText);
        Label label = WidgetFactory.createLabel((Composite)pnl, (String)CreateVdbDataSourceDialog.getString("jndiNameLabel"));
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)label);
        this.dataSourceNameText = new Text(pnl, 2048);
        this.dataSourceNameText.setText(this.vdbDataSourceInfo.getJndiName());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.dataSourceNameText);
        this.dataSourceNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = CreateVdbDataSourceDialog.this.dataSourceNameText.getText();
                CreateVdbDataSourceDialog.this.vdbDataSourceInfo.setJndiName(text);
                CreateVdbDataSourceDialog.this.validate();
            }
        });
        this.passThroughButton = new Button(pnl, 32);
        this.passThroughButton.setText(CreateVdbDataSourceDialog.getString("passTroughAuthenticationLabel"));
        this.passThroughButton.setToolTipText(CreateVdbDataSourceDialog.getString("passTroughAuthenticationTooltip"));
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.passThroughButton);
        this.passThroughButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CreateVdbDataSourceDialog.this.vdbDataSourceInfo.setPassThroughAuthentication(CreateVdbDataSourceDialog.this.passThroughButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return pnl;
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    private boolean validate() {
        String errorMessage = null;
        String warningMessage = null;
        if (!this.nameValidator.isValidName(this.vdbDataSourceInfo.getJndiName())) {
            errorMessage = CreateVdbDataSourceDialog.getString("invalidJndiName");
        }
        if (errorMessage == null) {
            try {
                if (this.server.getDataSource(this.vdbDataSourceInfo.getJndiName()) != null) {
                    warningMessage = this.withDeployment ? CreateVdbDataSourceDialog.getString("dataSourceExistsMessageWithDeployment", this.vdbDataSourceInfo.getJndiName()) : CreateVdbDataSourceDialog.getString("dataSourceExistsMessage", this.vdbDataSourceInfo.getJndiName());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (errorMessage == null) {
            this.setErrorMessage(null);
            this.getButton(0).setEnabled(true);
            if (warningMessage != null) {
                this.setMessage(warningMessage, 2);
            } else if (this.withDeployment) {
                this.setMessage(CreateVdbDataSourceDialog.getString("okMessageWithDeployment", this.vdbDataSourceInfo.getJndiName()), 0);
            } else {
                this.setMessage(CreateVdbDataSourceDialog.getString("okMessage", this.vdbDataSourceInfo.getJndiName()), 0);
            }
        } else {
            this.getButton(0).setEnabled(false);
            this.setErrorMessage(errorMessage);
        }
        return true;
    }
}

