/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.connection.properties;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.teiid.core.designer.properties.PropertyDefinition;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.translators.TranslatorOverrideProperty;
import org.teiid.designer.core.translators.TranslatorPropertyDefinition;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.datatools.connection.ConnectionInfoProviderFactory;
import org.teiid.designer.datatools.connection.IConnectionInfoProvider;
import org.teiid.designer.datatools.connection.ITranslatorOverridesProvider;
import org.teiid.designer.runtime.DqpPlugin;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.runtime.ui.DqpUiPlugin;
import org.teiid.designer.runtime.ui.connection.properties.EditTOPropertiesDialog;
import org.teiid.designer.runtime.ui.connection.properties.TranslatorOverride;
import org.teiid.designer.runtime.ui.server.RuntimeAssistant;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.designer.ui.actions.IConnectionAction;
import org.teiid.designer.ui.actions.SortableSelectionAction;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.vdb.connections.SourceHandler;
import org.teiid.designer.vdb.connections.SourceHandlerExtensionManager;
import org.teiid.designer.vdb.ui.VdbUiPlugin;

public class EditTOPropertiesAction
extends SortableSelectionAction
implements IConnectionAction,
DqpUiConstants {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(EditTOPropertiesAction.class);
    private static final String label = DqpUiConstants.UTIL.getString("label", new Object[0]);
    private ConnectionInfoProviderFactory providerFactory = ConnectionInfoProviderFactory.getInstance();
    private ITeiidServer cachedServer;

    private static String getString(String id) {
        return DqpUiConstants.UTIL.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    private static String getString(String id, Object value) {
        return DqpUiConstants.UTIL.getString(String.valueOf(I18N_PREFIX) + id, value);
    }

    public EditTOPropertiesAction() {
        super(label, -1);
        this.setImageDescriptor(DqpUiPlugin.getDefault().getImageDescriptor("icons/full/obj16/sourceBinding.gif"));
    }

    public void setTeiidServer(ITeiidServer teiidServer) {
        this.cachedServer = teiidServer;
    }

    public boolean isValidSelection(ISelection selection) {
        return this.sourceModelSelected(selection);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        IWorkbenchWindow iww = VdbUiPlugin.singleton.getCurrentWorkbenchWindow();
        ModelResource modelResource = null;
        ITranslatorOverridesProvider provider = null;
        if (!this.getSelection().isEmpty()) {
            IFile modelFile = (IFile)SelectionUtilities.getSelectedObjects((ISelection)this.getSelection()).get(0);
            modelResource = ModelUtilities.getModelResource((Object)modelFile);
            if (modelResource == null) {
                return;
            }
            provider = this.getProvider(modelResource);
            if (provider == null) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)EditTOPropertiesAction.getString("translatorOverridesNotSupported.title"), (String)EditTOPropertiesAction.getString("translatorOverridesNotSupported.message1"));
                return;
            }
        }
        try {
            boolean noOverrideProperties;
            ITeiidServer teiidServer = this.cachedServer;
            if (teiidServer == null) {
                teiidServer = DqpPlugin.getInstance().getServerManager().getDefaultServer();
                if (teiidServer == null) {
                    if (!RuntimeAssistant.ensureServerConnection(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), EditTOPropertiesAction.getString("noServer.message"), true)) return;
                    teiidServer = DqpPlugin.getInstance().getServerManager().getDefaultServer();
                    teiidServer.connect();
                } else {
                    if (!RuntimeAssistant.ensureServerConnection(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), EditTOPropertiesAction.getString("noServer.message"), false)) return;
                    teiidServer = DqpPlugin.getInstance().getServerManager().getDefaultServer();
                    teiidServer.connect();
                }
            }
            Properties props = provider.getTranslatorOverrideProperties(modelResource);
            Properties filteredProperties = new Properties();
            String translatorType = "jdbc ";
            for (Object key : props.keySet()) {
                if ("name".equals((String)key)) {
                    translatorType = props.getProperty((String)key);
                    continue;
                }
                filteredProperties.put(key, props.getProperty((String)key));
            }
            TranslatorOverride override = this.createOverride(translatorType, filteredProperties);
            boolean overridesSupported = teiidServer.getServerVersion().isGreaterThanOrEqualTo(TeiidServerVersion.Version.TEIID_8_6.get());
            boolean bl = noOverrideProperties = override.getProperties().length == 0;
            if (!overridesSupported) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)EditTOPropertiesAction.getString("translatorOverridesNotSupported.title"), (String)EditTOPropertiesAction.getString("translatorOverridesNotSupported.message2"));
                return;
            }
            if (noOverrideProperties) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)EditTOPropertiesAction.getString("translatorOverridesNotAvailable.title"), (String)EditTOPropertiesAction.getString("translatorOverridesNotAvailable.message", translatorType));
                return;
            }
            EditTOPropertiesDialog dialog = new EditTOPropertiesDialog(iww.getShell(), override);
            if (dialog.open() != 0) return;
            this.editPropertiesInTxn(override, modelResource, provider);
            modelResource.save(null, true);
            return;
        }
        catch (Exception e) {
            if (modelResource != null) {
                MessageDialog.openError((Shell)this.getShell(), (String)EditTOPropertiesAction.getString("errorCreatingDataSourceForModel", modelResource.getItemName()), (String)e.getMessage());
                DqpUiConstants.UTIL.log(4, (Throwable)e, EditTOPropertiesAction.getString("errorCreatingDataSourceForModel", modelResource.getItemName()));
                return;
            }
            MessageDialog.openError((Shell)this.getShell(), (String)EditTOPropertiesAction.getString("errorCreatingDataSource"), (String)e.getMessage());
            DqpUiConstants.UTIL.log(4, (Throwable)e, EditTOPropertiesAction.getString("errorCreatingDataSource"));
        }
    }

    private void editPropertiesInTxn(TranslatorOverride override, ModelResource modelResource, ITranslatorOverridesProvider provider) {
        boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)false, (String)"Set Translator Override Properties", (Object)this);
        boolean succeeded = false;
        try {
            Properties newOverrideProperties = new Properties();
            if (override.getProperties().length > 0) {
                TranslatorOverrideProperty[] translatorOverridePropertyArray = override.getProperties();
                int n = translatorOverridePropertyArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TranslatorOverrideProperty prop = translatorOverridePropertyArray[n2];
                    if (prop.hasOverridenValue()) {
                        String id = prop.getDefinition().getId();
                        String value = prop.getOverriddenValue();
                        newOverrideProperties.put(id, value);
                    }
                    ++n2;
                }
                provider.replaceTranlatorOverrideProperties(modelResource, newOverrideProperties);
            } else {
                provider.clearTranslatorOverrideProperties(modelResource);
            }
            succeeded = true;
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    public boolean isApplicable(ISelection selection) {
        return this.sourceModelSelected(selection);
    }

    private TranslatorOverride createOverride(String type, Properties properties) {
        TranslatorOverride override = new TranslatorOverride(type, properties);
        SourceHandler handler = SourceHandlerExtensionManager.getVdbConnectionFinder();
        PropertyDefinition[] propertyDefinitionsFromServer = handler.getTranslatorDefinitions(override.getType());
        if (propertyDefinitionsFromServer != null) {
            ArrayList<PropertyDefinition> newServerProps = new ArrayList<PropertyDefinition>();
            PropertyDefinition[] propertyDefinitionArray = propertyDefinitionsFromServer;
            int n = propertyDefinitionsFromServer.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDefinition propDefn = propertyDefinitionArray[n2];
                newServerProps.add(propDefn);
                ++n2;
            }
            if (!properties.isEmpty()) {
                for (Object key : properties.keySet()) {
                    String keyStr = (String)key;
                    String value = (String)properties.get(key);
                    PropertyDefinition serverPropDefn = null;
                    PropertyDefinition[] propertyDefinitionArray2 = propertyDefinitionsFromServer;
                    int n3 = propertyDefinitionsFromServer.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        PropertyDefinition propDefn = propertyDefinitionArray2[n4];
                        if (keyStr.equals(propDefn.getId())) {
                            serverPropDefn = propDefn;
                            newServerProps.remove(serverPropDefn);
                            break;
                        }
                        ++n4;
                    }
                    if (serverPropDefn == null) continue;
                    TranslatorOverrideProperty newProp = new TranslatorOverrideProperty(new TranslatorPropertyDefinition(serverPropDefn), value);
                    override.addProperty(newProp);
                }
            }
            for (PropertyDefinition propDefn : newServerProps) {
                override.addProperty(new TranslatorOverrideProperty(new TranslatorPropertyDefinition(propDefn), null));
            }
        }
        return override;
    }

    private boolean sourceModelSelected(ISelection theSelection) {
        boolean result = false;
        List allObjs = SelectionUtilities.getSelectedObjects((ISelection)theSelection);
        if (!allObjs.isEmpty() && allObjs.size() == 1) {
            Iterator iter = allObjs.iterator();
            result = true;
            Object nextObj = null;
            while (iter.hasNext() && result) {
                nextObj = iter.next();
                result = nextObj instanceof IFile ? ModelIdentifier.isRelationalSourceModel((IResource)((IFile)nextObj)) : false;
            }
        }
        return result;
    }

    public ITranslatorOverridesProvider getProvider(ModelResource modelResource) {
        IConnectionInfoProvider provider = null;
        try {
            provider = this.providerFactory.getProvider(modelResource);
        }
        catch (Exception exception) {
            return null;
        }
        if (provider != null && provider instanceof ITranslatorOverridesProvider) {
            return (ITranslatorOverridesProvider)provider;
        }
        return null;
    }

    private Shell getShell() {
        return Display.getCurrent().getActiveShell();
    }
}

