/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.connection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.datatools.connection.ConnectionInfoHelper;
import org.teiid.designer.runtime.connection.TranslatorUtils;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.spi.ITeiidTranslator;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.runtime.ui.DqpUiPlugin;
import org.teiid.designer.ui.actions.IConnectionAction;
import org.teiid.designer.ui.actions.SortableSelectionAction;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.widget.Dialog;
import org.teiid.designer.ui.common.widget.Label;
import org.teiid.designer.ui.editors.ModelEditor;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class SetTranslatorNameAction
extends SortableSelectionAction
implements IConnectionAction {
    private static final String ACTION_TITLE = DqpUiConstants.UTIL.getString("SetTranslatorNameAction.title", new Object[0]);
    private static final String DIALOG_TITLE = DqpUiConstants.UTIL.getString("EnterTranslatorNameDialog.title", new Object[0]);
    private static final String SPACE = " ";
    private ConnectionInfoHelper connectionInfoHelper;

    public SetTranslatorNameAction() {
        super(ACTION_TITLE, -1);
        this.setImageDescriptor(DqpUiPlugin.getDefault().getImageDescriptor("icons/full/obj16/set-connection.png"));
        this.connectionInfoHelper = new ConnectionInfoHelper();
    }

    public boolean isValidSelection(ISelection selection) {
        return this.sourceModelSelected(selection);
    }

    public void run() {
        String newTranslatorName;
        IFile modelFile = (IFile)SelectionUtilities.getSelectedObjects((ISelection)this.getSelection()).get(0);
        ModelResource mr = ModelUtilities.getModelResourceForIFile((IFile)modelFile, (boolean)true);
        String existingName = this.connectionInfoHelper.getTranslatorName(mr);
        if (!existingName.equals(newTranslatorName = this.queryUserForTranslatorName(existingName))) {
            this.setTranslatorNameInTxn(mr, newTranslatorName);
        }
    }

    private void setTranslatorNameInTxn(ModelResource modelResource, String translatorName) {
        boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)true, (String)"Set Translator Name", (Object)((Object)this));
        boolean succeeded = false;
        try {
            try {
                ModelEditor editor = ModelEditorManager.getModelEditorForFile((IFile)((IFile)modelResource.getCorrespondingResource()), (boolean)true);
                if (editor != null) {
                    boolean isDirty = editor.isDirty();
                    this.connectionInfoHelper.setTranslatorName(modelResource, translatorName);
                    if (!isDirty && editor.isDirty()) {
                        editor.doSave((IProgressMonitor)new NullProgressMonitor());
                    }
                    succeeded = true;
                }
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)DqpUiConstants.UTIL.getString("SetConnectionProfileAction.exceptionMessage", new Object[0]), (String)e.getMessage());
                Status status = new Status(4, "org.teiid.designer.dqp.ui", DqpUiConstants.UTIL.getString("SetConnectionProfileAction.exceptionMessage", new Object[0]), (Throwable)e);
                DqpUiConstants.UTIL.log((IStatus)status);
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
                return;
            }
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    public String queryUserForTranslatorName(String existingName) {
        EnterTranslatorNameDialog dialog = new EnterTranslatorNameDialog(Display.getCurrent().getActiveShell(), existingName);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            return dialog.getTranslatorName();
        }
        return existingName;
    }

    public boolean isApplicable(ISelection selection) {
        return this.sourceModelSelected(selection);
    }

    private boolean sourceModelSelected(ISelection theSelection) {
        boolean result = false;
        List allObjs = SelectionUtilities.getSelectedObjects((ISelection)theSelection);
        if (!allObjs.isEmpty() && allObjs.size() == 1) {
            Iterator iter = allObjs.iterator();
            result = true;
            Object nextObj = null;
            while (iter.hasNext() && result) {
                nextObj = iter.next();
                result = nextObj instanceof IFile ? ModelIdentifier.isRelationalSourceModel((IResource)((IFile)nextObj)) : false;
            }
        }
        return result;
    }

    class EnterTranslatorNameDialog
    extends Dialog {
        private static final int COLUMN_COUNT = 2;
        private Text translatorField;
        private String translatorName;
        private Collection<String> translatorNames;
        private Combo translatorNameCombo;

        public EnterTranslatorNameDialog(Shell shell, String existingName) {
            super(shell, DIALOG_TITLE);
            this.translatorNames = new ArrayList<String>();
            this.translatorName = existingName;
        }

        protected Control createDialogArea(Composite parent) {
            ITeiidServer server = TranslatorUtils.getDefaultServer();
            boolean serverAvailable = server != null && server.isConnected();
            Composite dlgPanel = (Composite)super.createDialogArea(parent);
            GridData pgd = new GridData(1, 0x1000000, true, true);
            pgd.minimumWidth = 400;
            pgd.grabExcessHorizontalSpace = true;
            dlgPanel.setLayoutData((Object)pgd);
            ((GridLayout)dlgPanel.getLayout()).numColumns = 2;
            String message = DqpUiConstants.UTIL.getString("EnterTranslatorNameDialog.message", new Object[0]);
            if (serverAvailable) {
                message = DqpUiConstants.UTIL.getString("EnterTranslatorNameDialog.selectTranslatorMessage", new Object[0]);
            }
            Label msgLabel = WidgetFactory.createLabel((Composite)dlgPanel, (String)message);
            GridData gd = new GridData(1, 0x1000000, true, true);
            gd.horizontalSpan = 2;
            msgLabel.setLayoutData((Object)gd);
            if (!serverAvailable) {
                WidgetFactory.createLabel((Composite)dlgPanel, (String)(String.valueOf(DqpUiConstants.UTIL.getString("EnterTranslatorNameDialog.nameLabel", new Object[0])) + SetTranslatorNameAction.SPACE));
                this.translatorField = WidgetFactory.createTextField((Composite)dlgPanel);
                if (this.translatorName != null && this.translatorName.length() > 0) {
                    this.translatorField.setText(this.translatorName);
                }
                this.translatorField.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        if (EnterTranslatorNameDialog.this.translatorField.getText() != null && EnterTranslatorNameDialog.this.translatorField.getText().length() > 0) {
                            EnterTranslatorNameDialog.this.getButton(0).setEnabled(true);
                            EnterTranslatorNameDialog.this.translatorName = EnterTranslatorNameDialog.this.translatorField.getText();
                        } else {
                            EnterTranslatorNameDialog.this.translatorName = "";
                            EnterTranslatorNameDialog.this.getButton(0).setEnabled(false);
                        }
                    }
                });
            } else {
                Label translatorLabel = new Label(dlgPanel, 0);
                translatorLabel.setText("Translator");
                try {
                    this.translatorNames.clear();
                    Collection availableTranslators = TranslatorUtils.getTranslators();
                    for (ITeiidTranslator translator : availableTranslators) {
                        this.translatorNames.add(translator.getName());
                    }
                }
                catch (Exception ex) {
                    this.translatorNames.clear();
                    DqpUiPlugin.UTIL.log((Throwable)ex);
                }
                this.translatorNameCombo = WidgetFactory.createCombo((Composite)dlgPanel, (int)8, (int)768, (Object[])this.translatorNames.toArray());
                this.translatorNameCombo.setVisibleItemCount(8);
                this.translatorNameCombo.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        int selIndex = EnterTranslatorNameDialog.this.translatorNameCombo.getSelectionIndex();
                        EnterTranslatorNameDialog.this.translatorName = EnterTranslatorNameDialog.this.translatorNameCombo.getItem(selIndex);
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                if (this.translatorName != null) {
                    String[] names = this.translatorNameCombo.getItems();
                    int i = 0;
                    while (i < names.length) {
                        if (names[i].equalsIgnoreCase(this.translatorName)) {
                            this.translatorNameCombo.select(i);
                            break;
                        }
                        ++i;
                    }
                } else {
                    this.translatorNameCombo.select(-1);
                }
            }
            return dlgPanel;
        }

        public void create() {
            super.create();
            this.getButton(0).setEnabled(this.translatorName != null);
        }

        protected void okPressed() {
            super.okPressed();
        }

        public String getTranslatorName() {
            return this.translatorName;
        }
    }
}

