/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.connection;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.runtime.DqpPlugin;
import org.teiid.designer.runtime.spi.ITeiidDataSource;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.spi.ITeiidVdb;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.runtime.ui.DqpUiPlugin;
import org.teiid.designer.runtime.ui.connection.VdbDataSourceInfo;
import org.teiid.designer.runtime.ui.dialogs.CreateVdbDataSourceDialog;
import org.teiid.designer.runtime.ui.server.RuntimeAssistant;
import org.teiid.designer.ui.actions.SortableSelectionAction;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.vdb.ui.VdbUiPlugin;

public class CreateVdbDataSourceAction
extends SortableSelectionAction
implements DqpUiConstants {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(CreateVdbDataSourceAction.class);
    private static final String label = DqpUiConstants.UTIL.getString("label", new Object[0]);
    private ITeiidServer cachedServer;
    private String cachedVdbName;

    private static String getString(String id) {
        return DqpUiConstants.UTIL.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    private static String getString(String id, Object value) {
        return DqpUiConstants.UTIL.getString(String.valueOf(I18N_PREFIX) + id, value);
    }

    private static String getString(String id, Object value, Object value2) {
        return DqpUiConstants.UTIL.getString(String.valueOf(I18N_PREFIX) + id, new Object[]{value, value2});
    }

    public CreateVdbDataSourceAction() {
        super(label, -1);
        this.setImageDescriptor(DqpUiPlugin.getDefault().getImageDescriptor("icons/full/obj16/sourceBinding.gif"));
    }

    public CreateVdbDataSourceAction(String vdbName) {
        super(label, -1);
        this.cachedVdbName = vdbName;
        this.setImageDescriptor(DqpUiPlugin.getDefault().getImageDescriptor("icons/full/obj16/sourceBinding.gif"));
    }

    public void setTeiidServer(ITeiidServer teiidServer) {
        this.cachedServer = teiidServer;
    }

    public boolean isValidSelection(ISelection selection) {
        return this.vdbSelected(selection);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        IWorkbenchWindow iww = VdbUiPlugin.singleton.getCurrentWorkbenchWindow();
        IFile selectedVdb = null;
        if (!this.getSelection().isEmpty()) {
            selectedVdb = (IFile)SelectionUtilities.getSelectedObjects((ISelection)this.getSelection()).get(0);
        }
        try {
            boolean result;
            ITeiidVdb deployedVDB;
            String vdbName;
            ITeiidServer teiidServer = this.cachedServer;
            if (teiidServer == null) {
                teiidServer = DqpPlugin.getInstance().getServerManager().getDefaultServer();
                if (teiidServer == null) {
                    if (!RuntimeAssistant.ensureServerConnection(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), CreateVdbDataSourceAction.getString("noServer.message"), true)) return;
                    teiidServer = DqpPlugin.getInstance().getServerManager().getDefaultServer();
                    teiidServer.connect();
                } else {
                    if (!RuntimeAssistant.ensureServerConnection(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), CreateVdbDataSourceAction.getString("noServer.message"), false)) return;
                    teiidServer = DqpPlugin.getInstance().getServerManager().getDefaultServer();
                    teiidServer.connect();
                }
            }
            if ((vdbName = this.cachedVdbName) == null) {
                vdbName = selectedVdb.getLocation().removeFileExtension().lastSegment();
            }
            if ((deployedVDB = teiidServer.getVdb(vdbName)) == null && !(result = MessageDialog.openQuestion((Shell)iww.getShell(), (String)CreateVdbDataSourceAction.getString("noDeployedVDB.title"), (String)CreateVdbDataSourceAction.getString("noDeployedVDB.message", vdbName)))) {
                return;
            }
            CreateVdbDataSourceAction.doCreateDataSource(vdbName, teiidServer, false);
            return;
        }
        catch (Exception e) {
            if (selectedVdb != null) {
                MessageDialog.openError((Shell)this.getShell(), (String)CreateVdbDataSourceAction.getString("errorCreatingDataSourceForVDB", selectedVdb.getName()), (String)e.getMessage());
                DqpUiConstants.UTIL.log(4, (Throwable)e, CreateVdbDataSourceAction.getString("errorCreatingDataSourceForVDB", selectedVdb.getName()));
                return;
            }
            MessageDialog.openError((Shell)this.getShell(), (String)CreateVdbDataSourceAction.getString("errorCreatingDataSource"), (String)e.getMessage());
            DqpUiConstants.UTIL.log(4, (Throwable)e, CreateVdbDataSourceAction.getString("errorCreatingDataSource"));
        }
    }

    public static void doCreateDataSource(String vdbName, ITeiidServer teiidServer, boolean withDeployment) throws Exception {
        IWorkbenchWindow iww = VdbUiPlugin.singleton.getCurrentWorkbenchWindow();
        VdbDataSourceInfo info = new VdbDataSourceInfo(vdbName, vdbName, vdbName);
        info.setPassword(teiidServer.getTeiidJdbcInfo().getPassword());
        info.setUsername(teiidServer.getTeiidJdbcInfo().getUsername());
        CreateVdbDataSourceDialog dialog = new CreateVdbDataSourceDialog(iww.getShell(), info, teiidServer, withDeployment);
        int rc = dialog.open();
        if (rc != 0) {
            return;
        }
        ITeiidDataSource vdbDS = teiidServer.getDataSource(info.getJndiName());
        if (vdbDS != null) {
            teiidServer.deleteDataSource(info.getJndiName());
        }
        teiidServer.getOrCreateDataSource(info.getDisplayName(), info.getJndiName(), "teiid", info.getProperties());
    }

    public boolean isApplicable(ISelection selection) {
        return this.vdbSelected(selection);
    }

    private boolean vdbSelected(ISelection theSelection) {
        boolean result = false;
        List allObjs = SelectionUtilities.getSelectedObjects((ISelection)theSelection);
        if (!allObjs.isEmpty() && allObjs.size() == 1) {
            Iterator iter = allObjs.iterator();
            result = true;
            Object nextObj = null;
            while (iter.hasNext() && result) {
                nextObj = iter.next();
                result = nextObj instanceof IFile ? ModelUtilities.isVdbFile((IResource)((IFile)nextObj)) : false;
            }
        }
        return result;
    }

    private Shell getShell() {
        return Display.getCurrent().getActiveShell();
    }
}

