/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.runtime.DqpPlugin;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.spi.ITeiidServerManager;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.runtime.ui.DqpUiPlugin;
import org.teiid.designer.runtime.ui.vdb.ExecuteVdbDialog;
import org.teiid.designer.runtime.ui.vdb.ExecuteVdbWorker;
import org.teiid.designer.runtime.ui.vdb.VdbConstants;
import org.teiid.designer.ui.actions.SortableSelectionAction;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.util.ErrorHandler;
import org.teiid.designer.vdb.Vdb;

public class ExecuteVDBAction
extends SortableSelectionAction
implements VdbConstants {
    protected static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(ExecuteVDBAction.class);
    protected boolean successfulRefresh = false;
    IFile selectedVDB;
    static ExecuteVdbWorker worker;

    public ExecuteVDBAction() {
        this.setImageDescriptor(DqpUiPlugin.getDefault().getImageDescriptor("icons/full/ctool16/run_vdb.gif"));
        worker = new ExecuteVdbWorker();
    }

    public int compareTo(Object o) {
        if (o instanceof String) {
            return this.getText().compareTo((String)o);
        }
        if (o instanceof Action) {
            return this.getText().compareTo(((Action)o).getText());
        }
        return 0;
    }

    public boolean isApplicable(ISelection selection) {
        ITeiidServer teiidServer;
        String extension;
        Object obj;
        boolean result = false;
        if (!SelectionUtilities.isMultiSelection((ISelection)selection) && (obj = SelectionUtilities.getSelectedObject((ISelection)selection)) instanceof IFile && (extension = ((IFile)obj).getFileExtension()) != null && extension.equals("vdb") && (teiidServer = ExecuteVDBAction.getServerManager().getDefaultServer()) != null) {
            return true;
        }
        return result;
    }

    public void run() {
        if (!this.checkForConnectedServer()) {
            return;
        }
        IFile vdb = this.selectedVDB;
        try {
            String msg;
            String title;
            Shell shell;
            if (!this.isVdbSyncd(vdb) && !MessageDialog.openQuestion((Shell)(shell = UiUtil.getWorkbenchShellOnlyIfUiThread()), (String)(title = DqpUiConstants.UTIL.getString("VdbNotSyncdDialog.title", new Object[0])), (String)(msg = DqpUiConstants.UTIL.getString("VdbNotSyncdDialog.msg", new Object[0])))) {
                return;
            }
            if (vdb == null) {
                ExecuteVdbDialog dialog = new ExecuteVdbDialog(worker.getShell(), null);
                dialog.open();
                if (dialog.getReturnCode() == 0) {
                    vdb = dialog.getSelectedVdb();
                }
            }
            if (vdb != null) {
                worker.run(vdb);
            }
        }
        catch (Exception ex) {
            ErrorHandler.toExceptionDialog((Throwable)ex);
        }
    }

    private boolean checkForConnectedServer() {
        ITeiidServer teiidServer = ExecuteVDBAction.getServerManager().getDefaultServer();
        if (teiidServer == null || !teiidServer.isConnected()) {
            Shell shell = UiUtil.getWorkbenchShellOnlyIfUiThread();
            String title = DqpUiConstants.UTIL.getString("ActionRequiresServer.title", new Object[0]);
            String msg = DqpUiConstants.UTIL.getString("ActionRequiresServer.msg", new Object[0]);
            MessageDialog.openInformation((Shell)shell, (String)title, (String)msg);
            return false;
        }
        return true;
    }

    private boolean isVdbSyncd(IFile file) throws Exception {
        Vdb vdb = new Vdb(file, null);
        return vdb.isSynchronized();
    }

    public static void executeVdb(ITeiidServer teiidServer, String vdbName) throws Exception {
        if (worker == null) {
            worker = new ExecuteVdbWorker();
        }
        worker.processForDTP(teiidServer, vdbName);
    }

    private static ITeiidServerManager getServerManager() {
        return DqpPlugin.getInstance().getServerManager();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        String extension;
        Object obj;
        boolean enable = false;
        if (!SelectionUtilities.isMultiSelection((ISelection)selection) && (obj = SelectionUtilities.getSelectedObject((ISelection)selection)) instanceof IFile && (extension = ((IFile)obj).getFileExtension()) != null && extension.equals("vdb")) {
            this.selectedVDB = (IFile)obj;
            enable = true;
        }
        if (!enable) {
            this.selectedVDB = null;
        }
        this.setEnabled(enable);
    }
}

