/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.osgi.framework.BundleContext;
import org.teiid.core.designer.PluginUtil;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.core.designer.util.PluginUtilImpl;
import org.teiid.designer.runtime.DqpPlugin;
import org.teiid.designer.runtime.preview.jobs.TeiidPreviewVdbCleanupJob;
import org.teiid.designer.runtime.spi.ITeiidServerManager;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.runtime.ui.server.ServerVersionGuard;
import org.teiid.designer.ui.common.AbstractUiPlugin;
import org.teiid.designer.ui.common.actions.ActionService;

public class DqpUiPlugin
extends AbstractUiPlugin
implements DqpUiConstants {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(DqpUiPlugin.class);
    public String testInstallPath;
    private static DqpUiPlugin plugin;
    private ResourceBundle resourceBundle;

    public static String getResourceString(String key) {
        ResourceBundle bundle = DqpUiPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    private static String getString(String theKey) {
        return UTIL.getStringOrKey(String.valueOf(PREFIX) + theKey);
    }

    public static DqpUiPlugin getDefault() {
        return plugin;
    }

    public static void showErrorDialog(Shell shell, Exception error) {
        MessageDialog.openError((Shell)shell, (String)DqpUiPlugin.getString("errorDialogTitle"), (String)error.getMessage());
    }

    public DqpUiPlugin() {
        plugin = this;
    }

    void cancelCleanupJobsRequested() {
        Job[] jobArray = Job.getJobManager().find(TeiidPreviewVdbCleanupJob.TEIID_CLEANUP_FAMILY);
        int n = jobArray.length;
        int n2 = 0;
        while (n2 < n) {
            Job job = jobArray[n2];
            job.cancel();
            ++n2;
        }
    }

    protected ActionService createActionService(IWorkbenchPage workbenchPage) {
        return null;
    }

    public Image getAnImage(String key) {
        return this.getOrCreateImage(key);
    }

    private Image getOrCreateImage(String key) {
        Image image = this.getImageRegistry().get(key);
        if (image == null) {
            ImageDescriptor d = this.getImageDescriptor(key);
            image = this.getImageRegistry().get(key);
            if (image == null) {
                image = d.createImage();
                this.getImageRegistry().put(key, image);
            }
        }
        return image;
    }

    public PluginUtil getPluginUtil() {
        return UTIL;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ((PluginUtilImpl)UTIL).initializePlatformLogger((Plugin)this);
        ITeiidServerManager manager = DqpPlugin.getInstance().getServerManager();
        manager.addListener(ServerVersionGuard.getInstance());
    }
}

