/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.preview.jobs;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.runtime.DqpPlugin;
import org.teiid.designer.runtime.PreferenceConstants;
import org.teiid.designer.runtime.preview.Messages;
import org.teiid.designer.runtime.preview.PreviewContext;
import org.teiid.designer.runtime.preview.jobs.PreviewVdbJob;

public abstract class WorkspacePreviewVdbJob
extends WorkspaceJob
implements PreferenceConstants,
PreviewVdbJob {
    public static final Object WORKSPACE_PREVIEW_FAMILY = PreviewVdbJob.PREVIEW_FAMILY + ".workspace";
    private final PreviewContext context;

    public WorkspacePreviewVdbJob(String name, PreviewContext context) {
        super(name);
        assert (context != null);
        this.context = context;
    }

    public boolean belongsTo(Object family) {
        return WORKSPACE_PREVIEW_FAMILY == family;
    }

    @Override
    public boolean completedSuccessfully() {
        IStatus status = this.getResult();
        if (status == null) {
            return false;
        }
        return status.getSeverity() != 4;
    }

    @Override
    public PreviewContext getContext() {
        return this.context;
    }

    public abstract IFile getPreviewVdb();

    protected IResourceRuleFactory getSchedulingRuleFactory() {
        return ModelerCore.getWorkspace().getRuleFactory();
    }

    protected abstract IStatus runImpl(IProgressMonitor var1) throws Exception;

    public final IStatus runInWorkspace(IProgressMonitor monitor) {
        IStatus iStatus;
        long startTime;
        block12: {
            if (DqpPlugin.getInstance().isDebugOptionEnabled("org.teiid.designer.dqp/debug/preview/jobs/jobStart")) {
                DqpPlugin.Util.log(1, NLS.bind((String)Messages.JobStarted, (Object)this.getName()));
            }
            IStatus results = null;
            startTime = System.currentTimeMillis();
            monitor.setTaskName(this.getName());
            try {
                results = this.runImpl(monitor);
                assert (results != null);
                iStatus = results;
                if (!DqpPlugin.getInstance().isDebugOptionEnabled("org.teiid.designer.dqp/debug/preview/jobs/jobDone")) break block12;
            }
            catch (Exception e) {
                Status status;
                block15: {
                    block13: {
                        Status status2;
                        block14: {
                            try {
                                if (!(e instanceof InterruptedException)) break block13;
                                status2 = new Status(2, "org.teiid.designer.dqp", NLS.bind((String)Messages.JobCanceled, (Object)this.getName()), (Throwable)e);
                                if (!DqpPlugin.getInstance().isDebugOptionEnabled("org.teiid.designer.dqp/debug/preview/jobs/jobDone")) break block14;
                            }
                            catch (Throwable throwable) {
                                if (DqpPlugin.getInstance().isDebugOptionEnabled("org.teiid.designer.dqp/debug/preview/jobs/jobDone")) {
                                    DqpPlugin.Util.log(1, NLS.bind((String)Messages.JobFinished, (Object)this.getName(), (Object)(results.getSeverity() != 4 ? 1 : 0)));
                                }
                                monitor.done();
                                if (DqpPlugin.getInstance().isDebugOptionEnabled("org.teiid.designer.dqp/debug/preview/jobs/jobDuration")) {
                                    long milliseconds = System.currentTimeMillis() - startTime;
                                    long hours = milliseconds / 3600000L;
                                    long minutes = milliseconds % 3600000L / 60000L;
                                    long seconds = milliseconds % 3600000L % 60000L / 1000L;
                                    String msg = hours > 0L ? NLS.bind((String)Messages.LongDurationJob, (Object[])new Object[]{this.getName(), hours, minutes, seconds}) : (minutes > 0L ? NLS.bind((String)Messages.LessThanAnHourDurationJob, (Object[])new Object[]{this.getName(), minutes, seconds}) : (seconds > 0L ? NLS.bind((String)Messages.LessThanAMinuteDurationJob, (Object)this.getName(), (Object)seconds) : NLS.bind((String)Messages.LessThanASecondDurationJob, (Object)this.getName())));
                                    DqpPlugin.Util.log(1, msg);
                                }
                                throw throwable;
                            }
                            DqpPlugin.Util.log(1, NLS.bind((String)Messages.JobFinished, (Object)this.getName(), (Object)(results.getSeverity() != 4 ? 1 : 0)));
                        }
                        monitor.done();
                        if (DqpPlugin.getInstance().isDebugOptionEnabled("org.teiid.designer.dqp/debug/preview/jobs/jobDuration")) {
                            long milliseconds = System.currentTimeMillis() - startTime;
                            long hours = milliseconds / 3600000L;
                            long minutes = milliseconds % 3600000L / 60000L;
                            long seconds = milliseconds % 3600000L % 60000L / 1000L;
                            String msg = hours > 0L ? NLS.bind((String)Messages.LongDurationJob, (Object[])new Object[]{this.getName(), hours, minutes, seconds}) : (minutes > 0L ? NLS.bind((String)Messages.LessThanAnHourDurationJob, (Object[])new Object[]{this.getName(), minutes, seconds}) : (seconds > 0L ? NLS.bind((String)Messages.LessThanAMinuteDurationJob, (Object)this.getName(), (Object)seconds) : NLS.bind((String)Messages.LessThanASecondDurationJob, (Object)this.getName())));
                            DqpPlugin.Util.log(1, msg);
                        }
                        return status2;
                    }
                    status = new Status(4, "org.teiid.designer.dqp", NLS.bind((String)Messages.UnexpectedErrorRunningJob, (Object)this.getName()), (Throwable)e);
                    if (!DqpPlugin.getInstance().isDebugOptionEnabled("org.teiid.designer.dqp/debug/preview/jobs/jobDone")) break block15;
                    DqpPlugin.Util.log(1, NLS.bind((String)Messages.JobFinished, (Object)this.getName(), (Object)(results.getSeverity() != 4 ? 1 : 0)));
                }
                monitor.done();
                if (DqpPlugin.getInstance().isDebugOptionEnabled("org.teiid.designer.dqp/debug/preview/jobs/jobDuration")) {
                    long milliseconds = System.currentTimeMillis() - startTime;
                    long hours = milliseconds / 3600000L;
                    long minutes = milliseconds % 3600000L / 60000L;
                    long seconds = milliseconds % 3600000L % 60000L / 1000L;
                    String msg = hours > 0L ? NLS.bind((String)Messages.LongDurationJob, (Object[])new Object[]{this.getName(), hours, minutes, seconds}) : (minutes > 0L ? NLS.bind((String)Messages.LessThanAnHourDurationJob, (Object[])new Object[]{this.getName(), minutes, seconds}) : (seconds > 0L ? NLS.bind((String)Messages.LessThanAMinuteDurationJob, (Object)this.getName(), (Object)seconds) : NLS.bind((String)Messages.LessThanASecondDurationJob, (Object)this.getName())));
                    DqpPlugin.Util.log(1, msg);
                }
                return status;
            }
            DqpPlugin.Util.log(1, NLS.bind((String)Messages.JobFinished, (Object)this.getName(), (Object)(results.getSeverity() != 4 ? 1 : 0)));
        }
        monitor.done();
        if (DqpPlugin.getInstance().isDebugOptionEnabled("org.teiid.designer.dqp/debug/preview/jobs/jobDuration")) {
            long milliseconds = System.currentTimeMillis() - startTime;
            long hours = milliseconds / 3600000L;
            long minutes = milliseconds % 3600000L / 60000L;
            long seconds = milliseconds % 3600000L % 60000L / 1000L;
            String msg = hours > 0L ? NLS.bind((String)Messages.LongDurationJob, (Object[])new Object[]{this.getName(), hours, minutes, seconds}) : (minutes > 0L ? NLS.bind((String)Messages.LessThanAnHourDurationJob, (Object[])new Object[]{this.getName(), minutes, seconds}) : (seconds > 0L ? NLS.bind((String)Messages.LessThanAMinuteDurationJob, (Object)this.getName(), (Object)seconds) : NLS.bind((String)Messages.LessThanASecondDurationJob, (Object)this.getName())));
            DqpPlugin.Util.log(1, msg);
        }
        return iStatus;
    }

    public boolean shouldRun() {
        boolean result = DqpPlugin.getInstance().getPreferences().getBoolean("org.teiid.designer.dqp.preferences.PreviewEnabled", true);
        if (DqpPlugin.getInstance().isDebugOptionEnabled("org.teiid.designer.dqp/debug/preview/jobs/jobShouldRun")) {
            DqpPlugin.Util.log(1, NLS.bind((String)Messages.JobShouldRun, (Object)this.getName(), (Object)result));
        }
        return result;
    }
}

