/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.preview.jobs;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.osgi.util.NLS;
import org.teiid.designer.runtime.preview.Messages;
import org.teiid.designer.runtime.preview.PreviewContext;
import org.teiid.designer.runtime.preview.jobs.WorkspacePreviewVdbJob;

public final class DeletePreviewVdbJob
extends WorkspacePreviewVdbJob {
    private final IFile pvdbFile;

    public DeletePreviewVdbJob(IFile pvdbToDelete, PreviewContext context) throws Exception {
        super(NLS.bind((String)Messages.DeletePreviewVdbJob, (Object)pvdbToDelete.getFullPath()), context);
        this.pvdbFile = pvdbToDelete;
        assert (this.pvdbFile != null) : "PVDB is null";
        this.initialize();
    }

    public DeletePreviewVdbJob(PreviewContext context, IFile deletedModel) throws Exception {
        super(NLS.bind((String)Messages.DeletePreviewVdbJobForModel, (Object)deletedModel.getFullPath()), context);
        this.pvdbFile = context.getPreviewVdb((IResource)deletedModel);
        assert (this.pvdbFile != null) : "PVDB is null";
        this.initialize();
    }

    @Override
    public IFile getPreviewVdb() {
        return this.pvdbFile;
    }

    private void initialize() {
        assert (this.pvdbFile != null) : "initialize() called before PVDB file is set";
        ISchedulingRule[] rules = new ISchedulingRule[]{this.getSchedulingRuleFactory().deleteRule((IResource)this.pvdbFile), this.getSchedulingRuleFactory().buildRule()};
        this.setRule(MultiRule.combine((ISchedulingRule[])rules));
    }

    @Override
    protected IStatus runImpl(IProgressMonitor monitor) throws Exception {
        try {
            this.pvdbFile.delete(true, monitor);
            return new Status(0, "org.teiid.designer.dqp", NLS.bind((String)Messages.DeletePreviewVdbJobSuccessfullyCompleted, (Object)this.pvdbFile.getFullPath()));
        }
        catch (Exception e) {
            return new Status(4, "org.teiid.designer.dqp", NLS.bind((String)Messages.DeletePreviewVdbJobError, (Object)this.pvdbFile.getFullPath()), (Throwable)e);
        }
    }
}

