/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.importer;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.common.xml.XmlUtil;
import org.teiid.designer.runtime.DqpPlugin;
import org.teiid.designer.runtime.importer.Messages;
import org.teiid.designer.runtime.spi.ExecutionConfigurationEvent;
import org.teiid.designer.runtime.spi.IExecutionConfigurationListener;
import org.teiid.designer.runtime.spi.ITeiidDataSource;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.spi.ITeiidTranslator;
import org.teiid.designer.runtime.spi.ITeiidVdb;
import org.teiid.designer.runtime.spi.TeiidPropertyDefinition;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;

public final class ImportManager
implements IExecutionConfigurationListener {
    private static final String DYNAMIC_VDB_SUFFIX = "-vdb.xml";
    public static final String IMPORT_SRC_MODEL = "SrcModel";
    private static final String JNDI_PROPERTY_KEY = "jndi-name";
    private static final int VDB_LOADING_TIMEOUT_SEC = 120;
    private volatile AtomicReference<ITeiidServer> importServer = new AtomicReference();
    private static ImportManager instance;

    public static ImportManager getInstance() {
        if (instance == null) {
            instance = new ImportManager();
        }
        return instance;
    }

    private ImportManager() {
    }

    public void configurationChanged(ExecutionConfigurationEvent event) {
        if (event.getEventType().equals((Object)ExecutionConfigurationEvent.EventType.DEFAULT) && event.getTargetType().equals((Object)ExecutionConfigurationEvent.TargetType.SERVER)) {
            this.setImportServer(event.getUpdatedServer());
        }
    }

    private void setImportServer(ITeiidServer teiidServer) {
        this.importServer.set(teiidServer);
    }

    private ITeiidServer getImportServer() {
        return this.importServer.get();
    }

    public boolean isValidImportServer() {
        ITeiidServer importServer = this.getImportServer();
        if (importServer == null || !importServer.isConnected()) {
            return false;
        }
        ITeiidServerVersion version = importServer.getServerVersion();
        return !version.isSevenServer();
    }

    public boolean vdbExists(String vdbName) {
        try {
            return this.getImportServer().getVdb(vdbName) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private ITeiidDataSource getDataSource(String sourceName) throws Exception {
        return this.getImportServer().getDataSource(sourceName);
    }

    public IStatus deployDynamicVdb(String vdbName, String sourceName, String translatorName, Map<String, String> modelPropertyMap, IProgressMonitor monitor) {
        ITeiidDataSource dataSource;
        int workRemaining = 100;
        Object resultStatus = Status.OK_STATUS;
        String deploymentName = String.valueOf(vdbName) + DYNAMIC_VDB_SUFFIX;
        String importSourceModel = String.valueOf(vdbName) + IMPORT_SRC_MODEL;
        try {
            dataSource = this.getDataSource(sourceName);
        }
        catch (Exception exception) {
            resultStatus = new Status(4, "org.teiid.designer.dqp", NLS.bind((String)Messages.ImportManagerGetDatasourceError, (Object)sourceName));
            return resultStatus;
        }
        if (dataSource == null) {
            return new Status(4, "org.teiid.designer.dqp", NLS.bind((String)Messages.ImportManagerGetDatasourceError, (Object)sourceName));
        }
        monitor.worked(10);
        workRemaining -= 10;
        String sourceJndiName = dataSource.getPropertyValue(JNDI_PROPERTY_KEY);
        if (CoreStringUtil.isEmpty((String)sourceJndiName)) {
            sourceJndiName = sourceName;
        }
        String dynamicVdbString = this.createDynamicVdb(vdbName, 1, translatorName, importSourceModel, sourceJndiName, modelPropertyMap);
        try {
            ITeiidVdb deployedImportVdb = this.getImportServer().getVdb(vdbName);
            if (deployedImportVdb != null) {
                this.getImportServer().undeployDynamicVdb(deployedImportVdb.getName());
            }
        }
        catch (Exception exception) {
            resultStatus = new Status(4, "org.teiid.designer.dqp", NLS.bind((String)Messages.ImportManagerUndeployVdbError, (Object)vdbName));
            return resultStatus;
        }
        monitor.worked(10);
        workRemaining -= 10;
        try {
            this.getImportServer().deployDynamicVdb(deploymentName, (InputStream)new ByteArrayInputStream(dynamicVdbString.getBytes("UTF-8")));
        }
        catch (Exception exception) {
            resultStatus = new Status(4, "org.teiid.designer.dqp", NLS.bind((String)Messages.ImportManagerDeployVdbError, (Object)vdbName));
            return resultStatus;
        }
        monitor.worked(10);
        workRemaining -= 10;
        String timeoutStr = DqpPlugin.getInstance().getPreferences().get("org.teiid.designer.dqp.preferences.TeiidImporterTimeoutSec", "120");
        int timeoutSec = 0;
        try {
            timeoutSec = Integer.parseInt(timeoutStr);
        }
        catch (NumberFormatException numberFormatException) {
            timeoutSec = 120;
        }
        boolean finishedLoading = false;
        try {
            finishedLoading = this.waitForVDBLoad(vdbName, timeoutSec, monitor, workRemaining);
        }
        catch (Exception exception) {
            resultStatus = new Status(4, "org.teiid.designer.dqp", NLS.bind((String)Messages.ImportManagerVdbLoadingError, (Object)vdbName));
            return resultStatus;
        }
        if (finishedLoading) {
            boolean isVDBActive;
            try {
                isVDBActive = this.getImportServer().isVdbActive(vdbName);
            }
            catch (Exception exception) {
                resultStatus = new Status(4, "org.teiid.designer.dqp", NLS.bind((String)Messages.ImportManagerVdbGetStateError, (Object)vdbName));
                return resultStatus;
            }
            resultStatus = isVDBActive ? Status.OK_STATUS : new Status(4, "org.teiid.designer.dqp", NLS.bind((String)Messages.ImportManagerVdbInactiveStateError, (Object)vdbName));
        } else {
            resultStatus = new Status(4, "org.teiid.designer.dqp", NLS.bind((String)Messages.ImportManagerVdbLoadingNotCompleteError, (Object)timeoutSec));
        }
        return resultStatus;
    }

    public String createDynamicVdbString(String vdbName, String sourceName, String translatorName, Map<String, String> modelPropertyMap) {
        ITeiidDataSource dataSource;
        String importSourceModel = String.valueOf(vdbName) + IMPORT_SRC_MODEL;
        try {
            dataSource = this.getDataSource(sourceName);
        }
        catch (Exception exception) {
            return Messages.ImportManagerDynamicVdbTextCannotBeGeneratedError;
        }
        String sourceJndiName = dataSource.getPropertyValue(JNDI_PROPERTY_KEY);
        if (CoreStringUtil.isEmpty((String)sourceJndiName)) {
            sourceJndiName = sourceName;
        }
        return this.createDynamicVdb(vdbName, 1, translatorName, importSourceModel, sourceJndiName, modelPropertyMap);
    }

    public String getSchema(String vdbName) throws Exception {
        return this.getImportServer().getSchema(vdbName, 1, String.valueOf(vdbName) + IMPORT_SRC_MODEL);
    }

    public IStatus undeployVdb(String importerVdbName) {
        Status resultStatus = null;
        try {
            ITeiidVdb deployedImportVdb = this.getImportServer().getVdb(importerVdbName);
            if (deployedImportVdb != null) {
                this.getImportServer().undeployDynamicVdb(deployedImportVdb.getName());
            }
        }
        catch (Exception exception) {
            resultStatus = new Status(4, "org.teiid.designer.dqp", NLS.bind((String)Messages.ImportManagerUndeployVdbError, (Object)importerVdbName));
        }
        return resultStatus;
    }

    private String getVdbDeploymentName(ITeiidVdb deployedVdb) {
        String fullVdbName = deployedVdb.getPropertyValue("deployment-name");
        return fullVdbName;
    }

    public String createDynamicVdb(String vdbName, int vdbVersion, String translatorName, String datasourceName, String datasourceJndiName, Map<String, String> modelProps) {
        StringBuffer sb = new StringBuffer();
        String deploymentName = String.valueOf(vdbName) + DYNAMIC_VDB_SUFFIX;
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        sb.append("\n<vdb name=\"" + vdbName + "\" version=\"" + vdbVersion + "\">");
        sb.append("\n\t<description>Importer VDB</description>");
        sb.append("\n\t<property name=\"UseConnectorMetadata\" value=\"true\" />");
        sb.append("\n\t<property name=\"deployment-name\" value=\"" + deploymentName + "\" />");
        sb.append("\n\t<model name=\"" + datasourceName + "\" type=\"PHYSICAL\" visible=\"true\">");
        Set<String> propNames = modelProps.keySet();
        for (String propName : propNames) {
            String propValue = XmlUtil.escapeCharacterData((String)modelProps.get(propName));
            sb.append("\n\t\t<property name=\"" + propName + "\" value=\"" + propValue + "\" />");
        }
        sb.append("\n\t\t<source name=\"" + datasourceName + "\" translator-name=\"" + translatorName + "\" connection-jndi-name=\"" + datasourceJndiName + "\" />");
        sb.append("\n\t</model>");
        sb.append("\n</vdb>");
        return sb.toString();
    }

    private boolean waitForVDBLoad(String vdbName, int timeoutInSecs, IProgressMonitor monitor, int workRemaining) throws Exception {
        int increments = timeoutInSecs / 5;
        int workIncrement = Math.round((float)workRemaining / (float)increments);
        long waitUntil = System.currentTimeMillis() + (long)(timeoutInSecs * 1000);
        if (timeoutInSecs < 0) {
            waitUntil = Long.MAX_VALUE;
        }
        boolean first = true;
        do {
            boolean hasValidityErrors;
            block5: {
                if (!first) {
                    try {
                        Thread.sleep(5000L);
                        break block5;
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                }
                first = false;
            }
            monitor.worked(workIncrement);
            boolean isActive = this.getImportServer().isVdbActive(vdbName);
            boolean isLoading = this.getImportServer().isVdbLoading(vdbName);
            boolean hasFailed = this.getImportServer().hasVdbFailed(vdbName);
            boolean bl = hasValidityErrors = !this.getImportServer().getVdb(vdbName).getValidityErrors().isEmpty();
            if (isLoading && !hasFailed && !hasValidityErrors && !isActive) continue;
            return true;
        } while (System.currentTimeMillis() < waitUntil);
        return false;
    }

    public String getDisplayName() throws Exception {
        return this.getImportServer().getParentName();
    }

    public Collection<ITeiidTranslator> getTranslators() throws Exception {
        return this.getImportServer().getTranslators();
    }

    public ITeiidTranslator getTranslator(String name) throws Exception {
        for (ITeiidTranslator translator : this.getTranslators()) {
            if (!name.equalsIgnoreCase(translator.getName())) continue;
            return translator;
        }
        return null;
    }

    public void deleteDataSource(String jndiName) throws Exception {
        this.getImportServer().deleteDataSource(jndiName);
    }

    public void deployDriver(File jarOrRarFile) throws Exception {
        this.getImportServer().deployDriver(jarOrRarFile);
    }

    public String getSchema(String vdbName, int vdbVersion, String modelName) throws Exception {
        return this.getImportServer().getSchema(vdbName, vdbVersion, modelName);
    }

    public Collection<ITeiidDataSource> getDataSources() throws Exception {
        return this.getImportServer().getDataSources();
    }

    public Set<String> getDataSourceTemplateNames() throws Exception {
        return this.getImportServer().getDataSourceTemplateNames();
    }

    public Collection<TeiidPropertyDefinition> getTemplatePropertyDefns(String templateName) throws Exception {
        return this.getImportServer().getTemplatePropertyDefns(templateName);
    }

    public ITeiidDataSource getOrCreateDataSource(String displayName, String jndiName, String typeName, Properties properties) throws Exception {
        return this.getImportServer().getOrCreateDataSource(displayName, jndiName, typeName, properties);
    }

    public void undeployDynamicVdb(String vdbName) throws Exception {
        this.getImportServer().undeployDynamicVdb(vdbName);
    }

    public void deployDynamicVdb(String deploymentName, InputStream inStream) throws Exception {
        this.getImportServer().deployDynamicVdb(deploymentName, inStream);
    }

    public Properties getDataSourceProperties(String dataSourceName) throws Exception {
        return this.getImportServer().getDataSourceProperties(dataSourceName);
    }

    public ITeiidServerVersion getServerVersion() {
        ITeiidServer importServer = this.getImportServer();
        if (importServer == null || !importServer.isConnected()) {
            return null;
        }
        return importServer.getServerVersion();
    }
}

