/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.connection;

import java.util.Properties;
import java.util.Set;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.runtime.connection.TranslatorProfile;

public class TranslatorProfileFactory {
    public TranslatorProfile createTeiidTranslator(String name, String type, Properties props) {
        CoreArgCheck.isNotEmpty((String)name, (String)"name");
        CoreArgCheck.isNotEmpty((String)type, (String)"type");
        CoreArgCheck.isNotEmpty((Properties)props, (String)"props");
        TranslatorProfile profile = new TranslatorProfile(name, type, props);
        return profile;
    }

    public Properties getNamespacedProperties(TranslatorProfile translatorProfile) {
        CoreArgCheck.isNotNull((Object)translatorProfile, (String)"translatorProfile");
        Properties translatorProps = translatorProfile.getProperties();
        Properties allProps = new Properties();
        allProps.put("translator:name", translatorProfile.getName());
        allProps.put("translator:type", translatorProfile.getType());
        Set<Object> keys = translatorProps.keySet();
        for (Object nextKey : keys) {
            allProps.put("translator:" + nextKey, translatorProps.get(nextKey));
        }
        return allProps;
    }
}

