/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.connection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.runtime.DqpPlugin;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.spi.ITeiidTranslator;
import org.teiid.designer.vdb.connections.VdbSourceConnection;

public class SourceConnectionBinding {
    private final String modelName;
    private final String modelLocation;
    private final Set<ITeiidTranslator> translators = new HashSet<ITeiidTranslator>();
    private final List<VdbSourceConnection> vdbSources = new ArrayList<VdbSourceConnection>();

    public SourceConnectionBinding(String modelName, String modelLocation, VdbSourceConnection vdbSource) {
        this.modelName = modelName;
        this.modelLocation = modelLocation;
        this.addVdbSource(vdbSource);
    }

    public SourceConnectionBinding(String modelName, String path, ITeiidTranslator translator) {
        this(modelName, path, Collections.singleton(translator));
        CoreArgCheck.isNotNull((Object)translator, (String)"translator");
    }

    public SourceConnectionBinding(String modelName, String modelLocation, Set<ITeiidTranslator> translators) {
        CoreArgCheck.isNotEmpty((String)modelName, (String)"modelName");
        CoreArgCheck.isNotEmpty((String)modelLocation, (String)"modelLocation");
        CoreArgCheck.isNotEmpty(translators, (String)"translators");
        this.modelName = modelName;
        this.modelLocation = modelLocation;
        ITeiidServer teiidServer = null;
        for (ITeiidTranslator translator : translators) {
            if (translator == null) {
                throw new IllegalArgumentException(DqpPlugin.Util.getString("translatorCannotBeNullForSourceBinding", new Object[0]));
            }
            if (teiidServer == null) {
                teiidServer = translator.getTeiidServer();
            } else if (teiidServer != translator.getTeiidServer()) {
                throw new IllegalArgumentException(DqpPlugin.Util.getString("sourceBindingWithTranslatorsFromDifferentServers", new Object[0]));
            }
            this.translators.add(translator);
        }
    }

    public boolean addTranslator(ITeiidTranslator translator) {
        CoreArgCheck.isNotNull((Object)translator, (String)"translator");
        if (translator.getTeiidServer() != null && !translator.getTeiidServer().equals(this.translators.iterator().next().getTeiidServer())) {
            throw new IllegalArgumentException(DqpPlugin.Util.getString("sourceBindingWithTranslatorsFromDifferentServers", new Object[0]));
        }
        return this.translators.add(translator);
    }

    public Set<ITeiidTranslator> getTranslators() {
        return Collections.unmodifiableSet(this.translators);
    }

    public String getModelName() {
        return this.modelName;
    }

    public String getModelLocation() {
        return this.modelLocation;
    }

    public void removeTranslator(ITeiidTranslator translator) {
        CoreArgCheck.isNotNull((Object)translator, (String)"translator");
        if (this.translators.size() == 1 && this.translators.contains(translator)) {
            throw new IllegalArgumentException(DqpPlugin.Util.getString("lastTranslatorOfSourceBindingCannotBeRemoved", new Object[0]));
        }
        if (!this.translators.remove(translator)) {
            throw new IllegalArgumentException(DqpPlugin.Util.getString("translatorToRemoveNotFoundInSourceBinding", new Object[]{translator.getName(), this.modelName}));
        }
    }

    public void addVdbSource(VdbSourceConnection vdbSource) {
        this.vdbSources.add(vdbSource);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("model: " + this.getModelName());
        sb.append(", path: " + this.getModelLocation());
        sb.append(", translators: ");
        int count = this.translators.size();
        int i = 1;
        for (ITeiidTranslator translator : this.translators) {
            sb.append(translator.getName());
            if (i < count) {
                sb.append(", ");
            }
            ++i;
        }
        return sb.toString();
    }
}

