/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.adapter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.core.server.internal.JBossServer;
import org.jboss.ide.eclipse.as.core.server.internal.v7.JBoss7Server;
import org.teiid.designer.runtime.DqpPlugin;
import org.teiid.designer.runtime.TeiidServerFactory;
import org.teiid.designer.runtime.adapter.JBoss7ServerUtil;
import org.teiid.designer.runtime.adapter.JBossServerUtil;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.spi.ITeiidServerManager;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;

public class TeiidServerAdapterFactory
implements IAdapterFactory {
    private Object lock = new Object();
    private ITeiidServerManager serverManager;

    public Class[] getAdapterList() {
        return new Class[]{ITeiidServer.class};
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (!ITeiidServer.class.isAssignableFrom(adapterType)) {
            return null;
        }
        try {
            if (adaptableObject instanceof IServer) {
                return this.adaptServer((IServer)adaptableObject, TeiidServerFactory.ServerOptions.ADD_TO_REGISTRY, TeiidServerFactory.ServerOptions.CONNECT);
            }
        }
        catch (Exception ex) {
            DqpPlugin.Util.log(4, (Throwable)ex, "Failed to determine if server supports teiid");
        }
        return null;
    }

    private ITeiidServerManager getTeiidServerManager() {
        if (this.serverManager == null) {
            this.serverManager = DqpPlugin.getInstance().getServerManager();
        }
        return this.serverManager;
    }

    public ITeiidServer adaptServer(IServer server, TeiidServerFactory.ServerOptions ... options) throws Exception {
        if (!this.getTeiidServerManager().isStarted()) {
            return null;
        }
        JBoss7Server jb7 = (JBoss7Server)server.loadAdapter(JBoss7Server.class, null);
        if (jb7 != null) {
            return this.adaptJBoss7Server(server, jb7, options);
        }
        JBossServer jb = (JBossServer)server.loadAdapter(JBossServer.class, null);
        if (jb != null) {
            return this.adaptJBossServer(server, jb, options);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ITeiidServer adaptJBossServer(IServer parentServer, JBossServer jbossServer, TeiidServerFactory.ServerOptions ... options) throws Exception {
        ITeiidServer teiidServer = null;
        List<Object> optionList = Collections.emptyList();
        if (options != null) {
            optionList = Arrays.asList(options);
        }
        if (!optionList.contains((Object)TeiidServerFactory.ServerOptions.NO_CHECK_SERVER_REGISTRY) && (teiidServer = this.getTeiidServerManager().getServer(parentServer)) != null) {
            return teiidServer;
        }
        Object object = this.lock;
        synchronized (object) {
            block9: {
                block10: {
                    if (optionList.contains((Object)TeiidServerFactory.ServerOptions.NO_CHECK_CONNECTION)) break block9;
                    if (JBossServerUtil.isJBossServerConnected(parentServer, jbossServer)) break block10;
                    return null;
                }
                if (JBossServerUtil.isTeiidServer(parentServer, jbossServer)) break block9;
                return null;
            }
            if (!optionList.contains((Object)TeiidServerFactory.ServerOptions.NO_CHECK_SERVER_REGISTRY)) {
                teiidServer = this.getTeiidServerManager().getServer(parentServer);
            }
            if (teiidServer == null) {
                teiidServer = this.createJbossTeiidServer(parentServer, jbossServer, options);
            }
            return teiidServer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ITeiidServer adaptJBoss7Server(IServer parentServer, JBoss7Server jboss7Server, TeiidServerFactory.ServerOptions ... options) throws Exception {
        ITeiidServer teiidServer = null;
        List<Object> optionList = Collections.emptyList();
        if (options != null) {
            optionList = Arrays.asList(options);
        }
        if (!optionList.contains((Object)TeiidServerFactory.ServerOptions.NO_CHECK_SERVER_REGISTRY) && (teiidServer = this.getTeiidServerManager().getServer(parentServer)) != null) {
            return teiidServer;
        }
        Object object = this.lock;
        synchronized (object) {
            block9: {
                block10: {
                    if (optionList.contains((Object)TeiidServerFactory.ServerOptions.NO_CHECK_CONNECTION)) break block9;
                    if (JBoss7ServerUtil.isJBossServerConnected(parentServer, jboss7Server)) break block10;
                    return null;
                }
                if (JBoss7ServerUtil.isTeiidServer(parentServer, jboss7Server)) break block9;
                return null;
            }
            if (!optionList.contains((Object)TeiidServerFactory.ServerOptions.NO_CHECK_SERVER_REGISTRY)) {
                teiidServer = this.getTeiidServerManager().getServer(parentServer);
            }
            if (teiidServer == null) {
                teiidServer = this.createJboss7TeiidServer(parentServer, jboss7Server, options);
            }
            return teiidServer;
        }
    }

    private ITeiidServer createJboss7TeiidServer(IServer parentServer, JBoss7Server jboss7Server, TeiidServerFactory.ServerOptions ... options) throws Exception {
        TeiidServerFactory factory = new TeiidServerFactory();
        ITeiidServer teiidServer = factory.createTeiidServer(JBoss7ServerUtil.getTeiidRuntimeVersion(parentServer, jboss7Server), this.getTeiidServerManager(), parentServer, new Integer(jboss7Server.getManagementPort()).toString(), jboss7Server.getUsername(), jboss7Server.getPassword(), JBoss7ServerUtil.getJdbcPort(parentServer, jboss7Server), "user", "user", options);
        return teiidServer;
    }

    private ITeiidServer createJbossTeiidServer(IServer parentServer, JBossServer jbossServer, TeiidServerFactory.ServerOptions ... options) {
        ArrayList<TeiidServerFactory.ServerOptions> optionList = new ArrayList<TeiidServerFactory.ServerOptions>();
        if (options != null) {
            TeiidServerFactory.ServerOptions[] serverOptionsArray = options;
            int n = options.length;
            int n2 = 0;
            while (n2 < n) {
                TeiidServerFactory.ServerOptions serverOption = serverOptionsArray[n2];
                optionList.add(serverOption);
                ++n2;
            }
        }
        optionList.add(TeiidServerFactory.ServerOptions.ADMIN_SECURE_CONNECTION);
        TeiidServerFactory factory = new TeiidServerFactory();
        ITeiidServer teiidServer = factory.createTeiidServer(JBossServerUtil.getTeiidRuntimeVersion(parentServer, jbossServer), this.getTeiidServerManager(), parentServer, "31443", "admin", "admin", "31000", "user", "user", optionList.toArray(new TeiidServerFactory.ServerOptions[0]));
        return teiidServer;
    }

    public boolean isParentServerConnected(IServer server) throws Exception {
        if (server.getServerState() != 2) {
            return false;
        }
        JBoss7Server jb7 = (JBoss7Server)server.loadAdapter(JBoss7Server.class, null);
        if (jb7 != null) {
            return JBoss7ServerUtil.isJBossServerConnected(server, jb7);
        }
        JBossServer jb = (JBossServer)server.loadAdapter(JBossServer.class, null);
        if (jb != null) {
            return JBossServerUtil.isJBossServerConnected(server, jb);
        }
        return false;
    }

    public ITeiidServerVersion getTeiidRuntimeVersion(IServer server) throws Exception {
        if (!this.getTeiidServerManager().isStarted()) {
            return null;
        }
        JBoss7Server jb7 = (JBoss7Server)server.loadAdapter(JBoss7Server.class, null);
        if (jb7 != null) {
            return JBoss7ServerUtil.getTeiidRuntimeVersion(server, jb7);
        }
        JBossServer jb = (JBossServer)server.loadAdapter(JBossServer.class, null);
        if (jb != null) {
            return JBossServerUtil.getTeiidRuntimeVersion(server, jb);
        }
        return null;
    }
}

