/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.xslt;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.transform.stream.StreamSource;
import org.teiid.core.designer.TeiidDesignerException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.xslt.CoreXsltPlugin;
import org.teiid.designer.core.xslt.Style;

public class StyleFromResource
implements Style {
    private final URL url;
    private final String name;
    private final String description;

    public StyleFromResource(URL url, String name) {
        this(url, name, null);
    }

    public StyleFromResource(URL url, String name, String desc) {
        CoreArgCheck.isNotNull((Object)name);
        CoreArgCheck.isNotZeroLength((String)name);
        CoreArgCheck.isNotNull((Object)url);
        this.url = url;
        this.name = name;
        this.description = desc != null ? desc : "";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public URL getUrl() {
        return this.url;
    }

    @Override
    public InputStream getInputStream() throws IOException, TeiidDesignerException {
        URL xsltURL = this.getUrl();
        InputStream stylesheetStream = xsltURL.openStream();
        if (stylesheetStream == null) {
            stylesheetStream = new FileInputStream(xsltURL.toExternalForm());
        }
        if (stylesheetStream.available() == 0) {
            Object[] params = new Object[]{xsltURL};
            String msg = CoreXsltPlugin.Util.getString("StyleFromResource.empty_xslt", params);
            throw new TeiidDesignerException(msg);
        }
        return stylesheetStream;
    }

    @Override
    public StreamSource getStreamSource() throws IOException, TeiidDesignerException {
        InputStream stream = this.getInputStream();
        return new StreamSource(stream);
    }
}

