/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.ui.viewers;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.modeshape.ui.UiUtils;

public abstract class CheckBoxLabelProvider
extends ColumnLabelProvider {
    private static final String CHECKED_KEY = "CHECKED";
    private static final String UNCHECK_KEY = "UNCHECKED";

    public CheckBoxLabelProvider(ColumnViewer viewer) {
        UiUtils.verifyIsNotNull(viewer, "viewer");
        if (JFaceResources.getImageRegistry().getDescriptor(CHECKED_KEY) == null) {
            JFaceResources.getImageRegistry().put(UNCHECK_KEY, this.createImage(viewer.getControl().getShell(), false));
            JFaceResources.getImageRegistry().put(CHECKED_KEY, this.createImage(viewer.getControl().getShell(), true));
        }
    }

    private Image createImage(Shell shell, boolean type) {
        Shell s = new Shell(shell, 8);
        Button b = new Button((Composite)s, 32);
        b.setSelection(type);
        Point bsize = b.computeSize(-1, -1);
        b.setSize(bsize);
        b.setLocation(0, 0);
        s.setSize(bsize);
        s.open();
        GC gc = new GC((Drawable)b);
        Image image = new Image((Device)shell.getDisplay(), bsize.x, bsize.y);
        gc.copyArea(image, 0, 0);
        gc.dispose();
        s.close();
        return image;
    }

    public Image getImage(Object element) {
        if (this.isChecked(element)) {
            return JFaceResources.getImageRegistry().getDescriptor(CHECKED_KEY).createImage();
        }
        return JFaceResources.getImageRegistry().getDescriptor(UNCHECK_KEY).createImage();
    }

    public String getText(Object element) {
        return "";
    }

    protected abstract boolean isChecked(Object var1);
}

