/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.xquery.saxon;

import java.util.Map;
import net.sf.saxon.om.Name11Checker;

final class StreamingUtils {
    StreamingUtils() {
    }

    public static String getStreamingPath(String locationPath, Map<String, String> prefixMap) {
        String[] localNames;
        if (locationPath.indexOf("//") >= 0) {
            throw new IllegalArgumentException("DESCENDANT axis is not supported");
        }
        String path = locationPath.trim();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ((localNames = (path = path.trim()).split("/")).length == 1) {
            throw new IllegalArgumentException(String.valueOf(locationPath) + " refers to only the root element");
        }
        String fixedPath = "";
        int i = 0;
        while (i < localNames.length) {
            fixedPath = String.valueOf(fixedPath) + "/";
            int k = localNames[i].indexOf(58);
            if (k >= 0 && localNames[i].indexOf(58, k + 1) >= 0) {
                throw new IllegalArgumentException("QName must not contain more than one colon: qname='" + localNames[i] + "', path='" + path + "'");
            }
            if (k <= 0) {
                fixedPath = String.valueOf(fixedPath) + "-:";
            } else {
                String prefix = localNames[i].substring(0, k).trim();
                if (k >= localNames[i].length() - 1) {
                    throw new IllegalArgumentException("Missing localName for prefix: prefix='" + prefix + "', path='" + path + "', prefixes=" + prefixMap);
                }
                fixedPath = String.valueOf(fixedPath) + prefix + ":";
            }
            localNames[i] = localNames[i].substring(k + 1).trim();
            if (!localNames[i].equals("*") && !Name11Checker.getInstance().isValidNCName((CharSequence)localNames[i])) {
                throw new IllegalArgumentException(String.valueOf(localNames[i]) + " is not a valid local name.");
            }
            fixedPath = String.valueOf(fixedPath) + localNames[i];
            ++i;
        }
        return fixedPath;
    }
}

