/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import org.teiid.designer.query.sql.lang.ISubqueryCompareCriteria;
import org.teiid.query.parser.LanguageVisitor;
import org.teiid.query.parser.TeiidNodeFactory;
import org.teiid.query.parser.TeiidParser;
import org.teiid.query.sql.lang.AbstractCompareCriteria;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ScalarSubquery;

public class SubqueryCompareCriteria
extends AbstractCompareCriteria
implements SubqueryContainer<QueryCommand>,
ISubqueryCompareCriteria<LanguageVisitor, QueryCommand> {
    private PredicateQuantifier predicateQuantifier = PredicateQuantifier.ALL;
    private QueryCommand command;

    public SubqueryCompareCriteria(TeiidParser p, int id) {
        super(p, id);
    }

    public PredicateQuantifier getPredicateQuantifier() {
        return this.predicateQuantifier;
    }

    public String getPredicateQuantifierAsString() {
        return String.valueOf(this.predicateQuantifier.name()) + " ";
    }

    public void setPredicateQuantifier(PredicateQuantifier predicateQuantifier) {
        this.predicateQuantifier = predicateQuantifier;
    }

    @Override
    public QueryCommand getCommand() {
        return this.command;
    }

    @Override
    public void setCommand(QueryCommand command) {
        this.command = command;
    }

    @Override
    public Expression getRightExpression() {
        ScalarSubquery scalarSubquery = (ScalarSubquery)this.parser.createASTNode(TeiidNodeFactory.ASTNodes.SCALAR_SUBQUERY);
        scalarSubquery.setCommand(this.getCommand());
        return scalarSubquery;
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.command == null ? 0 : this.command.hashCode());
        result = 31 * result + (this.predicateQuantifier == null ? 0 : this.predicateQuantifier.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubqueryCompareCriteria other = (SubqueryCompareCriteria)obj;
        if (this.command == null ? other.command != null : !this.command.equals(other.command)) {
            return false;
        }
        return this.predicateQuantifier == other.predicateQuantifier;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public SubqueryCompareCriteria clone() {
        SubqueryCompareCriteria clone = new SubqueryCompareCriteria(this.parser, this.id);
        if (this.getCommand() != null) {
            clone.setCommand(this.getCommand().clone());
        }
        if (this.getPredicateQuantifier() != null) {
            clone.setPredicateQuantifier(this.getPredicateQuantifier());
        }
        if (this.operator != null) {
            clone.setOperator(this.operator);
        }
        if (this.getLeftExpression() != null) {
            clone.setLeftExpression(this.getLeftExpression().clone());
        }
        return clone;
    }

    public static enum PredicateQuantifier {
        SOME,
        ANY,
        ALL;


        public int getQuantifier() {
            return this.ordinal() + 2;
        }

        public static PredicateQuantifier findQuantifier(int quantifier) {
            PredicateQuantifier[] predicateQuantifierArray = PredicateQuantifier.values();
            int n = predicateQuantifierArray.length;
            int n2 = 0;
            while (n2 < n) {
                PredicateQuantifier pq = predicateQuantifierArray[n2];
                if (pq.getQuantifier() == quantifier) {
                    return pq;
                }
                ++n2;
            }
            throw new IllegalStateException();
        }
    }
}

