/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.Map;
import java.util.TreeMap;
import org.teiid.designer.query.sql.lang.ISourceHint;

public class SourceHint
implements ISourceHint {
    private boolean useAliases;
    private String generalHint;
    private Map<String, SpecificHint> sourceHints;

    public String getGeneralHint() {
        return this.generalHint;
    }

    public void setGeneralHint(String generalHint) {
        this.generalHint = generalHint;
    }

    public void setSourceHint(String translatorName, String hint, boolean useAliases) {
        if (this.sourceHints == null) {
            this.sourceHints = new TreeMap<String, SpecificHint>(String.CASE_INSENSITIVE_ORDER);
        }
        this.sourceHints.put(translatorName, new SpecificHint(hint, useAliases));
    }

    public SpecificHint getSpecificHint(String sourceName) {
        if (this.sourceHints == null) {
            return null;
        }
        return this.sourceHints.get(sourceName);
    }

    public String getSourceHint(String sourceName) {
        SpecificHint sp = this.getSpecificHint(sourceName);
        if (sp != null) {
            return sp.getHint();
        }
        return null;
    }

    public Map<String, SpecificHint> getSpecificHints() {
        return this.sourceHints;
    }

    public boolean isUseAliases() {
        return this.useAliases;
    }

    public void setUseAliases(boolean useAliases) {
        this.useAliases = useAliases;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.generalHint == null ? 0 : this.generalHint.hashCode());
        result = 31 * result + (this.sourceHints == null ? 0 : this.sourceHints.hashCode());
        result = 31 * result + (this.useAliases ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SourceHint other = (SourceHint)obj;
        if (this.generalHint == null ? other.generalHint != null : !this.generalHint.equals(other.generalHint)) {
            return false;
        }
        if (this.sourceHints == null ? other.sourceHints != null : !this.sourceHints.equals(other.sourceHints)) {
            return false;
        }
        return this.useAliases == other.useAliases;
    }

    public static class SpecificHint {
        String hint;
        boolean useAliases;

        public SpecificHint(String hint, boolean useAliases) {
            this.hint = hint;
            this.useAliases = useAliases;
        }

        public String getHint() {
            return this.hint;
        }

        public boolean isUseAliases() {
            return this.useAliases;
        }
    }
}

