/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.api.exception.query.QueryValidatorException;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.designer.query.IQueryResolver;
import org.teiid.designer.query.metadata.IQueryMetadataInterface;
import org.teiid.designer.query.metadata.IQueryNode;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.parser.TeiidNodeFactory;
import org.teiid.query.parser.TeiidParser;
import org.teiid.query.resolver.CommandResolver;
import org.teiid.query.resolver.ProcedureContainerResolver;
import org.teiid.query.resolver.VariableResolver;
import org.teiid.query.resolver.command.AlterResolver;
import org.teiid.query.resolver.command.DeleteResolver;
import org.teiid.query.resolver.command.DynamicCommandResolver;
import org.teiid.query.resolver.command.ExecResolver;
import org.teiid.query.resolver.command.InsertResolver;
import org.teiid.query.resolver.command.SetQueryResolver;
import org.teiid.query.resolver.command.SimpleQueryResolver;
import org.teiid.query.resolver.command.TempTableResolver;
import org.teiid.query.resolver.command.UpdateProcedureResolver;
import org.teiid.query.resolver.command.UpdateResolver;
import org.teiid.query.resolver.command.XMLQueryResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.resolver.util.ResolverVisitor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.DynamicCommand;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.FromClause;
import org.teiid.query.sql.lang.GroupContext;
import org.teiid.query.sql.lang.ProcedureContainer;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.navigator.DeepPostOrderNavigator;
import org.teiid.query.sql.proc.CreateUpdateProcedureCommand;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.symbol.Symbol;
import org.teiid.query.sql.visitor.ExpressionMappingVisitor;
import org.teiid.query.sql.visitor.ValueIteratorProviderCollectorVisitor;
import org.teiid.query.validator.AbstractValidationVisitor;
import org.teiid.query.validator.UpdateValidator;
import org.teiid.query.validator.ValidationVisitor;
import org.teiid.query.validator.Validator;
import org.teiid.query.validator.ValidatorFailure;
import org.teiid.query.validator.ValidatorReport;
import org.teiid.runtime.client.Messages;
import org.teiid.runtime.client.TeiidClientException;

public class QueryResolver
implements IQueryResolver<Command, GroupSymbol, Expression> {
    private final String BINDING_GROUP = "INPUTS";
    private final CommandResolver simpleQueryResolver;
    private final CommandResolver setQueryResolver;
    private final CommandResolver xmlQueryResolver;
    private final ProcedureContainerResolver execResolver;
    private final ProcedureContainerResolver insertResolver;
    private final ProcedureContainerResolver updateResolver;
    private final ProcedureContainerResolver deleteResolver;
    private final CommandResolver updateProcedureResolver;
    private final CommandResolver dynamicCommandResolver;
    private final CommandResolver tempTableResolver;
    private final CommandResolver alterResolver;
    private final QueryParser parser;

    public QueryResolver(QueryParser parser) {
        this.parser = parser;
        this.simpleQueryResolver = new SimpleQueryResolver(this);
        this.setQueryResolver = new SetQueryResolver(this);
        this.xmlQueryResolver = new XMLQueryResolver(this);
        this.execResolver = new ExecResolver(this);
        this.insertResolver = new InsertResolver(this);
        this.updateResolver = new UpdateResolver(this);
        this.deleteResolver = new DeleteResolver(this);
        this.updateProcedureResolver = new UpdateProcedureResolver(this);
        this.dynamicCommandResolver = new DynamicCommandResolver(this);
        this.tempTableResolver = new TempTableResolver(this);
        this.alterResolver = new AlterResolver(this);
    }

    public QueryResolver(ITeiidServerVersion teiidVersion) {
        this(new QueryParser(teiidVersion));
    }

    public QueryParser getQueryParser() {
        return this.parser;
    }

    public TeiidParser getTeiidParser() {
        return this.parser.getTeiidParser();
    }

    public ITeiidServerVersion getTeiidVersion() {
        return this.getTeiidParser().getVersion();
    }

    protected boolean isTeiidVersionOrGreater(TeiidServerVersion.Version teiidVersion) {
        ITeiidServerVersion minVersion = this.getTeiidVersion().getMinimumVersion();
        return minVersion.equals(teiidVersion.get()) || minVersion.isGreaterThan(teiidVersion.get());
    }

    protected boolean isTeiid8OrGreater() {
        return this.isTeiidVersionOrGreater(TeiidServerVersion.Version.TEIID_8_0);
    }

    protected boolean isTeiid87OrGreater() {
        return this.isTeiidVersionOrGreater(TeiidServerVersion.Version.TEIID_8_7);
    }

    public Command expandCommand(ProcedureContainer proc, IQueryMetadataInterface metadata) throws Exception {
        ProcedureContainerResolver cr = (ProcedureContainerResolver)this.chooseResolver(proc, metadata);
        Command command = cr.expandCommand(proc, metadata);
        if (command == null) {
            return null;
        }
        if (command instanceof CreateUpdateProcedureCommand) {
            CreateUpdateProcedureCommand cupCommand = (CreateUpdateProcedureCommand)command;
            cupCommand.setUserCommand(proc);
            if (!cupCommand.isUpdateProcedure()) {
                cupCommand.setProjectedSymbols(proc.getProjectedSymbols());
            }
        }
        this.resolveCommand(command, proc.getGroup(), proc.getType(), metadata.getDesignTimeMetadata(), false);
        return command;
    }

    public TempMetadataStore resolveCommand(Command command, IQueryMetadataInterface metadata) throws Exception {
        return this.resolveCommand(command, metadata, true);
    }

    public TempMetadataStore resolveCommand(Command currentCommand, GroupSymbol container, int type, IQueryMetadataInterface metadata, boolean inferProcedureResultSetColumns) throws Exception {
        ResolverUtil.resolveGroup(container, metadata);
        switch (type) {
            case 1: {
                ResolverUtil.resolveGroup(container, metadata);
                IQueryNode queryNode = metadata.getVirtualPlan(container.getMetadataID());
                return this.resolveWithBindingMetadata(currentCommand, metadata, queryNode, false);
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                ProcedureContainerResolver.findChildCommandMetadata(this, currentCommand, container, type, metadata, inferProcedureResultSetColumns);
            }
        }
        return this.resolveCommand(currentCommand, metadata, false);
    }

    public void resolveCommand(Command command, GroupSymbol gSymbol, int teiidCommandType, IQueryMetadataInterface metadata) throws Exception {
        this.resolveCommand(command, gSymbol, teiidCommandType, metadata, true);
    }

    public void postResolveCommand(Command command, GroupSymbol gSymbol, int commandType, IQueryMetadataInterface metadata, List<Expression> projectedSymbols) {
        DynamicCommand dynamicCommand;
        CreateUpdateProcedureCommand updateCommand;
        if (command instanceof CreateUpdateProcedureCommand && (updateCommand = (CreateUpdateProcedureCommand)command).getResultsCommand() instanceof DynamicCommand && (dynamicCommand = (DynamicCommand)updateCommand.getResultsCommand()).isAsClauseSet()) {
            updateCommand.setProjectedSymbols(projectedSymbols);
        }
    }

    public TempMetadataStore resolveWithBindingMetadata(Command currentCommand, IQueryMetadataInterface metadata, IQueryNode queryNode, boolean replaceBindings) throws Exception {
        HashMap<ElementSymbol, ElementSymbol> symbolMap = null;
        TeiidParser teiidParser = this.parser.getTeiidParser();
        if (queryNode.getBindings() != null && queryNode.getBindings().size() > 0) {
            symbolMap = new HashMap<ElementSymbol, ElementSymbol>();
            final ArrayList<ElementSymbol> elements = new ArrayList<ElementSymbol>(queryNode.getBindings().size());
            boolean positional = true;
            for (Expression ses : this.parseBindings(queryNode)) {
                String name = Symbol.getShortName(ses);
                if (ses instanceof AliasSymbol) {
                    ses = ((AliasSymbol)ses).getSymbol();
                    positional = false;
                }
                ElementSymbol elementSymbol = (ElementSymbol)ses;
                ResolverVisitor visitor = new ResolverVisitor(this.getTeiidVersion());
                visitor.resolveLanguageObject(elementSymbol, metadata);
                elementSymbol.setIsExternalReference(true);
                if (!positional) {
                    if (this.isTeiid87OrGreater()) {
                        ElementSymbol inputSymbol = (ElementSymbol)teiidParser.createASTNode(TeiidNodeFactory.ASTNodes.ELEMENT_SYMBOL);
                        inputSymbol.setName("INPUT." + name);
                        inputSymbol.setType(elementSymbol.getType());
                        symbolMap.put(inputSymbol, elementSymbol.clone());
                    }
                    ElementSymbol keySymbol = (ElementSymbol)teiidParser.createASTNode(TeiidNodeFactory.ASTNodes.ELEMENT_SYMBOL);
                    keySymbol.setName("INPUTS." + name);
                    symbolMap.put(keySymbol, elementSymbol.clone());
                    elementSymbol.setShortName(name);
                }
                elements.add(elementSymbol);
            }
            if (positional) {
                ExpressionMappingVisitor emv = new ExpressionMappingVisitor(this.getTeiidVersion(), null){

                    @Override
                    public Expression replaceExpression(Expression element) {
                        if (!(element instanceof Reference)) {
                            return element;
                        }
                        Reference ref = (Reference)element;
                        if (!ref.isPositional()) {
                            return ref;
                        }
                        return ((ElementSymbol)elements.get(ref.getIndex())).clone();
                    }
                };
                DeepPostOrderNavigator.doVisit(currentCommand, emv);
            } else {
                TempMetadataStore rootExternalStore = new TempMetadataStore();
                GroupContext externalGroups = new GroupContext();
                ProcedureContainerResolver.addScalarGroup(this.parser.getTeiidParser(), "INPUT", rootExternalStore, externalGroups, elements);
                ProcedureContainerResolver.addScalarGroup(this.parser.getTeiidParser(), "INPUTS", rootExternalStore, externalGroups, elements);
                this.setChildMetadata(currentCommand, rootExternalStore, externalGroups);
            }
        }
        TempMetadataStore result = this.resolveCommand(currentCommand, metadata, false);
        if (replaceBindings && symbolMap != null && !symbolMap.isEmpty()) {
            ExpressionMappingVisitor emv = new ExpressionMappingVisitor(this.getTeiidVersion(), symbolMap);
            DeepPostOrderNavigator.doVisit(currentCommand, emv);
        }
        return result;
    }

    public List<Expression> parseBindings(IQueryNode planNode) throws Exception {
        List bindingsCol = planNode.getBindings();
        if (bindingsCol == null) {
            return Collections.emptyList();
        }
        ArrayList<Expression> parsedBindings = new ArrayList<Expression>(bindingsCol.size());
        Iterator bindings = bindingsCol.iterator();
        while (bindings.hasNext()) {
            try {
                Expression binding = this.parser.parseSelectExpression((String)bindings.next());
                parsedBindings.add(binding);
            }
            catch (Exception err) {
                throw new TeiidClientException(err, Messages.getString(Messages.TEIID.TEIID30063, new Object[0]));
            }
        }
        return parsedBindings;
    }

    public TempMetadataStore resolveCommand(Command currentCommand, IQueryMetadataInterface metadata, boolean resolveNullLiterals) throws Exception {
        TempMetadataAdapter resolverMetadata = null;
        try {
            TempMetadataStore discoveredMetadata = currentCommand.getTemporaryMetadata();
            if (discoveredMetadata == null) {
                discoveredMetadata = new TempMetadataStore();
                currentCommand.setTemporaryMetadata(discoveredMetadata);
            }
            resolverMetadata = new TempMetadataAdapter(metadata, discoveredMetadata);
            List<GroupSymbol> externalGroups = currentCommand.getAllExternalGroups();
            for (GroupSymbol extGroup : externalGroups) {
                Object metadataID = extGroup.getMetadataID();
                if (metadataID != null && (extGroup.getMetadataID() instanceof TempMetadataID || discoveredMetadata.getTempGroupID(extGroup.getName()) == null)) continue;
                metadataID = resolverMetadata.getGroupID(extGroup.getName());
                extGroup.setMetadataID(metadataID);
            }
            CommandResolver resolver = this.chooseResolver(currentCommand, resolverMetadata);
            resolver.resolveCommand(currentCommand, resolverMetadata, resolveNullLiterals);
        }
        catch (Exception e) {
            throw new QueryResolverException(e);
        }
        currentCommand.setIsResolved(true);
        return resolverMetadata.getMetadataStore();
    }

    private CommandResolver chooseResolver(Command command, IQueryMetadataInterface metadata) throws Exception {
        switch (command.getType()) {
            case 1: {
                if (command instanceof Query) {
                    if (this.isXMLQuery((Query)command, metadata)) {
                        return this.xmlQueryResolver;
                    }
                    return this.simpleQueryResolver;
                }
                return this.setQueryResolver;
            }
            case 2: {
                return this.insertResolver;
            }
            case 3: {
                return this.updateResolver;
            }
            case 4: {
                return this.deleteResolver;
            }
            case 6: {
                return this.execResolver;
            }
            case 13: {
                return this.updateProcedureResolver;
            }
            case 7: {
                return this.updateProcedureResolver;
            }
            case 10: {
                return this.dynamicCommandResolver;
            }
            case 11: {
                return this.tempTableResolver;
            }
            case 12: {
                return this.tempTableResolver;
            }
            case 14: 
            case 15: 
            case 16: {
                return this.alterResolver;
            }
        }
        throw new AssertionError((Object)"Unknown command type");
    }

    public boolean isXMLQuery(Query query, IQueryMetadataInterface metadata) throws Exception {
        if (query.getWith() != null) {
            return false;
        }
        From from = query.getFrom();
        if (from == null) {
            return false;
        }
        if (from.getClauses().size() != 1) {
            return false;
        }
        FromClause clause = from.getClauses().get(0);
        if (!(clause instanceof UnaryFromClause)) {
            return false;
        }
        GroupSymbol symbol = ((UnaryFromClause)clause).getGroup();
        ResolverUtil.resolveGroup(symbol, metadata);
        if (symbol.isProcedure()) {
            return false;
        }
        Object groupID = ((UnaryFromClause)clause).getGroup().getMetadataID();
        return metadata.isXMLGroup(groupID);
    }

    public void resolveCriteria(Criteria criteria, IQueryMetadataInterface metadata) throws Exception {
        ResolverVisitor visitor = new ResolverVisitor(this.getTeiidVersion());
        visitor.resolveLanguageObject(criteria, metadata);
    }

    public void setChildMetadata(Command subCommand, Command parent) {
        TempMetadataStore childMetadata = parent.getTemporaryMetadata();
        GroupContext parentContext = parent.getExternalGroupContexts();
        this.setChildMetadata(subCommand, childMetadata, parentContext);
    }

    public void setChildMetadata(Command subCommand, TempMetadataStore parentTempMetadata, GroupContext parentContext) {
        TempMetadataStore tempMetadata = subCommand.getTemporaryMetadata();
        if (tempMetadata == null) {
            subCommand.setTemporaryMetadata(parentTempMetadata.clone());
        } else {
            tempMetadata.getData().putAll(parentTempMetadata.getData());
        }
        subCommand.setExternalGroupContexts(parentContext);
    }

    public Map<ElementSymbol, Expression> getVariableValues(Command command, boolean changingOnly, IQueryMetadataInterface metadata) throws Exception {
        CommandResolver resolver = this.chooseResolver(command, metadata);
        if (resolver instanceof VariableResolver) {
            return ((VariableResolver)((Object)resolver)).getVariableValues(command, changingOnly, metadata);
        }
        return Collections.emptyMap();
    }

    public void resolveSubqueries(Command command, TempMetadataAdapter metadata, Collection<GroupSymbol> externalGroups) throws Exception {
        for (SubqueryContainer container : ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(command)) {
            this.setChildMetadata((Command)container.getCommand(), command);
            if (externalGroups != null) {
                ((Command)container.getCommand()).pushNewResolvingContext(externalGroups);
            }
            this.resolveCommand((Command)container.getCommand(), metadata.getMetadata(), false);
        }
    }

    public static void validateWithVisitor(AbstractValidationVisitor visitor, IQueryMetadataInterface metadata, Command command) throws Exception {
        ValidatorReport report = Validator.validate(command, metadata, visitor);
        if (report.hasItems()) {
            ValidatorFailure firstFailure = report.getItems().iterator().next();
            throw new TeiidClientException(firstFailure.getMessage());
        }
    }

    public QueryNode resolveView(GroupSymbol virtualGroup, IQueryNode qnode, String cacheString, IQueryMetadataInterface qmi) throws Exception {
        qmi = qmi.getDesignTimeMetadata();
        cacheString = "transformation/" + cacheString;
        QueryNode cachedNode = (QueryNode)qmi.getFromMetadataCache(virtualGroup.getMetadataID(), cacheString);
        if (cachedNode == null) {
            Command result = (Command)qnode.getCommand();
            List bindings = null;
            if (result == null) {
                try {
                    result = this.getQueryParser().parseCommand(qnode.getQuery());
                }
                catch (Exception exception) {
                    throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID30065, virtualGroup));
                }
                bindings = qnode.getBindings();
            } else {
                result = result.clone();
            }
            if (bindings != null && !bindings.isEmpty()) {
                this.resolveWithBindingMetadata(result, qmi, qnode, true);
            } else {
                this.resolveCommand(result, qmi, false);
            }
            QueryResolver.validateWithVisitor(new ValidationVisitor(this.getTeiidVersion()), qmi, result);
            this.validateProjectedSymbols(virtualGroup, qmi, result);
            cachedNode = new QueryNode(qnode.getQuery());
            cachedNode.setCommand(result);
            if (this.isView(virtualGroup, qmi)) {
                String updatePlan = qmi.getUpdatePlan(virtualGroup.getMetadataID());
                String deletePlan = qmi.getDeletePlan(virtualGroup.getMetadataID());
                String insertPlan = qmi.getInsertPlan(virtualGroup.getMetadataID());
                if (virtualGroup.getDefinition() != null) {
                    GroupSymbol group = (GroupSymbol)this.getTeiidParser().createASTNode(TeiidNodeFactory.ASTNodes.GROUP_SYMBOL);
                    group.setName(virtualGroup.getNonCorrelationName());
                    group.setMetadataID(virtualGroup.getMetadataID());
                    virtualGroup = group;
                }
                List<ElementSymbol> elements = ResolverUtil.resolveElementsInGroup(virtualGroup, qmi);
                UpdateValidator validator = new UpdateValidator(qmi, this.determineType(insertPlan), this.determineType(updatePlan), this.determineType(deletePlan));
                validator.validate(result, elements);
                UpdateValidator.UpdateInfo info = validator.getUpdateInfo();
                cachedNode.setUpdateInfo(info);
            }
            qmi.addToMetadataCache(virtualGroup.getMetadataID(), cacheString, (Object)cachedNode);
        }
        return cachedNode;
    }

    public void validateProjectedSymbols(GroupSymbol virtualGroup, IQueryMetadataInterface qmi, Command result) throws QueryValidatorException, Exception {
        List<ElementSymbol> symbols = ResolverUtil.resolveElementsInGroup(virtualGroup, qmi);
        List projectedSymbols = result.getProjectedSymbols();
        this.validateProjectedSymbols(virtualGroup, symbols, projectedSymbols);
    }

    public void validateProjectedSymbols(GroupSymbol virtualGroup, List<? extends Expression> symbols, List<? extends Expression> projectedSymbols) throws QueryValidatorException {
        if (symbols.size() != projectedSymbols.size()) {
            throw new QueryValidatorException(Messages.gs(Messages.TEIID.TEIID30066, virtualGroup, symbols.size(), projectedSymbols.size()));
        }
        DataTypeManagerService dataTypeManager = DataTypeManagerService.getInstance(this.getTeiidVersion());
        int i = 0;
        while (i < projectedSymbols.size()) {
            Expression projectedSymbol = projectedSymbols.get(i);
            ResolverUtil.setTypeIfNull(projectedSymbol, symbols.get(i).getType());
            if (projectedSymbol.getType() != symbols.get(i).getType()) {
                String symbolTypeName = dataTypeManager.getDataTypeName(symbols.get(i).getType());
                String projSymbolTypeName = dataTypeManager.getDataTypeName(projectedSymbol.getType());
                throw new QueryValidatorException(Messages.getString(Messages.QueryResolver.wrong_view_symbol_type, virtualGroup, i + 1, symbolTypeName, projSymbolTypeName));
            }
            ++i;
        }
    }

    public boolean isView(GroupSymbol virtualGroup, IQueryMetadataInterface qmi) throws Exception {
        return !(virtualGroup.getMetadataID() instanceof TempMetadataID) && qmi.isVirtualGroup(virtualGroup.getMetadataID());
    }

    private UpdateValidator.UpdateType determineType(String plan) {
        UpdateValidator.UpdateType type = UpdateValidator.UpdateType.INHERENT;
        if (plan != null) {
            type = UpdateValidator.UpdateType.INSTEAD_OF;
        }
        return type;
    }
}

