/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.parser;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import org.teiid.designer.annotation.Removed;
import org.teiid.designer.annotation.Since;
import org.teiid.designer.query.IQueryParser;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.MetadataFactory;
import org.teiid.query.parser.AbstractTeiidParser;
import org.teiid.query.parser.ParseInfo;
import org.teiid.query.parser.TeiidParser;
import org.teiid.query.parser.v7.Teiid7Parser;
import org.teiid.query.parser.v8.Teiid8Parser;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.LeadingComment;
import org.teiid.query.sql.lang.TrailingComment;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.runtime.client.Messages;
import org.teiid.runtime.client.TeiidClientException;

public class QueryParser
implements IQueryParser {
    private TeiidParser teiidParser;
    private final ITeiidServerVersion teiidVersion;

    public QueryParser(ITeiidServerVersion teiidVersion) {
        this.teiidVersion = teiidVersion;
        this.teiidParser = this.createTeiidParser(new StringReader(""));
    }

    private TeiidParser createTeiidParser(Reader sql) {
        if (sql == null) {
            throw new IllegalArgumentException(Messages.gs(Messages.TEIID.TEIID30377, new Object[0]));
        }
        int major = Integer.parseInt(this.teiidVersion.getMajor());
        AbstractTeiidParser teiidParser = null;
        switch (major) {
            case 7: {
                teiidParser = new Teiid7Parser(sql);
                teiidParser.setVersion(this.teiidVersion);
                break;
            }
            case 8: {
                teiidParser = new Teiid8Parser(sql);
                teiidParser.setVersion(this.teiidVersion);
                break;
            }
            default: {
                throw new IllegalStateException(Messages.getString(Messages.TeiidParser.noParserForVersion, major));
            }
        }
        return teiidParser;
    }

    public TeiidParser getTeiidParser() {
        return this.teiidParser;
    }

    public TeiidParser getTeiidParser(String sql) {
        return this.getSqlParser(new StringReader(sql));
    }

    private TeiidParser getSqlParser(Reader sql) {
        if (this.teiidParser == null) {
            this.teiidParser = this.createTeiidParser(sql);
        } else {
            this.teiidParser.ReInit(sql);
        }
        return this.teiidParser;
    }

    @Deprecated
    @Removed(value=TeiidServerVersion.Version.TEIID_8_0)
    private Command parseUpdateProcedure(String sql) throws Exception {
        try {
            TeiidParser teiidParser = this.getTeiidParser(sql);
            if (!(teiidParser instanceof Teiid7Parser)) {
                throw new IllegalStateException();
            }
            Command result = ((Teiid7Parser)teiidParser).updateProcedure(new ParseInfo());
            return result;
        }
        catch (Exception pe) {
            throw this.convertParserException(pe);
        }
    }

    @Since(value=TeiidServerVersion.Version.TEIID_8_0)
    public Command parseProcedure(String sql, boolean update) throws Exception {
        try {
            if (this.teiidVersion.isLessThan(TeiidServerVersion.Version.TEIID_8_0.get())) {
                return this.parseUpdateProcedure(sql);
            }
            if (update) {
                return this.getTeiidParser(sql).forEachRowTriggerAction(new ParseInfo());
            }
            Command result = this.getTeiidParser(sql).procedureBodyCommand(new ParseInfo());
            return result;
        }
        catch (Exception pe) {
            throw this.convertParserException(pe);
        }
    }

    public Command parseCommand(String sql) throws Exception {
        return this.parseCommand(sql, new ParseInfo(), false);
    }

    public Command parseCommand(String sql, ParseInfo parseInfo) throws Exception {
        return this.parseCommand(sql, parseInfo, false);
    }

    public Command parseDesignerCommand(String sql) throws Exception {
        return this.parseCommand(sql, new ParseInfo(), true);
    }

    private Command parseCommand(String sql, ParseInfo parseInfo, boolean designerCommands) throws Exception {
        if (sql == null || sql.length() == 0) {
            throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID30377, new Object[0]));
        }
        Command result = null;
        try {
            result = designerCommands ? this.getTeiidParser(sql).designerCommand(parseInfo) : this.getTeiidParser(sql).command(parseInfo);
            String noCommentSql = sql;
            LeadingComment leadingComment = this.getTeiidParser(sql).getLeadingComment(sql);
            TrailingComment trailingComment = this.getTeiidParser(sql).getTrailingComment(noCommentSql);
            if (leadingComment != null) {
                noCommentSql = this.getTeiidParser(sql).removeComments(sql, leadingComment, trailingComment);
            }
            result.setLeadingComment(leadingComment);
            result.setTrailingComment(trailingComment);
            result.setCacheHint(this.getTeiidParser(sql).getQueryCacheOption(noCommentSql));
        }
        catch (Exception e) {
            throw this.convertParserException(e);
        }
        return result;
    }

    private TeiidClientException convertParserException(Exception e) {
        TeiidClientException qpe = new TeiidClientException(e, Messages.getString(Messages.TeiidParser.lexicalError, e.getMessage()));
        return qpe;
    }

    public Criteria parseCriteria(String sql) throws Exception {
        if (sql == null) {
            throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID30377, new Object[0]));
        }
        ParseInfo dummyInfo = new ParseInfo();
        Criteria result = null;
        try {
            result = this.getTeiidParser(sql).criteria(dummyInfo);
        }
        catch (Exception e) {
            throw this.convertParserException(e);
        }
        return result;
    }

    public Expression parseExpression(String sql) throws Exception {
        if (sql == null) {
            throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID30377, new Object[0]));
        }
        ParseInfo dummyInfo = new ParseInfo();
        Expression result = null;
        try {
            result = this.getTeiidParser(sql).expression(dummyInfo);
        }
        catch (Exception e) {
            throw this.convertParserException(e);
        }
        return result;
    }

    public Expression parseSelectExpression(String sql) throws Exception {
        if (sql == null) {
            throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID30377, new Object[0]));
        }
        ParseInfo dummyInfo = new ParseInfo();
        Expression result = null;
        try {
            result = this.getTeiidParser(sql).selectExpression(dummyInfo);
        }
        catch (Exception e) {
            throw this.convertParserException(e);
        }
        return result;
    }

    public void parseDDL(MetadataFactory factory, String ddl) {
        this.parseDDL(factory, new StringReader(ddl));
    }

    public void parseDDL(MetadataFactory factory, Reader ddl) {
        try {
            this.getSqlParser(ddl).parseMetadata(factory);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        HashSet<FunctionMethod> functions = new HashSet<FunctionMethod>();
        for (FunctionMethod functionMethod : factory.getSchema().getFunctions().values()) {
            if (functions.add(functionMethod)) continue;
            throw new RuntimeException(Messages.gs(Messages.TEIID.TEIID60015, functionMethod.getName()));
        }
    }
}

