/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.mapping.xml;

import org.teiid.designer.annotation.Removed;
import org.teiid.designer.annotation.Since;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.designer.xml.IMappingAttribute;
import org.teiid.query.mapping.xml.MappingBaseNode;
import org.teiid.query.mapping.xml.MappingElement;
import org.teiid.query.mapping.xml.MappingNode;
import org.teiid.query.mapping.xml.MappingNodeConstants;
import org.teiid.query.mapping.xml.MappingSourceNode;
import org.teiid.query.mapping.xml.MappingVisitor;
import org.teiid.query.mapping.xml.Namespace;
import org.teiid.query.parser.TeiidParser;
import org.teiid.query.sql.symbol.ElementSymbol;

public class MappingAttribute
extends MappingNode
implements IMappingAttribute {
    ElementSymbol symbol;
    Namespace namespace;

    public MappingAttribute(TeiidParser teiidParser, String name) {
        this(teiidParser, name, MappingNodeConstants.NO_NAMESPACE);
    }

    public MappingAttribute(TeiidParser teiidParser, String name, String nameInSource) {
        this(teiidParser, name, MappingNodeConstants.NO_NAMESPACE);
        this.setNameInSource(nameInSource);
    }

    public MappingAttribute(TeiidParser teiidParser, String name, Namespace namespace) {
        super(teiidParser);
        this.setProperty(MappingNodeConstants.Properties.NAME, name);
        this.setProperty(MappingNodeConstants.Properties.NODE_TYPE, "attribute");
        this.namespace = namespace;
        if (namespace != MappingNodeConstants.NO_NAMESPACE) {
            this.setProperty(MappingNodeConstants.Properties.NAMESPACE_PREFIX, namespace.getPrefix());
        }
    }

    @Override
    public void acceptVisitor(MappingVisitor visitor) {
        visitor.visit(this);
    }

    public MappingElement getParentNode() {
        return (MappingElement)this.getParent();
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public void setNameInSource(String srcName) {
        if (srcName != null) {
            this.setProperty(MappingNodeConstants.Properties.ELEMENT_NAME, srcName);
        }
    }

    public void setDefaultValue(String value) {
        if (value != null) {
            this.setProperty(MappingNodeConstants.Properties.DEFAULT_VALUE, value);
        }
    }

    public void setValue(String value) {
        if (value != null) {
            this.setProperty(MappingNodeConstants.Properties.FIXED_VALUE, value);
        }
    }

    public void setOptional(boolean optional) {
        this.setProperty(MappingNodeConstants.Properties.IS_OPTIONAL, optional);
    }

    public void setNormalizeText(String normalize) {
        if (normalize != null) {
            this.setProperty(MappingNodeConstants.Properties.NORMALIZE_TEXT, normalize);
        }
    }

    public void setAlwaysInclude(boolean include) {
        this.setProperty(MappingNodeConstants.Properties.ALWAYS_INCLUDE, include);
    }

    @Override
    public String getPathName() {
        return "@" + super.getPathName();
    }

    @Removed(value=TeiidServerVersion.Version.TEIID_8_0)
    public String getCanonicalName() {
        return this.getFullyQualifiedName().toUpperCase();
    }

    public String getNamespacePrefix() {
        return (String)this.getProperty(MappingNodeConstants.Properties.NAMESPACE_PREFIX);
    }

    @Override
    public String getNameInSource() {
        return (String)this.getProperty(MappingNodeConstants.Properties.ELEMENT_NAME);
    }

    public String getDefaultValue() {
        return (String)this.getProperty(MappingNodeConstants.Properties.DEFAULT_VALUE);
    }

    public String getValue() {
        return (String)this.getProperty(MappingNodeConstants.Properties.FIXED_VALUE);
    }

    public boolean isOptional() {
        Boolean optional = (Boolean)this.getProperty(MappingNodeConstants.Properties.IS_OPTIONAL);
        if (optional != null) {
            return optional;
        }
        return false;
    }

    public String getNormalizeText() {
        String text = (String)this.getProperty(MappingNodeConstants.Properties.NORMALIZE_TEXT);
        if (text == null) {
            text = "preserve";
        }
        return text;
    }

    public boolean isAlwaysInclude() {
        Boolean include = (Boolean)this.getProperty(MappingNodeConstants.Properties.ALWAYS_INCLUDE);
        if (include != null) {
            return include;
        }
        return false;
    }

    public String getSource() {
        return (String)this.getProperty(MappingNodeConstants.Properties.RESULT_SET_NAME);
    }

    public void setElementSymbol(ElementSymbol symbol) {
        this.symbol = symbol;
    }

    @Override
    public ElementSymbol getElementSymbol() {
        return this.symbol;
    }

    @Override
    public MappingSourceNode getSourceNode() {
        String nameInSource = this.getNameInSource();
        if (nameInSource != null) {
            String source = nameInSource.substring(0, nameInSource.lastIndexOf(46));
            MappingBaseNode parent = this.getParentNode();
            while (parent != null) {
                MappingSourceNode sourceNode;
                if (parent instanceof MappingSourceNode && (sourceNode = (MappingSourceNode)parent).getResultName().equalsIgnoreCase(source)) {
                    return sourceNode;
                }
                parent = parent.getParentNode();
            }
        }
        return super.getSourceNode();
    }

    @Since(value=TeiidServerVersion.Version.TEIID_8_0)
    public String getType() {
        return (String)this.getProperty(MappingNodeConstants.Properties.BUILT_IN_TYPE);
    }

    @Since(value=TeiidServerVersion.Version.TEIID_8_0)
    public MappingAttribute setType(String type) {
        if (type != null) {
            this.setProperty(MappingNodeConstants.Properties.BUILT_IN_TYPE, type);
        }
        return this;
    }
}

