/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function.source;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.designer.annotation.AnnotationUtils;
import org.teiid.designer.annotation.Removed;
import org.teiid.designer.annotation.Since;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.designer.udf.IFunctionLibrary;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.FunctionParameter;
import org.teiid.metadata.MetadataFactory;
import org.teiid.query.function.FunctionMethods;
import org.teiid.query.function.JSONFunctionMethods;
import org.teiid.query.function.SystemFunctionMethods;
import org.teiid.query.function.TeiidFunction;
import org.teiid.query.function.UDFSource;
import org.teiid.query.function.metadata.FunctionCategoryConstants;
import org.teiid.query.function.source.SecuritySystemFunctions;
import org.teiid.query.function.source.XMLSystemFunctions;
import org.teiid.runtime.client.Messages;

public class SystemSource
extends UDFSource
implements FunctionCategoryConstants {
    private static final String FUNCTION_CLASS = FunctionMethods.class.getName();
    private static final String XML_FUNCTION_CLASS = XMLSystemFunctions.class.getName();
    private static final String SECURITY_FUNCTION_CLASS = SecuritySystemFunctions.class.getName();
    private final ITeiidServerVersion teiidVersion;
    private final DataTypeManagerService dataTypeManager;

    public SystemSource(ITeiidServerVersion teiidVersion, boolean allowEnvFunction, ClassLoader classLoader) {
        super(new ArrayList<FunctionMethod>(), classLoader);
        this.teiidVersion = teiidVersion;
        this.dataTypeManager = DataTypeManagerService.getInstance(teiidVersion);
        this.addArithmeticFunction("+", Messages.getString(Messages.SystemSource.Add_description, new Object[0]), "plus", Messages.getString(Messages.SystemSource.Add_result_description, new Object[0]));
        this.addArithmeticFunction("-", Messages.getString(Messages.SystemSource.Subtract_description, new Object[0]), "minus", Messages.getString(Messages.SystemSource.Subtract_result_description, new Object[0]));
        this.addArithmeticFunction("*", Messages.getString(Messages.SystemSource.Multiply_description, new Object[0]), "multiply", Messages.getString(Messages.SystemSource.Multiply_result_description, new Object[0]));
        this.addArithmeticFunction("/", Messages.getString(Messages.SystemSource.Divide_description, new Object[0]), "divide", Messages.getString(Messages.SystemSource.Divide_result_description, new Object[0]));
        this.addArithmeticFunction("mod", Messages.getString(Messages.SystemSource.Mod_description, new Object[0]), "mod", Messages.getString(Messages.SystemSource.Mod_result_description, new Object[0]));
        this.addAbsFunction();
        this.addRandFunction();
        this.addPowerFunction();
        this.addRoundFunction();
        this.addSignFunction();
        this.addSqrtFunction();
        this.addDoubleFunction("acos", Messages.getString(Messages.SystemSource.Acos_description, new Object[0]));
        this.addDoubleFunction("asin", Messages.getString(Messages.SystemSource.Asin_description, new Object[0]));
        this.addDoubleFunction("atan", Messages.getString(Messages.SystemSource.Atan_description, new Object[0]));
        this.addAtan2Function("atan2", Messages.getString(Messages.SystemSource.Atan2_description, new Object[0]));
        this.addDoubleFunction("cos", Messages.getString(Messages.SystemSource.Cos_description, new Object[0]));
        this.addDoubleFunction("cot", Messages.getString(Messages.SystemSource.Cot_description, new Object[0]));
        this.addDoubleFunction("degrees", Messages.getString(Messages.SystemSource.Degrees_description, new Object[0]));
        this.addPiFunction("pi", Messages.getString(Messages.SystemSource.Pi_description, new Object[0]));
        this.addDoubleFunction("radians", Messages.getString(Messages.SystemSource.Radians_description, new Object[0]));
        this.addDoubleFunction("sin", Messages.getString(Messages.SystemSource.Sin_description, new Object[0]));
        this.addDoubleFunction("tan", Messages.getString(Messages.SystemSource.Tan_description, new Object[0]));
        this.addDoubleFunction("log", Messages.getString(Messages.SystemSource.Log_description, new Object[0]));
        this.addDoubleFunction("log10", Messages.getString(Messages.SystemSource.Log10_description, new Object[0]));
        this.addDoubleFunction("ceiling", Messages.getString(Messages.SystemSource.Ceiling_description, new Object[0]));
        this.addDoubleFunction("exp", Messages.getString(Messages.SystemSource.Exp_description, new Object[0]));
        this.addDoubleFunction("floor", Messages.getString(Messages.SystemSource.Floor_description, new Object[0]));
        this.addBitFunction("bitand", Messages.getString(Messages.SystemSource.Bitand_description, new Object[0]), "bitand", 2, Messages.getString(Messages.SystemSource.Bitand_result_description, new Object[0]));
        this.addBitFunction("bitor", Messages.getString(Messages.SystemSource.Bitor_description, new Object[0]), "bitor", 2, Messages.getString(Messages.SystemSource.Bitor_result_description, new Object[0]));
        this.addBitFunction("bitxor", Messages.getString(Messages.SystemSource.Bitxor_description, new Object[0]), "bitxor", 2, Messages.getString(Messages.SystemSource.Bitxor_result_description, new Object[0]));
        this.addBitFunction("bitnot", Messages.getString(Messages.SystemSource.Bitnot_description, new Object[0]), "bitnot", 1, Messages.getString(Messages.SystemSource.Bitnot_result_description, new Object[0]));
        this.addConstantDateFunction("curdate", Messages.getString(Messages.SystemSource.Curdate_description, new Object[0]), "currentDate", DataTypeManagerService.DefaultDataTypes.DATE);
        this.addConstantDateFunction("curtime", Messages.getString(Messages.SystemSource.Curtime_description, new Object[0]), "currentTime", DataTypeManagerService.DefaultDataTypes.TIME);
        this.addConstantDateFunction("now", Messages.getString(Messages.SystemSource.Now_description, new Object[0]), "currentTimestamp", DataTypeManagerService.DefaultDataTypes.TIMESTAMP);
        this.addDateFunction("dayname", "dayName", Messages.getString(Messages.SystemSource.Dayname_result_d_description, new Object[0]), Messages.getString(Messages.SystemSource.Dayname_result_ts_description, new Object[0]), DataTypeManagerService.DefaultDataTypes.STRING);
        this.addDateFunction("dayofmonth", "dayOfMonth", Messages.getString(Messages.SystemSource.Dayofmonth_result_d_description, new Object[0]), Messages.getString(Messages.SystemSource.Dayofmonth_result_ts_description, new Object[0]), DataTypeManagerService.DefaultDataTypes.INTEGER);
        this.addDateFunction("dayofweek", "dayOfWeek", Messages.getString(Messages.SystemSource.Dayofweek_result_d_description, new Object[0]), Messages.getString(Messages.SystemSource.Dayofweek_result_ts_description, new Object[0]), DataTypeManagerService.DefaultDataTypes.INTEGER);
        this.addDateFunction("dayofyear", "dayOfYear", Messages.getString(Messages.SystemSource.Dayofyear_result_d_description, new Object[0]), Messages.getString(Messages.SystemSource.Dayofyear_result_ts_description, new Object[0]), DataTypeManagerService.DefaultDataTypes.INTEGER);
        this.addDateFunction("month", "month", Messages.getString(Messages.SystemSource.Month_result_d_description, new Object[0]), Messages.getString(Messages.SystemSource.Month_result_ts_description, new Object[0]), DataTypeManagerService.DefaultDataTypes.INTEGER);
        this.addDateFunction("monthname", "monthName", Messages.getString(Messages.SystemSource.Monthname_result_d_description, new Object[0]), Messages.getString(Messages.SystemSource.Monthname_result_ts_description, new Object[0]), DataTypeManagerService.DefaultDataTypes.STRING);
        this.addDateFunction("week", "week", Messages.getString(Messages.SystemSource.Week_result_d_description, new Object[0]), Messages.getString(Messages.SystemSource.Week_result_ts_description, new Object[0]), DataTypeManagerService.DefaultDataTypes.INTEGER);
        this.addDateFunction("year", "year", Messages.getString(Messages.SystemSource.Year_result_d_description, new Object[0]), Messages.getString(Messages.SystemSource.Year_result_ts_description, new Object[0]), DataTypeManagerService.DefaultDataTypes.INTEGER);
        this.addTimeFunction("hour", "hour", Messages.getString(Messages.SystemSource.Hour_result_t_description, new Object[0]), Messages.getString(Messages.SystemSource.Hour_result_ts_description, new Object[0]), DataTypeManagerService.DefaultDataTypes.INTEGER);
        this.addTimeFunction("minute", "minute", Messages.getString(Messages.SystemSource.Minute_result_t_description, new Object[0]), Messages.getString(Messages.SystemSource.Minute_result_ts_description, new Object[0]), DataTypeManagerService.DefaultDataTypes.INTEGER);
        this.addTimeFunction("second", "second", Messages.getString(Messages.SystemSource.Second_result_t_description, new Object[0]), Messages.getString(Messages.SystemSource.Second_result_ts_description, new Object[0]), DataTypeManagerService.DefaultDataTypes.INTEGER);
        this.addQuarterFunction("quarter", "quarter", Messages.getString(Messages.SystemSource.Quarter_result_d_description, new Object[0]), Messages.getString(Messages.SystemSource.Quarter_result_ts_description, new Object[0]), DataTypeManagerService.DefaultDataTypes.INTEGER);
        this.addTimestampAddFunction();
        this.addTimestampDiffFunction();
        this.addTimeZoneFunctions();
        this.addTimestampCreateFunction();
        this.addUnixTimeFunctions();
        this.addStringFunction("length", Messages.getString(Messages.SystemSource.Length_result, new Object[0]), "length", DataTypeManagerService.DefaultDataTypes.INTEGER);
        this.addStringFunction("ucase", Messages.getString(Messages.SystemSource.Ucase_result, new Object[0]), "upperCase", DataTypeManagerService.DefaultDataTypes.STRING);
        this.addStringFunction("lcase", Messages.getString(Messages.SystemSource.Lcase_result, new Object[0]), "lowerCase", DataTypeManagerService.DefaultDataTypes.STRING);
        this.addStringFunction("lower", Messages.getString(Messages.SystemSource.Lower_result, new Object[0]), "lowerCase", DataTypeManagerService.DefaultDataTypes.STRING);
        this.addStringFunction("upper", Messages.getString(Messages.SystemSource.Upper_result, new Object[0]), "upperCase", DataTypeManagerService.DefaultDataTypes.STRING);
        this.addStringFunction("ltrim", Messages.getString(Messages.SystemSource.Left_result, new Object[0]), "leftTrim", DataTypeManagerService.DefaultDataTypes.STRING);
        this.addStringFunction("rtrim", Messages.getString(Messages.SystemSource.Right_result, new Object[0]), "rightTrim", DataTypeManagerService.DefaultDataTypes.STRING);
        this.addConcatFunction();
        this.addSubstringFunction();
        this.addLeftRightFunctions();
        this.addLocateFunction();
        this.addReplaceFunction();
        this.addAsciiFunction();
        this.addCharFunction();
        this.addInitCapFunction();
        this.addLpadFunction();
        this.addRpadFunction();
        this.addTranslateFunction();
        this.addRepeatFunction();
        this.addSpaceFunction();
        this.addInsertFunction();
        this.addEndsWithFunction();
        this.addClobFunction("ucase", Messages.getString(Messages.SystemSource.UcaseClob_result, new Object[0]), "upperCase", DataTypeManagerService.DefaultDataTypes.CLOB);
        this.addClobFunction("lcase", Messages.getString(Messages.SystemSource.LcaseClob_result, new Object[0]), "lowerCase", DataTypeManagerService.DefaultDataTypes.CLOB);
        this.addClobFunction("lower", Messages.getString(Messages.SystemSource.LowerClob_result, new Object[0]), "lowerCase", DataTypeManagerService.DefaultDataTypes.CLOB);
        this.addClobFunction("upper", Messages.getString(Messages.SystemSource.UpperClob_result, new Object[0]), "upperCase", DataTypeManagerService.DefaultDataTypes.CLOB);
        this.addToCharsFunction();
        this.addToBytesFunction();
        this.addConversionFunctions();
        this.addContextFunctions();
        this.addRowLimitFunctions();
        this.addRowLimitExceptionFunctions();
        this.addDecodeFunctions();
        this.addLookupFunctions();
        this.addUserFunction();
        this.addCurrentDatabaseFunction();
        if (allowEnvFunction) {
            this.addEnvFunction();
        }
        this.addSessionIdFunction();
        this.addCommandPayloadFunctions();
        this.addIfNullFunctions();
        this.addFormatTimestampFunction();
        this.addFormatNumberFunctions();
        this.addParseTimestampFunction();
        this.addParseNumberFunctions();
        this.addXpathValueFunction();
        this.addXslTransformFunction();
        this.addXmlConcat();
        this.addXmlComment();
        this.addXmlPi();
        this.addJsonToXml();
        this.addSecurityFunctions();
        for (String type : this.dataTypeManager.getAllDataTypeNames()) {
            if (!this.dataTypeManager.isNonComparable(type)) {
                this.addTypedNullIfFunction(type);
            }
            this.addTypedCoalesceFunction(type);
        }
        this.addUnescape();
        this.addUuidFunction();
        this.addArrayGet();
        this.addArrayLength();
        this.addTrimFunction();
        this.addFunctions(JSONFunctionMethods.class);
        this.addFunctions(SystemFunctionMethods.class);
        this.addFunctions(FunctionMethods.class);
    }

    private Class<?> convertPrimitiveToObject(Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            return clazz;
        }
        if (clazz == Boolean.TYPE) {
            clazz = Boolean.class;
        } else if (clazz == Character.TYPE) {
            clazz = Character.class;
        } else if (clazz == Byte.TYPE) {
            clazz = Byte.class;
        } else if (clazz == Short.TYPE) {
            clazz = Short.class;
        } else if (clazz == Integer.TYPE) {
            clazz = Integer.class;
        } else if (clazz == Long.TYPE) {
            clazz = Long.class;
        } else if (clazz == Float.TYPE) {
            clazz = Float.class;
        } else if (clazz == Double.TYPE) {
            clazz = Double.class;
        }
        return clazz;
    }

    private void addFunctions(Class<?> clazz) {
        Method[] methods;
        if (!AnnotationUtils.isApplicable(clazz, (ITeiidServerVersion)this.teiidVersion)) {
            return;
        }
        Method[] methodArray = methods = clazz.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            TeiidFunction f = method.getAnnotation(TeiidFunction.class);
            if (f != null) {
                String name = f.name();
                if (name.isEmpty()) {
                    name = method.getName();
                }
                FunctionMethod func = MetadataFactory.createFunctionFromMethod(this.teiidVersion, name, method);
                Messages.SystemSource descKey = Messages.SystemSource.valueOf(String.valueOf(name) + "_description");
                Messages.SystemSource resultKey = Messages.SystemSource.valueOf(String.valueOf(name) + "_result");
                func.setDescription(Messages.getString(descKey, new Object[0]));
                func.setCategory(f.category());
                int i = 0;
                while (i < func.getInputParameterCount()) {
                    Messages.SystemSource paramKey = Messages.SystemSource.valueOf(String.valueOf(name) + "_param" + (i + 1));
                    func.getInputParameters().get(i).setDescription(Messages.getString(paramKey, new Object[0]));
                    ++i;
                }
                func.getOutputParameter().setDescription(Messages.getString(resultKey, new Object[0]));
                if (f.nullOnNull()) {
                    func.setNullOnNull(true);
                }
                func.setDeterminism(f.determinism());
                this.functions.add(func);
            }
            ++n2;
        }
    }

    private void addTrimFunction() {
        this.functions.add(new FunctionMethod("trim", Messages.getString(Messages.SystemSource.trim_description, new Object[0]), "String", FUNCTION_CLASS, "trim", new FunctionParameter[]{new FunctionParameter("spec", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.trim_arg1, new Object[0])), new FunctionParameter("trimChar", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.trim_arg2, new Object[0])), new FunctionParameter("string", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.trim_arg3, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.trim_result, new Object[0]))));
    }

    private void addArrayLength() {
        this.functions.add(new FunctionMethod("array_length", Messages.getString(Messages.SystemSource.array_length_description, new Object[0]), "Miscellaneous", FunctionMethod.PushDown.CAN_PUSHDOWN, FUNCTION_CLASS, "array_length", Arrays.asList(new FunctionParameter("array", DataTypeManagerService.DefaultDataTypes.OBJECT, Messages.getString(Messages.SystemSource.array_param1, new Object[0]))), new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.array_length_result, new Object[0])), true, FunctionMethod.Determinism.DETERMINISTIC));
    }

    private void addArrayGet() {
        this.functions.add(new FunctionMethod("array_get", Messages.getString(Messages.SystemSource.array_get_description, new Object[0]), "Miscellaneous", FunctionMethod.PushDown.CAN_PUSHDOWN, FUNCTION_CLASS, "array_get", Arrays.asList(new FunctionParameter("array", DataTypeManagerService.DefaultDataTypes.OBJECT, Messages.getString(Messages.SystemSource.array_param1, new Object[0])), new FunctionParameter("index", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.array_get_param2, new Object[0]))), new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.OBJECT, Messages.getString(Messages.SystemSource.array_get_result, new Object[0])), true, FunctionMethod.Determinism.DETERMINISTIC));
    }

    private void addUnescape() {
        this.functions.add(new FunctionMethod("unescape", Messages.getString(Messages.SystemSource.unescape_description, new Object[0]), "String", FunctionMethod.PushDown.CANNOT_PUSHDOWN, FUNCTION_CLASS, "unescape", Arrays.asList(new FunctionParameter("string", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.unescape_param1, new Object[0]))), new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.unescape_result, new Object[0])), true, FunctionMethod.Determinism.DETERMINISTIC));
    }

    private void addSecurityFunctions() {
        this.functions.add(new FunctionMethod("hasRole", Messages.getString(Messages.SystemSource.hasRole_description, new Object[0]), "Security", FunctionMethod.PushDown.CANNOT_PUSHDOWN, SECURITY_FUNCTION_CLASS, "hasRole", Arrays.asList(new FunctionParameter("roleType", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.hasRole_param1, new Object[0])), new FunctionParameter("roleName", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.hasRole_param2, new Object[0]))), new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.BOOLEAN, Messages.getString(Messages.SystemSource.hasRole_result, new Object[0])), true, FunctionMethod.Determinism.USER_DETERMINISTIC));
        this.functions.add(new FunctionMethod("hasRole", Messages.getString(Messages.SystemSource.hasRole_description, new Object[0]), "Security", FunctionMethod.PushDown.CANNOT_PUSHDOWN, SECURITY_FUNCTION_CLASS, "hasRole", Arrays.asList(new FunctionParameter("roleName", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.hasRole_param2, new Object[0]))), new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.BOOLEAN, Messages.getString(Messages.SystemSource.hasRole_result, new Object[0])), true, FunctionMethod.Determinism.USER_DETERMINISTIC));
    }

    private void addFormatNumberFunctions() {
        this.addFormatNumberFunction("formatinteger", Messages.getString(Messages.SystemSource.Formatinteger_description, new Object[0]), "format", "integer", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.Formatinteger_result_description, new Object[0]));
        this.addFormatNumberFunction("formatlong", Messages.getString(Messages.SystemSource.Formatlong_description, new Object[0]), "format", "long", DataTypeManagerService.DefaultDataTypes.LONG, Messages.getString(Messages.SystemSource.Formatlong_result_description, new Object[0]));
        this.addFormatNumberFunction("formatdouble", Messages.getString(Messages.SystemSource.Formatdouble_description, new Object[0]), "format", "double", DataTypeManagerService.DefaultDataTypes.DOUBLE, Messages.getString(Messages.SystemSource.Formatdouble_result_description, new Object[0]));
        this.addFormatNumberFunction("formatfloat", Messages.getString(Messages.SystemSource.Formatfloat_description, new Object[0]), "format", "float", DataTypeManagerService.DefaultDataTypes.FLOAT, Messages.getString(Messages.SystemSource.Formatfloat_result_description, new Object[0]));
        this.addFormatNumberFunction("formatbiginteger", Messages.getString(Messages.SystemSource.Formatbiginteger_description, new Object[0]), "format", "biginteger", DataTypeManagerService.DefaultDataTypes.BIG_INTEGER, Messages.getString(Messages.SystemSource.Formatbiginteger_result_description, new Object[0]));
        this.addFormatNumberFunction("formatbigdecimal", Messages.getString(Messages.SystemSource.Formatbigdecimal_description, new Object[0]), "format", "bigdecimal", DataTypeManagerService.DefaultDataTypes.BIG_DECIMAL, Messages.getString(Messages.SystemSource.Formatbigdecimal_result_description, new Object[0]));
    }

    private void addParseNumberFunctions() {
        this.addParseNumberFunction("parseinteger", Messages.getString(Messages.SystemSource.Parseinteger_description, new Object[0]), "parseInteger", "integer", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.Parseinteger_result_description, new Object[0]));
        this.addParseNumberFunction("parselong", Messages.getString(Messages.SystemSource.Parselong_description, new Object[0]), "parseLong", "long", DataTypeManagerService.DefaultDataTypes.LONG, Messages.getString(Messages.SystemSource.Parselong_result_description, new Object[0]));
        this.addParseNumberFunction("parsedouble", Messages.getString(Messages.SystemSource.Parsedouble_description, new Object[0]), "parseDouble", "double", DataTypeManagerService.DefaultDataTypes.DOUBLE, Messages.getString(Messages.SystemSource.Parsedouble_result_description, new Object[0]));
        this.addParseNumberFunction("parsefloat", Messages.getString(Messages.SystemSource.Parsefloat_description, new Object[0]), "parseFloat", "float", DataTypeManagerService.DefaultDataTypes.FLOAT, Messages.getString(Messages.SystemSource.Parsefloat_result_description, new Object[0]));
        this.addParseNumberFunction("parsebiginteger", Messages.getString(Messages.SystemSource.Parsebiginteger_description, new Object[0]), "parseBigInteger", "biginteger", DataTypeManagerService.DefaultDataTypes.BIG_INTEGER, Messages.getString(Messages.SystemSource.Parsebiginteger_result_description, new Object[0]));
        this.addParseNumberFunction("parsebigdecimal", Messages.getString(Messages.SystemSource.Parsebigdecimal_description, new Object[0]), "parseBigDecimal", "bigdecimal", DataTypeManagerService.DefaultDataTypes.BIG_DECIMAL, Messages.getString(Messages.SystemSource.Parsebigdecimal_result_description, new Object[0]));
    }

    private void addArithmeticFunction(String functionName, String description, String methodName, String resultsDescription) {
        this.addTypedArithmeticFunction(functionName, description, methodName, resultsDescription, DataTypeManagerService.DefaultDataTypes.INTEGER);
        this.addTypedArithmeticFunction(functionName, description, methodName, resultsDescription, DataTypeManagerService.DefaultDataTypes.LONG);
        this.addTypedArithmeticFunction(functionName, description, methodName, resultsDescription, DataTypeManagerService.DefaultDataTypes.FLOAT);
        this.addTypedArithmeticFunction(functionName, description, methodName, resultsDescription, DataTypeManagerService.DefaultDataTypes.DOUBLE);
        this.addTypedArithmeticFunction(functionName, description, methodName, resultsDescription, DataTypeManagerService.DefaultDataTypes.BIG_INTEGER);
        this.addTypedArithmeticFunction(functionName, description, methodName, resultsDescription, DataTypeManagerService.DefaultDataTypes.BIG_DECIMAL);
    }

    private void addTypedArithmeticFunction(String functionName, String description, String methodName, String resultsDescription, DataTypeManagerService.DefaultDataTypes type) {
        this.addTypedArithmeticFunction(functionName, description, methodName, resultsDescription, type.getId());
    }

    private void addTypedArithmeticFunction(String functionName, String description, String methodName, String resultsDescription, String type) {
        this.functions.add(new FunctionMethod(functionName, description, "Numeric", FUNCTION_CLASS, methodName, new FunctionParameter[]{new FunctionParameter("op1", type, Messages.getString(Messages.SystemSource.Arith_left_op, new Object[0])), new FunctionParameter("op2", type, Messages.getString(Messages.SystemSource.Arith_right_op, new Object[0]))}, new FunctionParameter("result", type, resultsDescription)));
    }

    private void addAbsFunction() {
        this.addTypedAbsFunction(DataTypeManagerService.DefaultDataTypes.INTEGER);
        this.addTypedAbsFunction(DataTypeManagerService.DefaultDataTypes.LONG);
        this.addTypedAbsFunction(DataTypeManagerService.DefaultDataTypes.FLOAT);
        this.addTypedAbsFunction(DataTypeManagerService.DefaultDataTypes.DOUBLE);
        this.addTypedAbsFunction(DataTypeManagerService.DefaultDataTypes.BIG_INTEGER);
        this.addTypedAbsFunction(DataTypeManagerService.DefaultDataTypes.BIG_DECIMAL);
    }

    private void addTypedAbsFunction(DataTypeManagerService.DefaultDataTypes type) {
        this.addTypedAbsFunction(type.getId());
    }

    private void addTypedAbsFunction(String type) {
        this.functions.add(new FunctionMethod("abs", Messages.getString(Messages.SystemSource.Abs_description, new Object[0]), "Numeric", FUNCTION_CLASS, "abs", new FunctionParameter[]{new FunctionParameter("number", type, Messages.getString(Messages.SystemSource.Abs_arg, new Object[0]))}, new FunctionParameter("result", type, Messages.getString(Messages.SystemSource.Abs_result_description, new Object[0]))));
    }

    private void addRandFunction() {
        FunctionMethod rand = new FunctionMethod("rand", Messages.getString(Messages.SystemSource.Rand_description, new Object[0]), "Numeric", FUNCTION_CLASS, "rand", new FunctionParameter[]{new FunctionParameter("seed", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.Rand_arg, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.DOUBLE, Messages.getString(Messages.SystemSource.Rand_result_description, new Object[0])));
        rand.setNullOnNull(false);
        rand.setDeterminism(FunctionMethod.Determinism.NONDETERMINISTIC);
        this.functions.add(rand);
        rand = new FunctionMethod("rand", Messages.getString(Messages.SystemSource.Rand_description, new Object[0]), "Numeric", FUNCTION_CLASS, "rand", new FunctionParameter[0], new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.DOUBLE, Messages.getString(Messages.SystemSource.Rand_result_description, new Object[0])));
        rand.setDeterminism(FunctionMethod.Determinism.NONDETERMINISTIC);
        this.functions.add(rand);
    }

    private void addUuidFunction() {
        FunctionMethod rand = new FunctionMethod("uuid", Messages.getString(Messages.SystemSource.uuid_description, new Object[0]), "Miscellaneous", FUNCTION_CLASS, "uuid", new FunctionParameter[0], new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.uuid_result_description, new Object[0])));
        rand.setDeterminism(FunctionMethod.Determinism.NONDETERMINISTIC);
        this.functions.add(rand);
    }

    private void addDoubleFunction(String name, String description) {
        this.functions.add(new FunctionMethod(name, description, "Numeric", FUNCTION_CLASS, name, new FunctionParameter[]{new FunctionParameter("number", DataTypeManagerService.DefaultDataTypes.DOUBLE, Messages.getString(Messages.SystemSource.Double_arg2, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.DOUBLE, description)));
        this.functions.add(new FunctionMethod(name, description, "Numeric", FUNCTION_CLASS, name, new FunctionParameter[]{new FunctionParameter("number", DataTypeManagerService.DefaultDataTypes.BIG_DECIMAL, Messages.getString(Messages.SystemSource.Double_arg2, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.DOUBLE, description)));
    }

    private void addAtan2Function(String name, String description) {
        this.functions.add(new FunctionMethod(name, description, "Numeric", FUNCTION_CLASS, name, new FunctionParameter[]{new FunctionParameter("number1", DataTypeManagerService.DefaultDataTypes.DOUBLE, Messages.getString(Messages.SystemSource.Atan_arg1, new Object[0])), new FunctionParameter("number2", DataTypeManagerService.DefaultDataTypes.DOUBLE, Messages.getString(Messages.SystemSource.Atan_arg2, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.DOUBLE, description)));
        this.functions.add(new FunctionMethod(name, description, "Numeric", FUNCTION_CLASS, name, new FunctionParameter[]{new FunctionParameter("number1", DataTypeManagerService.DefaultDataTypes.BIG_DECIMAL, Messages.getString(Messages.SystemSource.Atan_arg1, new Object[0])), new FunctionParameter("number2", DataTypeManagerService.DefaultDataTypes.BIG_DECIMAL, Messages.getString(Messages.SystemSource.Atan_arg2, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.DOUBLE, description)));
    }

    private void addPiFunction(String name, String description) {
        this.functions.add(new FunctionMethod(name, description, "Numeric", FUNCTION_CLASS, name, new FunctionParameter[0], new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.DOUBLE, description)));
    }

    private void addPowerFunction() {
        this.addTypedPowerFunction(DataTypeManagerService.DefaultDataTypes.DOUBLE, DataTypeManagerService.DefaultDataTypes.DOUBLE);
        this.addTypedPowerFunction(DataTypeManagerService.DefaultDataTypes.BIG_INTEGER, DataTypeManagerService.DefaultDataTypes.INTEGER);
        this.addTypedPowerFunction(DataTypeManagerService.DefaultDataTypes.BIG_DECIMAL, DataTypeManagerService.DefaultDataTypes.INTEGER);
    }

    private void addTypedPowerFunction(DataTypeManagerService.DefaultDataTypes baseType, DataTypeManagerService.DefaultDataTypes powerType) {
        this.addTypedPowerFunction(baseType.getId(), powerType.getId());
    }

    private void addTypedPowerFunction(String baseType, String powerType) {
        this.functions.add(new FunctionMethod("power", Messages.getString(Messages.SystemSource.Power_description, new Object[0]), "Numeric", FUNCTION_CLASS, "power", new FunctionParameter[]{new FunctionParameter("base", baseType, Messages.getString(Messages.SystemSource.Power_arg1, new Object[0])), new FunctionParameter("power", powerType, Messages.getString(Messages.SystemSource.Power_arg2, new Object[0]))}, new FunctionParameter("result", baseType, Messages.getString(Messages.SystemSource.Power_result_description, new Object[0]))));
    }

    private void addRoundFunction() {
        this.addTypedRoundFunction(DataTypeManagerService.DefaultDataTypes.INTEGER);
        this.addTypedRoundFunction(DataTypeManagerService.DefaultDataTypes.FLOAT);
        this.addTypedRoundFunction(DataTypeManagerService.DefaultDataTypes.DOUBLE);
        this.addTypedRoundFunction(DataTypeManagerService.DefaultDataTypes.BIG_DECIMAL);
    }

    private void addTypedRoundFunction(DataTypeManagerService.DefaultDataTypes roundType) {
        this.addTypedRoundFunction(roundType.getId());
    }

    private void addTypedRoundFunction(String roundType) {
        this.functions.add(new FunctionMethod("round", Messages.getString(Messages.SystemSource.Round_description, new Object[0]), "Numeric", FUNCTION_CLASS, "round", new FunctionParameter[]{new FunctionParameter("number", roundType, Messages.getString(Messages.SystemSource.Round_arg1, new Object[0])), new FunctionParameter("places", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.Round_arg2, new Object[0]))}, new FunctionParameter("result", roundType, Messages.getString(Messages.SystemSource.Round_result_description, new Object[0]))));
    }

    private void addSignFunction() {
        this.addTypedSignFunction(DataTypeManagerService.DefaultDataTypes.INTEGER);
        this.addTypedSignFunction(DataTypeManagerService.DefaultDataTypes.LONG);
        this.addTypedSignFunction(DataTypeManagerService.DefaultDataTypes.FLOAT);
        this.addTypedSignFunction(DataTypeManagerService.DefaultDataTypes.DOUBLE);
        this.addTypedSignFunction(DataTypeManagerService.DefaultDataTypes.BIG_INTEGER);
        this.addTypedSignFunction(DataTypeManagerService.DefaultDataTypes.BIG_DECIMAL);
    }

    private void addTypedSignFunction(DataTypeManagerService.DefaultDataTypes type) {
        this.addTypedSignFunction(type.getId());
    }

    private void addTypedSignFunction(String type) {
        this.functions.add(new FunctionMethod("sign", Messages.getString(Messages.SystemSource.Sign_description, new Object[0]), "Numeric", FUNCTION_CLASS, "sign", new FunctionParameter[]{new FunctionParameter("number", type, Messages.getString(Messages.SystemSource.Sign_arg1, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.Sign_result_description, new Object[0]))));
    }

    private void addSqrtFunction() {
        this.addTypedSqrtFunction(DataTypeManagerService.DefaultDataTypes.LONG);
        this.addTypedSqrtFunction(DataTypeManagerService.DefaultDataTypes.DOUBLE);
        this.addTypedSqrtFunction(DataTypeManagerService.DefaultDataTypes.BIG_DECIMAL);
    }

    private void addTypedSqrtFunction(DataTypeManagerService.DefaultDataTypes type) {
        this.addTypedSqrtFunction(type.getId());
    }

    private void addTypedSqrtFunction(String type) {
        this.functions.add(new FunctionMethod("sqrt", Messages.getString(Messages.SystemSource.Sqrt_description, new Object[0]), "Numeric", FUNCTION_CLASS, "sqrt", new FunctionParameter[]{new FunctionParameter("number", type, Messages.getString(Messages.SystemSource.Sqrt_arg1, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.DOUBLE, Messages.getString(Messages.SystemSource.Sqrt_result_description, new Object[0]))));
    }

    private void addConstantDateFunction(String name, String description, String methodName, DataTypeManagerService.DefaultDataTypes returnType) {
        this.addConstantDateFunction(name, description, methodName, returnType.getId());
    }

    private void addConstantDateFunction(String name, String description, String methodName, String returnType) {
        FunctionMethod method = new FunctionMethod(name, description, "Datetime", FUNCTION_CLASS, methodName, new FunctionParameter[0], new FunctionParameter("result", returnType, description));
        method.setDeterminism(FunctionMethod.Determinism.COMMAND_DETERMINISTIC);
        this.functions.add(method);
    }

    private void addDateFunction(String name, String methodName, String dateDesc, String timestampDesc, DataTypeManagerService.DefaultDataTypes returnType) {
        this.addDateFunction(name, methodName, dateDesc, timestampDesc, returnType.getId());
    }

    private void addDateFunction(String name, String methodName, String dateDesc, String timestampDesc, String returnType) {
        this.functions.add(new FunctionMethod(name, dateDesc, "Datetime", FUNCTION_CLASS, methodName, new FunctionParameter[]{new FunctionParameter("date", DataTypeManagerService.DefaultDataTypes.DATE, dateDesc)}, new FunctionParameter("result", returnType, dateDesc)));
        this.functions.add(new FunctionMethod(name, timestampDesc, "Datetime", FUNCTION_CLASS, methodName, new FunctionParameter[]{new FunctionParameter("timestamp", DataTypeManagerService.DefaultDataTypes.TIMESTAMP, timestampDesc)}, new FunctionParameter("result", returnType, timestampDesc)));
    }

    private void addQuarterFunction(String name, String methodName, String dateDesc, String timestampDesc, DataTypeManagerService.DefaultDataTypes returnType) {
        this.addQuarterFunction(name, methodName, dateDesc, timestampDesc, returnType.getId());
    }

    private void addQuarterFunction(String name, String methodName, String dateDesc, String timestampDesc, String returnType) {
        this.functions.add(new FunctionMethod(name, dateDesc, "Datetime", FUNCTION_CLASS, methodName, new FunctionParameter[]{new FunctionParameter("date", DataTypeManagerService.DefaultDataTypes.DATE, dateDesc)}, new FunctionParameter("result", returnType, dateDesc)));
        this.functions.add(new FunctionMethod(name, timestampDesc, "Datetime", FUNCTION_CLASS, methodName, new FunctionParameter[]{new FunctionParameter("timestamp", DataTypeManagerService.DefaultDataTypes.TIMESTAMP, timestampDesc)}, new FunctionParameter("result", returnType, timestampDesc)));
    }

    private void addTimestampAddFunction() {
        this.functions.add(SystemSource.createSyntheticMethod("timestampadd", Messages.getString(Messages.SystemSource.Timestampadd_d_description, new Object[0]), "Datetime", null, null, new FunctionParameter[]{new FunctionParameter("interval", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Timestampadd_d_arg1, new Object[0])), new FunctionParameter("count", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.Timestampadd_d_arg2, new Object[0])), new FunctionParameter("timestamp", DataTypeManagerService.DefaultDataTypes.DATE, Messages.getString(Messages.SystemSource.Timestampadd_d_arg3, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.DATE, Messages.getString(Messages.SystemSource.Timestampadd_d_result_description, new Object[0]))));
        this.functions.add(SystemSource.createSyntheticMethod("timestampadd", Messages.getString(Messages.SystemSource.Timestampadd_t_description, new Object[0]), "Datetime", null, null, new FunctionParameter[]{new FunctionParameter("interval", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Timestampadd_t_arg1, new Object[0])), new FunctionParameter("count", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.Timestampadd_t_arg2, new Object[0])), new FunctionParameter("timestamp", DataTypeManagerService.DefaultDataTypes.TIME, Messages.getString(Messages.SystemSource.Timestampadd_t_arg3, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.TIME, Messages.getString(Messages.SystemSource.Timestampadd_t_result_description, new Object[0]))));
        this.functions.add(new FunctionMethod("timestampadd", Messages.getString(Messages.SystemSource.Timestampadd_ts_description, new Object[0]), "Datetime", FUNCTION_CLASS, "timestampAdd", new FunctionParameter[]{new FunctionParameter("interval", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Timestampadd_ts_arg1, new Object[0])), new FunctionParameter("count", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.Timestampadd_ts_arg2, new Object[0])), new FunctionParameter("timestamp", DataTypeManagerService.DefaultDataTypes.TIMESTAMP, Messages.getString(Messages.SystemSource.Timestampadd_ts_arg3, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.TIMESTAMP, Messages.getString(Messages.SystemSource.Timestampadd_ts_result, new Object[0]))));
    }

    private void addTimestampDiffFunction() {
        this.functions.add(new FunctionMethod("timestampdiff", Messages.getString(Messages.SystemSource.Timestampdiff_ts_description, new Object[0]), "Datetime", FUNCTION_CLASS, "timestampDiff", new FunctionParameter[]{new FunctionParameter("interval", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Timestampdiff_ts_arg1, new Object[0])), new FunctionParameter("timestamp1", DataTypeManagerService.DefaultDataTypes.TIMESTAMP, Messages.getString(Messages.SystemSource.Timestampdiff_ts_arg2, new Object[0])), new FunctionParameter("timestamp2", DataTypeManagerService.DefaultDataTypes.TIMESTAMP, Messages.getString(Messages.SystemSource.Timestampdiff_ts_arg3, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.LONG, Messages.getString(Messages.SystemSource.Timestampdiff_ts_result_description, new Object[0]))));
    }

    private void addTimestampCreateFunction() {
        this.functions.add(new FunctionMethod("timestampcreate", Messages.getString(Messages.SystemSource.TimestampCreate_description, new Object[0]), "Datetime", FUNCTION_CLASS, "timestampCreate", new FunctionParameter[]{new FunctionParameter("date", DataTypeManagerService.DefaultDataTypes.DATE, Messages.getString(Messages.SystemSource.TimestampCreate_arg1, new Object[0])), new FunctionParameter("time", DataTypeManagerService.DefaultDataTypes.TIME, Messages.getString(Messages.SystemSource.TimestampCreate_arg2, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.TIMESTAMP, Messages.getString(Messages.SystemSource.TimestampCreate_result_description, new Object[0]))));
    }

    private void addTimeFunction(String name, String methodName, String timeDesc, String timestampDesc, DataTypeManagerService.DefaultDataTypes returnType) {
        this.addTimeFunction(name, methodName, timeDesc, timestampDesc, returnType.getId());
    }

    private void addTimeFunction(String name, String methodName, String timeDesc, String timestampDesc, String returnType) {
        this.functions.add(new FunctionMethod(name, timeDesc, "Datetime", FUNCTION_CLASS, methodName, new FunctionParameter[]{new FunctionParameter("time", DataTypeManagerService.DefaultDataTypes.TIME, timeDesc)}, new FunctionParameter("result", returnType, timeDesc)));
        this.functions.add(new FunctionMethod(name, timestampDesc, "Datetime", FUNCTION_CLASS, methodName, new FunctionParameter[]{new FunctionParameter("timestamp", DataTypeManagerService.DefaultDataTypes.TIMESTAMP, timestampDesc)}, new FunctionParameter("result", returnType, timestampDesc)));
    }

    private void addStringFunction(String name, String description, String methodName, DataTypeManagerService.DefaultDataTypes returnType) {
        this.addStringFunction(name, description, methodName, returnType.getId());
    }

    private void addStringFunction(String name, String description, String methodName, String returnType) {
        this.functions.add(new FunctionMethod(name, description, "String", FUNCTION_CLASS, methodName, new FunctionParameter[]{new FunctionParameter("string", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Stringfunc_arg1, new Object[0]))}, new FunctionParameter("result", returnType, description)));
    }

    private void addClobFunction(String name, String description, String methodName, DataTypeManagerService.DefaultDataTypes returnType) {
        this.addClobFunction(name, description, methodName, returnType.getId());
    }

    private void addClobFunction(String name, String description, String methodName, String returnType) {
        this.functions.add(new FunctionMethod(name, description, "String", FunctionMethod.PushDown.MUST_PUSHDOWN, FUNCTION_CLASS, methodName, Arrays.asList(new FunctionParameter("clob", DataTypeManagerService.DefaultDataTypes.CLOB, Messages.getString(Messages.SystemSource.Clobfunc_arg1, new Object[0]))), new FunctionParameter("result", returnType, description), true, FunctionMethod.Determinism.DETERMINISTIC));
    }

    private void addConcatFunction() {
        this.functions.add(new FunctionMethod("concat", Messages.getString(Messages.SystemSource.Concat_description, new Object[0]), "String", FUNCTION_CLASS, "concat", new FunctionParameter[]{new FunctionParameter("string1", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Concat_arg1, new Object[0])), new FunctionParameter("string2", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Concat_arg2, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Concat_result_description, new Object[0]))));
        this.functions.add(new FunctionMethod("||", Messages.getString(Messages.SystemSource.Concatop_description, new Object[0]), "String", FUNCTION_CLASS, "concat", new FunctionParameter[]{new FunctionParameter("string1", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Concatop_arg1, new Object[0])), new FunctionParameter("string2", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Concatop_arg2, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Concatop_result_description, new Object[0]))));
        FunctionMethod concat2 = new FunctionMethod("concat2", Messages.getString(Messages.SystemSource.Concat_description, new Object[0]), "String", FUNCTION_CLASS, "concat2", new FunctionParameter[]{new FunctionParameter("string1", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Concat_arg1, new Object[0])), new FunctionParameter("string2", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Concat_arg2, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Concat_result_description, new Object[0])));
        concat2.setNullOnNull(false);
        this.functions.add(concat2);
    }

    private void addSubstringFunction() {
        this.functions.add(new FunctionMethod("substring", Messages.getString(Messages.SystemSource.Substring_description, new Object[0]), "String", FUNCTION_CLASS, "substring", new FunctionParameter[]{new FunctionParameter("string", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Substring_arg1, new Object[0])), new FunctionParameter("index", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.Substring_arg2, new Object[0])), new FunctionParameter("length", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.Substring_arg3, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Substring_result, new Object[0]))));
        this.functions.add(new FunctionMethod("substring", Messages.getString(Messages.SystemSource.Susbstring2_description, new Object[0]), "String", FUNCTION_CLASS, "substring", new FunctionParameter[]{new FunctionParameter("string", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Substring2_arg1, new Object[0])), new FunctionParameter("index", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.Substring2_arg2, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Substring2_result, new Object[0]))));
    }

    private void addLeftRightFunctions() {
        this.functions.add(new FunctionMethod("left", Messages.getString(Messages.SystemSource.Left_description, new Object[0]), "String", FUNCTION_CLASS, "left", new FunctionParameter[]{new FunctionParameter("string", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Left_arg1, new Object[0])), new FunctionParameter("length", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.Left_arg2, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Left2_result, new Object[0]))));
        this.functions.add(new FunctionMethod("right", Messages.getString(Messages.SystemSource.Right_description, new Object[0]), "String", FUNCTION_CLASS, "right", new FunctionParameter[]{new FunctionParameter("string", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Right_arg1, new Object[0])), new FunctionParameter("length", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.Right_arg2, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Right2_result, new Object[0]))));
    }

    private void addLocateFunction() {
        FunctionMethod func = new FunctionMethod("locate", Messages.getString(Messages.SystemSource.Locate_description, new Object[0]), "String", FUNCTION_CLASS, "locate", new FunctionParameter[]{new FunctionParameter("substring", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Locate_arg1, new Object[0])), new FunctionParameter("string", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Locate_arg2, new Object[0])), new FunctionParameter("index", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.Locate_arg3, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.Locate_result, new Object[0])));
        func.setNullOnNull(false);
        this.functions.add(func);
        this.functions.add(new FunctionMethod("locate", Messages.getString(Messages.SystemSource.Locate2_description, new Object[0]), "String", FUNCTION_CLASS, "locate", new FunctionParameter[]{new FunctionParameter("substring", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Locate2_arg1, new Object[0])), new FunctionParameter("string", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Locate2_arg2, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.Locate2_result, new Object[0]))));
    }

    private void addReplaceFunction() {
        this.functions.add(new FunctionMethod("replace", Messages.getString(Messages.SystemSource.Replace_description, new Object[0]), "String", FUNCTION_CLASS, "replace", new FunctionParameter[]{new FunctionParameter("string", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Replace_arg1, new Object[0])), new FunctionParameter("substring", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Replace_arg2, new Object[0])), new FunctionParameter("replacement", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Replace_arg3, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Replace_result, new Object[0]))));
    }

    @Since(value=TeiidServerVersion.Version.TEIID_8_0)
    private void addEndsWithFunction() {
        if (this.teiidVersion.getMinimumVersion().isLessThan(TeiidServerVersion.Version.TEIID_8_0.get())) {
            return;
        }
        FunctionMethod f = new FunctionMethod("endswith", Messages.getString(Messages.SystemSource.endswith_description, new Object[0]), "String", FUNCTION_CLASS, "endsWith", new FunctionParameter[]{new FunctionParameter("substring", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.endswith_arg1, new Object[0])), new FunctionParameter("string", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.endswith_arg2, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.endswith_result, new Object[0])));
        this.functions.add(f);
    }

    private void addRepeatFunction() {
        this.functions.add(new FunctionMethod("repeat", Messages.getString(Messages.SystemSource.Repeat_description, new Object[0]), "String", FUNCTION_CLASS, "repeat", new FunctionParameter[]{new FunctionParameter("string", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Repeat_arg1, new Object[0])), new FunctionParameter("count", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.Repeat_arg2, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Repeat_result, new Object[0]))));
    }

    private void addSpaceFunction() {
        this.functions.add(SystemSource.createSyntheticMethod(IFunctionLibrary.FunctionName.SPACE.text(), Messages.getString(Messages.SystemSource.Space_description, new Object[0]), "String", null, null, new FunctionParameter[]{new FunctionParameter("count", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.Space_arg1, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Space_result, new Object[0]))));
    }

    private void addInsertFunction() {
        this.functions.add(new FunctionMethod("insert", Messages.getString(Messages.SystemSource.Insert_description, new Object[0]), "String", FUNCTION_CLASS, "insert", new FunctionParameter[]{new FunctionParameter("str1", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Insert_arg1, new Object[0])), new FunctionParameter("start", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.Insert_arg2, new Object[0])), new FunctionParameter("length", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.Insert_arg3, new Object[0])), new FunctionParameter("str2", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Insert_arg4, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Insert_result, new Object[0]))));
    }

    @Removed(value=TeiidServerVersion.Version.TEIID_8_0)
    private void addToCharsFunction() {
        if (this.teiidVersion.getMinimumVersion().isGreaterThanOrEqualTo(TeiidServerVersion.Version.TEIID_8_0.get())) {
            return;
        }
        this.functions.add(new FunctionMethod("to_chars", Messages.getString(Messages.SystemSource.encode_description, new Object[0]), "Conversion", FUNCTION_CLASS, "toChars", new FunctionParameter[]{new FunctionParameter("value", DataTypeManagerService.DefaultDataTypes.BLOB, Messages.getString(Messages.SystemSource.encode_arg1, new Object[0])), new FunctionParameter("encoding", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.encode_arg2, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.CLOB, Messages.getString(Messages.SystemSource.encode_result, new Object[0]))));
    }

    @Removed(value=TeiidServerVersion.Version.TEIID_8_0)
    private void addToBytesFunction() {
        if (this.teiidVersion.getMinimumVersion().isGreaterThanOrEqualTo(TeiidServerVersion.Version.TEIID_8_0.get())) {
            return;
        }
        this.functions.add(new FunctionMethod("to_bytes", Messages.getString(Messages.SystemSource.decode_description, new Object[0]), "Conversion", FUNCTION_CLASS, "toBytes", new FunctionParameter[]{new FunctionParameter("value", DataTypeManagerService.DefaultDataTypes.CLOB, Messages.getString(Messages.SystemSource.decode_arg1, new Object[0])), new FunctionParameter("encoding", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.decode_arg2, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.BLOB, Messages.getString(Messages.SystemSource.decode_result, new Object[0]))));
    }

    private void addAsciiFunction() {
        this.functions.add(new FunctionMethod("ascii", Messages.getString(Messages.SystemSource.Ascii_description, new Object[0]), "String", FUNCTION_CLASS, "ascii", new FunctionParameter[]{new FunctionParameter("string", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Ascii_arg1, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.Ascii_result, new Object[0]))));
        this.functions.add(new FunctionMethod("ascii", Messages.getString(Messages.SystemSource.Ascii2_description, new Object[0]), "String", FUNCTION_CLASS, "ascii", new FunctionParameter[]{new FunctionParameter("char", DataTypeManagerService.DefaultDataTypes.CHAR, Messages.getString(Messages.SystemSource.Ascii2_arg1, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.Ascii2_result, new Object[0]))));
    }

    private void addCharFunction() {
        this.functions.add(new FunctionMethod("char", Messages.getString(Messages.SystemSource.Char_description, new Object[0]), "String", FUNCTION_CLASS, "chr", new FunctionParameter[]{new FunctionParameter("code", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.Char_arg1, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.CHAR, Messages.getString(Messages.SystemSource.Char_result, new Object[0]))));
        this.functions.add(new FunctionMethod("chr", Messages.getString(Messages.SystemSource.Chr_description, new Object[0]), "String", FUNCTION_CLASS, "chr", new FunctionParameter[]{new FunctionParameter("code", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.Chr_arg1, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.CHAR, Messages.getString(Messages.SystemSource.Chr_result, new Object[0]))));
    }

    private void addInitCapFunction() {
        this.functions.add(new FunctionMethod("initcap", Messages.getString(Messages.SystemSource.Initcap_description, new Object[0]), "String", FUNCTION_CLASS, "initCap", new FunctionParameter[]{new FunctionParameter("string", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Initcap_arg1, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Initcap_result, new Object[0]))));
    }

    private void addLpadFunction() {
        this.functions.add(new FunctionMethod("lpad", Messages.getString(Messages.SystemSource.Lpad_description, new Object[0]), "String", FUNCTION_CLASS, "lpad", new FunctionParameter[]{new FunctionParameter("string", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Lpad_arg1, new Object[0])), new FunctionParameter("length", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.Lpad_arg2, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Lpad_result, new Object[0]))));
        this.functions.add(new FunctionMethod("lpad", Messages.getString(Messages.SystemSource.Lpad3_description, new Object[0]), "String", FUNCTION_CLASS, "lpad", new FunctionParameter[]{new FunctionParameter("string", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Lpad3_arg1, new Object[0])), new FunctionParameter("length", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.Lpad3_arg2, new Object[0])), new FunctionParameter("char", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Lpad3_arg3, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Lpad3_result, new Object[0]))));
    }

    private void addRpadFunction() {
        this.functions.add(new FunctionMethod("rpad", Messages.getString(Messages.SystemSource.Rpad1_description, new Object[0]), "String", FUNCTION_CLASS, "rpad", new FunctionParameter[]{new FunctionParameter("string", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Rpad1_arg1, new Object[0])), new FunctionParameter("length", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.Rpad1_arg2, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Rpad1_result, new Object[0]))));
        this.functions.add(new FunctionMethod("rpad", Messages.getString(Messages.SystemSource.Rpad3_description, new Object[0]), "String", FUNCTION_CLASS, "rpad", new FunctionParameter[]{new FunctionParameter("string", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Rpad3_arg1, new Object[0])), new FunctionParameter("length", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.Rpad3_arg2, new Object[0])), new FunctionParameter("char", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Rpad3_arg3, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Rpad3_result, new Object[0]))));
    }

    private void addTranslateFunction() {
        this.functions.add(new FunctionMethod("translate", Messages.getString(Messages.SystemSource.Translate_description, new Object[0]), "String", FUNCTION_CLASS, "translate", new FunctionParameter[]{new FunctionParameter("string", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Translate_arg1, new Object[0])), new FunctionParameter("source", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Translate_arg2, new Object[0])), new FunctionParameter("destination", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Translate_arg3, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Translate_result, new Object[0]))));
    }

    private void addConversionFunctions() {
        for (String type : this.dataTypeManager.getAllDataTypeNames()) {
            this.addTypedConversionFunction("convert", type);
            this.addTypedConversionFunction("cast", type);
        }
    }

    private void addTypedConversionFunction(String name, String sourceType) {
        this.functions.add(new FunctionMethod(name, Messages.getString(Messages.SystemSource.Convert_description, sourceType), "Conversion", FUNCTION_CLASS, "convert", new FunctionParameter[]{new FunctionParameter("value", sourceType, Messages.getString(Messages.SystemSource.Convert_arg1, new Object[0])), new FunctionParameter("target", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Convert_arg2, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.OBJECT, Messages.getString(Messages.SystemSource.Convert_result, new Object[0]))));
    }

    private void addContextFunctions() {
        for (String contextType : this.dataTypeManager.getAllDataTypeNames()) {
            for (String exprType : this.dataTypeManager.getAllDataTypeNames()) {
                this.addTypedContextFunction(contextType, exprType);
            }
        }
    }

    private void addTypedContextFunction(String contextType, String exprType) {
        this.functions.add(new FunctionMethod("context", Messages.getString(Messages.SystemSource.Context_description, new Object[0]), "Miscellaneous", FUNCTION_CLASS, "context", new FunctionParameter[]{new FunctionParameter("context", contextType, Messages.getString(Messages.SystemSource.Context_arg1, new Object[0])), new FunctionParameter("element", exprType, Messages.getString(Messages.SystemSource.Context_arg2, new Object[0]))}, new FunctionParameter("result", exprType, Messages.getString(Messages.SystemSource.Context_result, new Object[0]))));
    }

    private void addRowLimitFunctions() {
        for (String exprType : this.dataTypeManager.getAllDataTypeNames()) {
            this.functions.add(new FunctionMethod("rowlimit", Messages.getString(Messages.SystemSource.Rowlimit_description, new Object[0]), "Miscellaneous", FUNCTION_CLASS, "rowlimit", new FunctionParameter[]{new FunctionParameter("element", exprType, Messages.getString(Messages.SystemSource.Rowlimit_arg1, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.Rowlimit_result, new Object[0]))));
        }
    }

    private void addRowLimitExceptionFunctions() {
        for (String exprType : this.dataTypeManager.getAllDataTypeNames()) {
            this.functions.add(new FunctionMethod("rowlimitexception", Messages.getString(Messages.SystemSource.RowlimitException_description, new Object[0]), "Miscellaneous", FUNCTION_CLASS, "rowlimitexception", new FunctionParameter[]{new FunctionParameter("element", exprType, Messages.getString(Messages.SystemSource.Rowlimit_arg1, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.Rowlimit_result, new Object[0]))));
        }
    }

    private void addDecodeFunctions() {
        this.addDecodeFunction("decodeInteger", DataTypeManagerService.DefaultDataTypes.INTEGER);
        this.addDecodeFunction("decodeString", DataTypeManagerService.DefaultDataTypes.STRING);
    }

    private void addDecodeFunction(String functionName, DataTypeManagerService.DefaultDataTypes resultType) {
        this.addDecodeFunction(functionName, resultType.getId());
    }

    private void addDecodeFunction(String functionName, String resultType) {
        this.functions.add(SystemSource.createSyntheticMethod(functionName, Messages.getString(Messages.SystemSource.Decode1_description, new Object[0]), "Miscellaneous", null, null, new FunctionParameter[]{new FunctionParameter("input", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Decode1_arg1, new Object[0])), new FunctionParameter("decodeString", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Decode1_arg2, new Object[0]))}, new FunctionParameter("result", resultType, Messages.getString(Messages.SystemSource.Decode1_result, new Object[0]))));
        this.functions.add(SystemSource.createSyntheticMethod(functionName, Messages.getString(Messages.SystemSource.Decode2_description, new Object[0]), "Miscellaneous", null, null, new FunctionParameter[]{new FunctionParameter("input", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Decode2_arg1, new Object[0])), new FunctionParameter("decodeString", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Decode2_arg2, new Object[0])), new FunctionParameter("delimiter", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Decode2_arg3, new Object[0]))}, new FunctionParameter("result", resultType, Messages.getString(Messages.SystemSource.Decode2_result, new Object[0]))));
    }

    private void addLookupFunctions() {
        for (String keyValueType : this.dataTypeManager.getAllDataTypeNames()) {
            this.functions.add(new FunctionMethod("lookup", Messages.getString(Messages.SystemSource.Lookup_description, new Object[0]), "Miscellaneous", FunctionMethod.PushDown.CANNOT_PUSHDOWN, FUNCTION_CLASS, "lookup", Arrays.asList(new FunctionParameter("codetable", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Lookup_arg1, new Object[0])), new FunctionParameter("returnelement", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Lookup_arg2, new Object[0])), new FunctionParameter("keyelement", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Lookup_arg3, new Object[0])), new FunctionParameter("keyvalue", keyValueType, Messages.getString(Messages.SystemSource.Lookup_arg4, new Object[0]))), new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.OBJECT, Messages.getString(Messages.SystemSource.Lookup_result, new Object[0])), false, FunctionMethod.Determinism.VDB_DETERMINISTIC));
        }
    }

    private void addUserFunction() {
        this.functions.add(new FunctionMethod("user", Messages.getString(Messages.SystemSource.User_description, new Object[0]), "Miscellaneous", FunctionMethod.PushDown.CANNOT_PUSHDOWN, FUNCTION_CLASS, "user", null, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.User_result, new Object[0])), true, FunctionMethod.Determinism.USER_DETERMINISTIC));
    }

    private void addCurrentDatabaseFunction() {
        this.functions.add(new FunctionMethod("current_database", Messages.getString(Messages.SystemSource.current_database_description, new Object[0]), "Miscellaneous", FunctionMethod.PushDown.CANNOT_PUSHDOWN, FUNCTION_CLASS, "current_database", null, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.current_database_result, new Object[0])), true, FunctionMethod.Determinism.VDB_DETERMINISTIC));
    }

    private void addEnvFunction() {
        this.functions.add(new FunctionMethod("env", Messages.getString(Messages.SystemSource.Env_description, new Object[0]), "Miscellaneous", FunctionMethod.PushDown.CANNOT_PUSHDOWN, FUNCTION_CLASS, "env", Arrays.asList(new FunctionParameter("variablename", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Env_varname, new Object[0]))), new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Env_result, new Object[0])), true, FunctionMethod.Determinism.DETERMINISTIC));
    }

    private void addSessionIdFunction() {
        this.functions.add(new FunctionMethod(IFunctionLibrary.FunctionName.SESSION_ID.text(), Messages.getString(Messages.SystemSource.session_id_description, new Object[0]), "Miscellaneous", FunctionMethod.PushDown.CANNOT_PUSHDOWN, FUNCTION_CLASS, "session_id", null, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.session_id_result, new Object[0])), true, FunctionMethod.Determinism.SESSION_DETERMINISTIC));
    }

    private void addCommandPayloadFunctions() {
        this.functions.add(new FunctionMethod("commandpayload", Messages.getString(Messages.SystemSource.CommandPayload_desc0, new Object[0]), "Miscellaneous", FunctionMethod.PushDown.CANNOT_PUSHDOWN, FUNCTION_CLASS, "commandPayload", null, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.CommandPayload_result, new Object[0])), true, FunctionMethod.Determinism.COMMAND_DETERMINISTIC));
        this.functions.add(new FunctionMethod("commandpayload", Messages.getString(Messages.SystemSource.CommandPayload_desc1, new Object[0]), "Miscellaneous", FunctionMethod.PushDown.CANNOT_PUSHDOWN, FUNCTION_CLASS, "commandPayload", Arrays.asList(new FunctionParameter("property", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.CommandPayload_property, new Object[0]))), new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.CommandPayload_result, new Object[0])), true, FunctionMethod.Determinism.COMMAND_DETERMINISTIC));
    }

    private void addIfNullFunctions() {
        for (String type : this.dataTypeManager.getAllDataTypeNames()) {
            this.addNvlFunction(type);
            this.addIfNullFunction(type);
        }
    }

    private void addNvlFunction(String valueType) {
        FunctionMethod nvl = new FunctionMethod("nvl", Messages.getString(Messages.SystemSource.Nvl_description, new Object[0]), "Miscellaneous", FUNCTION_CLASS, "ifnull", new FunctionParameter[]{new FunctionParameter("value", valueType, Messages.getString(Messages.SystemSource.Nvl_arg1, new Object[0])), new FunctionParameter("valueIfNull", valueType, Messages.getString(Messages.SystemSource.Nvl_arg2, new Object[0]))}, new FunctionParameter("result", valueType, Messages.getString(Messages.SystemSource.Nvl_result, new Object[0])));
        nvl.setNullOnNull(false);
        this.functions.add(nvl);
    }

    private void addIfNullFunction(String valueType) {
        FunctionMethod nvl = new FunctionMethod("ifnull", Messages.getString(Messages.SystemSource.Ifnull_description, new Object[0]), "Miscellaneous", FUNCTION_CLASS, "ifnull", new FunctionParameter[]{new FunctionParameter("value", valueType, Messages.getString(Messages.SystemSource.Ifnull_arg1, new Object[0])), new FunctionParameter("valueIfNull", valueType, Messages.getString(Messages.SystemSource.Ifnull_arg2, new Object[0]))}, new FunctionParameter("result", valueType, Messages.getString(Messages.SystemSource.Ifnull_result, new Object[0])));
        nvl.setNullOnNull(false);
        this.functions.add(nvl);
    }

    private void addFormatTimestampFunction() {
        this.functions.add(new FunctionMethod("formattimestamp", Messages.getString(Messages.SystemSource.Formattimestamp_description, new Object[0]), "Conversion", FUNCTION_CLASS, "format", new FunctionParameter[]{new FunctionParameter("timestamp", DataTypeManagerService.DefaultDataTypes.TIMESTAMP, Messages.getString(Messages.SystemSource.Formattimestamp_arg1, new Object[0])), new FunctionParameter("format", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Formattimestamp_arg2, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Formattimestamp_result_description, new Object[0]))));
        this.functions.add(SystemSource.createSyntheticMethod(IFunctionLibrary.FunctionName.FORMATDATE.text(), Messages.getString(Messages.SystemSource.Formatdate_description, new Object[0]), "Conversion", null, null, new FunctionParameter[]{new FunctionParameter("date", DataTypeManagerService.DefaultDataTypes.DATE, Messages.getString(Messages.SystemSource.Formatdate_arg1, new Object[0])), new FunctionParameter("format", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Formatdate_arg2, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Formatdate_result_description, new Object[0]))));
        this.functions.add(SystemSource.createSyntheticMethod(IFunctionLibrary.FunctionName.FORMATTIME.text(), Messages.getString(Messages.SystemSource.Formattime_description, new Object[0]), "Conversion", null, null, new FunctionParameter[]{new FunctionParameter("time", DataTypeManagerService.DefaultDataTypes.TIME, Messages.getString(Messages.SystemSource.Formattime_arg1, new Object[0])), new FunctionParameter("format", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Formattime_arg2, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Formattime_result_description, new Object[0]))));
    }

    private void addParseTimestampFunction() {
        this.functions.add(new FunctionMethod("parsetimestamp", Messages.getString(Messages.SystemSource.Parsetimestamp_description, new Object[0]), "Conversion", FUNCTION_CLASS, "parseTimestamp", new FunctionParameter[]{new FunctionParameter("timestamp", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Parsetimestamp_arg1, new Object[0])), new FunctionParameter("format", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Parsetimestamp_arg2, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.TIMESTAMP, Messages.getString(Messages.SystemSource.Parsetimestamp_result_description, new Object[0]))));
        this.functions.add(SystemSource.createSyntheticMethod(IFunctionLibrary.FunctionName.PARSETIME.text(), Messages.getString(Messages.SystemSource.Parsetime_description, new Object[0]), "Conversion", null, null, new FunctionParameter[]{new FunctionParameter("time", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Parsetime_arg1, new Object[0])), new FunctionParameter("format", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Parsetime_arg2, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.TIME, Messages.getString(Messages.SystemSource.Parsetime_result_description, new Object[0]))));
        this.functions.add(SystemSource.createSyntheticMethod(IFunctionLibrary.FunctionName.PARSEDATE.text(), Messages.getString(Messages.SystemSource.Parsedate_description, new Object[0]), "Conversion", null, null, new FunctionParameter[]{new FunctionParameter("date", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Parsedate_arg1, new Object[0])), new FunctionParameter("format", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Parsedate_arg2, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.DATE, Messages.getString(Messages.SystemSource.Parsedate_result_description, new Object[0]))));
    }

    private void addFormatNumberFunction(String functionName, String description, String methodName, String inputParam, DataTypeManagerService.DefaultDataTypes dataType, String resultDesc) {
        this.addFormatNumberFunction(functionName, description, methodName, inputParam, dataType.getId(), resultDesc);
    }

    private void addFormatNumberFunction(String functionName, String description, String methodName, String inputParam, String dataType, String resultDesc) {
        this.functions.add(new FunctionMethod(functionName, description, "Conversion", FUNCTION_CLASS, methodName, new FunctionParameter[]{new FunctionParameter(inputParam, dataType, Messages.getString(Messages.SystemSource.Formatnumber_arg1, new Object[0])), new FunctionParameter("format", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Formatnumber_arg2, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.STRING, resultDesc)));
    }

    private void addParseNumberFunction(String functionName, String description, String methodName, String inputParam, DataTypeManagerService.DefaultDataTypes dataType, String resultDesc) {
        this.addParseNumberFunction(functionName, description, methodName, inputParam, dataType.getId(), resultDesc);
    }

    private void addParseNumberFunction(String functionName, String description, String methodName, String inputParam, String dataType, String resultDesc) {
        this.functions.add(new FunctionMethod(functionName, description, "Conversion", FUNCTION_CLASS, methodName, new FunctionParameter[]{new FunctionParameter(inputParam, DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Parsenumber_arg1, new Object[0])), new FunctionParameter("format", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.Parsenumber_arg2, new Object[0]))}, new FunctionParameter("result", dataType, resultDesc)));
    }

    private void addBitFunction(String functionName, String description, String methodName, int parameters, String resultDescription) {
        FunctionParameter[] paramArray = null;
        if (parameters == 1) {
            paramArray = new FunctionParameter[]{new FunctionParameter("integer", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.Bitfunc_arg1, new Object[0]))};
        } else if (parameters == 2) {
            paramArray = new FunctionParameter[]{new FunctionParameter("integer1", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.Bitfunc2_arg1, new Object[0])), new FunctionParameter("integer2", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.Bitfunc2_arg2, new Object[0]))};
        }
        this.functions.add(new FunctionMethod(functionName, description, "Numeric", FUNCTION_CLASS, methodName, paramArray, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.INTEGER, resultDescription)));
    }

    private void addXpathValueFunction() {
        this.functions.add(new FunctionMethod("xpathvalue", Messages.getString(Messages.SystemSource.xpathvalue_description, new Object[0]), "XML", XML_FUNCTION_CLASS, "xpathValue", new FunctionParameter[]{new FunctionParameter("document", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.xpath_param1, new Object[0])), new FunctionParameter("xpath", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.xpath_param2, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.xpathvalue_result, new Object[0]))));
        this.functions.add(new FunctionMethod("xpathvalue", Messages.getString(Messages.SystemSource.xpathvalue_description, new Object[0]), "XML", XML_FUNCTION_CLASS, "xpathValue", new FunctionParameter[]{new FunctionParameter("document", DataTypeManagerService.DefaultDataTypes.CLOB, Messages.getString(Messages.SystemSource.xpath_param1, new Object[0])), new FunctionParameter("xpath", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.xpath_param2, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.xpathvalue_result, new Object[0]))));
        this.functions.add(new FunctionMethod("xpathvalue", Messages.getString(Messages.SystemSource.xpathvalue_description, new Object[0]), "XML", XML_FUNCTION_CLASS, "xpathValue", new FunctionParameter[]{new FunctionParameter("document", DataTypeManagerService.DefaultDataTypes.BLOB, Messages.getString(Messages.SystemSource.xpath_param1, new Object[0])), new FunctionParameter("xpath", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.xpath_param2, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.xpathvalue_result, new Object[0]))));
        this.functions.add(new FunctionMethod("xpathvalue", Messages.getString(Messages.SystemSource.xpathvalue_description, new Object[0]), "XML", XML_FUNCTION_CLASS, "xpathValue", new FunctionParameter[]{new FunctionParameter("document", DataTypeManagerService.DefaultDataTypes.XML, Messages.getString(Messages.SystemSource.xpath_param1, new Object[0])), new FunctionParameter("xpath", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.xpath_param2, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.xpathvalue_result, new Object[0]))));
    }

    private void addXslTransformFunction() {
        for (DataTypeManagerService.DefaultDataTypes type1 : Arrays.asList(DataTypeManagerService.DefaultDataTypes.STRING, DataTypeManagerService.DefaultDataTypes.XML, DataTypeManagerService.DefaultDataTypes.CLOB)) {
            for (DataTypeManagerService.DefaultDataTypes type2 : Arrays.asList(DataTypeManagerService.DefaultDataTypes.STRING, DataTypeManagerService.DefaultDataTypes.XML, DataTypeManagerService.DefaultDataTypes.CLOB)) {
                this.functions.add(new FunctionMethod("xsltransform", Messages.getString(Messages.SystemSource.xsltransform_description, new Object[0]), "XML", XML_FUNCTION_CLASS, "xslTransform", new FunctionParameter[]{new FunctionParameter("document", type1, Messages.getString(Messages.SystemSource.xsltransform_param1, new Object[0])), new FunctionParameter("xsl", type2, Messages.getString(Messages.SystemSource.xsltransform_param2, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.CLOB, Messages.getString(Messages.SystemSource.xsltransform_result, new Object[0]))));
            }
        }
    }

    private void addXmlComment() {
        this.functions.add(new FunctionMethod("xmlcomment", Messages.getString(Messages.SystemSource.xmlcomment_description, new Object[0]), "XML", XML_FUNCTION_CLASS, "xmlComment", new FunctionParameter[]{new FunctionParameter("value", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.xmlcomment_param2, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.XML, Messages.getString(Messages.SystemSource.xmlcomment_result, new Object[0]))));
    }

    private void addXmlPi() {
        this.functions.add(new FunctionMethod("xmlpi", Messages.getString(Messages.SystemSource.xmlpi_description, new Object[0]), "XML", XML_FUNCTION_CLASS, "xmlPi", new FunctionParameter[]{new FunctionParameter("name", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.xmlpi_param1, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.XML, Messages.getString(Messages.SystemSource.xmlpi_result, new Object[0]))));
        this.functions.add(new FunctionMethod("xmlpi", Messages.getString(Messages.SystemSource.xmlpi_description, new Object[0]), "XML", XML_FUNCTION_CLASS, "xmlPi", new FunctionParameter[]{new FunctionParameter("name", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.xmlpi_param1, new Object[0])), new FunctionParameter("value", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.xmlpi_param2, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.XML, Messages.getString(Messages.SystemSource.xmlpi_result, new Object[0]))));
    }

    private void addJsonToXml() {
        this.functions.add(new FunctionMethod("jsontoxml", Messages.getString(Messages.SystemSource.jsonToXml_description, new Object[0]), "XML", XML_FUNCTION_CLASS, "jsonToXml", new FunctionParameter[]{new FunctionParameter("rootElementName", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.jsonToXml_param1, new Object[0])), new FunctionParameter("json", DataTypeManagerService.DefaultDataTypes.CLOB, Messages.getString(Messages.SystemSource.jsonToXml_param2, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.XML, Messages.getString(Messages.SystemSource.jsonToXml_result, new Object[0]))));
        this.functions.add(new FunctionMethod("jsontoxml", Messages.getString(Messages.SystemSource.jsonToXml_description, new Object[0]), "XML", XML_FUNCTION_CLASS, "jsonToXml", new FunctionParameter[]{new FunctionParameter("rootElementName", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.jsonToXml_param1, new Object[0])), new FunctionParameter("json", DataTypeManagerService.DefaultDataTypes.BLOB, Messages.getString(Messages.SystemSource.jsonToXml_param2, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.XML, Messages.getString(Messages.SystemSource.jsonToXml_result, new Object[0]))));
    }

    private void addXmlConcat() {
        this.functions.add(new FunctionMethod("xmlconcat", Messages.getString(Messages.SystemSource.xmlconcat_description, new Object[0]), "XML", FunctionMethod.PushDown.CAN_PUSHDOWN, XML_FUNCTION_CLASS, "xmlConcat", Arrays.asList(new FunctionParameter("param1", DataTypeManagerService.DefaultDataTypes.XML, Messages.getString(Messages.SystemSource.xmlconcat_param1, new Object[0])), new FunctionParameter("param2", DataTypeManagerService.DefaultDataTypes.XML, Messages.getString(Messages.SystemSource.xmlconcat_param2, new Object[0]), true)), new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.XML, Messages.getString(Messages.SystemSource.xmlconcat_result, new Object[0])), false, FunctionMethod.Determinism.DETERMINISTIC));
    }

    private void addTimeZoneFunctions() {
        this.functions.add(new FunctionMethod("modifytimezone", Messages.getString(Messages.SystemSource.modifyTimeZone_description, new Object[0]), "Datetime", FUNCTION_CLASS, "modifyTimeZone", new FunctionParameter[]{new FunctionParameter("timestamp", DataTypeManagerService.DefaultDataTypes.TIMESTAMP, Messages.getString(Messages.SystemSource.modifyTimeZone_param1, new Object[0])), new FunctionParameter("startTimeZone", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.modifyTimeZone_param2, new Object[0])), new FunctionParameter("endTimeZone", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.modifyTimeZone_param3, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.TIMESTAMP, Messages.getString(Messages.SystemSource.modifyTimeZone_result, new Object[0]))));
        this.functions.add(new FunctionMethod("modifytimezone", Messages.getString(Messages.SystemSource.modifyTimeZone_description, new Object[0]), "Datetime", FUNCTION_CLASS, "modifyTimeZone", new FunctionParameter[]{new FunctionParameter("timestamp", DataTypeManagerService.DefaultDataTypes.TIMESTAMP, Messages.getString(Messages.SystemSource.modifyTimeZone_param1, new Object[0])), new FunctionParameter("endTimeZone", DataTypeManagerService.DefaultDataTypes.STRING, Messages.getString(Messages.SystemSource.modifyTimeZone_param3, new Object[0]))}, new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.TIMESTAMP, Messages.getString(Messages.SystemSource.modifyTimeZone_result, new Object[0]))));
    }

    private void addUnixTimeFunctions() {
        this.functions.add(new FunctionMethod(IFunctionLibrary.FunctionName.FROM_UNIXTIME.text(), Messages.getString(Messages.SystemSource.from_unixtime_description, new Object[0]), "Datetime", FunctionMethod.PushDown.SYNTHETIC, null, null, Arrays.asList(new FunctionParameter("unix_timestamp", DataTypeManagerService.DefaultDataTypes.INTEGER, Messages.getString(Messages.SystemSource.from_unixtime_param1, new Object[0]))), new FunctionParameter("result", DataTypeManagerService.DefaultDataTypes.TIMESTAMP, Messages.getString(Messages.SystemSource.from_unixtime_result, new Object[0])), true, FunctionMethod.Determinism.DETERMINISTIC));
    }

    private void addTypedNullIfFunction(String type) {
        this.functions.add(new FunctionMethod(IFunctionLibrary.FunctionName.NULLIF.text(), Messages.getString(Messages.SystemSource.nullif_description, new Object[0]), "Miscellaneous", FunctionMethod.PushDown.SYNTHETIC, null, null, Arrays.asList(new FunctionParameter("op1", type, Messages.getString(Messages.SystemSource.nullif_param1, new Object[0])), new FunctionParameter("op2", type, Messages.getString(Messages.SystemSource.nullif_param1, new Object[0]))), new FunctionParameter("result", type, Messages.getString(Messages.SystemSource.nullif_result, new Object[0])), false, FunctionMethod.Determinism.DETERMINISTIC));
    }

    private void addTypedCoalesceFunction(String type) {
        this.functions.add(new FunctionMethod(IFunctionLibrary.FunctionName.COALESCE.text(), Messages.getString(Messages.SystemSource.coalesce_description, new Object[0]), "Miscellaneous", FunctionMethod.PushDown.CAN_PUSHDOWN, FUNCTION_CLASS, "coalesce", Arrays.asList(new FunctionParameter("op1", type, Messages.getString(Messages.SystemSource.coalesce_param1, new Object[0])), new FunctionParameter("op2", type, Messages.getString(Messages.SystemSource.coalesce_param1, new Object[0])), new FunctionParameter("op3", type, Messages.getString(Messages.SystemSource.coalesce_param1, new Object[0]), true)), new FunctionParameter("result", type, Messages.getString(Messages.SystemSource.coalesce_result, new Object[0])), false, FunctionMethod.Determinism.DETERMINISTIC));
    }

    @Override
    public Collection<FunctionMethod> getFunctionMethods() {
        return this.functions;
    }

    public static FunctionMethod createSyntheticMethod(String name, String description, String category, String invocationClass, String invocationMethod, FunctionParameter[] inputParams, FunctionParameter outputParam) {
        return new FunctionMethod(name, description, category, FunctionMethod.PushDown.SYNTHETIC, invocationClass, invocationMethod, inputParams != null ? Arrays.asList(inputParams) : null, outputParam, false, FunctionMethod.Determinism.NONDETERMINISTIC);
    }
}

