/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.core.types.Transform;
import org.teiid.designer.query.sql.symbol.IAggregateSymbol;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.designer.udf.IFunctionLibrary;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.AggregateAttributes;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.FunctionParameter;
import org.teiid.query.function.FunctionDescriptor;
import org.teiid.query.function.FunctionForm;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Function;

public class FunctionLibrary
implements IFunctionLibrary<FunctionForm, FunctionDescriptor> {
    public static final String MVSTATUS = "mvstatus";
    public static final Set<String> INTERNAL_SCHEMAS = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private FunctionTree systemFunctions;
    private FunctionTree[] userFunctions;
    private final ITeiidServerVersion teiidVersion;
    private DataTypeManagerService dataTypeManager;

    static {
        INTERNAL_SCHEMAS.add("SYS");
        INTERNAL_SCHEMAS.add("SYSADMIN");
        INTERNAL_SCHEMAS.add("pg_catalog");
    }

    public FunctionLibrary(ITeiidServerVersion teiidVersion, FunctionTree systemFuncs, FunctionTree ... userFuncs) {
        this.teiidVersion = teiidVersion;
        this.systemFunctions = systemFuncs;
        this.userFunctions = userFuncs;
    }

    public ITeiidServerVersion getTeiidVersion() {
        return this.teiidVersion;
    }

    public DataTypeManagerService getDataTypeManager() {
        if (this.dataTypeManager == null) {
            this.dataTypeManager = DataTypeManagerService.getInstance(this.getTeiidVersion());
        }
        return this.dataTypeManager;
    }

    public FunctionTree[] getUserFunctions() {
        return this.userFunctions;
    }

    public List<String> getFunctionCategories() {
        TreeSet<String> categories = new TreeSet<String>();
        categories.addAll(this.systemFunctions.getCategories());
        if (this.userFunctions != null) {
            FunctionTree[] functionTreeArray = this.userFunctions;
            int n = this.userFunctions.length;
            int n2 = 0;
            while (n2 < n) {
                FunctionTree tree = functionTreeArray[n2];
                categories.addAll(tree.getCategories());
                ++n2;
            }
        }
        ArrayList<String> categoryList = new ArrayList<String>(categories);
        return categoryList;
    }

    public List<FunctionMethod> getFunctionsInCategory(String category) {
        ArrayList<FunctionMethod> forms = new ArrayList<FunctionMethod>();
        forms.addAll(this.systemFunctions.getFunctionsInCategory(category));
        if (this.userFunctions != null) {
            FunctionTree[] functionTreeArray = this.userFunctions;
            int n = this.userFunctions.length;
            int n2 = 0;
            while (n2 < n) {
                FunctionTree tree = functionTreeArray[n2];
                forms.addAll(tree.getFunctionsInCategory(category));
                ++n2;
            }
        }
        return forms;
    }

    public List<FunctionForm> getFunctionForms(String category) {
        Set<FunctionMethod> fMethods = this.systemFunctions.getFunctionsInCategory(category);
        FunctionTree[] functionTreeArray = this.userFunctions;
        int n = this.userFunctions.length;
        int n2 = 0;
        while (n2 < n) {
            FunctionTree tree = functionTreeArray[n2];
            fMethods.addAll(tree.getFunctionsInCategory(category));
            ++n2;
        }
        ArrayList<FunctionForm> forms = new ArrayList<FunctionForm>();
        if (fMethods != null) {
            for (FunctionMethod fMethod : fMethods) {
                forms.add(new FunctionForm(fMethod));
            }
        }
        return forms;
    }

    public FunctionForm findFunctionForm(String name, int numArgs) {
        List<FunctionMethod> functionMethods = this.systemFunctions.findFunctionMethods(name, numArgs);
        if (functionMethods.size() > 0) {
            return new FunctionForm(functionMethods.get(0));
        }
        if (functionMethods.isEmpty() && this.userFunctions != null) {
            FunctionTree[] functionTreeArray = this.userFunctions;
            int n = this.userFunctions.length;
            int n2 = 0;
            while (n2 < n) {
                FunctionTree tree = functionTreeArray[n2];
                functionMethods = tree.findFunctionMethods(name, numArgs);
                if (functionMethods.size() > 0) {
                    return new FunctionForm(functionMethods.get(0));
                }
                ++n2;
            }
        }
        return null;
    }

    public boolean hasFunctionMethod(String name, int numArgs) {
        List<FunctionMethod> methods = this.systemFunctions.findFunctionMethods(name, numArgs);
        if (!methods.isEmpty()) {
            return true;
        }
        if (this.userFunctions != null) {
            FunctionTree[] functionTreeArray = this.userFunctions;
            int n = this.userFunctions.length;
            int n2 = 0;
            while (n2 < n) {
                FunctionTree tree = functionTreeArray[n2];
                methods = tree.findFunctionMethods(name, numArgs);
                if (!methods.isEmpty()) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public FunctionDescriptor findFunction(IFunctionLibrary.FunctionName name, Class[] types) {
        return this.findFunction(name.text(), types);
    }

    public FunctionDescriptor findFunction(String name, Class[] types) {
        FunctionDescriptor descriptor = this.systemFunctions.getFunction(name, types);
        if (descriptor == null && this.userFunctions != null) {
            FunctionTree[] functionTreeArray = this.userFunctions;
            int n = this.userFunctions.length;
            int n2 = 0;
            while (n2 < n) {
                FunctionTree tree = functionTreeArray[n2];
                descriptor = tree.getFunction(name, types);
                if (descriptor != null) break;
                ++n2;
            }
        }
        return descriptor;
    }

    public List<FunctionDescriptor> findAllFunctions(String name, Class<?>[] types) {
        FunctionDescriptor descriptor = this.systemFunctions.getFunction(name, types);
        if (descriptor == null && this.userFunctions != null) {
            LinkedList<FunctionDescriptor> result = new LinkedList<FunctionDescriptor>();
            FunctionTree[] functionTreeArray = this.userFunctions;
            int n = this.userFunctions.length;
            int n2 = 0;
            while (n2 < n) {
                FunctionTree tree = functionTreeArray[n2];
                descriptor = tree.getFunction(name, types);
                if (descriptor != null) {
                    if (this.teiidVersion.isGreaterThanOrEqualTo(TeiidServerVersion.Version.TEIID_8_7.get()) ? "SYS".equals(descriptor.getSchema()) : descriptor.getMethod().getParent() == null || "SYS".equals(descriptor.getMethod().getParent().getName())) {
                        return Arrays.asList(descriptor);
                    }
                    result.add(descriptor);
                }
                ++n2;
            }
            return result;
        }
        if (descriptor != null) {
            return Arrays.asList(descriptor);
        }
        return Collections.emptyList();
    }

    public FunctionDescriptor[] determineNecessaryConversions(String name, Class<?> returnType, Expression[] args, Class<?>[] types, boolean hasUnknownType) throws Exception {
        if (types.length == 0) {
            if (this.getTeiidVersion().isLessThan(TeiidServerVersion.Version.TEIID_8_0.get())) {
                return new FunctionDescriptor[0];
            }
            return null;
        }
        LinkedList<FunctionMethod> functionMethods = new LinkedList<FunctionMethod>();
        functionMethods.addAll(this.systemFunctions.findFunctionMethods(name, types.length));
        if (this.userFunctions != null) {
            FunctionTree[] functionTreeArray = this.userFunctions;
            int n = this.userFunctions.length;
            int n2 = 0;
            while (n2 < n) {
                FunctionTree tree = functionTreeArray[n2];
                functionMethods.addAll(tree.findFunctionMethods(name, types.length));
                ++n2;
            }
        }
        int bestScore = Integer.MAX_VALUE;
        boolean ambiguous = false;
        AbstractMetadataRecord result = null;
        boolean isSystem = false;
        boolean narrowing = false;
        block5: for (FunctionMethod nextMethod : functionMethods) {
            boolean isSystemNext;
            int currentScore = 0;
            boolean nextNarrowing = false;
            List<FunctionParameter> methodTypes = nextMethod.getInputParameters();
            int i = 0;
            while (i < types.length) {
                block32: {
                    Class<?> sourceType;
                    Class<?> targetType;
                    String tmpTypeName;
                    block35: {
                        block34: {
                            block33: {
                                tmpTypeName = methodTypes.get(Math.min(i, methodTypes.size() - 1)).getType();
                                targetType = this.getDataTypeManager().getDataTypeClass(tmpTypeName);
                                sourceType = types[i];
                                if (sourceType != null) break block33;
                                ++currentScore;
                                break block32;
                            }
                            if (!sourceType.isArray() || !targetType.isArray() || !sourceType.getComponentType().equals(targetType.getComponentType())) break block34;
                            ++currentScore;
                            break block32;
                        }
                        if (!sourceType.isArray()) break block35;
                        if (this.isVarArgArrayParam(nextMethod, types, i, targetType)) break block32;
                        sourceType = DataTypeManagerService.DefaultDataTypes.OBJECT.getTypeClass();
                    }
                    try {
                        Transform t = this.getConvertFunctionDescriptor(sourceType, targetType);
                        if (t == null) break block32;
                        if (t.isExplicit()) {
                            if (!(args[i] instanceof Constant) || ResolverUtil.convertConstant(this.getDataTypeManager().getDataTypeName(sourceType), tmpTypeName, (Constant)args[i]) == null) continue block5;
                            nextNarrowing = true;
                            ++currentScore;
                        } else {
                            ++currentScore;
                        }
                    }
                    catch (Exception exception) {
                        continue block5;
                    }
                }
                ++i;
            }
            if (currentScore > bestScore) continue;
            if (hasUnknownType && returnType != null) {
                try {
                    Transform t = this.getConvertFunctionDescriptor(this.getDataTypeManager().getDataTypeClass(nextMethod.getOutputParameter().getType()), returnType);
                    if (t != null) {
                        if (t.isExplicit()) {
                            currentScore += types.length + 1;
                            nextNarrowing = true;
                        } else {
                            ++currentScore;
                        }
                    }
                }
                catch (Exception exception) {
                    currentScore += types.length * types.length;
                }
            }
            if (nextNarrowing && result != null && !narrowing) continue;
            boolean useNext = false;
            if (!nextNarrowing && narrowing) {
                useNext = true;
            }
            boolean bl = isSystemNext = nextMethod.getParent() == null || INTERNAL_SCHEMAS.contains(nextMethod.getParent().getName());
            if (isSystem && isSystemNext || !isSystem && !isSystemNext && result != null) {
                int nextPartCount;
                int partCount = this.partCount(result.getName());
                if (partCount < (nextPartCount = this.partCount(nextMethod.getName()))) continue;
                if (nextPartCount < partCount) {
                    useNext = true;
                }
            } else if (isSystemNext) {
                useNext = true;
            }
            if (currentScore == bestScore && !useNext) {
                ambiguous = true;
                boolean useCurrent = false;
                List<FunctionParameter> bestParams = ((FunctionMethod)result).getInputParameters();
                int j = 0;
                while (j < types.length) {
                    String t1 = bestParams.get(Math.min(j, bestParams.size() - 1)).getType();
                    String t2 = methodTypes.get(Math.min(j, methodTypes.size() - 1)).getType();
                    if (types[j] != null && !t1.equals(t2)) {
                        String commonType = ResolverUtil.getCommonType(this.teiidVersion, new String[]{t1, t2});
                        if (commonType == null) continue block5;
                        if (commonType.equals(t1)) {
                            if (!useCurrent) {
                                useNext = true;
                            }
                        } else {
                            if (!commonType.equals(t2)) continue block5;
                            if (!useNext) {
                                useCurrent = true;
                            }
                        }
                    }
                    ++j;
                }
                if (useCurrent) {
                    ambiguous = false;
                }
            }
            if (currentScore >= bestScore && !useNext) continue;
            ambiguous = false;
            if (currentScore == 0 && isSystemNext) {
                return null;
            }
            bestScore = currentScore;
            result = nextMethod;
            isSystem = isSystemNext;
            narrowing = nextNarrowing;
        }
        if (ambiguous || result == null) {
            throw new Exception();
        }
        return this.getConverts((FunctionMethod)result, types);
    }

    private int partCount(String name) {
        int result = 0;
        int index = 0;
        while ((index = name.indexOf(46, index + 1)) > 0) {
            ++result;
        }
        return result;
    }

    private FunctionDescriptor[] getConverts(FunctionMethod method, Class<?>[] types) {
        List<FunctionParameter> methodTypes = method.getInputParameters();
        FunctionDescriptor[] result = new FunctionDescriptor[types.length];
        int i = 0;
        while (i < types.length) {
            String tmpTypeName = methodTypes.get(Math.min(i, methodTypes.size() - 1)).getType();
            Class<?> targetType = this.getDataTypeManager().getDataTypeClass(tmpTypeName);
            Class<?> sourceType = types[i];
            if (sourceType == null) {
                result[i] = this.findTypedConversionFunction(DataTypeManagerService.DefaultDataTypes.NULL.getTypeClass(), targetType);
            } else if (sourceType != targetType && !this.isVarArgArrayParam(method, types, i, targetType)) {
                result[i] = this.findTypedConversionFunction(sourceType, targetType);
            }
            ++i;
        }
        return result;
    }

    public boolean isVarArgArrayParam(FunctionMethod method, Class<?>[] types, int i, Class<?> targetType) {
        return i == types.length - 1 && method.isVarArgs() && i == method.getInputParameterCount() - 1 && types[i].isArray() && targetType.isAssignableFrom(types[i].getComponentType());
    }

    private Transform getConvertFunctionDescriptor(Class<?> sourceType, Class<?> targetType) throws Exception {
        if (sourceType.equals(targetType)) {
            return null;
        }
        Transform result = this.getDataTypeManager().getTransform(sourceType, targetType);
        if (result == null) {
            throw new Exception();
        }
        if (this.teiidVersion.isLessThan(TeiidServerVersion.Version.TEIID_8_0.get()) && result.isExplicit()) {
            throw new Exception();
        }
        return result;
    }

    public FunctionDescriptor findTypedConversionFunction(Class<?> sourceType, Class<?> targetType) {
        FunctionDescriptor fd = this.findFunction(IFunctionLibrary.FunctionName.CONVERT, new Class[]{sourceType, DataTypeManagerService.DefaultDataTypes.STRING.getTypeClass()});
        if (fd != null) {
            return this.copyFunctionChangeReturnType(fd, targetType);
        }
        return null;
    }

    public FunctionDescriptor copyFunctionChangeReturnType(FunctionDescriptor fd, Class<?> returnType) {
        if (fd != null) {
            FunctionDescriptor fdImpl = fd;
            FunctionDescriptor copy = fdImpl.clone();
            copy.setReturnType(returnType);
            return copy;
        }
        return fd;
    }

    public static boolean isConvert(Function function) {
        Expression[] args = function.getArgs();
        String funcName = function.getName();
        return args.length == 2 && (IFunctionLibrary.FunctionName.CONVERT.equalsIgnoreCase(funcName) || IFunctionLibrary.FunctionName.CAST.equalsIgnoreCase(funcName));
    }

    public String getFunctionName(IFunctionLibrary.FunctionName functionName) {
        if (functionName == null) {
            throw new IllegalArgumentException();
        }
        return functionName.text();
    }

    /*
     * Enabled aggressive block sorting
     */
    public List<FunctionMethod> getBuiltInAggregateFunctions(boolean includeAnalytic) {
        ArrayList<FunctionMethod> result = new ArrayList<FunctionMethod>();
        IAggregateSymbol.Type[] typeArray = IAggregateSymbol.Type.values();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            block14: {
                IAggregateSymbol.Type type = typeArray[n2];
                AggregateAttributes aa = new AggregateAttributes();
                String returnType = null;
                String[] argTypes = null;
                aa.setAllowsDistinct(true);
                switch (type) {
                    case USER_DEFINED: {
                        break block14;
                    }
                    case RANK: 
                    case DENSE_RANK: 
                    case ROW_NUMBER: {
                        if (includeAnalytic) {
                            aa.setAllowsDistinct(false);
                            aa.setAnalytic(true);
                            returnType = DataTypeManagerService.DefaultDataTypes.INTEGER.getId();
                            argTypes = new String[]{};
                            break;
                        }
                        break block14;
                    }
                    case ANY: 
                    case SOME: 
                    case EVERY: {
                        returnType = DataTypeManagerService.DefaultDataTypes.BOOLEAN.getId();
                        argTypes = new String[]{DataTypeManagerService.DefaultDataTypes.BOOLEAN.getId()};
                        break;
                    }
                    case COUNT: {
                        returnType = DataTypeManagerService.DefaultDataTypes.INTEGER.getId();
                        argTypes = new String[]{DataTypeManagerService.DefaultDataTypes.OBJECT.getId()};
                        break;
                    }
                    case SUM: 
                    case AVG: 
                    case MIN: 
                    case MAX: {
                        returnType = DataTypeManagerService.DefaultDataTypes.OBJECT.getId();
                        argTypes = new String[]{DataTypeManagerService.DefaultDataTypes.OBJECT.getId()};
                        break;
                    }
                    case STDDEV_POP: 
                    case STDDEV_SAMP: 
                    case VAR_POP: 
                    case VAR_SAMP: {
                        returnType = DataTypeManagerService.DefaultDataTypes.DOUBLE.getId();
                        argTypes = new String[]{DataTypeManagerService.DefaultDataTypes.DOUBLE.getId()};
                        break;
                    }
                    case STRING_AGG: {
                        returnType = DataTypeManagerService.DefaultDataTypes.OBJECT.getId();
                        argTypes = new String[]{DataTypeManagerService.DefaultDataTypes.OBJECT.getId()};
                        aa.setAllowsOrderBy(true);
                        break;
                    }
                    case ARRAY_AGG: {
                        returnType = DataTypeManagerService.DefaultDataTypes.OBJECT.getId();
                        argTypes = new String[]{this.getDataTypeManager().getDataTypeName(DataTypeManagerService.DefaultDataTypes.OBJECT.getTypeArrayClass())};
                        aa.setAllowsOrderBy(true);
                        aa.setAllowsDistinct(false);
                        break;
                    }
                    case JSONARRAY_AGG: {
                        returnType = DataTypeManagerService.DefaultDataTypes.CLOB.getId();
                        argTypes = new String[]{DataTypeManagerService.DefaultDataTypes.OBJECT.getId()};
                        aa.setAllowsOrderBy(true);
                        aa.setAllowsDistinct(false);
                        break;
                    }
                    case XMLAGG: {
                        returnType = DataTypeManagerService.DefaultDataTypes.XML.getId();
                        argTypes = new String[]{DataTypeManagerService.DefaultDataTypes.XML.getId()};
                        aa.setAllowsOrderBy(true);
                        aa.setAllowsDistinct(false);
                    }
                }
                FunctionMethod fm = FunctionMethod.createFunctionMethod(type.name(), type.name(), "Aggregatee", returnType, argTypes);
                fm.setAggregateAttributes(aa);
                result.add(fm);
            }
            ++n2;
        }
        return result;
    }
}

