/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.teiid.client.DQP;
import org.teiid.client.RequestMessage;
import org.teiid.client.ResultsMessage;
import org.teiid.client.metadata.ParameterInfo;
import org.teiid.client.metadata.ResultsMetadataConstants;
import org.teiid.client.plan.Annotation;
import org.teiid.client.plan.PlanNode;
import org.teiid.client.util.ResultsFuture;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.core.types.JDBCSQLTypeInfo;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.core.util.StringUtil;
import org.teiid.designer.query.sql.lang.ISPParameter;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.DataTypeTransformer;
import org.teiid.jdbc.EnhancedTimer;
import org.teiid.jdbc.MetadataProvider;
import org.teiid.jdbc.NonBlockingRowProcessor;
import org.teiid.jdbc.RequestOptions;
import org.teiid.jdbc.ResultSetImpl;
import org.teiid.jdbc.ResultSetMetaDataImpl;
import org.teiid.jdbc.StatementCallback;
import org.teiid.jdbc.TeiidStatement;
import org.teiid.jdbc.WarningUtil;
import org.teiid.jdbc.WrapperImpl;
import org.teiid.runtime.client.Messages;
import org.teiid.runtime.client.TeiidRuntimePlugin;

public class StatementImpl
extends WrapperImpl
implements TeiidStatement {
    private static Logger logger = Logger.getLogger("org.teiid.jdbc");
    static EnhancedTimer cancellationTimer = new EnhancedTimer("Teiid Statement Timeout");
    public static final String USE_CALLING_THREAD = "useCallingThread";
    protected static final int NO_TIMEOUT = 0;
    private static final int NO_LIMIT = 0;
    private QueryTimeoutCancelTask cancelTask = new QueryTimeoutCancelTask(this);
    private ConnectionImpl driverConnection;
    private Properties execProps;
    private int fetchSize = 2048;
    private int fetchDirection = 1000;
    private int resultSetType = 1003;
    private int resultSetConcurrency = 1007;
    private boolean isClosed = false;
    protected volatile State commandStatus = State.RUNNING;
    protected long queryTimeoutMS = 0L;
    protected long currentRequestID = -1L;
    private PlanNode currentPlanDescription;
    private String debugLog;
    private Collection<Annotation> annotations;
    protected volatile ResultSetImpl resultSet;
    private List<Throwable> serverWarnings;
    private Serializable payload;
    private List<String> batchedUpdates;
    protected int[] updateCounts;
    private Calendar defaultCalendar;
    private int maxRows = 0;
    private int maxFieldSize = 0;
    protected Map<Integer, Integer> outParamIndexMap = new HashMap<Integer, Integer>();
    protected Map<String, Integer> outParamByName = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
    static Pattern TRANSACTION_STATEMENT = Pattern.compile("\\s*(commit|rollback|(start\\s+transaction))\\s*;?\\s*", 2);
    static Pattern SET_STATEMENT = Pattern.compile("\\s*set(?:\\s+(payload))?\\s+((?:session authorization)|(?:[a-zA-Z]\\w*))\\s+(?:to\\s+)?((?:[^\\s]*)|(?:'[^']*')+)\\s*;?\\s*", 2);
    static Pattern SHOW_STATEMENT = Pattern.compile("\\s*show\\s+([a-zA-Z]\\w*)\\s*;?\\s*?", 2);

    StatementImpl(ConnectionImpl driverConnection, int resultSetType, int resultSetConcurrency) {
        this.driverConnection = driverConnection;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.execProps = new Properties(this.driverConnection.getExecutionProperties());
        String fetchSizeStr = this.execProps.getProperty("fetchSize");
        if (fetchSizeStr != null) {
            try {
                this.fetchSize = Integer.parseInt(fetchSizeStr);
            }
            catch (Exception exception) {}
        }
        this.setTimeoutFromProperties();
    }

    protected ITeiidServerVersion getTeiidVersion() {
        return this.driverConnection.getTeiidVersion();
    }

    protected boolean isLessThanTeiidEight() {
        ITeiidServerVersion minVersion = this.getTeiidVersion().getMinimumVersion();
        return minVersion.isLessThan(TeiidServerVersion.Version.TEIID_8_0.get());
    }

    protected boolean isGreaterThanTeiidSeven() {
        ITeiidServerVersion minVersion = this.getTeiidVersion().getMinimumVersion();
        return minVersion.isGreaterThan(TeiidServerVersion.Version.TEIID_7_7.get());
    }

    protected void checkSupportedVersion(TeiidServerVersion.Version teiidVersion) {
        ITeiidServerVersion minVersion = this.getTeiidVersion().getMinimumVersion();
        if (minVersion.isLessThan(teiidVersion.get())) {
            TeiidRuntimePlugin.logError("StatementImpl.checkSupportedVersion", "Method being executed that is not supported in teiid version " + this.getTeiidVersion());
            throw new UnsupportedOperationException();
        }
    }

    protected DataTypeManagerService getDataTypeManager() {
        return DataTypeManagerService.getInstance(this.driverConnection.getTeiidVersion());
    }

    private void setTimeoutFromProperties() {
        String queryTimeoutStr = this.execProps.getProperty("QUERYTIMEOUT");
        if (queryTimeoutStr != null) {
            try {
                this.queryTimeoutMS = Integer.parseInt(queryTimeoutStr) * 1000;
            }
            catch (Exception exception) {}
        }
    }

    protected DQP getDQP() {
        return this.driverConnection.getDQP();
    }

    protected ConnectionImpl getMMConnection() {
        return this.driverConnection;
    }

    protected TimeZone getServerTimeZone() throws SQLException {
        return this.driverConnection.getServerConnection().getLogonResult().getTimeZone();
    }

    protected synchronized void resetExecutionState() throws SQLException {
        this.currentRequestID = -1L;
        this.currentPlanDescription = null;
        this.debugLog = null;
        this.annotations = null;
        if (this.resultSet != null) {
            this.resultSet.close();
            this.resultSet = null;
        }
        this.serverWarnings = null;
        this.batchedUpdates = null;
        this.updateCounts = null;
        this.outParamIndexMap.clear();
        this.outParamByName.clear();
        this.commandStatus = State.RUNNING;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.checkStatement();
        if (this.batchedUpdates == null) {
            this.batchedUpdates = new ArrayList<String>();
        }
        this.batchedUpdates.add(sql);
    }

    @Override
    public synchronized void cancel() throws SQLException {
        this.commandStatus = State.CANCELLED;
        this.cancelRequest();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkStatement();
        this.serverWarnings = null;
    }

    @Override
    public void clearBatch() throws SQLException {
        if (this.batchedUpdates != null) {
            this.batchedUpdates.clear();
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        if (this.resultSet != null) {
            this.resultSet.close();
            this.resultSet = null;
        }
        this.isClosed = true;
        this.driverConnection.closeStatement(this);
        logger.fine(Messages.getString(Messages.JDBC.MMStatement_Close_stmt_success, new Object[0]));
    }

    protected void checkStatement() throws SQLException {
        if (this.isClosed) {
            throw new SQLException(Messages.getString(Messages.JDBC.MMStatement_Stmt_closed, new Object[0]));
        }
    }

    @Override
    public void submitExecute(String sql, StatementCallback callback, RequestOptions options) throws SQLException {
        NonBlockingRowProcessor processor = new NonBlockingRowProcessor(this, callback);
        this.submitExecute(sql, options).addCompletionListener(processor);
    }

    public ResultsFuture<Boolean> submitExecute(String sql, RequestOptions options) throws SQLException {
        return this.executeSql(new String[]{sql}, false, RequestMessage.ResultsMode.EITHER, false, options);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        if (this.isLessThanTeiidEight()) {
            this.executeSql(new String[]{sql}, false, RequestMessage.ResultsMode.EITHER, true, null);
            return this.hasResultSet();
        }
        return this.execute(sql, 2);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        if (this.batchedUpdates == null || this.batchedUpdates.isEmpty()) {
            return new int[0];
        }
        String[] commands = this.batchedUpdates.toArray(new String[this.batchedUpdates.size()]);
        this.executeSql(commands, true, RequestMessage.ResultsMode.UPDATECOUNT, true, null);
        return this.updateCounts;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.executeSql(new String[]{sql}, false, RequestMessage.ResultsMode.RESULTSET, true, null);
        return this.resultSet;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return this.executeUpdate(sql, 2);
    }

    protected boolean hasResultSet() throws SQLException {
        return this.updateCounts == null && this.resultSet != null && this.resultSet.getMetaData().getColumnCount() > 0;
    }

    protected void createResultSet(ResultsMessage resultsMsg) throws SQLException {
        List listOfParameters = resultsMsg.getParameters();
        if (listOfParameters != null) {
            int resultIndex;
            int resultSetSize = 0;
            for (ParameterInfo parameter : listOfParameters) {
                if (parameter.getType() != ISPParameter.ParameterInfo.RESULT_SET.index()) continue;
                resultSetSize = parameter.getNumColumns();
                break;
            }
            int index = 0;
            int count = 0;
            for (ParameterInfo parameter : listOfParameters) {
                if (parameter.getType() != ISPParameter.ParameterInfo.RETURN_VALUE.index()) continue;
                resultIndex = resultSetSize + ++count;
                this.outParamIndexMap.put(++index, resultIndex);
                this.outParamByName.put(resultsMsg.getColumnNames()[resultIndex - 1].toUpperCase(), resultIndex);
                break;
            }
            for (ParameterInfo parameter : listOfParameters) {
                if (parameter.getType() == ISPParameter.ParameterInfo.RETURN_VALUE.index() || parameter.getType() == ISPParameter.ParameterInfo.RESULT_SET.index()) continue;
                ++index;
                if (parameter.getType() != ISPParameter.ParameterInfo.OUT.index() && parameter.getType() != ISPParameter.ParameterInfo.INOUT.index()) continue;
                resultIndex = resultSetSize + ++count;
                this.outParamIndexMap.put(index, resultIndex);
                this.outParamByName.put(resultsMsg.getColumnNames()[resultIndex - 1].toUpperCase(), resultIndex);
            }
        }
        this.resultSet = new ResultSetImpl(resultsMsg, this, null, this.outParamIndexMap.size());
        this.resultSet.setMaxFieldSize(this.maxFieldSize);
    }

    protected ResultsFuture<Boolean> executeSql(String[] commands, boolean isBatchedCommand, RequestMessage.ResultsMode resultsMode, boolean synch, RequestOptions options) throws SQLException {
        return this.executeSql(commands, isBatchedCommand, resultsMode, synch, options, false);
    }

    protected ResultsFuture<Boolean> executeSql(String[] commands, boolean isBatchedCommand, RequestMessage.ResultsMode resultsMode, boolean synch, RequestOptions options, boolean autoGenerateKeys) throws SQLException {
        this.checkStatement();
        this.resetExecutionState();
        if (options != null && options.isContinuous()) {
            if (!this.driverConnection.getServerConnection().supportsContinuous()) {
                throw new SQLException(Messages.getString(Messages.JDBC.continuous, new Object[0]));
            }
            if (this.getResultSetType() != 1003) {
                String msg = Messages.getString(Messages.JDBC.forward_only_resultset, new Object[0]);
                throw new SQLException(msg);
            }
            if (resultsMode == RequestMessage.ResultsMode.EITHER) {
                resultsMode = RequestMessage.ResultsMode.RESULTSET;
            } else if (resultsMode == RequestMessage.ResultsMode.UPDATECOUNT) {
                String msg = Messages.getString(Messages.JDBC.forward_only_resultset, new Object[0]);
                throw new SQLException(msg);
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Executing: requestID " + this.getCurrentRequestID() + " commands: " + Arrays.toString(commands) + " expecting: " + (Object)((Object)resultsMode));
        }
        if (commands.length == 1) {
            Matcher match = SET_STATEMENT.matcher(commands[0]);
            if (match.matches()) {
                if (resultsMode == RequestMessage.ResultsMode.RESULTSET) {
                    throw new SQLException(Messages.getString(Messages.JDBC.StatementImpl_set_result_set, new Object[0]));
                }
                String key = match.group(2);
                String value = match.group(3);
                if (value != null && value.startsWith("'") && value.endsWith("'")) {
                    value = value.substring(1, value.length() - 1);
                    value = StringUtil.replaceAll(value, "''", "'");
                }
                if (match.group(1) != null) {
                    Properties p = this.getMMConnection().getPayload();
                    if (p == null) {
                        p = new Properties();
                        this.getMMConnection().setPayload(p);
                    }
                    p.setProperty(key, value);
                } else if ("SESSION AUTHORIZATION".equalsIgnoreCase(key)) {
                    this.getMMConnection().changeUser(value, this.getMMConnection().getPassword());
                } else if (key.equalsIgnoreCase("password")) {
                    this.getMMConnection().setPassword(value);
                } else if ("NEWINSTANCE".equalsIgnoreCase(key)) {
                    if (Boolean.valueOf(value).booleanValue()) {
                        this.getMMConnection().getServerConnection().cleanUp();
                    }
                } else {
                    this.driverConnection.setExecutionProperty(key, value);
                }
                this.updateCounts = new int[1];
                return StatementImpl.booleanFuture(false);
            }
            match = TRANSACTION_STATEMENT.matcher(commands[0]);
            if (match.matches()) {
                logger.finer("Executing as transaction statement");
                if (resultsMode == RequestMessage.ResultsMode.RESULTSET) {
                    throw new SQLException(Messages.getString(Messages.JDBC.StatementImpl_set_result_set, new Object[0]));
                }
                String command = match.group(1);
                Boolean commit = null;
                if (StringUtil.startsWithIgnoreCase(command, "start")) {
                    this.getConnection().setAutoCommit(false);
                } else if (command.equalsIgnoreCase("commit")) {
                    commit = true;
                    if (synch) {
                        this.getConnection().setAutoCommit(true);
                    }
                } else if (command.equalsIgnoreCase("rollback")) {
                    commit = false;
                    if (synch) {
                        this.getConnection().rollback(false);
                    }
                }
                this.updateCounts = new int[1];
                if (commit != null && !synch) {
                    ResultsFuture<?> pending = this.getConnection().submitSetAutoCommitTrue(commit);
                    final ResultsFuture<Boolean> result = new ResultsFuture<Boolean>();
                    pending.addCompletionListener(new ResultsFuture.CompletionListener(){

                        public void onCompletion(ResultsFuture future) {
                            try {
                                future.get();
                                result.getResultsReceiver().receiveResults(false);
                            }
                            catch (Throwable t) {
                                result.getResultsReceiver().exceptionOccurred(t);
                            }
                        }
                    });
                    return result;
                }
                return StatementImpl.booleanFuture(false);
            }
            match = SHOW_STATEMENT.matcher(commands[0]);
            if (match.matches()) {
                logger.finer("Executing as show statement");
                if (resultsMode == RequestMessage.ResultsMode.UPDATECOUNT) {
                    throw new SQLException(Messages.getString(Messages.JDBC.StatementImpl_show_update_count, new Object[0]));
                }
                return this.executeShow(match);
            }
        }
        final RequestMessage reqMessage = this.createRequestMessage(commands, isBatchedCommand, resultsMode);
        reqMessage.setReturnAutoGeneratedKeys(autoGenerateKeys);
        reqMessage.setRequestOptions(options);
        ResultsFuture<ResultsMessage> pendingResult = this.execute(reqMessage, synch);
        final ResultsFuture<Boolean> result = new ResultsFuture<Boolean>();
        pendingResult.addCompletionListener(new ResultsFuture.CompletionListener<ResultsMessage>(){

            @Override
            public void onCompletion(ResultsFuture<ResultsMessage> future) {
                try {
                    StatementImpl.this.postReceiveResults(reqMessage, future.get());
                    result.getResultsReceiver().receiveResults(StatementImpl.this.hasResultSet());
                }
                catch (Throwable t) {
                    result.getResultsReceiver().exceptionOccurred(t);
                }
            }
        });
        if (synch) {
            try {
                pendingResult.get(this.queryTimeoutMS == 0L ? Integer.MAX_VALUE : this.queryTimeoutMS, TimeUnit.MILLISECONDS);
                result.get();
                return result;
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof SQLException) {
                    throw (SQLException)e.getCause();
                }
                if (e.getCause() != null) {
                    throw new SQLException(e.getCause());
                }
                throw new SQLException(e);
            }
            catch (InterruptedException interruptedException) {
                this.timeoutOccurred();
            }
            catch (TimeoutException timeoutException) {
                this.timeoutOccurred();
            }
            throw new SQLException(Messages.getString(Messages.JDBC.MMStatement_Timeout_before_complete, new Object[0]));
        }
        return result;
    }

    ResultsFuture<Boolean> executeShow(Matcher match) throws SQLException {
        String show = match.group(1);
        if (show.equalsIgnoreCase("PLAN")) {
            ArrayList records = new ArrayList(1);
            PlanNode plan = this.driverConnection.getCurrentPlanDescription();
            String connDebugLog = this.driverConnection.getDebugLog();
            if (plan != null || connDebugLog != null) {
                ArrayList<Object> row = new ArrayList<Object>(3);
                if (plan != null) {
                    row.add(DataTypeTransformer.getClob(this.getTeiidVersion(), plan.toString()));
                    row.add(new SQLXMLImpl(plan.toXml()));
                } else {
                    row.add(null);
                    row.add(null);
                }
                row.add(DataTypeTransformer.getClob(this.getTeiidVersion(), connDebugLog));
                records.add(row);
            }
            this.createResultSet(records, new String[]{"PLAN_TEXT", "PLAN_XML", "DEBUG_LOG"}, new String[]{DataTypeManagerService.DefaultDataTypes.CLOB.getId(), DataTypeManagerService.DefaultDataTypes.XML.getId(), DataTypeManagerService.DefaultDataTypes.CLOB.getId()});
            return StatementImpl.booleanFuture(true);
        }
        if (show.equalsIgnoreCase("ANNOTATIONS")) {
            ArrayList records = new ArrayList(1);
            Collection<Annotation> annos = this.driverConnection.getAnnotations();
            for (Annotation annotation : annos) {
                ArrayList<String> row = new ArrayList<String>(4);
                row.add(annotation.getCategory());
                row.add(annotation.getPriority().name());
                row.add(annotation.getAnnotation());
                row.add(annotation.getResolution());
                records.add(row);
            }
            this.createResultSet(records, new String[]{"CATEGORY", "PRIORITY", "ANNOTATION", "RESOLUTION"}, new String[]{DataTypeManagerService.DefaultDataTypes.STRING.getId(), DataTypeManagerService.DefaultDataTypes.STRING.getId(), DataTypeManagerService.DefaultDataTypes.STRING.getId(), DataTypeManagerService.DefaultDataTypes.STRING.getId()});
            return StatementImpl.booleanFuture(true);
        }
        if (show.equalsIgnoreCase("ALL")) {
            ArrayList records = new ArrayList(1);
            for (String key : this.driverConnection.getExecutionProperties().stringPropertyNames()) {
                ArrayList<Object> row = new ArrayList<Object>(4);
                row.add(key);
                row.add(this.driverConnection.getExecutionProperties().get(key));
                records.add(row);
            }
            this.createResultSet(records, new String[]{"NAME", "VALUE"}, new String[]{DataTypeManagerService.DefaultDataTypes.STRING.getId(), DataTypeManagerService.DefaultDataTypes.STRING.getId()});
            return StatementImpl.booleanFuture(true);
        }
        List<List<String>> records = Collections.singletonList(Collections.singletonList(this.driverConnection.getExecutionProperty(show)));
        this.createResultSet(records, new String[]{show}, new String[]{DataTypeManagerService.DefaultDataTypes.STRING.getId()});
        return StatementImpl.booleanFuture(true);
    }

    private ResultsFuture<ResultsMessage> execute(RequestMessage reqMsg, boolean synch) throws SQLException, SQLException {
        this.getConnection().beginLocalTxnIfNeeded();
        this.currentRequestID = this.driverConnection.nextRequestID();
        if (this.payload != null) {
            reqMsg.setExecutionPayload(this.payload);
        } else {
            reqMsg.setExecutionPayload(this.getMMConnection().getPayload());
        }
        reqMsg.setDelaySerialization(true);
        reqMsg.setCursorType(this.resultSetType);
        reqMsg.setFetchSize(this.fetchSize);
        reqMsg.setRowLimit(this.maxRows);
        reqMsg.setTransactionIsolation(this.driverConnection.getTransactionIsolation());
        reqMsg.setSync(synch && this.useCallingThread());
        this.copyPropertiesToRequest(reqMsg);
        reqMsg.setExecutionId(this.currentRequestID);
        ResultsFuture.CompletionListener<ResultsMessage> compeletionListener = null;
        if (this.queryTimeoutMS > 0L && (!synch || this.driverConnection.getServerConnection().isLocal())) {
            final EnhancedTimer.Task c = cancellationTimer.add(this.cancelTask, this.queryTimeoutMS);
            compeletionListener = new ResultsFuture.CompletionListener<ResultsMessage>(){

                @Override
                public void onCompletion(ResultsFuture<ResultsMessage> future) {
                    c.cancel();
                }
            };
        }
        ResultsFuture<ResultsMessage> pendingResult = null;
        try {
            pendingResult = this.getDQP().executeRequest(this.currentRequestID, reqMsg);
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        if (compeletionListener != null) {
            pendingResult.addCompletionListener(compeletionListener);
        }
        return pendingResult;
    }

    boolean useCallingThread() throws SQLException {
        if (this.getConnection().getServerConnection() == null || !this.getConnection().getServerConnection().isLocal()) {
            return false;
        }
        String useCallingThread = this.getExecutionProperty(USE_CALLING_THREAD);
        return useCallingThread == null || Boolean.valueOf(useCallingThread) != false;
    }

    public static ResultsFuture<Boolean> booleanFuture(boolean isTrue) {
        ResultsFuture<Boolean> rs = new ResultsFuture<Boolean>();
        rs.getResultsReceiver().receiveResults(isTrue);
        return rs;
    }

    private synchronized void postReceiveResults(RequestMessage reqMessage, ResultsMessage resultsMsg) throws SQLException {
        this.commandStatus = State.DONE;
        List<Throwable> resultsWarning = resultsMsg.getWarnings();
        resultsMsg.setTeiidVersion(this.getTeiidVersion());
        this.setAnalysisInfo(resultsMsg);
        if (resultsMsg.getException() != null) {
            throw new SQLException(resultsMsg.getException());
        }
        if (resultsWarning != null) {
            this.accumulateWarnings(resultsWarning);
        }
        if (resultsMsg.isUpdateResult()) {
            List<List<?>> results = resultsMsg.getResultsList();
            if (resultsMsg.getUpdateCount() == -1) {
                this.updateCounts = new int[results.size()];
                int i = 0;
                while (i < results.size()) {
                    this.updateCounts[i] = (Integer)results.get(i).get(0);
                    ++i;
                }
            } else {
                this.updateCounts = new int[]{resultsMsg.getUpdateCount()};
                this.createResultSet(resultsMsg);
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Recieved update counts: " + Arrays.toString(this.updateCounts));
            }
            try {
                this.getDQP().closeRequest(this.getCurrentRequestID());
            }
            catch (Exception e) {
                throw new SQLException(e);
            }
        } else {
            this.createResultSet(resultsMsg);
        }
        logger.fine(Messages.getString(Messages.JDBC.MMStatement_Success_query, reqMessage.getCommandString()));
    }

    protected RequestMessage createRequestMessage(String[] commands, boolean isBatchedCommand, RequestMessage.ResultsMode resultsMode) {
        RequestMessage reqMessage = new RequestMessage();
        reqMessage.setCommands(commands);
        reqMessage.setBatchedUpdate(isBatchedCommand);
        reqMessage.setResultsMode(resultsMode);
        return reqMessage;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.checkStatement();
        if (this.resultSet != null) {
            this.resultSet.close();
            this.resultSet = null;
        }
        this.updateCounts = null;
        return false;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.checkStatement();
        return false;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkStatement();
        return (int)this.queryTimeoutMS / 1000;
    }

    @Override
    public ResultSetImpl getResultSet() throws SQLException {
        this.checkStatement();
        if (!this.hasResultSet()) {
            return null;
        }
        return this.resultSet;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetType() {
        return this.resultSetType;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkStatement();
        if (this.updateCounts == null) {
            return -1;
        }
        return this.updateCounts[0];
    }

    protected void accumulateWarnings(List<Throwable> serverWarnings) {
        if (serverWarnings == null || serverWarnings.isEmpty()) {
            return;
        }
        if (this.serverWarnings == null) {
            this.serverWarnings = new ArrayList<Throwable>();
        }
        this.serverWarnings.addAll(serverWarnings);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkStatement();
        if (this.serverWarnings != null && this.serverWarnings.size() != 0) {
            return WarningUtil.convertWarnings(this.serverWarnings);
        }
        return null;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkStatement();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkStatement();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkStatement();
        if (rows < 0) {
            String msg = Messages.getString(Messages.JDBC.MMStatement_Invalid_fetch_size, new Object[0]);
            throw new SQLException(msg);
        }
        this.fetchSize = rows == 0 ? 2048 : rows;
    }

    @Override
    public void setMaxRows(int maxRows) throws SQLException {
        this.checkStatement();
        if (maxRows < 0 || maxRows == Integer.MAX_VALUE) {
            maxRows = 0;
        }
        this.maxRows = maxRows;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkStatement();
        if (seconds < 0) {
            throw new SQLException(Messages.getString(Messages.JDBC.MMStatement_Bad_timeout_value, new Object[0]));
        }
        this.queryTimeoutMS = seconds * 1000;
    }

    void setQueryTimeoutMS(int queryTimeoutMS) {
        this.queryTimeoutMS = queryTimeoutMS;
    }

    protected void copyPropertiesToRequest(RequestMessage res) throws SQLException {
        String noExec;
        String partial = this.getExecutionProperty("partialResultsMode");
        res.setPartialResults(Boolean.valueOf(partial));
        String validate = this.getExecutionProperty("XMLValidation");
        if (validate == null) {
            res.setValidationMode(false);
        } else {
            res.setValidationMode(Boolean.valueOf(validate));
        }
        String format = this.getExecutionProperty("XMLFormat");
        res.setXMLFormat(format);
        String txnAutoWrapMode = this.getExecutionProperty("autoCommitTxn");
        try {
            res.setTxnAutoWrapMode(txnAutoWrapMode);
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        String rsCache = this.getExecutionProperty("resultSetCacheMode");
        res.setUseResultSetCache(Boolean.valueOf(rsCache));
        res.setAnsiQuotedIdentifiers(Boolean.valueOf(this.getExecutionProperty("ansiQuotedIdentifiers")));
        String showPlan = this.getExecutionProperty("SHOWPLAN");
        if (showPlan != null) {
            try {
                res.setShowPlan(RequestMessage.ShowPlan.valueOf(showPlan.toUpperCase()));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        if ((noExec = this.getExecutionProperty("NOEXEC")) != null) {
            res.setNoExec(noExec.equalsIgnoreCase("ON"));
        }
    }

    protected synchronized void timeoutOccurred() {
        if (this.commandStatus != State.RUNNING) {
            return;
        }
        logger.warning(Messages.getString(Messages.JDBC.MMStatement_Timeout_ocurred_in_Statement, new Object[0]));
        try {
            this.cancel();
            this.commandStatus = State.TIMED_OUT;
            this.queryTimeoutMS = 0L;
            this.setTimeoutFromProperties();
            this.currentRequestID = -1L;
            if (this.resultSet != null) {
                this.resultSet.close();
            }
        }
        catch (SQLException se) {
            logger.log(Level.SEVERE, Messages.getString(Messages.JDBC.MMStatement_Error_timing_out, new Object[0]), se);
        }
    }

    protected void cancelRequest() throws SQLException {
        this.checkStatement();
        try {
            this.getDQP().cancelRequest(this.currentRequestID);
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void setPayload(Serializable payload) {
        this.payload = payload;
    }

    @Override
    public void setExecutionProperty(String name, String value) {
        this.execProps.setProperty(name, value);
    }

    @Override
    public String getExecutionProperty(String name) {
        return this.execProps.getProperty(name);
    }

    long getCurrentRequestID() {
        return this.currentRequestID;
    }

    @Override
    public PlanNode getPlanDescription() {
        if (this.resultSet != null) {
            return this.resultSet.getUpdatedPlanDescription();
        }
        if (this.currentPlanDescription != null) {
            return this.currentPlanDescription;
        }
        return null;
    }

    @Override
    public String getDebugLog() {
        return this.debugLog;
    }

    @Override
    public Collection<Annotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public String getRequestIdentifier() {
        if (this.currentRequestID >= 0L) {
            return Long.toString(this.currentRequestID);
        }
        return null;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    protected void setAnalysisInfo(ResultsMessage resultsMsg) {
        if (resultsMsg.getDebugLog() != null) {
            this.debugLog = resultsMsg.getDebugLog();
        }
        if (resultsMsg.getPlanDescription() != null) {
            this.currentPlanDescription = resultsMsg.getPlanDescription();
        }
        if (resultsMsg.getAnnotations() != null) {
            this.annotations = resultsMsg.getAnnotations();
        }
        this.driverConnection.setDebugLog(this.debugLog);
        this.driverConnection.setCurrentPlanDescription(this.currentPlanDescription);
        this.driverConnection.setAnnotations(this.annotations);
    }

    Calendar getDefaultCalendar() {
        if (this.defaultCalendar == null) {
            this.defaultCalendar = Calendar.getInstance();
        }
        return this.defaultCalendar;
    }

    void setDefaultCalendar(Calendar cal) {
        this.defaultCalendar = cal;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.checkStatement();
        return false;
    }

    @Override
    public void setPoolable(boolean arg0) throws SQLException {
        this.checkStatement();
    }

    @Override
    public ConnectionImpl getConnection() throws SQLException {
        return this.driverConnection;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkSupportedVersion(TeiidServerVersion.Version.TEIID_7_7);
        this.executeSql(new String[]{sql}, false, RequestMessage.ResultsMode.EITHER, true, null, autoGeneratedKeys == 1);
        return this.hasResultSet();
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.checkSupportedVersion(TeiidServerVersion.Version.TEIID_7_7);
        return this.execute(sql, 1);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.checkSupportedVersion(TeiidServerVersion.Version.TEIID_7_7);
        return this.execute(sql, 1);
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkSupportedVersion(TeiidServerVersion.Version.TEIID_7_7);
        this.executeSql(new String[]{sql}, false, RequestMessage.ResultsMode.UPDATECOUNT, true, null, autoGeneratedKeys == 1);
        if (this.updateCounts == null) {
            return 0;
        }
        return this.updateCounts[0];
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.checkSupportedVersion(TeiidServerVersion.Version.TEIID_7_7);
        return this.executeUpdate(sql, 1);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.checkSupportedVersion(TeiidServerVersion.Version.TEIID_7_7);
        return this.executeUpdate(sql, 1);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.checkSupportedVersion(TeiidServerVersion.Version.TEIID_7_7);
        if (this.updateCounts != null && this.resultSet != null) {
            return this.resultSet;
        }
        return this.createResultSet(Collections.emptyList(), new Map[0]);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.checkStatement();
        if (max < 0) {
            throw new SQLException(Messages.getString(Messages.JDBC.MMStatement_Invalid_field_size, max));
        }
        this.maxFieldSize = max;
    }

    ResultSetImpl createResultSet(List records, String[] columnNames, String[] dataTypes) throws SQLException {
        Map[] metadata = new Map[columnNames.length];
        int i = 0;
        while (i < columnNames.length) {
            metadata[i] = StatementImpl.getColumnMetadata(null, columnNames[i], dataTypes[i], ResultsMetadataConstants.NULL_TYPES.UNKNOWN, this.driverConnection);
            ++i;
        }
        return this.createResultSet(records, metadata);
    }

    ResultSetImpl createResultSet(List records, Map[] columnMetadata) throws SQLException {
        ResultSetMetaDataImpl rsmd = new ResultSetMetaDataImpl(new MetadataProvider(columnMetadata), this.getExecutionProperty("useJDBC4ColumnNameAndLabelSemantics"));
        return this.createResultSet(records, rsmd);
    }

    ResultSetImpl createResultSet(List records, ResultSetMetaData rsmd) throws SQLException {
        if (rsmd.getColumnCount() > 0) {
            rsmd.getScale(1);
        }
        ResultsMessage resultsMsg = StatementImpl.createDummyResultsMessage(null, null, records);
        this.resultSet = new ResultSetImpl(resultsMsg, this, rsmd, 0);
        this.resultSet.setMaxFieldSize(this.maxFieldSize);
        return this.resultSet;
    }

    static ResultsMessage createDummyResultsMessage(String[] columnNames, String[] dataTypes, List records) {
        ResultsMessage resultsMsg = new ResultsMessage();
        resultsMsg.setColumnNames(columnNames);
        resultsMsg.setDataTypes(dataTypes);
        resultsMsg.setFirstRow(1);
        resultsMsg.setLastRow(records.size());
        resultsMsg.setFinalRow(records.size());
        resultsMsg.setResults(records.toArray(new List[records.size()]));
        return resultsMsg;
    }

    static Map<Integer, Object> getColumnMetadata(String tableName, String columnName, String dataType, Integer nullable, ConnectionImpl driverConnection) throws SQLException {
        return StatementImpl.getColumnMetadata(tableName, columnName, dataType, nullable, ResultsMetadataConstants.SEARCH_TYPES.UNSEARCHABLE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, driverConnection);
    }

    static Map<Integer, Object> getColumnMetadata(String tableName, String columnName, DataTypeManagerService.DefaultDataTypes dataType, Integer nullable, ConnectionImpl driverConnection) throws SQLException {
        return StatementImpl.getColumnMetadata(tableName, columnName, dataType.getId(), nullable, ResultsMetadataConstants.SEARCH_TYPES.UNSEARCHABLE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, driverConnection);
    }

    static Map<Integer, Object> getColumnMetadata(String tableName, String columnName, String dataType, Integer nullable, Integer searchable, Boolean writable, Boolean signed, Boolean caseSensitive, ConnectionImpl driverConnection) throws SQLException {
        HashMap<Integer, Object> metadataMap = new HashMap<Integer, Object>();
        metadataMap.put(ResultsMetadataConstants.VIRTUAL_DATABASE_NAME, driverConnection.getVDBName());
        metadataMap.put(ResultsMetadataConstants.GROUP_NAME, tableName);
        metadataMap.put(ResultsMetadataConstants.ELEMENT_NAME, columnName);
        metadataMap.put(ResultsMetadataConstants.DATA_TYPE, dataType);
        metadataMap.put(ResultsMetadataConstants.PRECISION, JDBCSQLTypeInfo.getDefaultPrecision(dataType));
        metadataMap.put(ResultsMetadataConstants.RADIX, new Integer(10));
        metadataMap.put(ResultsMetadataConstants.SCALE, new Integer(0));
        metadataMap.put(ResultsMetadataConstants.AUTO_INCREMENTING, Boolean.FALSE);
        metadataMap.put(ResultsMetadataConstants.CASE_SENSITIVE, caseSensitive);
        metadataMap.put(ResultsMetadataConstants.NULLABLE, nullable);
        metadataMap.put(ResultsMetadataConstants.SEARCHABLE, searchable);
        metadataMap.put(ResultsMetadataConstants.SIGNED, signed);
        metadataMap.put(ResultsMetadataConstants.WRITABLE, writable);
        metadataMap.put(ResultsMetadataConstants.CURRENCY, Boolean.FALSE);
        metadataMap.put(ResultsMetadataConstants.DISPLAY_SIZE, JDBCSQLTypeInfo.getMaxDisplaySize(dataType));
        return metadataMap;
    }

    static Map<Integer, Object> getColumnMetadata(String tableName, String columnName, DataTypeManagerService.DefaultDataTypes dataType, Integer nullable, Integer searchable, Boolean writable, Boolean signed, Boolean caseSensitive, ConnectionImpl driverConnection) throws SQLException {
        return StatementImpl.getColumnMetadata(tableName, columnName, dataType.getId(), nullable, searchable, writable, signed, caseSensitive, driverConnection);
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    private static final class QueryTimeoutCancelTask
    implements Runnable {
        private WeakReference<StatementImpl> ref;

        private QueryTimeoutCancelTask(StatementImpl stmt) {
            this.ref = new WeakReference<StatementImpl>(stmt);
        }

        @Override
        public void run() {
            StatementImpl stmt = (StatementImpl)this.ref.get();
            if (stmt != null) {
                stmt.timeoutOccurred();
            }
        }
    }

    static enum State {
        RUNNING,
        DONE,
        TIMED_OUT,
        CANCELLED;

    }
}

