/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JDBCURL {
    private static final String UTF_8 = "UTF-8";
    public static final String WAIT_FOR_LOAD = "waitForLoad";
    public static final String USE_CALLING_THREAD = "useCallingThread";
    public static final String JDBC_PROTOCOL = "jdbc:teiid:";
    static final String URL_PATTERN = "jdbc:teiid:([\\w-\\.]+)(?:@([^;]*))?(;.*)?";
    static Pattern urlPattern = Pattern.compile("jdbc:teiid:([\\w-\\.]+)(?:@([^;]*))?(;.*)?");
    public static final Map<String, String> EXECUTION_PROPERTIES = Collections.unmodifiableMap(JDBCURL.buildProps());
    public static final Map<String, String> KNOWN_PROPERTIES = JDBCURL.getKnownProperties();
    private String vdbName;
    private String connectionURL;
    private Properties properties = new Properties();
    private String urlString;

    private static Map<String, String> buildProps() {
        TreeMap<String, String> result = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        String[] stringArray = new String[]{"autoCommitTxn", "partialResultsMode", "resultSetCacheMode", "ansiQuotedIdentifiers", "SHOWPLAN", "NOEXEC", "fetchSize", "XMLFormat", "XMLValidation", USE_CALLING_THREAD, "disableLocalTxn", "useJDBC4ColumnNameAndLabelSemantics"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            result.put(key, key);
            ++n2;
        }
        return result;
    }

    private static Map<String, String> getKnownProperties() {
        HashSet<String> props = new HashSet<String>(Arrays.asList("ApplicationName", "VirtualDatabaseName", "version", "VirtualDatabaseVersion", "user", "password", WAIT_FOR_LOAD, "autoFailover", "discoveryStategy", "PassthroughAuthentication", "jaasName", "kerberosServicePrincipleName", "encryptRequests", "reportAsViews", "disableResultSetFetchSize"));
        props.addAll(EXECUTION_PROPERTIES.keySet());
        TreeMap<String, String> result = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (String string : props) {
            result.put(string, string);
        }
        return Collections.unmodifiableMap(result);
    }

    public static ConnectionType acceptsUrl(String url) {
        Matcher m = urlPattern.matcher(url);
        if (m.matches()) {
            return m.group(2) != null ? ConnectionType.Socket : ConnectionType.Embedded;
        }
        return null;
    }

    public JDBCURL(String jdbcURL) {
        this.parseURL(jdbcURL);
    }

    public JDBCURL(String vdbName, String connectionURL, Properties props) {
        if (vdbName == null || vdbName.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        this.vdbName = vdbName;
        this.connectionURL = connectionURL;
        if (props != null) {
            JDBCURL.normalizeProperties(props, this.properties);
        }
    }

    public String getVDBName() {
        return this.vdbName;
    }

    public String getConnectionURL() {
        return this.connectionURL;
    }

    public Properties getProperties() {
        Properties newProps = new Properties();
        newProps.putAll((Map<?, ?>)this.properties);
        return newProps;
    }

    private void parseURL(String jdbcURL) {
        String props;
        if (jdbcURL == null) {
            throw new IllegalArgumentException();
        }
        if ((jdbcURL = jdbcURL.trim()).length() == 0) {
            throw new IllegalArgumentException();
        }
        Matcher m = urlPattern.matcher(jdbcURL);
        if (!m.matches()) {
            throw new IllegalArgumentException();
        }
        this.vdbName = m.group(1);
        this.connectionURL = m.group(2);
        if (this.connectionURL != null) {
            this.connectionURL = this.connectionURL.trim();
        }
        if ((props = m.group(3)) != null) {
            JDBCURL.parseConnectionProperties(props, this.properties);
        }
    }

    public static void parseConnectionProperties(String connectionInfo, Properties p) {
        String[] connectionParts = connectionInfo.split(";");
        if (connectionParts.length != 0) {
            int i = 0;
            while (i < connectionParts.length) {
                JDBCURL.parseConnectionProperty(connectionParts[i], p);
                ++i;
            }
        }
    }

    static void parseConnectionProperty(String connectionProperty, Properties p) {
        if (connectionProperty.length() == 0) {
            return;
        }
        if (connectionProperty.length() < 3) {
            throw new IllegalArgumentException();
        }
        int firstEquals = connectionProperty.indexOf(61);
        if (firstEquals < 1) {
            throw new IllegalArgumentException();
        }
        String key = connectionProperty.substring(0, firstEquals).trim();
        String value = connectionProperty.substring(firstEquals + 1).trim();
        if (value.indexOf(61) >= 0) {
            throw new IllegalArgumentException();
        }
        JDBCURL.addNormalizedProperty(key, JDBCURL.getValidValue(value), p);
    }

    public String getJDBCURL() {
        if (this.urlString == null) {
            StringBuffer buf = new StringBuffer(JDBC_PROTOCOL).append(this.vdbName);
            if (this.connectionURL != null) {
                buf.append('@').append(this.connectionURL);
            }
            for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
                if (!(entry.getValue() instanceof String)) continue;
                try {
                    buf.append(';').append(entry.getKey()).append('=').append(URLEncoder.encode((String)entry.getValue(), UTF_8));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    buf.append(entry.getValue());
                }
            }
            this.urlString = buf.toString();
        }
        return this.urlString;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public String getUserName() {
        return this.properties.getProperty("user");
    }

    public String getPassword() {
        return this.properties.getProperty("password");
    }

    public String getVDBVersion() {
        if (this.properties.contains("VirtualDatabaseVersion")) {
            return this.properties.getProperty("VirtualDatabaseVersion");
        }
        return this.properties.getProperty("version");
    }

    public String getTransactionAutowrapMode() {
        return this.properties.getProperty("autoCommitTxn");
    }

    public String getPartialResultsMode() {
        return this.properties.getProperty("partialResultsMode");
    }

    public String getResultSetCacheMode() {
        return this.properties.getProperty("resultSetCacheMode");
    }

    public String getAnsiQuotedIdentifiers() {
        return this.properties.getProperty("ansiQuotedIdentifiers");
    }

    public String getFetchSize() {
        return this.properties.getProperty("fetchSize");
    }

    public String getXMLFormat() {
        return this.properties.getProperty("XMLFormat");
    }

    public String getXMLValidation() {
        return this.properties.getProperty("XMLValidation");
    }

    public String getTransparentFailover() {
        return this.properties.getProperty("autoFailover");
    }

    public String getDisableLocalTransactions() {
        return this.properties.getProperty("disableLocalTxn");
    }

    public String toString() {
        return this.getJDBCURL();
    }

    private static void normalizeProperties(Properties source, Properties target) {
        Enumeration<?> e = source.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            JDBCURL.addNormalizedProperty(key, source.get(key), target);
        }
    }

    public static void addNormalizedProperty(String key, Object value, Properties target) {
        String validKey = JDBCURL.getValidKey(key);
        target.put(validKey, value);
    }

    public static String getValidKey(String key) {
        String result = KNOWN_PROPERTIES.get(key);
        if (result != null) {
            return result;
        }
        return key;
    }

    private static Object getValidValue(Object value) {
        if (value instanceof String) {
            try {
                return URLDecoder.decode((String)value, UTF_8);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        return value;
    }

    public static Properties normalizeProperties(Properties props) {
        JDBCURL.normalizeProperties(props, props);
        return props;
    }

    public static enum ConnectionType {
        Embedded,
        Socket;

    }
}

