/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types.basic;

import org.teiid.core.types.DataTypeManagerService;
import org.teiid.core.types.Transform;

public class NumberToDoubleTransform
extends Transform {
    private Class<?> sourceType;
    private boolean isNarrowing;
    private boolean isLossy;

    public NumberToDoubleTransform(DataTypeManagerService dataTypeManager, Class<?> sourceType, boolean isNarrowing, boolean isLossy) {
        super(dataTypeManager);
        this.sourceType = sourceType;
        this.isNarrowing = isNarrowing;
        this.isLossy = isLossy;
    }

    @Override
    public Class<?> getSourceType() {
        return this.sourceType;
    }

    @Override
    public Object transformDirect(Object value) throws Exception {
        if (this.isNarrowing) {
            this.checkValueRange(value, -1.7976931348623157E308, Double.MAX_VALUE);
        }
        return ((Number)value).doubleValue();
    }

    @Override
    public Class<?> getTargetType() {
        return DataTypeManagerService.DefaultDataTypes.DOUBLE.getTypeClass();
    }

    @Override
    public boolean isExplicit() {
        return this.isNarrowing || this.isLossy;
    }
}

