/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.webservice;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDSchema;
import org.teiid.designer.compare.ModelProducer;
import org.teiid.designer.compare.selector.ModelSelector;
import org.teiid.designer.compare.selector.TransientModelSelector;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.wsdl.Definitions;
import org.teiid.designer.webservice.IWebServiceGenerator;
import org.teiid.designer.webservice.IWebServiceModelBuilder;
import org.teiid.designer.webservice.IWebServiceResource;
import org.teiid.designer.webservice.IWebServiceXsdResource;
import org.teiid.designer.webservice.WebServicePlugin;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public class WebServiceModelProducer
implements ModelProducer {
    public static final int WARNING_NO_WSDL_OBJECTS = 31301;
    private final IWebServiceModelBuilder builder;
    private final TransientModelSelector output;
    private final List roots;

    public WebServiceModelProducer(IWebServiceModelBuilder builder) {
        this.builder = builder;
        this.roots = new ArrayList();
        this.output = new TransientModelSelector(builder.getModelPath().toString());
    }

    public void execute(IProgressMonitor monitor, List problems) throws Exception {
        this.roots.clear();
        ModelAnnotation modelAnnotation = this.output.getModelAnnotation();
        if (modelAnnotation.getPrimaryMetamodelUri() != null && !modelAnnotation.getPrimaryMetamodelUri().equals("http://www.metamatrix.com/metamodels/WebService")) {
            modelAnnotation.setPrimaryMetamodelUri("http://www.metamatrix.com/metamodels/WebService");
        }
        if (modelAnnotation.getModelType() != null && modelAnnotation.getModelType() != ModelType.VIRTUAL_LITERAL) {
            modelAnnotation.setModelType(ModelType.VIRTUAL_LITERAL);
        }
        IWebServiceGenerator generator = WebServicePlugin.createWebServiceGenerator();
        generator.setWebServiceResource(this.output.getResource());
        generator.setSelectedOperations(this.builder.getSelectedOperations());
        Set allXsdSchemas = this.doProcessXsds(monitor, problems);
        Collection resources = this.builder.getWSDLResources();
        for (IWebServiceResource wsr : resources) {
            Resource emfResource = this.builder.getEmfResource(wsr);
            if (emfResource == null) continue;
            EList roots = emfResource.getContents();
            for (EObject root : roots) {
                if (!(root instanceof Definitions)) continue;
                generator.addWsdlDefinitions((Definitions)root);
            }
        }
        for (XSDSchema schema : allXsdSchemas) {
            generator.addXsdSchema(schema);
        }
        if (generator.getWsdlDefinitions().isEmpty()) {
            String msg = WebServicePlugin.Util.getString("WebServiceModelProducer.NoWsdlObjectsFound", new Object[0]);
            problems.add(new Status(2, "org.teiid.designer.webservice", 31301, msg, null));
        } else {
            generator.generate(monitor, problems);
        }
    }

    public ModelSelector getOutputSelector() {
        return this.output;
    }

    protected Set doProcessXsds(IProgressMonitor monitor, List problems) {
        HashSet<EObject> results = new HashSet<EObject>();
        Collection xsdDestinations = this.builder.getXsdDestinations();
        Iterator iter = xsdDestinations.iterator();
        HashSet<IFile> newXsdFiles = new HashSet<IFile>();
        Set destProjectRelativePaths = this.getDestProjectRelativePaths(xsdDestinations);
        while (iter.hasNext()) {
            IWebServiceXsdResource xsdDest = (IWebServiceXsdResource)iter.next();
            if (xsdDest == null || xsdDest.getDestinationPath() == null) continue;
            IPath destFilePath = xsdDest.getDestinationPath();
            IPath destProjectRelativePath = destFilePath.removeFirstSegments(1);
            IPath destPath = destProjectRelativePath.removeLastSegments(1);
            IPath absoluteProjectPath = this.builder.getParentResource().getLocation();
            IPath absoluteDestPath = absoluteProjectPath.append(destPath);
            File pathFile = new File(absoluteDestPath.toOSString());
            pathFile.mkdirs();
            try {
                this.builder.getParentResource().refreshLocal(2, null);
            }
            catch (CoreException err1) {
                Object[] params = new Object[]{this.builder.getParentResource().getName(), err1.getMessage()};
                String msg = WebServicePlugin.Util.getString("WebServiceModelProducer.ErrorRefreshingWorkspace", params);
                Status status = new Status(4, "org.teiid.designer.webservice", 0, msg, null);
                problems.add(status);
            }
            XSDSchema schema = xsdDest.getSchema();
            IFile file = ((IContainer)this.builder.getParentResource()).getFile(destProjectRelativePath);
            if (file == null) {
                Object[] params = new Object[]{xsdDest.getOriginalPath(), destProjectRelativePath};
                String msg = WebServicePlugin.Util.getString("WebServiceModelProducer.UnableToCopyXsdFrom0To1", params);
                Status status = new Status(4, "org.teiid.designer.webservice", 0, msg, null);
                problems.add(status);
                continue;
            }
            File tempFile = null;
            try {
                OutputStream stream = null;
                InputStream inputStream = null;
                try {
                    for (Object content : schema.getContents()) {
                        if (!(content instanceof XSDImport)) continue;
                        XSDImport xsdImport = (XSDImport)content;
                        String schemaLocation = xsdImport.getSchemaLocation();
                        IPath importLocation = null;
                        if (schemaLocation == null || !destProjectRelativePaths.contains(importLocation = new Path(URI.createURI((String)xsdImport.getSchemaLocation()).path()).makeRelative())) continue;
                        xsdImport.setSchemaLocation(ModelUtil.getRelativePath((IPath)importLocation, (IPath)destProjectRelativePath));
                    }
                    tempFile = File.createTempFile("XSDCopy", ".xsd");
                    stream = new FileOutputStream(tempFile);
                    stream = new BufferedOutputStream(stream);
                    Element schemaElement = schema.getElement();
                    this.doWriteXmlDocument(xsdDest.getTargetNamespace(), stream, schemaElement);
                    stream.close();
                    stream = null;
                    inputStream = new FileInputStream(tempFile);
                    inputStream = new BufferedInputStream(inputStream);
                    if (file.exists()) {
                        file.setContents(inputStream, true, true, monitor);
                    } else {
                        file.create(inputStream, true, monitor);
                    }
                    newXsdFiles.add(file);
                }
                finally {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException err) {
                            WebServicePlugin.Util.log((Throwable)err);
                        }
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException err) {
                            WebServicePlugin.Util.log((Throwable)err);
                        }
                    }
                    if (tempFile != null) {
                        try {
                            tempFile.delete();
                        }
                        catch (RuntimeException err) {
                            WebServicePlugin.Util.log((Throwable)err);
                        }
                    }
                }
            }
            catch (Exception e) {
                Object[] params = new Object[]{xsdDest.getOriginalPath(), destProjectRelativePath, e.getLocalizedMessage()};
                String msg = WebServicePlugin.Util.getString("WebServiceModelProducer.ErrorCopyingXsdFrom0To1", params);
                Status status = new Status(4, "org.teiid.designer.webservice", 0, msg, (Throwable)e);
                problems.add(status);
            }
        }
        for (IFile xsdFile : newXsdFiles) {
            try {
                ModelResource modelResource = (ModelResource)ModelWorkspaceManager.getModelWorkspaceManager().findModelWorkspaceItem((IResource)xsdFile, true);
                List allRoots = modelResource.getAllRootEObjects();
                for (EObject root : allRoots) {
                    if (!(root instanceof XSDSchema)) continue;
                    results.add(root);
                }
            }
            catch (Exception e) {
                String msg = WebServicePlugin.Util.getString("WebServiceModelProducer.ErrorLoadingXsd1", (Object)xsdFile);
                Status status = new Status(4, "org.teiid.designer.webservice", 0, msg, (Throwable)e);
                problems.add(status);
            }
        }
        return results;
    }

    private Set getDestProjectRelativePaths(Collection xsdDestinations) {
        HashSet<IPath> destProjectRelativePaths = new HashSet<IPath>();
        for (IWebServiceXsdResource xsdDest : xsdDestinations) {
            destProjectRelativePaths.add(xsdDest.getDestinationPath().removeFirstSegments(1));
        }
        return destProjectRelativePaths;
    }

    protected void doWriteXmlDocument(String targetNamespace, OutputStream stream, Element schemaElement) throws Exception {
        DocumentBuilderFactoryImpl documentBuilderFactory = new DocumentBuilderFactoryImpl();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(false);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document docCopy = documentBuilder.newDocument();
        Element schemaElementCopy = (Element)docCopy.importNode(schemaElement, true);
        docCopy.appendChild(schemaElementCopy);
        NamedNodeMap nameMap = schemaElement.getOwnerDocument().getDocumentElement().getAttributes();
        int i = 0;
        while (i < nameMap.getLength()) {
            Node child = nameMap.item(i);
            String value = child.getNodeValue();
            String prefix = child.getPrefix();
            if (!(!"xmlns".equals(prefix) || "http://schemas.xmlsoap.org/wsdl/".equals(value) || "http://schemas.xmlsoap.org/wsdl/soap/".equals(value) || "http://schemas.xmlsoap.org/wsdl/http/".equals(value) || "http://schemas.xmlsoap.org/wsdl/mime/".equals(value))) {
                Node newChild = docCopy.importNode(child, false);
                schemaElementCopy.setAttributeNode((Attr)newChild);
            }
            ++i;
        }
        DOMImplementationLS impl = (DOMImplementationLS)((Object)DOMImplementationRegistry.newInstance().getDOMImplementation("LS"));
        LSSerializer writer = impl.createLSSerializer();
        LSOutput output = impl.createLSOutput();
        output.setByteStream(stream);
        output.setEncoding("UTF-8");
        writer.write(docCopy, output);
    }
}

