/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.wizards.wsdl;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.util.URLHelper;
import org.teiid.designer.metamodels.core.util.UriValidator;
import org.teiid.designer.ui.IHelpContextIds;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.common.ICredentialsCommon;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.widget.CredentialsComposite;
import org.teiid.designer.ui.common.widget.Dialog;
import org.teiid.designer.ui.common.widget.MessageLabel;

public class WsdlUrlDialog
extends Dialog
implements IHelpContextIds,
UiConstants {
    static final String PREFIX = I18nUtil.getPropertyPrefix(WsdlUrlDialog.class);
    private Button btnOk;
    private IStatus currentStatus;
    private CredentialsComposite credentialsComposite;
    private MessageLabel lblMsg;
    private String newValue;
    String oldValue;
    private URL urlObject;
    private NamespaceUriValidator validator = new NamespaceUriValidator();

    static String getString(String theKey) {
        return Util.getStringOrKey(String.valueOf(PREFIX) + theKey);
    }

    public WsdlUrlDialog(Shell theParent) {
        super(theParent, WsdlUrlDialog.getString("title"));
        this.setReturnCode(1);
        this.setSizeRelativeToScreen(55, 35);
        this.setCenterOnDisplay(true);
    }

    protected Button createButton(Composite theParent, int theId, String theLabel, boolean theDefaultButton) {
        Button btn = super.createButton(theParent, theId, theLabel, theDefaultButton);
        if (theId == 0) {
            this.btnOk = btn;
            this.updateButtonStatus();
        }
        this.btnOk.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent theEvent) {
            }

            public void widgetDefaultSelected(SelectionEvent theEvent) {
                WsdlUrlDialog.this.okPressed();
            }
        });
        return btn;
    }

    protected void okPressed() {
        this.currentStatus = new Status(1, "org.teiid.designer.ui", 0, Util.getString("WsdlUrlDialog.0", new Object[0]), null);
        this.updateMessage();
        boolean resolved = true;
        try {
            resolved = ICredentialsCommon.SecurityType.None.equals((Object)this.getSecurityOption()) ? URLHelper.resolveUrl((URL)this.urlObject) : URLHelper.resolveUrl((URL)this.urlObject, (String)this.getUserName(), (String)this.getPassword(), null, (boolean)true);
        }
        catch (Exception exception) {
            resolved = false;
            this.currentStatus = new Status(4, "org.teiid.designer.ui", 0, Util.getString("WsdlUrlDialog.2", new Object[0]), null);
        }
        this.updateMessage();
        if (resolved) {
            super.okPressed();
        }
    }

    protected Control createDialogArea(Composite theParent) {
        Composite panel = new Composite(theParent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(1808));
        Label urlLabel = new Label(panel, 0);
        urlLabel.setText(WsdlUrlDialog.getString("label.text"));
        GridDataFactory.swtDefaults().grab(false, false).applyTo((Control)urlLabel);
        Text txf = new Text(panel, 2048);
        txf.setLayoutData((Object)new GridData(768));
        txf.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent theEvent) {
                WsdlUrlDialog.this.handleModifyText(theEvent);
            }
        });
        Label spacerLabel = new Label(panel, 0);
        spacerLabel.setVisible(false);
        GridDataFactory.swtDefaults().grab(false, false).applyTo((Control)spacerLabel);
        this.credentialsComposite = new CredentialsComposite(panel, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.credentialsComposite);
        this.lblMsg = new MessageLabel(panel);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.lblMsg.setLayoutData((Object)gd);
        txf.setText(this.oldValue == null ? "" : this.oldValue);
        IWorkbenchHelpSystem helpSystem = UiUtil.getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)panel, "org.teiid.designer.ui.namespaceUriRenameDialog");
        return panel;
    }

    public String getUrl() {
        String result = this.oldValue;
        int code = this.getReturnCode();
        if (code == 0 && this.currentStatus != null && this.currentStatus.getSeverity() != 4) {
            result = this.newValue;
        }
        return result;
    }

    public ICredentialsCommon.SecurityType getSecurityOption() {
        return this.credentialsComposite.getSecurityOption();
    }

    public String getUserName() {
        return this.credentialsComposite.getUserName();
    }

    public String getPassword() {
        return this.credentialsComposite.getPassword();
    }

    public URL getUrlObject() {
        return this.urlObject;
    }

    public void setUrlObject(URL urlObject) {
        this.urlObject = urlObject;
    }

    public ICellEditorValidator getValidator() {
        return this.validator;
    }

    void handleModifyText(ModifyEvent theEvent) {
        this.newValue = ((Text)theEvent.widget).getText();
        this.currentStatus = new Status(0, "org.teiid.designer.ui", 0, "", null);
        URL url = null;
        try {
            url = URLHelper.buildURL((String)this.newValue);
            this.setUrlObject(url);
        }
        catch (MalformedURLException e) {
            this.currentStatus = new Status(4, "org.teiid.designer.ui", 0, Util.getString("WsdlUrlDialog.1", new Object[0]), (Throwable)e);
        }
        this.updateMessage();
        this.updateButtonStatus();
    }

    private void updateMessage() {
        this.lblMsg.setErrorStatus(this.currentStatus);
        this.lblMsg.pack(true);
        this.lblMsg.update();
    }

    private void updateButtonStatus() {
        if (this.btnOk != null) {
            this.btnOk.setEnabled(this.currentStatus != null && this.currentStatus.getSeverity() != 4);
        }
    }

    final class NamespaceUriValidator
    implements ICellEditorValidator {
        NamespaceUriValidator() {
        }

        public String isValid(Object theValue) {
            String result = null;
            if (theValue instanceof String) {
                IStatus status = this.validate((String)theValue);
                if (status.getSeverity() == 4) {
                    result = status.getMessage();
                }
            } else if (theValue != null) {
                result = Util.getString(String.valueOf(PREFIX) + "invalidTypeForUri", theValue.getClass());
            }
            return result;
        }

        public IStatus validate(String theNewValue) {
            IStatus result = null;
            try {
                result = UriValidator.validate((String)theNewValue);
                if (result.getSeverity() == 4) {
                    result = new Status(result.getSeverity(), result.getPlugin(), result.getCode(), String.valueOf(result.getMessage()) + WsdlUrlDialog.getString("helpText"), null);
                } else if (theNewValue == WsdlUrlDialog.this.oldValue || theNewValue != null && WsdlUrlDialog.this.oldValue != null && theNewValue.equals(WsdlUrlDialog.this.oldValue)) {
                    result = new Status(4, "org.teiid.designer.ui", 1000, WsdlUrlDialog.getString("valueUnchanged"), null);
                } else if (!CoreStringUtil.isEmpty((String)WsdlUrlDialog.this.oldValue) && CoreStringUtil.isEmpty((String)theNewValue)) {
                    result = new Status(2, "org.teiid.designer.ui", 1010, WsdlUrlDialog.getString("valueCleared"), null);
                } else if (!(CoreStringUtil.isEmpty((String)WsdlUrlDialog.this.oldValue) || CoreStringUtil.isEmpty((String)theNewValue) || WsdlUrlDialog.this.oldValue.equals(theNewValue))) {
                    result = new Status(2, "org.teiid.designer.ui", 1020, Util.getString(String.valueOf(PREFIX) + "valueChanged", (Object)WsdlUrlDialog.this.oldValue), null);
                }
            }
            catch (RuntimeException theException) {
                result = new Status(4, "org.teiid.designer.ui", -1, theException.getLocalizedMessage(), null);
            }
            return result;
        }
    }

    static interface StatusCodes
    extends UriValidator.StatusCodes {
        public static final int NO_CHANGE = 1000;
        public static final int CLEAR_VALUE = 1010;
        public static final int CHANGED_VALUE = 1020;
    }
}

