/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.MetamodelDescriptor;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.common.InternalUiConstants;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.product.ProductCustomizerMgr;
import org.teiid.designer.ui.common.table.CtrlClickListener;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.product.IModelerProductContexts;
import org.teiid.designer.ui.viewsupport.DesignerPropertiesUtil;
import org.teiid.designer.ui.viewsupport.ModelNameUtil;
import org.teiid.designer.ui.viewsupport.ModelProjectSelectionStatusValidator;
import org.teiid.designer.ui.viewsupport.ModelingResourceFilter;
import org.teiid.designer.ui.wizards.ContributorTableLabelProvider;
import org.teiid.designer.ui.wizards.NewModelWizard;
import org.teiid.designer.ui.wizards.NewModelWizardDescriptor;
import org.teiid.designer.ui.wizards.NewModelWizardInput;

public class NewModelWizardMetamodelPage
extends WizardPage
implements InternalUiConstants.Widgets,
UiConstants,
IModelerProductContexts {
    protected static final String CHOOSE_A_METAMODEL = UiConstants.Util.getString("NewModelWizard.chooseAMetamodel", new Object[0]);
    protected static final String CHOOSE_A_MODEL_TYPE = UiConstants.Util.getString("NewModelWizard.chooseAModelType", new Object[0]);
    protected static final String CONTRIBUTOR_LABEL = UiConstants.Util.getString("NewModelWizard.contributors", new Object[0]);
    protected static final String DEFAULT_EXTENSION = UiConstants.Util.getString("ModelUtilities.modelFileExtension", new Object[0]);
    protected static final String DEFAULT_CLASS = "Relational";
    protected static final String DEFAULT_TYPE = UiConstants.Util.getString("NewModelWizardMetamodelPage.defaultType", new Object[0]);
    static final List ORDERED_METAMODELS_LIST;
    private static final int STATUS_OK = 0;
    private static final int STATUS_NO_LOCATION = 1;
    private static final int STATUS_FILE_EXISTS = 3;
    private static final int STATUS_NO_METAMODEL = 4;
    private static final int STATUS_NO_TYPE = 5;
    private static final int STATUS_BAD_FILENAME = 6;
    private static final int STATUS_CLOSED_PROJECT = 7;
    private static final int STATUS_NO_PROJECT_NATURE = 8;
    private static final int STATUS_DEPRECATED_EXTENSION_METAMODEL = 9;
    private static final int STATUS_DEPRECATED_FUNCTION_METAMODEL = 10;
    protected HashMap descriptorMap = new HashMap();
    protected HashMap modelTypeMap = new HashMap();
    private Text containerText;
    private Text fileText;
    private IPath filePath;
    private ISelection selection;
    private String panelMessage = null;
    private Combo modelTypesCombo;
    private Combo metamodelCombo;
    private TableViewer contributorTable;
    private CtrlClickListener tableClickListener;
    private int currentStatus = 0;
    private String fileNameMessage = null;
    private String fileExtension = DEFAULT_EXTENSION;
    private String initialMetamodelClass;
    private ModelType initialModelType;
    private String initialBuilderType;
    private String initialFileName;
    private boolean metamodelWasFoundAndSelected = false;
    private boolean builderAutoSelected = false;
    private Properties designerProperties;

    static {
        String[] ORDERED_METAMODELS = new String[]{DEFAULT_CLASS, "XML", "XML Schema (XSD)", "Web Service", "Function (Deprecated)", "Model Extension (Deprecated)"};
        ORDERED_METAMODELS_LIST = Arrays.asList(ORDERED_METAMODELS);
    }

    public NewModelWizardMetamodelPage(ISelection selection, Properties properties) {
        super("specifyModelPage");
        this.setTitle(Util.getString("NewModelWizard.title", new Object[0]));
        this.setDescription(Util.getString("NewModelWizard.specifyModelDesc", new Object[0]));
        this.selection = selection;
        this.designerProperties = properties;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        Composite topComposite = new Composite(container, 0);
        GridData topCompositeGridData = new GridData(768);
        topComposite.setLayoutData((Object)topCompositeGridData);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 3;
        topComposite.setLayout((Layout)topLayout);
        GridData gd = null;
        if (!ProductCustomizerMgr.getInstance().getProductCharacteristics().isHiddenProjectCentric()) {
            Label locationLabel = new Label(topComposite, 0);
            locationLabel.setText(Util.getString("NewModelWizard.location", new Object[0]));
            this.containerText = new Text(topComposite, 2052);
            gd = new GridData(768);
            this.containerText.setLayoutData((Object)gd);
            this.containerText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    NewModelWizardMetamodelPage.this.updateStatusMessage();
                }
            });
            this.containerText.setEditable(false);
            Button browseButton = new Button(topComposite, 8);
            GridData buttonGridData = new GridData();
            browseButton.setLayoutData((Object)buttonGridData);
            browseButton.setText(Util.getString("NewModelWizard.browse", new Object[0]));
            browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    NewModelWizardMetamodelPage.this.handleBrowse();
                }
            });
        }
        Label fileLabel = new Label(topComposite, 0);
        fileLabel.setText(Util.getString("NewModelWizard.fileName", new Object[0]));
        this.fileText = new Text(topComposite, 2052);
        gd = new GridData(768);
        this.fileText.setLayoutData((Object)gd);
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewModelWizardMetamodelPage.this.updateStatusMessage();
            }
        });
        new Label(topComposite, 0);
        Label modelLabel = new Label(topComposite, 0);
        modelLabel.setText(Util.getString("NewModelWizard.metamodel", new Object[0]));
        String[] virtualModelComboChoices = this.getMetamodelChoices();
        this.metamodelCombo = new Combo(topComposite, 12);
        this.metamodelCombo.setLayoutData((Object)new GridData(768));
        this.metamodelCombo.setItems(virtualModelComboChoices);
        this.metamodelCombo.select(virtualModelComboChoices.length == 2 ? 1 : 0);
        this.metamodelCombo.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                NewModelWizardMetamodelPage.this.metamodelComboSelected();
            }
        });
        this.metamodelCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                NewModelWizardMetamodelPage.this.metamodelComboSelected();
            }
        });
        new Label(topComposite, 0);
        Label modelTypesLabel = new Label(topComposite, 0);
        modelTypesLabel.setText(Util.getString("NewModelWizard.modelType", new Object[0]));
        this.modelTypesCombo = new Combo(topComposite, 12);
        this.modelTypesCombo.add(CHOOSE_A_MODEL_TYPE);
        this.modelTypesCombo.select(0);
        this.modelTypesCombo.setEnabled(false);
        this.modelTypesCombo.setLayoutData((Object)new GridData(768));
        this.modelTypesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                NewModelWizardMetamodelPage.this.modelTypeSelected();
            }
        });
        Group contributorGroup = new Group(container, 16);
        GridLayout groupLayout = new GridLayout();
        groupLayout.numColumns = 1;
        contributorGroup.setLayout((Layout)groupLayout);
        contributorGroup.setLayoutData((Object)new GridData(1808));
        Label contributorLabel = new Label((Composite)contributorGroup, 0);
        contributorLabel.setText(CONTRIBUTOR_LABEL);
        this.contributorTable = new TableViewer((Composite)contributorGroup, 66304);
        this.contributorTable.getTable().setLayout((Layout)new TableLayout());
        gd = new GridData(1808);
        gd.heightHint = 100;
        gd.grabExcessVerticalSpace = true;
        this.contributorTable.getTable().setLayoutData((Object)gd);
        this.contributorTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NewModelWizardMetamodelPage.this.handleTableSelection();
            }
        });
        this.contributorTable.setLabelProvider((IBaseLabelProvider)new ContributorTableLabelProvider());
        this.tableClickListener = new CtrlClickListener(this.contributorTable);
        this.initialize();
        this.updateStatusMessage();
        this.setControl((Control)container);
        this.fileText.setFocus();
        container.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                NewModelWizardMetamodelPage.this.setInitialComboStates();
            }
        });
    }

    void metamodelComboSelected() {
        if (this.metamodelCombo.isDisposed()) {
            return;
        }
        if (this.metamodelCombo.getSelectionIndex() == 0) {
            this.modelTypesCombo.setEnabled(false);
        } else {
            String type = this.getMetamodelType();
            MetamodelDescriptor md = (MetamodelDescriptor)this.descriptorMap.get(type);
            List typeList = this.getModelTypeList(md);
            this.populateModelTypesCombo(typeList);
            this.fileExtension = md.getFileExtension();
        }
        this.updateContributorTable();
        this.updateStatusMessage();
    }

    private void populateModelTypesCombo(List types) {
        this.modelTypesCombo.removeAll();
        this.modelTypesCombo.add(CHOOSE_A_MODEL_TYPE);
        for (ModelType modelType : types) {
            String modelTypeName = modelType.getDisplayName();
            this.modelTypeMap.put(modelTypeName, modelType);
            this.modelTypesCombo.add(modelTypeName);
        }
        if (types.size() == 1) {
            this.modelTypesCombo.select(1);
        } else {
            this.modelTypesCombo.select(0);
        }
        this.modelTypesCombo.setEnabled(true);
        this.modelTypeSelected();
    }

    void modelTypeSelected() {
        this.updateContributorTable();
        this.updateStatusMessage();
    }

    public ModelType getSelectedModelType() {
        int selectionIndex = this.modelTypesCombo.getSelectionIndex();
        ModelType modelType = null;
        if (selectionIndex >= 0) {
            String modelTypeName = this.modelTypesCombo.getItem(selectionIndex);
            modelType = (ModelType)this.modelTypeMap.get(modelTypeName);
        }
        return modelType;
    }

    private void updateContributorTable() {
        if (!this.builderAutoSelected) {
            this.contributorTable.setSelection((ISelection)new StructuredSelection());
            Object[] elements = NewModelWizard.getContributorList().toArray();
            this.contributorTable.remove(elements);
            if (this.modelTypesCombo.getSelectionIndex() > 0) {
                ModelType selectedModelType = this.getSelectedModelType();
                boolean isVirtual = selectedModelType != null && selectedModelType.equals(ModelType.VIRTUAL_LITERAL);
                List contributorList = NewModelWizard.getModelBuilders(this.getMetamodelDescriptor(), isVirtual);
                this.contributorTable.add(contributorList.toArray());
            }
        }
    }

    void handleTableSelection() {
        this.updateStatusMessage();
    }

    private void initialize() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IResource) {
                IContainer container = obj instanceof IContainer ? (IContainer)obj : ((IResource)obj).getParent();
                if (this.containerText != null) {
                    this.containerText.setText(container.getFullPath().makeRelative().toString());
                }
            }
        }
        if (this.initialFileName != null) {
            this.fileText.setText(this.initialFileName);
        } else {
            this.fileText.setText(Util.getString("NewModelWizard.defaultFileName", new Object[0]));
        }
        this.updateStatusMessage();
    }

    void handleBrowse() {
        IContainer folder = WidgetUtil.showFolderSelectionDialog((IContainer)((IContainer)this.getTargetContainer()), (ViewerFilter)new ModelingResourceFilter(), (ISelectionStatusValidator)new ModelProjectSelectionStatusValidator());
        if (folder != null && this.containerText != null) {
            IPath folderPath;
            this.containerText.setText(folder.getFullPath().makeRelative().toString());
            if (this.designerProperties != null) {
                DesignerPropertiesUtil.setProjectName(this.designerProperties, folder.getProject().getName());
            }
            if ((folderPath = folder.getProjectRelativePath()).segmentCount() == 1 && folderPath.toString().equals("sources")) {
                DesignerPropertiesUtil.setSourcesFolderName(this.designerProperties, "sources");
            } else if (folderPath.segmentCount() == 1 && folderPath.toString().equals("views")) {
                DesignerPropertiesUtil.setViewsFolderName(this.designerProperties, "views");
            }
        }
        this.updateStatusMessage();
    }

    void updateStatusMessage() {
        this.checkStatus();
        switch (this.currentStatus) {
            case 1: {
                this.updateStatus(Util.getString("NewModelWizard.locationMustBeSpecified", new Object[0]));
                break;
            }
            case 7: {
                this.updateStatus(Util.getString("NewModelWizard.projectClosed", (Object)this.getTargetProject().getName()));
                break;
            }
            case 8: {
                this.updateStatus(Util.getString("NewModelWizard.notModelProject", (Object)this.getTargetProject().getName()));
                break;
            }
            case 6: {
                this.updateStatus(this.fileNameMessage);
                break;
            }
            case 3: {
                String fileName = this.getFileName();
                String container = this.getContainerName();
                this.filePath = new Path(container).append(fileName);
                this.updateStatus(Util.getString("NewModelWizard.fileAlreadyExistsMessage", (Object)this.filePath.toOSString()));
                break;
            }
            case 4: {
                this.updateStatus(Util.getString("NewModelWizard.mustSelectMetamodel", new Object[0]));
                break;
            }
            case 5: {
                this.updateStatus(Util.getString("NewModelWizard.mustSelectModelType", new Object[0]));
                break;
            }
            case 9: {
                this.updateStatus(this.panelMessage);
                this.setMessage(Util.getString("NewModelWizard.extensionMetamodelDeprecated", new Object[0]), 2);
                break;
            }
            case 10: {
                this.updateStatus(this.panelMessage);
                this.setMessage(Util.getString("NewModelWizard.functionMetamodelDeprecated", new Object[0]), 2);
                break;
            }
            default: {
                this.updateStatus(this.panelMessage);
                this.setMessage(Util.getString("NewModelWizard.specifyModelDesc", new Object[0]), 0);
            }
        }
    }

    private boolean checkStatus() {
        String container = this.getContainerName();
        if (CoreStringUtil.isEmpty((String)container)) {
            this.currentStatus = 1;
            return false;
        }
        IProject project = this.getTargetProject();
        if (project == null) {
            this.currentStatus = 1;
            return false;
        }
        if (!project.isOpen()) {
            this.currentStatus = 7;
            return false;
        }
        try {
            if (project.getNature("org.teiid.designer.core.modelNature") == null) {
                this.currentStatus = 8;
                return false;
            }
        }
        catch (CoreException coreException) {
            this.currentStatus = 8;
            return false;
        }
        String fileText = this.getFileText();
        IStatus nameStatus = ModelNameUtil.validate(fileText, this.fileExtension, (IContainer)project, 5);
        if (nameStatus.getSeverity() == 4) {
            this.fileNameMessage = String.valueOf(ModelNameUtil.MESSAGES.INVALID_MODEL_NAME) + nameStatus.getMessage();
            this.currentStatus = 6;
            return false;
        }
        String fileName = this.getFileName();
        this.filePath = new Path(container).append(fileName);
        if (ModelerCore.getWorkspace().getRoot().exists(this.filePath)) {
            this.currentStatus = 3;
            return false;
        }
        if (this.metamodelCombo.getSelectionIndex() < 1) {
            this.currentStatus = 4;
            return false;
        }
        if (this.modelTypesCombo.getSelectionIndex() < 1) {
            this.currentStatus = 5;
            return false;
        }
        String metaModelType = this.getMetamodelType();
        if (metaModelType != null) {
            if (metaModelType.startsWith("Model Extension (Deprecated)")) {
                this.currentStatus = 9;
                return true;
            }
            if (metaModelType.startsWith("Function (Deprecated)")) {
                this.currentStatus = 10;
                return true;
            }
        }
        this.currentStatus = 0;
        return true;
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        boolean complete = message == null && this.getSelectedBuilder() == null;
        this.setPageComplete(complete);
    }

    public void setVisible(boolean theVisibleFlag) {
        super.setVisible(theVisibleFlag);
        if (this.isCurrentPage() && theVisibleFlag) {
            this.updateStatusMessage();
        }
    }

    private String getHiddenProjectPath() {
        String result = null;
        IProject hiddenProj = ProductCustomizerMgr.getInstance().getProductCharacteristics().getHiddenProject(false);
        if (hiddenProj != null) {
            result = hiddenProj.getFullPath().makeRelative().toString();
        }
        return result;
    }

    public String getContainerName() {
        String result = null;
        result = ProductCustomizerMgr.getInstance().getProductCharacteristics().isHiddenProjectCentric() ? this.getHiddenProjectPath() : this.containerText.getText().trim();
        return result;
    }

    public String getFileName() {
        String result = this.fileText.getText().trim();
        if (!result.endsWith(this.fileExtension)) {
            result = String.valueOf(result) + this.fileExtension;
        }
        return result;
    }

    public String getFileText() {
        return this.fileText.getText().trim();
    }

    public IPath getFilePath() {
        return this.filePath;
    }

    public boolean isVirtualSelected() {
        boolean isVirtual = false;
        if (this.metamodelCombo.getSelectionIndex() > 0) {
            ModelType selectedModelType = this.getSelectedModelType();
            isVirtual = selectedModelType != null && selectedModelType.equals(ModelType.VIRTUAL_LITERAL);
        }
        return isVirtual;
    }

    public IResource getTargetContainer() {
        IWorkspaceRoot root;
        IResource resource;
        IResource result = null;
        String containerName = this.getContainerName();
        if (!CoreStringUtil.isEmpty((String)containerName) && (resource = (root = ModelerCore.getWorkspace().getRoot()).findMember((IPath)new Path(containerName))).exists()) {
            result = resource;
        }
        return result;
    }

    public IProject getTargetProject() {
        IWorkspaceRoot root;
        IResource resource;
        IProject result = null;
        String containerName = this.getContainerName();
        if (!CoreStringUtil.isEmpty((String)containerName) && (resource = (root = ModelerCore.getWorkspace().getRoot()).findMember((IPath)new Path(containerName))).exists()) {
            result = resource.getProject();
        }
        return result;
    }

    public String getMetamodelType() {
        String metamodelType = this.metamodelCombo.getText();
        if (metamodelType.equals(CHOOSE_A_METAMODEL)) {
            metamodelType = null;
        }
        return metamodelType;
    }

    public MetamodelDescriptor getMetamodelDescriptor() {
        MetamodelDescriptor result = null;
        String metamodelName = this.getMetamodelType();
        if (metamodelName != null) {
            result = (MetamodelDescriptor)this.descriptorMap.get(metamodelName);
        }
        return result;
    }

    public NewModelWizardDescriptor getSelectedBuilder() {
        ISelection selection = this.contributorTable.getSelection();
        NewModelWizardDescriptor builder = (NewModelWizardDescriptor)SelectionUtilities.getSelectedObject((ISelection)selection);
        return builder;
    }

    protected String[] getMetamodelChoices() {
        List<MetamodelDescriptor> mmdescs = Arrays.asList(ModelerCore.getMetamodelRegistry().getMetamodelDescriptors());
        ArrayList<String> choicesList = new ArrayList<String>(mmdescs.size());
        for (MetamodelDescriptor mmd : mmdescs) {
            if (!UiPlugin.getDefault().isProductContextValueSupported(IModelerProductContexts.Metamodel.URI, mmd.getNamespaceURI()) || !mmd.supportsNewModel()) continue;
            ArrayList<ModelType> typeList = new ArrayList<ModelType>(Arrays.asList(mmd.getAllowableModelTypes()));
            typeList.remove(ModelType.METAMODEL_LITERAL);
            if (typeList.isEmpty()) continue;
            choicesList.add(mmd.getDisplayName());
            this.descriptorMap.put(mmd.getDisplayName(), mmd);
        }
        TreeSet choiceSet = new TreeSet(choicesList);
        String[] choices = new String[choiceSet.size() + 1];
        choices[0] = CHOOSE_A_METAMODEL;
        int ix = 0;
        for (String sMetamodelName : ORDERED_METAMODELS_LIST) {
            if (!choiceSet.contains(sMetamodelName)) continue;
            choices[++ix] = sMetamodelName;
            choiceSet.remove(sMetamodelName);
        }
        for (String sEntryName : choiceSet) {
            choices[++ix] = sEntryName;
        }
        return choices;
    }

    protected List getModelTypeList(MetamodelDescriptor md) {
        ArrayList<ModelType> typeList = new ArrayList<ModelType>(Arrays.asList(md.getAllowableModelTypes()));
        return typeList;
    }

    public boolean canFlipToNextPage() {
        return this.currentStatus == 0 && this.getSelectedBuilder() != null && !CoreStringUtil.isEmpty((String)this.getContainerName()) && this.getFileName().length() > 0;
    }

    public void dispose() {
        if (this.tableClickListener != null) {
            this.tableClickListener.dispose();
        }
        super.dispose();
    }

    void setInitialComboStates() {
        String sMetamodelClass = DEFAULT_CLASS;
        if (this.initialMetamodelClass != null) {
            sMetamodelClass = this.initialMetamodelClass;
        }
        String[] classItems = this.metamodelCombo.getItems();
        int i = 0;
        while (i < classItems.length) {
            if (classItems[i].equalsIgnoreCase(sMetamodelClass)) {
                this.metamodelCombo.select(i);
                this.metamodelComboSelected();
                this.metamodelWasFoundAndSelected = true;
                break;
            }
            ++i;
        }
        String sMetamodelType = DEFAULT_TYPE;
        if (this.initialModelType != null && this.initialModelType.getDisplayName() != null) {
            sMetamodelType = this.initialModelType.getDisplayName();
        }
        boolean foundType = false;
        if (this.metamodelWasFoundAndSelected && sMetamodelType != null) {
            String[] typeItems = this.modelTypesCombo.getItems();
            int i2 = 0;
            while (i2 < typeItems.length) {
                if (typeItems[i2].equalsIgnoreCase(sMetamodelType)) {
                    this.modelTypesCombo.select(i2);
                    this.modelTypeSelected();
                    foundType = true;
                    break;
                }
                ++i2;
            }
        }
        if (this.initialBuilderType != null && this.metamodelWasFoundAndSelected && foundType) {
            TableItem[] items = this.contributorTable.getTable().getItems();
            String label = null;
            int i3 = 0;
            while (i3 < items.length) {
                label = items[i3].getText();
                if (label != null && label.equalsIgnoreCase(this.initialBuilderType)) {
                    this.builderAutoSelected = true;
                    this.contributorTable.setSelection((ISelection)new StructuredSelection(items[i3].getData()));
                    this.handleTableSelection();
                    break;
                }
                ++i3;
            }
        }
        if (this.initialMetamodelClass != null) {
            boolean hiddenProject = ProductCustomizerMgr.getInstance().getProductCharacteristics().isHiddenProjectCentric();
            String msgId = hiddenProject ? "NewModelWizard.hiddenProjectSpecifyMsg" : "NewModelWizard.specifyOnlylModelNameDesc";
            this.setDescription(Util.getStringOrKey(msgId));
            this.setTitle(Util.getString("NewModelWizard.singleModelTypeTitle", (Object)this.initialMetamodelClass));
        }
        if (this.designerProperties != null) {
            IContainer viewsFolder;
            IProject container = DesignerPropertiesUtil.getProject(this.designerProperties);
            if (this.initialModelType != null && this.initialModelType.getLiteral().equalsIgnoreCase(ModelType.PHYSICAL_LITERAL.toString())) {
                IContainer srcsFolder = DesignerPropertiesUtil.getSourcesFolder(this.designerProperties);
                if (srcsFolder != null) {
                    container = srcsFolder;
                }
            } else if (this.initialModelType != null && this.initialModelType.getLiteral().equalsIgnoreCase(ModelType.PHYSICAL_LITERAL.toString()) && (viewsFolder = DesignerPropertiesUtil.getViewsFolder(this.designerProperties)) != null) {
                container = viewsFolder;
            }
            if (container != null && this.containerText != null) {
                this.containerText.setText(container.getFullPath().makeRelative().toString());
            }
        }
    }

    public void setNewModelInput(NewModelWizardInput newModelInput) {
        this.initialMetamodelClass = newModelInput.getMetamodelClass();
        this.initialModelType = newModelInput.getModelType();
        this.initialBuilderType = newModelInput.getBuilderType();
        if (newModelInput.getModelName() != null) {
            this.initialFileName = newModelInput.getModelName();
        }
    }
}

