/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.wizards;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.xsd.XSDElementDeclaration;
import org.teiid.core.designer.PluginUtil;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.notification.util.DefaultIgnorableNotificationSource;
import org.teiid.designer.core.transaction.UnitOfWorkImpl;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.xsd.XsdBuilderOptions;
import org.teiid.designer.metamodels.xsd.XsdSchemaBuilderImpl;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.common.wizard.AbstractWizard;
import org.teiid.designer.ui.wizards.GenerateXsdHelper;
import org.teiid.designer.ui.wizards.GenerateXsdWizardOptionslPage;
import org.teiid.designer.webservice.util.WebServiceBuilderHelper;

public class GenerateXsdWizard
extends AbstractWizard
implements INewWizard,
UiConstants {
    public static boolean HEADLESS = false;
    private final PluginUtil Util = UiConstants.Util;
    protected GenerateXsdWizardOptionslPage genXsdWizardOptionsPage;
    protected ISelection selection;
    private IWizardPage[] wizardPageArray;
    private IProgressMonitor monitor;
    private MultiStatus result;
    XsdBuilderOptions ops;
    private HashMap outputToInputMappings = new HashMap();
    private ModelResource wsModel;

    public GenerateXsdWizard() {
        super((AbstractUIPlugin)UiPlugin.getDefault(), UiConstants.Util.getString("GenerateXsdWizard.title", new Object[0]), null);
        this.setNeedsProgressMonitor(true);
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer, false);
    }

    public void addPages() {
        this.genXsdWizardOptionsPage = new GenerateXsdWizardOptionslPage(this.selection);
        this.addPage((IWizardPage)this.genXsdWizardOptionsPage);
    }

    public boolean finish() {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor theMonitor) {
                GenerateXsdWizard.this.ops = GenerateXsdWizard.this.genXsdWizardOptionsPage.getOptions();
                GenerateXsdWizard.this.doFinish(theMonitor);
            }
        };
        boolean startedTxn = ModelerCore.startTxn((boolean)false, (boolean)false, (String)this.getWindowTitle(), (Object)new DefaultIgnorableNotificationSource((Object)this));
        if (startedTxn) {
            ((UnitOfWorkImpl)ModelerCore.getCurrentUoW()).setOverrideRollback(true);
        }
        try {
            try {
                new ProgressMonitorDialog(this.getShell()).run(false, false, (IRunnableWithProgress)op);
            }
            catch (Throwable err) {
                this.Util.log(4, err, err.getMessage());
                if (startedTxn) {
                    ModelerCore.commitTxn();
                }
            }
        }
        finally {
            if (startedTxn) {
                ModelerCore.commitTxn();
            }
        }
        return true;
    }

    public void doFinish(IProgressMonitor monitor) {
        CoreArgCheck.isNotNull((Object)this.ops);
        XsdSchemaBuilderImpl builder = new XsdSchemaBuilderImpl(this.ops);
        this.monitor = monitor == null ? new NullProgressMonitor() : monitor;
        this.result = this.getResult();
        String msg = this.Util.getString("GenerateXsdWizard.begin", new Object[0]);
        this.monitor.beginTask(msg, 4);
        this.result = builder.buildSchemas(this.monitor, this.result);
        this.monitor.worked(1);
        GenerateXsdHelper helper = new GenerateXsdHelper(builder, this.ops, this.result);
        this.outputToInputMappings = helper.execute(monitor);
        for (XSDElementDeclaration elem : builder.getRootElements()) {
            ModelResource resrc = ModelerCore.getModelEditor().findModelResource((EObject)elem);
            try {
                if (resrc == null || !resrc.hasUnsavedChanges()) continue;
                resrc.save(monitor, true);
            }
            catch (ModelWorkspaceException err) {
                this.Util.log((Throwable)err);
            }
        }
        this.monitor.worked(1);
        if (this.ops.genWs()) {
            Collection webServiceOptions = helper.createWebServiceBuildOptions(this.outputToInputMappings, this.ops);
            WebServiceBuilderHelper wsbh = new WebServiceBuilderHelper();
            wsbh.setParentPath(this.ops.getParentPath());
            wsbh.createWebServices(webServiceOptions, true, this.result, monitor);
            helper.doSave();
            this.wsModel = wsbh.getWebServiceModel();
            wsbh.postProcess();
        }
        if (!this.result.isOK()) {
            int i = 0;
            while (i < this.result.getChildren().length) {
                this.Util.log(this.result.getChildren()[i]);
                ++i;
            }
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.genXsdWizardOptionsPage) {
            return null;
        }
        int i = 0;
        while (i < this.wizardPageArray.length) {
            if (this.wizardPageArray[i] == page && i + 1 < this.wizardPageArray.length) {
                return this.wizardPageArray[i + 1];
            }
            ++i;
        }
        return null;
    }

    public boolean canFinish() {
        boolean result = false;
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage == this.genXsdWizardOptionsPage) {
            result = currentPage.isPageComplete();
        } else {
            boolean lastPage = currentPage == this.wizardPageArray[this.wizardPageArray.length - 1];
            result = lastPage && currentPage.isPageComplete();
        }
        return result;
    }

    public int getPageCount() {
        if (this.wizardPageArray != null) {
            return this.wizardPageArray.length + 1;
        }
        return 1;
    }

    public void setOptions(XsdBuilderOptions ops) {
        this.ops = ops;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (this.wizardPageArray == null || page == this.genXsdWizardOptionsPage) {
            return null;
        }
        if (page == this.wizardPageArray[0]) {
            return this.genXsdWizardOptionsPage;
        }
        int i = 1;
        while (i < this.wizardPageArray.length) {
            if (page == this.wizardPageArray[i]) {
                return this.wizardPageArray[i - 1];
            }
            ++i;
        }
        return null;
    }

    public MultiStatus getResult() {
        if (this.result == null) {
            this.result = new MultiStatus("org.teiid.designer.ui", 0, this.Util.getString("GenerateXsdWizard.result", new Object[0]), null);
        }
        return this.result;
    }

    public HashMap getOutPutToInputMappings() {
        return this.outputToInputMappings;
    }

    public ModelResource getWebServiceModel() {
        return this.wsModel;
    }
}

