/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.viewsupport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.viewsupport.StatusInfo;
import org.teiid.designer.ui.common.widget.accumulator.IAccumulatorSource;
import org.teiid.designer.ui.explorer.ModelExplorerContentProvider;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;

public class WorkspaceTreeAccumulatorSource
implements IAccumulatorSource {
    private static final IStatus OK_STATUS = new StatusInfo("org.teiid.designer.ui");
    private TreeViewer treeViewer;
    private ISelectionStatusValidator validator;
    private IStatus currentStatus = OK_STATUS;
    private Collection currentValues;
    private ILabelProvider labelProvider;
    private ITreeContentProvider contentProvider;
    private ViewerFilter viewerFilter;

    public WorkspaceTreeAccumulatorSource(Collection currentValues) {
        this(currentValues, (ILabelProvider)new ModelExplorerLabelProvider(), (ITreeContentProvider)new ModelExplorerContentProvider());
    }

    public WorkspaceTreeAccumulatorSource(Collection currentValues, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        this.currentValues = new ArrayList(currentValues);
        this.labelProvider = labelProvider;
        this.contentProvider = contentProvider;
    }

    public void setSelectionValidator(ISelectionStatusValidator validator) {
        this.validator = validator;
    }

    public void setViewerFilter(ViewerFilter filter) {
        this.viewerFilter = filter;
    }

    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public Collection getCurrentValues() {
        return Collections.unmodifiableCollection(this.currentValues);
    }

    public void accumulatedValuesRemoved(Collection values) {
        this.currentValues.removeAll(values);
    }

    public void accumulatedValuesAdded(Collection values) {
        this.currentValues.addAll(values);
        this.treeViewer.setSelection(null, false);
    }

    public Collection getAvailableValues() {
        return Collections.EMPTY_LIST;
    }

    public int getAvailableValuesCount() {
        return 10;
    }

    public Collection getSelectedAvailableValues() {
        ISelection selection = this.treeViewer.getSelection();
        List result = SelectionUtilities.getSelectedObjects((ISelection)selection);
        if (this.validator != null) {
            this.currentStatus = this.validator.validate(result.toArray());
        }
        return result;
    }

    public int getSelectedAvailableValuesCount() {
        return this.getSelectedAvailableValues().size();
    }

    public Control createControl(Composite parent) {
        this.treeViewer = new TreeViewer(parent);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        if (this.viewerFilter != null) {
            this.treeViewer.addFilter(this.viewerFilter);
        }
        this.treeViewer.setInput((Object)ModelerCore.getWorkspace().getRoot());
        this.treeViewer.expandToLevel(2);
        return this.treeViewer.getControl();
    }

    public void addSelectionListener(SelectionListener listener) {
        this.treeViewer.getTree().addSelectionListener(listener);
    }

    public boolean supportsAddAll() {
        return false;
    }

    public IStatus getSelectionStatus() {
        this.getSelectedAvailableValues();
        return this.currentStatus;
    }
}

