/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.viewsupport;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.teiid.designer.core.metamodel.MetamodelDescriptor;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.common.viewsupport.StatusInfo;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class ModelResourceSelectionValidator
implements ISelectionStatusValidator {
    private static final IStatus OK_STATUS = new StatusInfo("org.teiid.designer.ui");
    private static final String NOTHING_SELECTED = UiConstants.Util.getString("ModelResourceSelectionValidator.noSelection", new Object[0]);
    private static final String MULTI_SELECTION = UiConstants.Util.getString("ModelResourceSelectionValidator.noMultiSelection", new Object[0]);
    private static final String MUST_SELECT_MODEL = UiConstants.Util.getString("ModelResourceSelectionValidator.mustSelectModel", new Object[0]);
    private static final String MUST_SELECT_MODELS = UiConstants.Util.getString("ModelResourceSelectionValidator.mustSelectModels", new Object[0]);
    private static final String MUST_MATCH_METAMODEL = "ModelResourceSelectionValidator.mustSelectSameMetamodel";
    private static final String MUST_MATCH_METAMODELS = "ModelResourceSelectionValidator.mustSelectSameMetamodels";
    private MetamodelDescriptor metamodelDescriptor = null;
    private boolean allowMultiSelection = false;

    public ModelResourceSelectionValidator(boolean allowMultiSelection) {
        this(null, allowMultiSelection);
    }

    public ModelResourceSelectionValidator(MetamodelDescriptor descriptorToMatch, boolean allowMultiSelection) {
        this.metamodelDescriptor = descriptorToMatch;
        this.allowMultiSelection = allowMultiSelection;
    }

    public IStatus validate(Object[] selection) {
        IStatus result = OK_STATUS;
        if (selection == null || selection.length == 0) {
            return new StatusInfo("org.teiid.designer.ui", 4, NOTHING_SELECTED);
        }
        if (!this.allowMultiSelection && selection.length > 1) {
            return new StatusInfo("org.teiid.designer.ui", 4, MULTI_SELECTION);
        }
        if (selection.length == 1) {
            result = this.metamodelDescriptor != null ? this.checkMetamodel(selection[0], false) : this.checkModelFile(selection[0], false);
        } else {
            int i = 0;
            while (i < selection.length) {
                result = this.metamodelDescriptor != null ? this.checkMetamodel(selection[i], true) : this.checkModelFile(selection[i], true);
                if (result != OK_STATUS) break;
                ++i;
            }
        }
        return result;
    }

    private IStatus checkFile(Object obj, boolean generateMultiSelectMessage) {
        if (obj instanceof IFile) {
            return OK_STATUS;
        }
        if (generateMultiSelectMessage) {
            return new StatusInfo("org.teiid.designer.ui", 4, MUST_SELECT_MODELS);
        }
        return new StatusInfo("org.teiid.designer.ui", 4, MUST_SELECT_MODEL);
    }

    private IStatus checkModelFile(Object obj, boolean generateMultiSelectMessage) {
        IStatus result = this.checkFile(obj, generateMultiSelectMessage);
        if (result == OK_STATUS && !ModelUtilities.isModelFile((IResource)((IFile)obj))) {
            if (generateMultiSelectMessage) {
                return new StatusInfo("org.teiid.designer.ui", 4, MUST_SELECT_MODELS);
            }
            return new StatusInfo("org.teiid.designer.ui", 4, MUST_SELECT_MODEL);
        }
        return result;
    }

    private IStatus checkMetamodel(Object obj, boolean generateMultiSelectMessage) {
        IStatus result = this.checkModelFile(obj, generateMultiSelectMessage);
        if (result == OK_STATUS) {
            String message;
            boolean exceptionOccurred = false;
            ModelResource modelResource = null;
            try {
                modelResource = ModelUtil.getModelResource((IFile)((IFile)obj), (boolean)true);
            }
            catch (Exception ex) {
                UiConstants.Util.log(4, (Throwable)ex, ex.getClass().getName());
                if (generateMultiSelectMessage) {
                    message = UiConstants.Util.getString(MUST_MATCH_METAMODELS, (Object)this.metamodelDescriptor.getDisplayName());
                    result = new StatusInfo("org.teiid.designer.ui", 4, message);
                } else {
                    message = UiConstants.Util.getString(MUST_MATCH_METAMODEL, (Object)this.metamodelDescriptor.getDisplayName());
                    result = new StatusInfo("org.teiid.designer.ui", 4, message);
                }
                exceptionOccurred = true;
            }
            if (!exceptionOccurred) {
                MetamodelDescriptor descriptor = null;
                try {
                    descriptor = modelResource.getPrimaryMetamodelDescriptor();
                }
                catch (Exception ex) {
                    UiConstants.Util.log(4, (Throwable)ex, ex.getClass().getName());
                    exceptionOccurred = true;
                    if (generateMultiSelectMessage) {
                        String message2 = UiConstants.Util.getString(MUST_MATCH_METAMODELS, (Object)this.metamodelDescriptor.getDisplayName());
                        result = new StatusInfo("org.teiid.designer.ui", 4, message2);
                    }
                    String message3 = UiConstants.Util.getString(MUST_MATCH_METAMODEL, (Object)this.metamodelDescriptor.getDisplayName());
                    result = new StatusInfo("org.teiid.designer.ui", 4, message3);
                }
                if (!exceptionOccurred && !this.metamodelDescriptor.equals(descriptor)) {
                    if (generateMultiSelectMessage) {
                        message = UiConstants.Util.getString(MUST_MATCH_METAMODELS, (Object)this.metamodelDescriptor.getDisplayName());
                        result = new StatusInfo("org.teiid.designer.ui", 4, message);
                    } else {
                        message = UiConstants.Util.getString(MUST_MATCH_METAMODEL, (Object)this.metamodelDescriptor.getDisplayName());
                        result = new StatusInfo("org.teiid.designer.ui", 4, message);
                    }
                }
            }
        }
        return result;
    }
}

