/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.views;

import java.util.EventObject;
import java.util.Stack;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.xsd.XSDFacet;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.provider.XSDSemanticItemProviderAdapterFactory;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.event.EventObjectListener;
import org.teiid.core.designer.event.EventSourceException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.notification.util.NotificationUtilities;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.common.eventsupport.CompositeNotifyChangeListener;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.widget.AbstractTableLabelProvider;
import org.teiid.designer.ui.common.widget.DefaultContentProvider;
import org.teiid.designer.ui.event.ModelResourceEvent;
import org.teiid.designer.ui.views.ModelerView;
import org.teiid.designer.ui.viewsupport.DatatypeHierarchyTreeViewer;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class DatatypeHierarchyView
extends ModelerView {
    private static final int NAME_COLUMN = 0;
    private static final int VALUE_COLUMN = 1;
    private static final int TYPE_COLUMN = 2;
    private static final String LABEL_DETAILS = UiConstants.Util.getString("DatatypeHierarchyView.details", new Object[0]);
    private static final String LABEL_NAME = UiConstants.Util.getString("DatatypeHierarchyView.name", new Object[0]);
    private static final String LABEL_VALUE = UiConstants.Util.getString("DatatypeHierarchyView.value", new Object[0]);
    private static final String LABEL_TYPE = UiConstants.Util.getString("DatatypeHierarchyView.type", new Object[0]);
    TreeViewer typeTree;
    TableViewer detailsTable;
    private CompositeNotifyChangeListener notifyListener;
    private EventObjectListener modelResourceListener;

    public void revealType(XSDTypeDefinition type) {
        if (this.typeTree != null) {
            Stack<XSDTypeDefinition> s = new Stack<XSDTypeDefinition>();
            try {
                EObject root = ModelerCore.getBuiltInTypesManager().getAnyType();
                XSDTypeDefinition parent = type.getBaseType();
                while (parent != root) {
                    s.push(parent);
                    parent = parent.getBaseType();
                }
            }
            catch (ModelerCoreException err) {
                UiConstants.Util.log((Throwable)err);
            }
            while (!s.isEmpty()) {
                Object element = s.pop();
                this.typeTree.setExpandedState(element, true);
            }
            this.typeTree.setSelection((ISelection)new StructuredSelection((Object)type));
            this.typeTree.reveal((Object)type);
        }
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        SashForm sf = new SashForm(parent, 512);
        this.typeTree = new DatatypeHierarchyTreeViewer((Composite)sf);
        Group lowerComp = new Group((Composite)sf, 0);
        lowerComp.setText(LABEL_DETAILS);
        lowerComp.setLayout((Layout)new FillLayout());
        this.detailsTable = new TableViewer((Composite)lowerComp);
        this.detailsTable.setContentProvider((IContentProvider)new DefaultContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ((XSDSimpleTypeDefinition)inputElement).getFacets().toArray();
            }
        });
        this.detailsTable.setLabelProvider((IBaseLabelProvider)new DetailsTableLabelProvider());
        Table table = this.detailsTable.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(false);
        TableColumn col = new TableColumn(table, 131072);
        col.setText(LABEL_NAME);
        col = new TableColumn(table, 16384);
        col.setText(LABEL_VALUE);
        col = new TableColumn(table, 16384);
        col.setText(LABEL_TYPE);
        this.packColumns();
        sf.setWeights(new int[]{3, 1});
        this.setPartName(UiConstants.Util.getString("DatatypeHierarchyView.title", new Object[0]));
        this.getViewSite().setSelectionProvider((ISelectionProvider)this.typeTree);
        this.notifyListener = new CompositeNotifyChangeListener();
        ModelUtilities.addNotifyChangedListener((INotifyChangedListener)this.notifyListener);
        this.notifyListener.addNotifyChangeListener((INotifyChangedListener)new DatatypeHierarchyNotificationHandler());
        this.typeTree.addSelectionChangedListener(new ISelectionChangedListener(){
            private Object lastSelected;

            public void selectionChanged(SelectionChangedEvent event) {
                Object selectedObject;
                ISelection sel = event.getSelection();
                if (!sel.isEmpty() && this.lastSelected != (selectedObject = SelectionUtilities.getSelectedObject((ISelection)sel))) {
                    this.lastSelected = selectedObject;
                    DatatypeHierarchyView.this.detailsTable.setInput(selectedObject);
                    DatatypeHierarchyView.this.packColumns();
                }
            }
        });
        this.typeTree.addSelectionChangedListener(this.getStatusBarListener());
        this.modelResourceListener = new EventObjectListener(){

            public void processEvent(EventObject obj) {
                int type;
                ModelResourceEvent event = (ModelResourceEvent)obj;
                IResource file = event.getResource();
                String fileExtension = file.getFileExtension();
                if (fileExtension != null && fileExtension.equalsIgnoreCase("xsd") && ((type = event.getType()) == 3 || type == 6 || type == 7 || type == 8 || type == 4)) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!(this).DatatypeHierarchyView.this.typeTree.getTree().isDisposed()) {
                                (this).DatatypeHierarchyView.this.typeTree.refresh();
                            }
                        }
                    });
                }
            }
        };
        try {
            UiPlugin.getDefault().getEventBroker().addListener(ModelResourceEvent.class, this.modelResourceListener);
        }
        catch (EventSourceException e) {
            UiConstants.Util.log(4, (Throwable)e, e.getMessage());
        }
        this.typeTree.expandToLevel(2);
    }

    void packColumns() {
        Table table = this.detailsTable.getTable();
        int i = 0;
        while (i < table.getColumnCount()) {
            TableColumn col = table.getColumn(i);
            col.pack();
            if (col.getWidth() > 200) {
                col.setWidth(200);
            }
            ++i;
        }
    }

    public void setFocus() {
        if (this.typeTree != null && !this.typeTree.getTree().isDisposed()) {
            this.typeTree.getTree().setFocus();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.notifyListener != null) {
            ModelUtilities.removeNotifyChangedListener((INotifyChangedListener)this.notifyListener);
        }
        if (this.modelResourceListener != null) {
            try {
                UiPlugin.getDefault().getEventBroker().removeListener(this.modelResourceListener);
            }
            catch (EventSourceException e) {
                UiConstants.Util.log(4, (Throwable)e, e.getMessage());
            }
        }
    }

    class DatatypeHierarchyNotificationHandler
    implements INotifyChangedListener {
        DatatypeHierarchyNotificationHandler() {
        }

        public void notifyChanged(Notification notification) {
            EObject obj;
            if (DatatypeHierarchyView.this.typeTree != null && !DatatypeHierarchyView.this.typeTree.getTree().isDisposed() && (obj = NotificationUtilities.getEObject((Notification)notification)) instanceof XSDSimpleTypeDefinition) {
                XSDSimpleTypeDefinition std = (XSDSimpleTypeDefinition)obj;
                block0 : switch (notification.getEventType()) {
                    case 3: 
                    case 5: {
                        DatatypeHierarchyView.this.typeTree.refresh((Object)std.getBaseTypeDefinition());
                        break;
                    }
                    case 4: 
                    case 6: {
                        DatatypeHierarchyView.this.typeTree.remove((Object)std);
                        break;
                    }
                    case 1: {
                        int feature = NotificationUtilities.getFeatureChanged((Notification)notification);
                        switch (feature) {
                            case 16: 
                            case 28: {
                                Object oldParent = notification.getOldValue();
                                Object newParent = notification.getNewValue();
                                DatatypeHierarchyView.this.typeTree.refresh(oldParent);
                                DatatypeHierarchyView.this.typeTree.refresh(newParent);
                                break block0;
                            }
                            case 5: {
                                DatatypeHierarchyView.this.typeTree.update((Object)std, null);
                                break block0;
                            }
                        }
                        if (std != SelectionUtilities.getSelectedObject((ISelection)DatatypeHierarchyView.this.typeTree.getSelection())) break;
                        DatatypeHierarchyView.this.detailsTable.setInput((Object)std);
                        DatatypeHierarchyView.this.packColumns();
                        break;
                    }
                }
            }
        }
    }

    class DetailsTableLabelProvider
    extends AbstractTableLabelProvider {
        private AdapterFactoryLabelProvider labelProv = new AdapterFactoryLabelProvider((AdapterFactory)new XSDSemanticItemProviderAdapterFactory());

        DetailsTableLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof XSDFacet) {
                XSDFacet f = (XSDFacet)element;
                switch (columnIndex) {
                    case 0: {
                        return f.getFacetName();
                    }
                    case 1: {
                        return f.getLexicalValue();
                    }
                    case 2: {
                        XSDSimpleTypeDefinition std = f.getSimpleTypeDefinition();
                        if (DatatypeHierarchyView.this.detailsTable.getInput() == std) {
                            return "";
                        }
                        return this.labelProv.getText((Object)std);
                    }
                }
            }
            return null;
        }
    }
}

