/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.util;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.statushandlers.StatusManager;
import org.teiid.core.designer.util.StringConstants;
import org.teiid.designer.ui.UiConstants;

public class ErrorHandler
implements StringConstants {
    private ErrorHandler() {
    }

    private static Display getDisplay() {
        return Display.getCurrent() == null ? Display.getDefault() : Display.getCurrent();
    }

    private static void runInSwtThread(Runnable operation, boolean asynchronous) {
        Display display = ErrorHandler.getDisplay();
        if (Thread.currentThread() != display.getThread()) {
            if (asynchronous) {
                display.asyncExec(operation);
            } else {
                display.syncExec(operation);
            }
        } else {
            operation.run();
        }
    }

    public static CoreException toCoreException(String message, Throwable throwable) {
        if (throwable instanceof CoreException) {
            return (CoreException)throwable;
        }
        if (message == null) {
            message = UiConstants.Util.getStringOrKey(String.valueOf(ErrorHandler.class.getSimpleName()) + "." + "operationExceptionThrown");
        }
        MultiStatus status = new MultiStatus("org.teiid.designer.ui", 4, message, null);
        do {
            status.add((IStatus)new Status(4, "org.teiid.designer.ui", " * " + throwable.getLocalizedMessage()));
        } while ((throwable = throwable.getCause()) != null);
        return new CoreException((IStatus)status);
    }

    public static CoreException toCoreException(Throwable throwable) {
        return ErrorHandler.toCoreException(null, throwable);
    }

    public static void toExceptionDialog(final CoreException coreException) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                StatusManager.getManager().handle(coreException.getStatus(), 2);
                UiConstants.Util.log((Throwable)coreException);
            }
        };
        ErrorHandler.runInSwtThread(runnable, true);
    }

    public static void toExceptionDialog(String message, Throwable throwable) {
        ErrorHandler.toExceptionDialog(ErrorHandler.toCoreException(message, throwable));
    }

    public static void toExceptionDialog(Throwable throwable) {
        ErrorHandler.toExceptionDialog(ErrorHandler.toCoreException(null, throwable));
    }
}

