/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.actions.IModelerActionConstants;
import org.teiid.designer.ui.actions.ModelerActionBarIdManager;
import org.teiid.designer.ui.actions.ModelerGlobalActionsMap;
import org.teiid.designer.ui.common.actions.ActionService;
import org.teiid.designer.ui.common.actions.GlobalActionsMap;
import org.teiid.designer.ui.common.actions.IActionConstants;
import org.teiid.designer.ui.editors.AbstractModelEditorPageActionBarContributor;
import org.teiid.designer.ui.editors.ModelEditorPage;
import org.teiid.designer.ui.table.ModelTableEditor;

public class ModelTableEditorActionContributor
extends AbstractModelEditorPageActionBarContributor
implements IModelerActionConstants,
UiConstants {
    private ModelerGlobalActionsMap actionsMap;
    private Collection menuManagers = new ArrayList();

    public ModelTableEditorActionContributor(ModelEditorPage thePage) {
        super(thePage);
    }

    @Override
    public void createContextMenu() {
        ModelTableEditor tableEditor = (ModelTableEditor)this.getEditorPage();
        Map tableViewers = tableEditor.getTableViewerMap();
        if (tableViewers != null && !tableViewers.isEmpty()) {
            Set tabEntries = tableViewers.entrySet();
            for (Map.Entry entry : tabEntries) {
                TableViewer viewer = (TableViewer)entry.getValue();
                IMenuManager newManager = this.createContextMenu(String.valueOf(entry.getKey().toString()) + ".contextMenu", viewer.getControl());
                this.menuManagers.add(newManager);
            }
        }
    }

    void addContextMenu(Control control, String controlName) {
        IMenuManager newManager = this.createContextMenu(String.valueOf(controlName) + ".contextMenu", control);
        this.menuManagers.add(newManager);
    }

    public void contributeToMenu(IMenuManager theMenuManager) {
        IContributionItem item = theMenuManager.find(ModelerActionBarIdManager.getEditMenuId());
        if (item != null && item instanceof IMenuManager) {
            IMenuManager editMenu = (IMenuManager)item;
            IContributionItem temp = this.getEditColumnVisibilityAndOrderItem((IContributionManager)theMenuManager);
            if (temp == null) {
                editMenu.insertAfter(ModelerActionBarIdManager.getCutGroupExtrasMarkerId(), (IContributionItem)new ActionContributionItem(this.getEditColumnVisibilityAndOrderAction()));
                editMenu.insertAfter(this.getEditColumnVisibilityAndOrderAction().getId(), (IContributionItem)new ActionContributionItem(this.getInsertRowsAction()));
                editMenu.insertAfter(this.getInsertRowsAction().getId(), (IContributionItem)new ActionContributionItem(this.getRefreshTableAction()));
            }
        }
    }

    @Override
    public void pageActivated() {
        this.setActionsVisible(true);
    }

    @Override
    public void pageDeactivated() {
        this.setActionsVisible(false);
    }

    private void setActionsVisible(boolean theShowFlag) {
        IActionBars actionBars = this.getActionBars();
        if (actionBars != null) {
            IMenuManager mgr = actionBars.getMenuManager();
            IContributionItem item = this.getEditColumnVisibilityAndOrderItem((IContributionManager)(mgr = (IMenuManager)mgr.find(ModelerActionBarIdManager.getEditMenuId())));
            if (item != null) {
                item.setVisible(theShowFlag);
            }
            if ((item = this.getClipboardPasteItem((IContributionManager)mgr)) != null) {
                item.setVisible(theShowFlag);
            }
            if ((item = this.getInsertRowsItem((IContributionManager)mgr)) != null) {
                item.setVisible(theShowFlag);
            }
            if ((item = this.getRefreshTableItem((IContributionManager)mgr)) != null) {
                item.setVisible(theShowFlag);
            }
            mgr.update(true);
            mgr = actionBars.getToolBarManager();
            item = this.getClipboardPasteItem((IContributionManager)mgr);
            if (item != null) {
                item.setVisible(theShowFlag);
            }
            if ((item = this.getInsertRowsItem((IContributionManager)mgr)) != null) {
                item.setVisible(theShowFlag);
            }
            mgr.update(true);
        }
    }

    @Override
    public void menuAboutToShow(IMenuManager theMenuMgr) {
        super.menuAboutToShow(theMenuMgr);
        theMenuMgr.add(this.getEditColumnVisibilityAndOrderAction());
        theMenuMgr.add(this.getInsertRowsAction());
        theMenuMgr.add(this.getRefreshTableAction());
    }

    private IAction getClipboardPasteAction() {
        IAction action = null;
        ActionService service = this.getActionService();
        try {
            action = service.getAction(IModelerActionConstants.TableEditorActions.CLIPBOARD_PASTE);
        }
        catch (CoreException theException) {
            Util.log((Throwable)theException);
        }
        return action;
    }

    private IContributionItem getClipboardPasteItem(IContributionManager theMgr) {
        return theMgr.find(this.getClipboardPasteAction().getId());
    }

    private IAction getInsertRowsAction() {
        IAction action = null;
        ActionService service = this.getActionService();
        try {
            action = service.getAction(IModelerActionConstants.TableEditorActions.INSERT_ROWS);
        }
        catch (CoreException theException) {
            Util.log((Throwable)theException);
        }
        return action;
    }

    private IContributionItem getInsertRowsItem(IContributionManager theMgr) {
        return theMgr.find(this.getInsertRowsAction().getId());
    }

    private IAction getEditColumnVisibilityAndOrderAction() {
        IAction action = null;
        ActionService service = this.getActionService();
        try {
            action = service.getAction(IModelerActionConstants.TableEditorActions.EDIT_COLUMNS);
        }
        catch (CoreException theException) {
            Util.log((Throwable)theException);
        }
        return action;
    }

    private IContributionItem getEditColumnVisibilityAndOrderItem(IContributionManager theMgr) {
        return theMgr.find(this.getEditColumnVisibilityAndOrderAction().getId());
    }

    private IAction getPrintAction() {
        IAction action = null;
        ActionService service = this.getActionService();
        try {
            action = service.getAction(IModelerActionConstants.TableEditorActions.PRINT);
        }
        catch (CoreException theException) {
            Util.log((Throwable)theException);
        }
        return action;
    }

    private IAction getRefreshTableAction() {
        IAction action = null;
        ActionService service = this.getActionService();
        try {
            action = service.getAction(IModelerActionConstants.TableEditorActions.REFRESH_TABLE);
        }
        catch (CoreException theException) {
            Util.log((Throwable)theException);
        }
        return action;
    }

    private IContributionItem getRefreshTableItem(IContributionManager theMgr) {
        return theMgr.find(this.getRefreshTableAction().getId());
    }

    public void contributeToToolBar(IToolBarManager theToolBarMgr) {
        IContributionItem temp = this.getClipboardPasteItem((IContributionManager)theToolBarMgr);
        if (temp == null) {
            theToolBarMgr.add((IContributionItem)new ActionContributionItem(this.getClipboardPasteAction()));
        }
        if ((temp = this.getInsertRowsItem((IContributionManager)theToolBarMgr)) == null) {
            theToolBarMgr.add((IContributionItem)new ActionContributionItem(this.getInsertRowsAction()));
        }
    }

    @Override
    public GlobalActionsMap getGlobalActions() {
        if (this.actionsMap == null) {
            this.actionsMap = new ModelerGlobalActionsMap();
            this.actionsMap.reset();
            this.actionsMap.put(IActionConstants.EclipseGlobalActions.PRINT, this.getPrintAction());
            this.actionsMap.put(IActionConstants.EclipseGlobalActions.PASTE, this.getClipboardPasteAction());
        }
        return this.actionsMap;
    }

    public void dispose() {
        for (MenuManager nextManager : this.menuManagers) {
            nextManager.removeMenuListener((IMenuListener)this);
        }
        super.dispose();
    }
}

